/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: vtkQtRenderWindow.cxx,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkQtRenderWindow.h"
#include <qstring.h>
#include <qsize.h>  
#include <qapplication.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

vtkQtRenderWindow::vtkQtRenderWindow (QWidget *parent, const char *name ):QGLWidget(parent, name)
{
  if (!parent) InitializeResize = FALSE;
  else InitializeResize = TRUE;
      
  vtkXOpenGLRenderWindow::SetDisplayId(qt_xdisplay());
  vtkXOpenGLRenderWindow::SetWindowId(this->winId());
}

void vtkQtRenderWindow::initializeGL()
{
  vtkXOpenGLRenderWindow::OpenGLInit();
}

void vtkQtRenderWindow::paintGL()
{
  vtkXOpenGLRenderWindow::Render();
}

void vtkQtRenderWindow::SetWindowName(const char * cname)
{
  vtkXOpenGLRenderWindow::SetWindowName(cname);
  QString name(cname);
  QGLWidget::setCaption(name);
}

void vtkQtRenderWindow::SetFullScreen(int arg)
{ 
  if (this->OffScreenRendering)
    {
    return;
    }
  
  if (this->FullScreen == arg) return;
  
  // set the mode 
  this->FullScreen = arg;
  if (this->FullScreen <= 0)
    {
    this->Position[0] = this->OldScreen[0];
    this->Position[1] = this->OldScreen[1];
    this->Size[0] = this->OldScreen[2]; 
    this->Size[1] = this->OldScreen[3];
    this->Borders = this->OldScreen[4];
    this->SetPosition(Position);
    this->SetSize(Size);
    }
  else
    {
    int border = 5;
    int topborder = 20;  
    // Store old Attributes
    QPoint PosWidget = QGLWidget::pos();
     
    this->OldScreen[2] = this->Size[0];
    this->OldScreen[3] = this->Size[1];

    this->OldScreen[0] = PosWidget.x();
    this->OldScreen[1] = PosWidget.y();

    this->OldScreen[4] = this->Borders;
    // Full screen
    vtkWarningMacro(<<"Full screen mode is actualy not a full screen mode, it just a window on all screen");
    const QRect screen = qApp->desktop()->screenGeometry( qApp->desktop()->screenNumber( this ) );
    vtkXOpenGLRenderWindow::SetSize(screen.right(),screen.bottom());
    QGLWidget::move(-border,-topborder);
    }
}

void vtkQtRenderWindow::SetPosition(int x,int y)
{
  vtkXOpenGLRenderWindow::SetPosition(x,y);
  QGLWidget::move(x,y);
}

void vtkQtRenderWindow::resizeGL(int w, int h)
{
  if (this->InitializeResize) 
   this->SetSize(w,h);
}
