/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: vtkQtRenderWindow.h,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __vtkQtRenderWindow_h
#define __vtkQtRenderWindow_h

#include <qgl.h> 
#include <vtkXOpenGLRenderWindow.h>

class VTK_RENDERING_EXPORT vtkQtRenderWindow : public QGLWidget, public vtkXOpenGLRenderWindow
{
  Q_OBJECT
public:
  static vtkQtRenderWindow *New( QWidget *parent, const char *name ) {return new vtkQtRenderWindow(parent, name);};
  static vtkQtRenderWindow *New() {return new vtkQtRenderWindow(NULL, "VtkQt");};

  // Description:
  // Set name of rendering window.
  void SetWindowName(const char *);
  
  // Description:
  // Change the window to fill the entire screen.
  void SetFullScreen(int);
  
  // Description:
  // Move the window to a new position on the display.
  void SetPosition(int,int);
  void SetPosition(int a[2]) {this->SetPosition(a[0], a[1]);};

  void SetInitializeResize(bool var) {InitializeResize = var;};
  
public slots:
  // Description:
  // Updates the widget by calling Render(). 
  void updateGL() { this->Render();};
  
protected:
  vtkQtRenderWindow (QWidget *parent, const char *name );
  ~vtkQtRenderWindow() {};
    
  // Description:  
  // This function should set up any required OpenGL context rendering flags,
  // defining display lists, etc. 
  void initializeGL ();
  
  // Description:
  // This function is called whenever the widget needs to be painted. 
  void paintGL();
    
  void resizeGL(int w, int h);
  bool InitializeResize;
 
private:
  vtkQtRenderWindow(const vtkQtRenderWindow&);  // Not implemented.
  void operator=(const vtkQtRenderWindow&);  // Not implemented.
};

#endif
