/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: vtkQtRenderWindowInteractor.h,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __vtkQtRenderWindowInteractor_h
#define __vtkQtRenderWindowInteractor_h

#include <qwidget.h> 
#include <vtkRenderWindowInteractor.h>
#include "vtkQtRenderWindow.h"
#include <X11/StringDefs.h> // Needed for X types in the public interface
#include <X11/Intrinsic.h> // Needed for X types in the public interface

class VTK_RENDERING_EXPORT vtkQtRenderWindowInteractor : public QWidget, public vtkRenderWindowInteractor
{
  Q_OBJECT
public:
  static vtkQtRenderWindowInteractor *New(QWidget *parent, const char *name) {return new vtkQtRenderWindowInteractor(parent, name);};
  static vtkQtRenderWindowInteractor *New() {return new vtkQtRenderWindowInteractor(NULL, "VtkQt");};
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Set/Get the rendering window being controlled by this object.
  void SetRenderWindow(vtkQtRenderWindow *aren);
  
  // Description:
  // Initializes the event handlers without an XtAppContext.  This is
  // good for when you don't have a user interface, but you still
  // want to have mouse interaction.
  virtual void Initialize();

  // Description:
  // Call exit on 'q','e' keypress. Want more ???
  void TerminateApp(void) { exit(0); }

  // Description:
  // The BreakLoopFlag is checked in the Start() method.
  // Setting it to anything other than zero will cause
  // the interactor loop to terminate and return to the
  // calling function.
  vtkSetMacro(BreakLoopFlag, int);
  vtkGetMacro(BreakLoopFlag, int);
  vtkBooleanMacro(BreakLoopFlag, int);

  // Description:
  // X timer methods
  int CreateTimer(int timertype);
  int DestroyTimer(void);

  // Description:
  // Enable/Disable interactions.  By default interactors are enabled when
  // initialized.  Initialize() must be called prior to enabling/disabling
  // interaction. These methods are used when a window/widget is being
  // shared by multiple renderers and interactors.  This allows a "modal"
  // display where one interactor is active when its data is to be displayed
  // and all other interactors associated with the widget are disabled
  // when their data is not displayed.
  virtual void Enable();
  virtual void Disable();

  // Description:
  // This will start up the X event loop and never return. If you
  // call this method it will loop processing X events until the
  // application is exited.
  virtual void Start();

  // Description:
  // Re-defines virtual function to get mouse position by querying X-server.
  virtual void GetMousePosition(int *x, int *y); 

  // Description:
  // Functions that are used internally.
  friend void vtkQtRenderWindowInteractorCallback(Widget,XtPointer,
                                                 XEvent *,Boolean *);
  friend void vtkQtRenderWindowInteractorTimer(XtPointer,XtIntervalId *);

  // Description:
  // Render the scene. Just pass the render call on to the 
  // associated vtkRenderWindow.
  virtual void Render();  
  
protected:
  vtkQtRenderWindowInteractor(QWidget *parent, const char *name);
  ~vtkQtRenderWindowInteractor();

  Display *DisplayId;
  Window WindowId;
  QWidget *Top;
  int OwnTop;
  int PositionBeforeStereo[2];
  QWidget *TopLevelShell;

  int BreakLoopFlag;
  int AddTimeOut(unsigned long );
  
protected:
  void timerEvent( QTimerEvent * );
  bool x11Event ( XEvent * event);
  void paintEvent ( QPaintEvent *e) {this->Render();};
  void mouseMoveEvent(QMouseEvent* e);
  
  int TimerId;
  int WidgetSize[2];
  int InitializedWidgetSize;
private:
  vtkQtRenderWindowInteractor(const vtkQtRenderWindowInteractor&);  // Not implemented.
  void operator=(const vtkQtRenderWindowInteractor&);  // Not implemented.
  
};

#endif
