//LabPlot : ConfigureDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qhbuttongroup.h>
#include <qvbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qhbox.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kcombobox.h>
#include "ConfigureDialog.h"

using namespace std;

const char* pageSize[] = { "ISO A4","ISO B5", "US Letter", "US Legal", "US Executive",
                       "ISO A0", "ISO A1", "ISO A2", "ISO A3", "ISO A5", "ISO A6", "ISO A7",
		       "ISO A8", "ISO A9", "ISO B0", "ISO B1","ISO B10", "ISO B2", "ISO B3",
		       "ISO B4", "ISO B6", "ISO B7", "ISO B8","ISO B9", "ISO C5", "US Common 10",
                       "ISO DL", "US Folio", "US Ledger", "US Tabloid"};

ConfigureDialog::ConfigureDialog(MainWin *mw, const char *name,KConfig *config)
	: KDialogBase (KDialogBase::IconList, i18n("Configure LabPlot"),
	KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel, KDialogBase::Ok),
	config(config)
{
	QFrame* general = addPage(i18n("General Options"),i18n("General Options"), BarIcon(QString("edit"), KIcon::SizeMedium));
	QVBoxLayout *genLayout = new QVBoxLayout(general);

	QLabel *label = new QLabel(i18n("Open worksheets as .. "),general);
	genLayout->addWidget(label);
	QHButtonGroup *bg = new QHButtonGroup(general);
	fullscreen = new QRadioButton(i18n("Fullscreen"), bg );
	fullscreen->setChecked(true);
	cascade = new QRadioButton(i18n("Cascade"), bg );
	if (config->readBoolEntry("Cascade",false))
		cascade->setChecked(true);
	// autosave
	QVButtonGroup *asbg = new QVButtonGroup(general);
	autosave = new QCheckBox(asbg, "Autosave");
	autosave->setText(i18n("Auto&save"));

	QHBox *hb = new QHBox(asbg);
	QLabel *lb = new QLabel(i18n("Interval &time in minutes (1 - 9999) : "),hb);
	asIntervalInput = new KIntNumInput(hb,"asIntervalInput");
        asIntervalInput->setRange(1, 9999, 1, false);
	lb->setBuddy(asIntervalInput);
	autosave->setChecked(config->readBoolEntry("Autosave",true));
	asIntervalInput->setValue(config->readLongNumEntry("AutosaveInterval",600000)/60000);
	
	genLayout->addWidget(bg);
	genLayout->addWidget(asbg);

	QFrame* printpreview = addPage(i18n("Print Preview"),i18n("Print Preview"), BarIcon(QString("printer"), KIcon::SizeMedium));
	QVBoxLayout *printLayout = new QVBoxLayout(printpreview);
	
	QVButtonGroup *printbg = new QVButtonGroup(i18n("Printer settings"),printpreview);
	color = new QRadioButton(i18n("Print in color if available") , printbg);
	color->setChecked(true);
	grayscale = new QRadioButton(i18n("Print in grayscale") , printbg);
	if (!config->readBoolEntry("ColorMode",true))
		grayscale->setChecked(true);

	printLayout->addWidget(printbg);
	
	QVButtonGroup *paperbg = new QVButtonGroup(i18n("Paper Format"),printpreview);
	
	orientation = new KComboBox(paperbg);
	QStringList olst;
	olst += QString("Portrait");
	olst += QString("Landscape");
	orientation->insertStringList(olst);
	orientation->setCurrentItem(config->readNumEntry("Orientation",1));

	pagesize = new KComboBox(paperbg);
	QStringList slst;
    	for ( int i = 0 ; i < 30 ; ++i )
        	slst << i18n( pageSize[ i ] );
	pagesize->insertStringList(slst);
	pagesize->setCurrentItem(config->readNumEntry("PageSize",9));

	printLayout->addWidget(paperbg);

	QObject::connect(this,SIGNAL(okClicked()),SLOT(ok_clicked()));
        QObject::connect(this,SIGNAL(applyClicked()),SLOT(apply_clicked()));
}

void ConfigureDialog::apply_clicked() {
	config->writeEntry("Cascade",cascade->isChecked());
	config->writeEntry("ColorMode",color->isChecked());
	config->writeEntry("Landscape",orientation->currentItem());
	config->writeEntry("PageSize",pagesize->currentItem());

	config->writeEntry("Autosave",autosave->isChecked());
	config->writeEntry("AutosaveInterval",asIntervalInput->value()*60000);
}

void ConfigureDialog::ok_clicked() {
	apply_clicked();
	accept();	
}
