//LabPlot : DataDialog.h

#ifndef DATADIALOG_H
#define DATADIALOG_H

#include <qtoolbutton.h>
#include <qcheckbox.h>
#include "Dialog.h"
#include "GraphListDialog.h"
#include "FilterAUDIOFILE.h"

/*! Main class for Data Dialog*/
class DataDialog: public Dialog
{
	Q_OBJECT
public:
	DataDialog(Worksheet *p, const char *name,class ListDialog *l,int item,PType newtype);
public slots:
	void selectFile();
	void applyStyle();
	void setLabel(){ labelle->setText(filele->text()); }
private slots :
	void fileInfo();
	void checkData();
	void updateRead();
	int addData();
	int agree();
	void ok_clicked() { if (!agree()) accept(); }
private:
	double formatLabel(QString value,int item);
	double getValue(FilterAUDIOFILE auf,int var, int i,double *data, int startRow);
	int type;
	QLabel *readx, *ready, *readz, *readt;
	KLineEdit *readxle, *readyle, *readzle, *readtle;
	KLineEdit *filele, *labelle;
	KComboBox *interpretxcb, *interpretycb, *interpretzcb, *interprettcb;
	KComboBox *cbi;	// Graph Type, Input
	QCheckBox *reread;
	KLineEdit *readsc, *startrow, *endrow;
	ListDialog *l;
	int item;
	Graph *graph;
};
#endif //DATADIALOG_H
