// //LabPlot : DifferencesListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#ifdef HAVE_GSL
#endif
#include "DifferencesListDialog.h"

using namespace std;

DifferencesListDialog::DifferencesListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Differences Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void DifferencesListDialog::apply_clicked() {
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/18);

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->getData();

		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx-1;i++) {
			double x=(a[i].X()+a[i+1].X())/2;
			double y=(a[i+1].Y()-a[i].Y())/(a[i+1].X()-a[i].X());
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString("differences of "+g->Label());

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,nx-1);
		p->addGraph2D(ng);
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();
}
