//LabPlot : DumpDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <klocale.h>
#include <kfilterbase.h>
#include <kfilterdev.h>
#include <kmessagebox.h>
#include <kimageio.h>
#include "DumpDialog.h"
#include "FilterCDF.h"
#include "FilterAUDIOFILE.h"
#include "Plot2DSurface.h"

#ifdef HAVE_CDF
#include <cdf.h>
#endif
#include <netcdf.h>
#include <audiofile.h>

using namespace std;

DumpDialog::DumpDialog(Worksheet *p, const char *name, int item)
	: Dialog(p, name), item(item),plot(p->getPlot(p->getAPI()))
{
	setCaption(i18n("Dump Data")+i18n(" : ")+QString(name));

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Filename (append .gz or .bz2 for compression) : "),hb);
	hb = new QHBox(vbox);
	filele = new KLineEdit(i18n("out.dat"),hb);
	KPushButton *newFile = new KPushButton(i18n("Browse"),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(vbox);
	new QLabel(i18n("Start Row : "),hb);
	startrow = new KLineEdit("1",hb);
	startrow->setValidator(new QIntValidator(startrow));
	new QLabel(i18n(" End Row : "),hb);
	endrow = new KLineEdit(i18n("END"),hb);
	// no validator here -> make "END" possible

	hb = new QHBox(vbox);
	new QLabel(i18n("Export to : "),hb);
        exportcb = new KComboBox(hb);
	QStringList elist;
	elist << i18n("ASCII") <<i18n("CDF") << i18n("NETCDF") << i18n("AUDIO");
	if ( plot->getType() == PSURFACE) 
		elist<<i18n("IMAGE");
	exportcb->insertStringList(elist);
	QObject::connect(exportcb,SIGNAL(activated (int)),SLOT(updateOptions(int)));
	exportcb->setCurrentItem(0);
	
	// ASCII
	hb = new QHBox(vbox);
	slabel = new QLabel(i18n("Separating character : "),hb);
        sc= new KComboBox(hb);
	QStringList slist;
	slist << i18n("SPACE");
	slist << i18n("TAB");
	slist << i18n(",");
	sc->insertStringList(slist);
	sc->setCurrentItem(0);

	// IMAGE
	hb = new QHBox(vbox);
	flabel = new QLabel(i18n("Format : "),hb);
        ic = new KComboBox(hb);
	QStringList ilist;
	
	for ( unsigned int i = 0; i < QImageIO::outputFormats().count(); i++ ) {
        	QString str = QString( QImageIO::outputFormats().at( i ) );
		ilist<<str;
	}

	ic->insertStringList(ilist);
	QObject::connect(ic,SIGNAL(activated (int)),SLOT(updateImageFormat(int)));
	ic->setCurrentItem(0);

#ifdef HAVE_CDF
	// cdf
	hb = new QHBox(vbox);
	cdfcomlabel = new QLabel(i18n("Compression : "),hb);
        cdfcomcb= new KComboBox(hb);
	QStringList clist;
	FilterCDF cdf;
	for ( unsigned int i = 0; i < 6; i++ )
        	clist << cdf.getComp(i);
	cdfcomcb->insertStringList(clist);
	cdfcomcb->setCurrentItem(0);

	hb = new QHBox(vbox);
	cdfenclabel = new QLabel(i18n("Encoding : "),hb);
        cdfenccb= new KComboBox(hb);
	QStringList enclist;
	for ( unsigned int i = 1; i < 17; i++ )
        	enclist << cdf.getEnc(i);
	cdfenccb->insertStringList(enclist);
	cdfenccb->setCurrentItem(0);
#endif
	
	// netcdf : nothing
	
	// audio
	hb = new QHBox(vbox);
	audioformatlabel = new QLabel(i18n("Format : "),hb);
        audioformatcb= new KComboBox(hb);
	QStringList alist;
	FilterAUDIOFILE auf;
	alist<<QString("RAW")<<QString("AIFFC")<<QString("AIFF")<<QString("SND");
	alist<<QString("WAV")<<QString("BICSF");
	audioformatcb->insertStringList(alist);
	QObject::connect(audioformatcb,SIGNAL(activated (int)),SLOT(updateAudioFormat(int)));
	audioformatcb->setCurrentItem(0);
	hb = new QHBox(vbox);
	samplelabel = new QLabel(i18n("Sample rate : "),hb);
	samplele = new KLineEdit("44100",hb);
	samplele->setValidator(new QIntValidator(samplele));

	// TODO : only selected region
	
	updateOptions(0);
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint()+QSize(0,30));
}

//! update options when changing exported format
void DumpDialog::updateOptions(int item) {
	slabel->hide();sc->hide();
	flabel->hide();ic->hide();
	cdfcomlabel->hide();cdfcomcb->hide();
	cdfenclabel->hide();cdfenccb->hide();
	audioformatlabel->hide();audioformatcb->hide();
	samplelabel->hide();samplele->hide();
	QString filename =  filele->text();
	
	switch(item) {
	case 0 : 
		slabel->show();sc->show(); 
		filename.replace( QRegExp(QString("[.]+.*")), ".dat" );	
		break;
	case 1:	// CDF 
		filename.replace( QRegExp(QString("[.]+.*")), ".cdf" );
		cdfcomlabel->show();cdfcomcb->show();
		cdfenclabel->show();cdfenccb->show();
		break;
	case 2:	// NETCDF
		filename.replace( QRegExp(QString("[.]+.*")), ".nc" );
		break;
	case 3: 	// AUDIO
		filename.replace( QRegExp(QString("[.]+.*")), "." + audioformatcb->currentText().lower() );
		audioformatlabel->show();audioformatcb->show();
		samplelabel->show();samplele->show();
		break;
	case 4 : 	// IMAGE
		flabel->show();ic->show();
		filename.replace( QRegExp(QString("[.]+.*")), "." + ic->currentText().lower() );
		break;
	}
        
	filele->setText(filename);
}

void DumpDialog::selectFile() {
	QString f = QFileDialog::getOpenFileName(filele->text(),QString("*.dat"), this );
	if (! f.isEmpty() )
		filele->setText(QString(f.latin1()));
}

int DumpDialog::apply_clicked() {
	QString filename = filele->text();

	// check if file exists
	if ( QFile::exists(filename) ) {
		int answer = KMessageBox::warningYesNoCancel( this, 
			i18n( "Overwrite\n\'%1\'?" ).arg( filename ), i18n("Export data"));
		if (answer != KMessageBox::Yes)
			return 1;
		else {
			// delete it (needed for CDF)
			QFile::remove(filename);
		}
	}

	QString sep;
	switch (sc->currentItem()) {
	case 0: sep=QString(" "); break;
	case 1: sep=QString("	"); break;
	case 2: sep=QString(","); break;
	}

	QIODevice *file=0;
	QTextStream t;
	if(exportcb->currentItem()==0) {	// ASCII
		file = KFilterDev::deviceForFile(filename,QString::null,TRUE);
		if(file == 0) file = new QFile(filename);

		if (! file->open( IO_WriteOnly )) {
			KMessageBox::error(this, i18n("Sorry. Could not open file for writing!"));
			return 0;
		}
	
		t.setDevice(file);
	}

	switch (exportcb->currentItem()) {
	case 0: dumpASCII(&t, sep); break;
	case 1: dumpCDF(filename); break;
	case 2: dumpNETCDF(filename); break;
	case 3: dumpAUDIOFILE(filename); break;
	case 4: dumpIMAGE(filename); break;
	}

	if(file) file->close();
	
	return 0;
}

void DumpDialog::dumpASCII(QTextStream *t, QString sep) {
	int start = startrow->text().toInt();
	int end = endrow->text().toInt();	
	
	GraphList *gl = plot->getGraphList();
	GRAPHType st =  gl->getStruct(item);
	switch(st) {
	case GRAPH2D: {
		Graph2D *g = gl->getGraph2D(item);
		Point *ptr=g->getData();
		for (int i=start;i<g->Number();i++) {
			if(end>0 && i>end) return;
			
			*t<<ptr[i].X()<<sep<<ptr[i].Y()<<endl;
		}}
		break;
	case GRAPH3D: {
		Graph3D *g = gl->getGraph3D(item);
		Point3D *ptr=g->getData();
		for (int i=start;i< g->NX()*g->NY();i++) {
			if(end>0 && i>end) return;
			
			*t<<ptr[i].X()<<sep<<ptr[i].Y()<<sep<<ptr[i].Z()<<endl;
		}}
		break;
	case GRAPH4D: {
		Graph4D *g = gl->getGraph4D(item);
		Point4D *ptr=g->getData();
		for (int i=start;i< g->Number();i++) {
			if(end>0 && i>end) return;
			
			*t<<ptr[i].X()<<sep<<ptr[i].Y()<<sep<<ptr[i].Z()<<sep<<ptr[i].T()<<endl;
		}}
		break;
	case GRAPHM: {
		GraphM *g = gl->getGraphM(item);
		double *array = g->getData();
		int nx=g->NX(), ny = g->NY();
		
		for (int i=0;i<nx;i++) {
			for (int j=0;j<ny;j++) {
				if(j>0)
					*t<<sep;
				*t<<array[j+ny*i];
			}
			*t<<endl;
		}
		}
		break;
	case GRAPHGRASS:
	case GRAPHVTK:
		break;
	}
}

void DumpDialog::dumpCDF(QString filename) {
#ifdef HAVE_CDF
	int start = startrow->text().toInt()-1;
	int end = endrow->text().toInt();

	// TODO	-> FilterCDF ???
	CDFid id;
	long dimsizes[1]={1};
	// extension is automatically added, so we need to delete it first
	filename.replace( QRegExp(QString("[.]+.*")), "" );
	CDFcreate(filename.latin1(),1,dimsizes,cdfenccb->currentItem()+1,ROW_MAJOR,&id);
	// enable compression
	long parms[1];
	switch(cdfcomcb->currentItem()) {
		case 1: parms[0]=RLE_OF_ZEROs;
		case 2: parms[0]=OPTIMAL_ENCODING_TREES;
		case 3: parms[0]=OPTIMAL_ENCODING_TREES;
		case 5: parms[0]=9;
	}
	CDFlib(PUT_,CDF_COMPRESSION_,(long) cdfcomcb->currentItem(),parms);
	
	static long varys[1]={NOVARY};
	long indices[1]={0};
	long varnum1,varnum2,varnum3,varnum4;
	double v;
	
	GraphList *gl = plot->getGraphList();
	GRAPHType st =  gl->getStruct(item);
	switch(st) {
	case GRAPH2D: {
		Graph2D *g = gl->getGraph2D(item);
		Point *ptr=g->getData();
		CDFvarCreate(id,"x",CDF_DOUBLE,1,VARY,varys,&varnum1);
		CDFvarCreate(id,"y",CDF_DOUBLE,1,VARY,varys,&varnum2);
		for(int i=0;i<=g->Number()-start;i++) {
			if(end>0 && i+start>end) break;
			v=ptr[i+start].X();
			CDFvarPut(id,varnum1,i,indices,&v);
			v=ptr[i+start].Y();
			CDFvarPut(id,varnum2,i,indices,&v);
		}
		}
		break;
	case GRAPH3D: {
		Graph3D *g = gl->getGraph3D(item);
		Point3D *ptr=g->getData();
		CDFvarCreate(id,"x",CDF_DOUBLE,1,VARY,varys,&varnum1);
		CDFvarCreate(id,"y",CDF_DOUBLE,1,VARY,varys,&varnum2);
		CDFvarCreate(id,"z",CDF_DOUBLE,1,VARY,varys,&varnum3);
		for(int i=0;i<=g->Number()-start;i++) {
			if(end>0 && i+start>end) break;
			v=ptr[i+start].X();
			CDFvarPut(id,varnum1,i,indices,&v);
			v=ptr[i+start].Y();
			CDFvarPut(id,varnum2,i,indices,&v);
			v=ptr[i+start].Z();
			CDFvarPut(id,varnum3,i,indices,&v);
		}
		}
	case GRAPH4D: {
		Graph4D *g = gl->getGraph4D(item);
		Point4D *ptr=g->getData();
		CDFvarCreate(id,"x",CDF_DOUBLE,1,VARY,varys,&varnum1);
		CDFvarCreate(id,"y",CDF_DOUBLE,1,VARY,varys,&varnum2);
		CDFvarCreate(id,"z",CDF_DOUBLE,1,VARY,varys,&varnum3);
		CDFvarCreate(id,"t",CDF_DOUBLE,1,VARY,varys,&varnum4);
		for(int i=0;i<=g->Number()-start;i++) {
			if(end>0 && i+start>end) break;
			v=ptr[i+start].X();
			CDFvarPut(id,varnum1,i,indices,&v);
			v=ptr[i+start].Y();
			CDFvarPut(id,varnum2,i,indices,&v);
			v=ptr[i+start].Z();
			CDFvarPut(id,varnum3,i,indices,&v);
			v=ptr[i+start].T();
			CDFvarPut(id,varnum4,i,indices,&v);
		}
		}
	case GRAPHM: {
		GraphM *g = gl->getGraphM(item);
		double *data = g->getData();
		int nx=g->NX(), ny=g->NY();
		// TODO : create 2 dim array nx * ny ?
		CDFvarCreate(id,"i",CDF_DOUBLE,1,VARY,varys,&varnum1);
		CDFvarCreate(id,"j",CDF_DOUBLE,1,VARY,varys,&varnum2);
		CDFvarCreate(id,"v",CDF_DOUBLE,1,VARY,varys,&varnum3);
		for(int i=0;i<=nx*ny-start;i++) {
			if(end>0 && i+start>end) break;
			v=i%nx;
			CDFvarPut(id,varnum1,i,indices,&v);
			v=(int)i/nx;
			CDFvarPut(id,varnum2,i,indices,&v);
			v=data[i];
			CDFvarPut(id,varnum3,i,indices,&v);
		}
		}
	case GRAPHGRASS:	
	case GRAPHVTK:
		break;
	}
	
	CDFclose(id);
#else
	// TODO : error message : CDF not available
#endif
}

void DumpDialog::dumpNETCDF(QString filename) {
	int start = startrow->text().toInt()-1;
	int end = endrow->text().toInt();

	int ncid;
	nc_create(filename.latin1(),NC_WRITE, &ncid);

	GraphList *gl = plot->getGraphList();
	GRAPHType st =  gl->getStruct(item);
	switch(st) {
	case GRAPH2D: {
		Graph2D *g = gl->getGraph2D(item);
		Point *ptr=g->getData();
		int nr = g->Number();
		if (end==0) end=nr;
		int N = end - start;
	
		int dimid;
		nc_def_dim(ncid,"vector",N,&dimid);
		int xvarid, yvarid;
		int dimids[1]={dimid};
		nc_def_var(ncid,"x",NC_DOUBLE, 1, dimids, &xvarid );
		nc_def_var(ncid,"y",NC_DOUBLE, 1, dimids, &yvarid );
		nc_enddef(ncid);
		double *xdata = new double[N];
		double *ydata = new double[N];
		for(int i=start;i<end;i++) {
			xdata[i-start]=ptr[i].X();
			ydata[i-start]=ptr[i].Y();
		}
		nc_put_var_double(ncid,xvarid,xdata);
		nc_put_var_double(ncid,yvarid,ydata);
		}
		break;
	case GRAPH3D: {
		Graph3D *g = gl->getGraph3D(item);
		Point3D *ptr=g->getData();
		int nr = g->Number();
		if (end==0) end=nr;
		int N = end - start;
	
		int dimid;
		nc_def_dim(ncid,"vector",N,&dimid);
		int xvarid, yvarid, zvarid;
		int dimids[1]={dimid};
		nc_def_var(ncid,"x",NC_DOUBLE, 1, dimids, &xvarid );
		nc_def_var(ncid,"y",NC_DOUBLE, 1, dimids, &yvarid );
		nc_def_var(ncid,"z",NC_DOUBLE, 1, dimids, &zvarid );
		nc_enddef(ncid);
		double *xdata = new double[N];
		double *ydata = new double[N];
		double *zdata = new double[N];
		for(int i=start;i<end;i++) {
			xdata[i-start]=ptr[i].X();
			ydata[i-start]=ptr[i].Y();
			zdata[i-start]=ptr[i].Z();
		}
		nc_put_var_double(ncid,xvarid,xdata);
		nc_put_var_double(ncid,yvarid,ydata);
		nc_put_var_double(ncid,zvarid,zdata);
		}
		break;
	case GRAPH4D: {
		Graph4D *g = gl->getGraph4D(item);
		Point4D *ptr=g->getData();
		int nr = g->Number();
		if (end==0) end=nr;
		int N = end - start;
	
		int dimid;
		nc_def_dim(ncid,"vector",N,&dimid);
		int xvarid, yvarid, zvarid, tvarid;
		int dimids[1]={dimid};
		nc_def_var(ncid,"x",NC_DOUBLE, 1, dimids, &xvarid );
		nc_def_var(ncid,"y",NC_DOUBLE, 1, dimids, &yvarid );
		nc_def_var(ncid,"z",NC_DOUBLE, 1, dimids, &zvarid );
		nc_def_var(ncid,"t",NC_DOUBLE, 1, dimids, &tvarid );
		nc_enddef(ncid);
		double *xdata = new double[N];
		double *ydata = new double[N];
		double *zdata = new double[N];
		double *tdata = new double[N];
		for(int i=start;i<end;i++) {
			xdata[i-start]=ptr[i].X();
			ydata[i-start]=ptr[i].Y();
			zdata[i-start]=ptr[i].Z();
			tdata[i-start]=ptr[i].T();
		}
		nc_put_var_double(ncid,xvarid,xdata);
		nc_put_var_double(ncid,yvarid,ydata);
		nc_put_var_double(ncid,zvarid,zdata);
		nc_put_var_double(ncid,tvarid,tdata);
		}
		break;
	case GRAPHM: {
		GraphM *g = gl->getGraphM(item);
		double *data=g->getData();
		int nx = g->NX(), ny = g->NY();
	
		int xdimid, ydimid;
		nc_def_dim(ncid,"x",nx,&xdimid);
		nc_def_dim(ncid,"y",ny,&ydimid);
		int varid;
		int dimids[2]={xdimid,ydimid};
		nc_def_var(ncid,"value",NC_DOUBLE, 2, dimids, &varid );
		nc_enddef(ncid);
		
		nc_put_var_double(ncid,varid,data);
		}
		break;
	case GRAPHGRASS:
	case GRAPHVTK:
		break;
	}
	
	nc_close(ncid);
}

void DumpDialog::dumpAUDIOFILE(QString filename) {
	int start = startrow->text().toInt()-1;
	int end = endrow->text().toInt();

	AFfilehandle af=0;
	AFfilesetup setup = afNewFileSetup();
	afInitFileFormat(setup, audioformatcb->currentItem());
	afInitRate(setup, AF_DEFAULT_TRACK, samplele->text().toInt());
 	afInitSampleFormat(setup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, 16);

	GraphList *gl = plot->getGraphList();
	GRAPHType st =  gl->getStruct(item);
	switch(st) {
	case GRAPH2D: {
		Graph2D *g = gl->getGraph2D(item);
		Point *ptr=g->getData();
		if (end==0) end=g->Number();
		int N = end - start;

		afInitChannels(setup, AF_DEFAULT_TRACK, 1);
		af = afOpenFile(filename.latin1(),"w",setup);

		short *data = new short[N];	// frameCount=1(mono),2(stereo)
	
		for(int i=start;i<end;i++)
			data[i-start] = (int) ptr[i].Y();

		afWriteFrames(af,AF_DEFAULT_TRACK,(void *) data, N);
		}
		break;
	case GRAPH3D: {
		Graph3D *g = gl->getGraph3D(item);
		Point3D *ptr=g->getData();
		if (end==0) end=g->Number();
		int N = end - start;

		afInitChannels(setup, AF_DEFAULT_TRACK, 2);
		af = afOpenFile(filename.latin1(),"w",setup);

		short *data = new short[2*N];
		
		for(int i=start;i<end;i++) {
			data[2*i-start] = (int) ptr[i].Y();
			data[2*i+1-start] = (int) ptr[i].Z();
		}
				
		afWriteFrames(af,AF_DEFAULT_TRACK,(void *) data, N);
		}
	default: break;
	}

	afCloseFile(af);
}

// this is only called with GRAPHM
void DumpDialog::dumpIMAGE(QString filename) {
	GraphList *gl = plot->getGraphList();
	GraphM *g = gl->getGraphM(item);
	double *array = g->getData();
	int nx=g->NX(), ny = g->NY();	
	LRange range = g->getRange(2);
	Plot2DSurface *plot2 =(Plot2DSurface *) plot;
	
	// depth = 8, numColors = 256
	QImage *image = new QImage(nx,ny,8,256);
	for (int i=0;i<256;i++) {
		QColor c = plot2->getColor(i,plot2->getPalette());
		image->setColor (i, c.rgb() );
	}

	for (int i=0;i<nx;i++) {
		for (int j=0;j<ny;j++) {
			unsigned int value =  (int)((array[j+ny*i]-range.Min())/(range.Max()-range.Min())*255.0);
			image->setPixel(i,j,value);
		}
	}
	image->save(filename,ic->currentText());
	free(image);
}
