//LabPlot : EditDialog.h

#ifndef EDITDIALOG_H
#define EDITDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qtable.h>
#include <kprocess.h>
#include <ktempfile.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "Graph.h"
#include "ListDialog.h"

class EditDialog: public Dialog
{
	Q_OBJECT
public:
	EditDialog(Worksheet *p, const char *name, int item,ListDialog *ld=0);
public slots:
	void select() {
#if QT_VERSION >0x030005
	table->selectCells(0,0,table->numRows(),table->numCols());
#endif
	}
	void deselect() { table->clearSelection(); }
	void deleteSelection();
	void evaluateExpression();
	void sortascColumn();
	void sortdescColumn();
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
private slots:
	void edit_editor(int editor);
	void readfile(KProcess*);
private:
	ListDialog *ld;		// used for updating list view
	QTable *table;
	Graph2D *graph2d;
	Graph3D *graph3d;
	GraphM *graphm;
	Graph4D *graph4d;
	KLineEdit *evalle;
	KComboBox *editorcb;
	QString filename;		// temp file for external editor
	int number, numberx, numbery;
};

#endif //EDITDIALOG_H
