//LabPlot : ExplorerDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "ExplorerDialog.h"

ExplorerDialog::ExplorerDialog(Worksheet *p, const char *name)
	: Dialog(p, name),mw(p->getMainWin())
{
	setCaption(i18n("Project Explorer"));

	lv = new QListView(vbox,0);
	lv->addColumn(i18n("Object"));
	lv->addColumn(i18n("Type"));
	lv->setRootIsDecorated( TRUE );

	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);

	menu = new QPopupMenu( lv );
       	menu->insertItem( i18n( "Delete" ) );
	connect(lv, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( rmouse( QListViewItem *, const QPoint &, int ) ) );

	initlist();

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(300,500);
}

void ExplorerDialog::initlist() {
	QWorkspace *ws = mw->getWorkspace();
	QWidgetList list = ws->windowList();

	for (unsigned int i = 0; i < list.count(); ++i ) {
		kdDebug()<<" LIST : Worksheet "<<i<<endl;
		QListViewItem *lviworksheet = new QListViewItem(lv);
		lviworksheet->setText(0,"Worksheet "+QString::number(i+1));
		lviworksheet->setText(1,"Worksheet");
		Worksheet *worksheet =  ((Worksheet *) list.at(i));
		for (unsigned int j=0;j<worksheet->getNrPlots();j++) {
			QListViewItem *lviplot = new QListViewItem(lviworksheet);
			lviplot->setText(0,"Plot "+QString::number(j+1));
			Plot *plot = worksheet->getPlot(j);

			QString ptype;
			switch(plot->getType()) {
			case P2D: ptype=i18n("2 D"); break;
			case PSURFACE: ptype=i18n("SURFACE"); break;
			case P3D: ptype=i18n("3 D"); break;
			case PGRASS: ptype=i18n("GRASS"); break;
			case PVTK: ptype=i18n("VTK"); break;
			case PPIE: ptype=i18n("PIE"); break;
			case PPOLAR: ptype=i18n("POLAR"); break;
			case PTERNARY: ptype=i18n("TERNARY"); break;
			}
			lviplot->setText(1,ptype);

			// list of graphs
			kdDebug()<<"getting list of graphs for plot "<<j<<" of type "<<ptype<<endl;
			GraphList *graphlist = plot->getGraphList();
			for(unsigned int k=0;k<graphlist->getNumber();k++) {
				QListViewItem *lvigraph = new QListViewItem(lviplot);
				lvigraph->setText(0,"Graph "+QString::number(k+1));
				QString gtype;
				switch (graphlist->getStruct(k) ) {
				case GRAPH2D: gtype=i18n("2 D"); break;
				case GRAPH3D: gtype=i18n("3 D"); break;
				case GRAPHM: gtype=i18n("MATRIX"); break;
				case GRAPHGRASS: gtype=i18n("GRASS"); break;
				case GRAPHVTK: gtype=i18n("VTK"); break;
				case GRAPH4D: gtype=i18n("4 D"); break;
				}
				lvigraph->setText(1,gtype);
			}
			// TODO : crash with this function
			//lv->setOpen(lviplot,true);
		}
		lv->setOpen(lviworksheet,true);
	}
	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);
}

void ExplorerDialog::rmouse(QListViewItem *item, const QPoint & point, int ) {
	//if( item )
        //menu->popup( point );
	// TODO
}
