//LabPlot : FFTListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#ifdef HAVE_GSL
#include <gsl/gsl_fft_complex.h>
#endif
#ifdef HAVE_FFTW3
#include <fftw3.h>
#elif HAVE_FFTW
#include <fftw.h>
#endif
#include <math.h>
#include "FFTListDialog.h"

using namespace std;

FFTListDialog::FFTListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("FFT Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n("Library : "),hb);
        library = new KComboBox(hb);
	QStringList llist;
#if defined(HAVE_FFTW) || defined(HAVE_FFTW3)
	llist << i18n("fftw");
#endif
#ifdef HAVE_GSL
	llist << i18n("gsl");
#endif
	library->insertStringList(llist);
	library->setCurrentItem(0);

	hb = new QHBox(tab1);
	new QLabel(i18n("Transform : "),hb);
        transform = new KComboBox(hb);
	QStringList tlist;
	tlist << i18n("forward") << i18n("backward");
	transform->insertStringList(tlist);
	transform->setCurrentItem(0);

	hb = new QHBox(tab1);
	new QLabel(i18n("x-values : "),hb);
        xvalues = new KComboBox(hb);
	QStringList vlist;
	vlist << i18n("index")<< i18n("frequency") << i18n("period");
	xvalues->insertStringList(vlist);
	xvalues->setCurrentItem(0);

	hb = new QHBox(tab1);
	new QLabel(i18n("y-values : "),hb);
        yvalues = new KComboBox(hb);
	QStringList ylist;
	ylist << i18n("magnitude") << i18n("real") << i18n("imag") << i18n("phase");
	yvalues->insertStringList(ylist);
	yvalues->setCurrentItem(0);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void FFTListDialog::apply_clicked() {
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/18);

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);
	
	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->getData();
		LRange range = g->getRange(0);
		double *tmp = (double *) malloc(nx*sizeof(double));

		// copy the data
		for (int i = 0;i<nx;i++)
			tmp[i]=a[i].Y();

		int N=nx/2;
#ifdef HAVE_FFTW3
		fftw_complex *in = 0, *out = 0;
		if (library->currentText() == QString("fftw")) { // only if fftw is selected
			in = (fftw_complex *) fftw_malloc(sizeof(fftw_complex) * nx);
			out = (fftw_complex *) fftw_malloc(sizeof(fftw_complex) * nx);
		}
#elif HAVE_FFTW
		fftw_complex *in = 0, *out = 0;
		if (library->currentText() == QString("fftw")) { // only if fftw is selected
			in = new fftw_complex[nx];
			out = new fftw_complex[nx];
		}
#endif

		// initialize
#ifdef HAVE_GSL
   		#define REAL(z,i) ((z)[2*(i)])
     		#define IMAG(z,i) ((z)[2*(i)+1])
		double *data=0;
		
		if (library->currentText() == QString("gsl"))	// only if gsl is selected
			data = new double[2*nx];

#endif

		if (library->currentText() == QString("fftw")) {
#if defined(HAVE_FFTW3)
			int sign=0;
#elif defined(HAVE_FFTW)
			fftw_direction sign=FFTW_FORWARD;
#endif
#if defined(HAVE_FFTW3) || defined(HAVE_FFTW)
			switch(transform->currentItem()) {
			case 0:
				sign = FFTW_FORWARD;
			case 1:
				sign = FFTW_BACKWARD;
			}
#endif

			// fft the data set
#ifdef HAVE_FFTW3
			for (int i=0;i<nx;i++) {
				in[i][0] = tmp[i];
				in[i][1] = 0;
			}

			fftw_plan plan = fftw_plan_dft_1d(nx, in, out, sign, FFTW_ESTIMATE);

			fftw_execute(plan);
			fftw_destroy_plan(plan);

			out[0][0]=0.0;
			out[0][1]=0.0;
			for(int i=1;i<N;i++) {
				out[i][0] += out[nx-i][0];
				out[i][1] -= out[nx-i][1];
			}
#elif HAVE_FFTW
			for (int i=0;i<nx;i++) {
				in[i].re = tmp[i];
				in[i].im = 0;
			}
			
			fftw_plan plan = fftw_create_plan(nx, sign, FFTW_ESTIMATE);
          
          		fftw_one(plan, in, out);
          		fftw_destroy_plan(plan);
			
			out[0].re=0.0;
			out[0].im=0.0;
			for(int i=1;i<N;i++) {
				out[i].re += out[nx-i].re;
				out[i].im -= out[nx-i].im;
			}
#endif
		}
		else {	
#ifdef HAVE_GSL
			for (int i = 0; i < nx; i++) {
				REAL(data,i) = tmp[i];
				IMAG(data,i) = 0.0;
			}
			
			gsl_fft_complex_workspace *workspace = gsl_fft_complex_workspace_alloc(nx);
			gsl_fft_complex_wavetable *wavetable = gsl_fft_complex_wavetable_alloc(nx);

			gsl_fft_direction sign = forward;
			switch(transform->currentItem()) {
			case 0:
				sign = forward;
			case 1:
				sign = backward;
			}

		 	gsl_fft_complex_transform (data,1,nx,wavetable,workspace,sign);
			
			gsl_fft_complex_wavetable_free(wavetable);
			gsl_fft_complex_workspace_free(workspace);

			REAL(data,0)=0.0;
			IMAG(data,0)=0.0;
			for(int i=1;i<N;i++) {
 				REAL(data,i) += REAL(data,nx-i);
				IMAG(data,i) -= IMAG(data,nx-i);
			}
#endif
		}

		// create new data set
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<N;i++) {
			double dx = range.Max()-range.Min();
			
			// x-values
			double x = i;
			switch (xvalues->currentItem()) {
			case 0: x = i;break;
			case 1: x = (double)i/dx;break;
			case 2: x = 2*M_PI*(double)i/dx;break;
			}

			//y-values
			double y=0;
			if (library->currentText()==QString("fftw")) {
#ifdef HAVE_FFTW3
				switch (yvalues->currentItem()) {
				case 0:
					y=hypot(out[i][0],out[i][1]);
					break;
				case 1:
					y=out[i][0];
					break;
				case 2:
					y=out[i][1];
					break;
				case 3:
					y=atan2(out[i][0],out[i][1]);
					break;
				}
#elif HAVE_FFTW
				switch (yvalues->currentItem()) {
				case 0:
					y=hypot(out[i].re,out[i].im);
					break;
				case 1:
					y=out[i].re;
					break;
				case 2:
					y=out[i].im;
					break;
				case 3:
					y=atan2(out[i].re,out[i].im);
					break;
				}
#endif
			}
			else {
#ifdef HAVE_GSL
				switch (yvalues->currentItem()) {
				case 0:
					y=hypot(REAL(data,i),IMAG(data,i));
					break;
				case 1:
					y=REAL(data,i);
					break;
				case 2:
					y=IMAG(data,i);
					break;
				case 3:
					y=atan2(REAL(data,i),IMAG(data,i));
					break;
				}
#endif
			}

			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

#ifdef HAVE_FFTW3
		if (library->currentText() == QString("fftw")) {
			fftw_free(in); 
			fftw_free(out);
		}
#elif HAVE_FFTW
		if (library->currentText() == QString("fftw")) {
			free(in);
			free(out);
		}
#endif
#ifdef HAVE_GSL
		if (library->currentText() == QString("gsl")) {
			free(data);
		}
#endif

		// create the new Graph only if fft is possible
#if defined(HAVE_FFTW3) || defined(HAVE_FFTW) || defined(HAVE_GSL)
		LRange newrange[2];
		newrange[0] = LRange(xmin,xmax);
		newrange[1] = LRange(ymin,ymax);

		QString fun = QString("fft of ")+g->Label();

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,newrange,P2D,style,symbol,ptr,N);
		p->addGraph2D(ng);
#endif
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();
}
