//LabPlot : FilterCDF.h

#ifndef FILTERCDF_H
#define FILTERCDF_H

#include <qstring.h>
#include <qstringlist.h>

#ifdef HAVE_CDF
#include <cdf.h>
#endif

class FilterCDF
{
public:
	FilterCDF(QString filename=0);
#ifdef HAVE_CDF
	bool fileOK() { return fileok; }
	QString version();
	QString copyright();
	long getNDims() { return ndims; }
	QString getMaj();
	QString getCompression();
	long getMaxRec() { return maxrec; }
	long getNVars() { return nvars; }
	long getNAtts() { return natts; }
	QString getAtt(int aid);				 	// get attribute aid
	QString getVar(int varid);					// get variable varid
	long getVarLen(QString name);
	QStringList getDataString(int varid);		// data info
	double getData(QString varname, int i);	
	
	QString getComp(int c);
	QString getEnc(int e);
protected:
	QString getType(int t);
	bool isZvar(int varid);
	bool isZvar(QString varname);
	double getValue(void *value,long type);
#endif
private:
	QString filename;			// file name
#ifdef HAVE_CDF
	bool fileok;				// is a netcdf file and readable
	CDFid id;					// file id
	long ndims, enc, nvars, natts, maj, maxrec;  
	long inquire(int type);
#endif
};

#endif //FILTERCDF_H
