//LabPlot : FitListDialog.h

#ifndef FITLISTDIALOG_H
#define FITLISTDIALOG_H

#include <qtextedit.h>
#include "ListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_multifit_nlin.h>
int fun_f(const gsl_vector *x, void *params, gsl_vector *f);
int fun_df(const gsl_vector *x, void *params, gsl_matrix *J);
int fun_fdf(const gsl_vector *x, void *params, gsl_vector *f,gsl_matrix *J);
#endif

class FitListDialog : public ListDialog
{
	Q_OBJECT
public:
	FitListDialog(Worksheet *p, const char *name);
private slots:
	void updateModel(int model);
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
private:
#ifdef HAVE_GSL
	void print_state(int iter, gsl_multifit_fdfsolver * s);
#endif
	QTextEdit *infote;
	KComboBox *modelcb;
	QCheckBox *regioncb, *baselinecb;
	KLineEdit *funle, *parle, *stepsle, *tolle;
	KLineEdit *par1le, *par2le, *par3le;
	KLineEdit *par4le, *par5le, *par6le;
	KLineEdit *regionminle, *regionmaxle, *baselinele;
	KLineEdit *minle, *maxle;
};

#endif // FITLISTDIALOG_H

