//LabPlot : FunctionDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

#ifdef USE_SOLARIS
#include <ieeefp.h>
#endif

#include <qlabel.h>
#include <qhbox.h>
#include <qcolordialog.h>
#include <qprogressdialog.h>
#include <qtabwidget.h>
#include <klocale.h>
#include <kdebug.h>
#include "FunctionDialog.h"
#include "Plot2DSurface.h"
#include "defs.h"

#ifdef HAVE_GSL
#include <gsl/gsl_math.h>
#endif

using namespace std;

/*! newtype -> new 3D Plot type*/
FunctionDialog::FunctionDialog(Worksheet *p, const char *name, ListDialog *l, int item, PType newtype)
	: Dialog(p, name), l(l), item(item)
{
	Plot *plot = p->getPlot(p->getAPI());
	if (plot != 0)
		type = plot->getType();
	else
		type = newtype;

	kdDebug()<<"FunctionDialog"<<endl;
	kdDebug()<<"Type = "<<type<<endl;

	QString caption;
	if (type == P2D)
		caption=i18n("2D Function Dialog");
	else if (type == P3D)
		caption=i18n("3D Function Dialog");
	else if (type == PSURFACE)
		caption=i18n("2D Surface Function Dialog");
	else if (type == PPOLAR)
		caption=i18n("2D Polar Function Dialog");
	caption += i18n(" : ")+QString(name);
	setCaption(caption);

	Style style;
	Symbol symbol;
	LRange rx, ry;
	GRAPHType s = GRAPH2D;
	int nrx = 0, nry = 0;

	if(type == PPOLAR) {
		symbol.setType(1);
	}

	// default style and symbol for polar plots
	if (item == -1) {	// new graph
		graph = 0;
	}
	else {
		GraphList *graphlist = plot->getGraphList();
		graph = graphlist->getGraph(item);
		s = graphlist->getStruct(item);

		style = graph->getStyle();
		symbol = graph->getSymbol();
		kdDebug()<<"Struct : "<<s<<endl;

		if (s == GRAPH2D) {
			Graph2D *g = graphlist->getGraph2D(item);
			rx = g->getRange(0);
			nrx = graph->Number();
		}
		else if (s == GRAPH3D) {
			Graph3D *g = graphlist->getGraph3D(item);
			rx = g->getRange(0);
			ry = g->getRange(1);
			nrx = g->NX();
			nry = g->NY();
		}
		else if (s == GRAPHM) {
			GraphM *g = graphlist->getGraphM(item);
			rx = g->getRange(0);
			ry = g->getRange(1);
			nrx = g->NX();
			nry = g->NY();
		}
	}

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QString fun("sin(x)");
	if (type == P3D || type == PSURFACE)
		fun = QString("sin(x+y)");
	if (graph != 0) fun = graph->Name();
	new QLabel(i18n("Function :"),tab1);
	funle = new KLineEdit(fun,tab1);

	QHBox *hb = new QHBox(tab1);
	if (graph !=0) {
		reread = new QCheckBox(i18n("Recreate Function"),hb);
		reread->setChecked(0);
	}
	else
		reread=0;

	QString label = fun;
	if (graph != 0) label = graph->Label();
	new QLabel(i18n("Label :"),tab1);
	hb = new QHBox(tab1);
	labelle = new KLineEdit(label,hb);
	KPushButton *setLabel = new KPushButton(i18n("Set Label"),hb);
	QObject::connect(setLabel,SIGNAL(clicked()),SLOT(setLabel()));

	new QLabel(i18n("Range :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(QString("x = "),hb);

	double x1 = 0, x2 = 1;
	if (type == PSURFACE) {
		x1=0;
		x2=1;
	}
	if (graph != 0) {
		x1 = rx.Min();
		x2 = rx.Max();
	}
	xmin = new KLineEdit(QString::number(x1),hb);
	xmin->setValidator(new QDoubleValidator(xmin));
	new QLabel(QString(" .. "),hb);
	xmax = new KLineEdit(QString::number(x2),hb);
	xmax->setValidator(new QDoubleValidator(xmax));
	if (type == P3D || type == PSURFACE) {
		new QLabel(QString(" y = "),hb);

		double y1 = 0, y2 = 1;
		if (type == PSURFACE) {
			y1=0;
			y2=1;
		}
		if (graph != 0) {
			x1 = rx.Min();
			x2 = rx.Max();
			y1 = ry.Min();
			y2 = ry.Max();
		}
		ymin = new KLineEdit(QString::number(y1),hb);
		ymin->setValidator(new QDoubleValidator(ymin));
		new QLabel(QString(" .. "),hb);
		ymax = new KLineEdit(QString::number(y2),hb);
		ymax->setValidator(new QDoubleValidator(ymax));
	}
	new QLabel(i18n("Number of Points :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(QString("NX = "),hb);
	if(type == P2D || type == PPOLAR) {
		if (graph == 0) nrx = 100;
		nx = new KLineEdit(QString::number(nrx),hb);
		nx->setValidator(new QIntValidator(nx));
	}
	else if (type == P3D || type == PSURFACE){
		if (graph == 0) {
			nrx = 10;
			nry = 10;
		}
		nx = new KLineEdit(QString::number(nrx),hb);
		nx->setValidator(new QIntValidator(nx));
		new QLabel(QString("NY = "),hb);
		ny = new KLineEdit(QString::number(nry),hb);
		ny->setValidator(new QIntValidator(ny));
	}

	tw->addTab(tab1,i18n("Parameter"));
	
	QVBox *styletab, *annotatetab;
	if (type == PSURFACE) {
		styletab = surfaceStyle(tw);
		tw->addTab(styletab,i18n("Style"));
	}
	else {
		styletab = simpleStyle(tw,graph, &style, &symbol);
		annotatetab = annotateValuesTab(tw,graph);
		tw->addTab(styletab,i18n("Style"));
		tw->addTab(annotatetab,i18n("Annotate Values"));
	}
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(agree()));

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

int FunctionDialog::agree() {
	kdDebug()<<"FunctionDialog::agree()"<<endl;
	QString label = labelle->text();
	int status=0;
	if (reread == 0 || reread->isChecked()) {
		status = addFunction();
	}
	else {
		if(type == PSURFACE) {
			if (p != 0) {
				Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->getAPI());

				if (plot != 0) {
					plot->enableDensity(dcb->isChecked());
					plot->enableContour(ccb->isChecked());
					plot->setNumber(numberle->text().toInt());
					plot->setPalette(pcb->currentItem());
					plot->setContourColor(contourcolor->color());
					plot->setColoredContour(coloredcb->isChecked());
					plot->setMesh(meshcb->isChecked());
					plot->setRelative(relativecb->isChecked());
					plot->setBrush(dbrushcb->currentItem());
					plot->setThreshold(thresholdle->text().toDouble());
				}
			}
		}
		else {
			Style style(cb2->currentItem(),color->color(),filled->isChecked(),
				fcolor->color(),widthle->text().toInt(),
				pencb->currentItem(),brushcb->currentItem());
			Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
					(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
			AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
			graph->setStyle(style);
			graph->setSymbol(symbol);
			graph->setAnnotateValues(av);
		}
		graph->setLabel(label);
	}

	if(l) l->updateList();
	p->repaint();

	kdDebug()<<"FunctionDialog::agree() OK"<<endl;
	return status;
}

int FunctionDialog::addFunction() {
	QString fun = funle->text();
	QString label = labelle->text();
	int NX = (nx->text()).toInt();
	int NY = 0;
	if (type == P3D || type == PSURFACE)
		NY = (ny->text()).toInt();

	QProgressDialog progress( "Creating function ...", "Cancel", NX,this, "progress", TRUE );
	progress.setMinimumDuration(2000);
	if (type == P2D || type == PPOLAR) {
		Point *ptr = new Point[NX];
		char buf[500];
		QString tmp;

		double ymin=0, ymax=1;
		double xmi = parse((char *) (xmin->text()).latin1());
		double xma = parse((char *) (xmax->text()).latin1());
		for(int i = 0;i < NX;i++) {
			if(i%100 == 0) progress.setProgress( i );
    			qApp->processEvents();

			double x = (xma-xmi)*i/(double)(NX-1)+xmi;
			sprintf(buf,"(%g)",(xma-xmi)*i/(double)(NX-1)+xmi);
			tmp=fun;
			if (tmp.length()==1)
				tmp += " ";

			int pos;
			do {
				pos = tmp.find(QRegExp("x\\W"));
				if (pos>=0) {
					tmp.replace(pos,1," ");
					tmp.insert(pos,buf);
				}
			} while(pos>=0);
			do {
				pos = tmp.find(QRegExp("\\Wx"));
				if (pos>=0) {
					tmp.replace(pos+1,1," ");
					tmp.insert(pos+1,buf);
				}
			} while(pos>=0);

			double y = parse((char *) tmp.latin1());

			//kdDebug()<<"tmp = "<<tmp<<endl;
			//kdDebug()<<"y = "<<y<<endl;

			if (!finite(y))
				y=0;

			if (i == 0) ymin=ymax=y;
			y<ymin?ymin=y:0;
			y>ymax?ymax=y:0;

			ptr[i].setPoint(x,y);
			if ( progress.wasCancelled() )
        			return 1;
		}
		if(graph != 0)
			p->getPlot(p->getAPI())->getGraphList()->delGraph(item);

		if(ymax-ymin == 0) {
			ymin -= 1;
			ymax += 1;
		}

		if(type == PPOLAR) {
			xmi = 0;
			xma = 2*M_PI;
		}
		
		LRange range[2];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymin,ymax);
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),
			fcolor->color(),widthle->text().toInt(),
			pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		kdDebug()<<"range[0]="<<range[0].Min()<<","<<range[0].Max()<<endl;
		kdDebug()<<"range[1]="<<range[1].Min()<<","<<range[1].Max()<<endl;
		kdDebug()<<"sfc = "<<sfcolor->color().name()<<endl;

		Graph2D *g = new Graph2D(fun,label,range,type,style,symbol,ptr,NX);
		
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
		g->setAnnotateValues(av);
		p->addGraph2D(g);
	}
	else if (type == PSURFACE) {
		kdDebug() << "\"surface\" selected"<<endl;
		kdDebug()<<"NX = "<<NX<<"/ NY = "<<NY<<endl;

		double *a = new double[NY*NX];

		double xmi=0, xma=1, ymi=0, yma=1, zmin=0, zmax=1;
		for (int i=0;i<NY;i++) {
			if(i%10==0)progress.setProgress( i );
    			qApp->processEvents();
			xmi = parse((char *) (xmin->text()).latin1());
			xma = parse((char *) (xmax->text()).latin1());
			ymi = parse((char *) (ymin->text()).latin1());
			yma = parse((char *) (ymax->text()).latin1());
			char buf[500];
			double y = (yma-ymi)*i/(double)(NY-1)+ymi;
			int pos;
			sprintf(buf,"(%f)",y);
			QString tmp(fun);
			if (tmp.length()==1)
				tmp += " ";
			do {
				pos = tmp.find(QRegExp("y\\W"));
				if (pos>=0) {
					tmp.replace(pos,1," ");
					tmp.insert(pos,buf);
				}
			} while(pos>=0);
			do {
				pos = tmp.find(QRegExp("\\Wy"));
				if (pos>=0) {
					tmp.replace(pos+1,1," ");
					tmp.insert(pos+1,buf);
				}
			} while(pos>=0);

			for (int j=0;j<NX;j++) {
				double z, x = (xma-xmi)*j/(double)(NX-1)+xmi;
				sprintf(buf,"(%f)",x);
				QString tmp2 = tmp;
				do {
					pos = tmp2.find(QRegExp("x\\W"));
					if (pos>=0) {
						tmp2.replace(pos,1," ");
						tmp2.insert(pos,buf);
					}
				} while(pos>=0);
				do {
					pos = tmp2.find(QRegExp("\\Wx"));
					if (pos>=0) {
						tmp2.replace(pos+1,1," ");
						tmp2.insert(pos+1,buf);
					}
				} while(pos>=0);

				z = parse((char *) tmp2.latin1());

				//kdDebug()<<"z = "<<z<<" (i/j = "<<i<<'/'<<j<<")\n";

				if (!finite(z))
					z=0;

				a[j+NX*i] = z;

				if (i == 0 && j == 0) {
					zmin=z;
					zmax=z;
				}

				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			if ( progress.wasCancelled() )
        			return 1;
		}

		Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->getAPI());

		// edit graph
		if(graph != 0)
			plot->getGraphList()->delGraph(item);

		if (plot != 0) {
			plot->enableDensity(dcb->isChecked());
			plot->enableContour(ccb->isChecked());
			plot->setNumber(numberle->text().toInt());
			plot->setPalette(pcb->currentItem());
			plot->setContourColor(contourcolor->color());
			plot->setColoredContour(coloredcb->isChecked());
			plot->setMesh(meshcb->isChecked());
			plot->setRelative(relativecb->isChecked());
			plot->setBrush(dbrushcb->currentItem());
			plot->setThreshold(thresholdle->text().toDouble());
		}

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		range[0] = LRange(0,NX);
		range[1] = LRange(0,NY);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"zmin : "<<zmin<<"/ zmax : "<<zmax<<endl;
		kdDebug()<<"range : "<<range[0].Min()<<' '<<range[0].Max()<<endl;
		kdDebug()<<"range : "<<range[1].Min()<<' '<<range[1].Max()<<endl;
		kdDebug()<<"range : "<<range[2].Min()<<' '<<range[2].Max()<<endl;
		/*for(int i=0;i<NX;i++) {
			for(int j=0;j<NY;j++) {
				kdDebug()<<" ("<<j+NY*i<<')'<<a[j+NY*i]<<endl;
			}
			kdDebug()<<endl;
		}*/

		Style style(0);
		Symbol symbol(SNONE);
		GraphM *g = new GraphM(fun,label,range,type,style,symbol,a,NX,NY);
		p->addGraphM(g);
	}
	else if (type == P3D) {
		kdDebug() << "\"3d\" selected"<<endl;

		Point3D *ptr = new Point3D[NX*NY];

		double xmi=0, xma=1, ymi=0, yma=1, zmin=0, zmax=1;
		xmi = (xmin->text()).toDouble();
		xma = (xmax->text()).toDouble();
		ymi = (ymin->text()).toDouble();
		yma = (ymax->text()).toDouble();
		for(int i = 0;i < NY;i++) {
			if(i%100==0)progress.setProgress( i );
    			qApp->processEvents();

			char buf[500];
			double z, y = (yma-ymi)*i/(double)(NY-1)+ymi;
			int pos;
			sprintf(buf,"(%f)",y);
			QString tmp(fun);
			if (tmp.length()==1)
				tmp += " ";

			do {
				pos = tmp.find(QRegExp("y\\W"));
				if (pos>=0) {
					tmp.replace(pos,1," ");
					tmp.insert(pos,buf);
				}
			} while(pos>=0);
			do {
				pos = tmp.find(QRegExp("\\Wy"));
				if (pos>=0) {
					tmp.replace(pos+1,1," ");
					tmp.insert(pos+1,buf);
				}
			} while(pos>=0);

			for (int j = 0;j < NX;j++) {
				double x = (xma-xmi)*j/(double)(NX-1)+xmi;
				sprintf(buf,"(%f)",x);
				QString tmp2 = tmp;
				do {
					pos = tmp2.find(QRegExp("x\\W"));
					if (pos>=0) {
						tmp2.replace(pos,1," ");
						tmp2.insert(pos,buf);
					}
				} while(pos>=0);
				do {
					pos = tmp2.find(QRegExp("\\Wx"));
					if (pos>=0) {
						tmp2.replace(pos+1,1," ");
						tmp2.insert(pos+1,buf);
					}
				} while(pos>=0);

				z = parse((char *) tmp2.latin1());

				//kdDebug()<<"z = "<<z<<endl;

				if (!finite(z))
					z=0;

				if (i == 0 && j==0 ) zmin=zmax=z;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;

				ptr[i*NX+j].setPoint(x,y,z);
			}
			if ( progress.wasCancelled() )
        			return 1;
		}

		if(graph != 0)
			p->getPlot(p->getAPI())->getGraphList()->delGraph(item);

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"Z RANGE = "<<zmin<<' '<<zmax<<endl;

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
			pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
				(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		Graph3D *g = new Graph3D(fun,label,range,P3D,style,symbol,ptr,NX,NY);
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
		g->setAnnotateValues(av);
		p->addGraph3D(g);
	}

	return 0;
}
