//LabPlot : GRASSDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>
#include <klocale.h>

#include "PlotGRASS.h"
#include "GRASSDialog.h"

using namespace std;

/*! newtype -> new 3D Plot type*/
GRASSDialog::GRASSDialog(Worksheet *p, const char *name,int item)
	: Dialog(p, name)
{
	setCaption(i18n("GRASS Dialog")+QString(" : ")+QString(name));
	
	type = PGRASS;
	Plot *plot = p->getPlot(p->getAPI());

	QString gisbase = QString(getenv("GRASS_DIR"))+QString("/dist.i686-pc-linux-gnu");
	QString gisrc = QString(getenv("HOME"))+QString("/.grassrc5");
	QString location = QString("spearfish");

	if (plot != 0) {
		gisbase = ((PlotGRASS *)plot)->getGISBASE();
		gisrc = ((PlotGRASS *)plot)->getGISRC();
		location = ((PlotGRASS *)plot)->getLOCATION();
	}
	LType type = LVECTOR;
	QString layer = QString("soils");
	QColor c = QColor(Qt::red);
	QColor fc = QColor(Qt::green);
	int drawmode=0;

	if (item == -1) {       // new graph
                graph = 0;
        }
	else {
		GraphList *graphlist = plot->getGraphList();
        	graph = graphlist->getGraph(item);
		GRAPHType s = graphlist->getStruct(item);
		if (s == GRAPHGRASS) {
			GraphGRASS *g = graphlist->getGraphGRASS(item);
			Style style = g->getStyle();
			layer = g->getLayer();
			type = g->getType();
			drawmode = style.isFilled();
			c = style.Color();
			fc = style.FillColor();
		}
	}

	kdDebug()<<"GRASSDialog"<<endl;
	kdDebug()<<"Type = "<<type<<endl;

	setCaption(i18n("GRASS Dialog"));

	// TODO : label

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n(" GISBASE : "),hb);
        GISBASEle = new KLineEdit(gisbase,hb);

	hb = new QHBox(vbox);
	new QLabel(i18n(" GISRC : "),hb);
        GISRCle = new KLineEdit(gisrc,hb);

	hb = new QHBox(vbox);
	new QLabel(i18n(" LOCATION_NAME : "),hb);
        LOCle = new KLineEdit(location,hb);
	// TODO : changed -> update layer list

	hb = new QHBox(vbox);
	new QLabel(i18n(" Layer Type : "),hb);
	typecb = new KComboBox(hb);
        QStringList typelist;
        typelist<<i18n("Vector")<<i18n("Raster")<<i18n("Site");
        typecb->insertStringList(typelist);
        typecb->setCurrentItem(type);
	// TODO : changed -> update layer list

	// TODO : layer list ( how to get ???)
	// "g.list -f type=vect",etc.
	hb = new QHBox(vbox);
	new QLabel(i18n(" Layer : "),hb);
        layerle = new KLineEdit(layer,hb);

	// drawMode
	hb = new QHBox(vbox);
	drawmodecb = new KComboBox(hb);
        QStringList drawmodelist;
        drawmodelist<<i18n("Line")<<i18n("Fill");
        drawmodecb->insertStringList(drawmodelist);
        drawmodecb->setCurrentItem(drawmode);

	// color
	hb = new QHBox(vbox);
	new QLabel(i18n(" Line Color : "),hb);
	color = new KColorButton(c,hb);

	// fillColor
	hb = new QHBox(vbox);
	new QLabel(i18n(" Fill Color : "),hb);
	fillcolor = new KColorButton(fc,hb);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(agree()));

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

int GRASSDialog::agree() {
	kdDebug()<<"GRASSDialog::agree()"<<endl;

	//GraphGRASS *g = new GraphGRASS(fun,label,range,type,style,symbol,a,NX,NY);
	GraphGRASS *g = new GraphGRASS("GRASS",layerle->text());

	g->setType((LType) typecb->currentItem());
	g->setLayer(layerle->text());

	Style style(0,color->color(),drawmodecb->currentItem(),fillcolor->color());
	g->setStyle(style);

	// TODO  not set. why ???
	/*
	((PlotGRASS *)plot)->setGISBASE(GISBASEle->text());
	((PlotGRASS *)plot)->setGISRC(GISRCle->text());
	((PlotGRASS *)plot)->setLOCATION(LOCle->text());
	*/
	p->addGraphGRASS(g);

	return 0;
}
