//LabPlot : Graph3D.h

#ifndef GRAPH3D_H
#define GRAPH3D_H

#include <qtextstream.h>
#include "Graph.h"
#include "LRange.h"
#include "Point3D.h"
#include "defs.h"

class Graph3D: public Graph
{
public:
	Graph3D(QString n=QString(""), QString l=QString(""), LRange r[3]=0, int t=P3D, 
		Style st=Style(), Symbol sy=Symbol(), Point3D *p=0, int nrx=0, int nry=0, bool s=TRUE);
	Point3D *getData() { return ptr; }
	LRange getRange(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	int Number() { return number; }
	int NX() { return numberx; }
	int NY() { return numbery; }
	void setNumber(int n) { number = n; }
	void setNumberX(int n) { numberx = n; }
	void setNumberY(int n) { numbery = n; }
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	QStringList Info();
private:
	int number, numberx, numbery;
	Point3D *ptr;
	LRange *range;
};

#endif // GRAPH3D_H
