//LabPlot : GraphGRASS.h

#ifndef GRAPHGRASS_H
#define GRAPHGRASS_H

#include <qstringlist.h>
#include <qtextstream.h>
#include <kdebug.h>
#include "Graph.h"
#include "Point.h"

#ifdef HAVE_GRASS
#include "GRASSVectorLayer.h"
#endif

class GraphGRASS: public Graph
{
public:
	GraphGRASS(QString n="", QString l="",LRange r[2]=0, int t=PGRASS, Style st=0,
		Symbol sy=Symbol(), int nr=0);
	LRange getRange(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1]; }
	QStringList Info();
	LType getType() { return ltype; }
	void setType(LType t) { ltype = t; }
	QString getLayer() { return layer; }
	void setLayer(QString l) { layer = l; }
#ifdef HAVE_GRASS
	void get_rid_of_message() {GRASS_copyright=0; }
#endif
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
private:
	LRange *range;
	LType ltype;
	QString layer;
};

#endif // GRAPHGRASS_H
