//LabPlot : GraphVTK.h

#ifndef GRAPHVTK_H
#define GRAPHVTK_H

#include <qstringlist.h>
#include <qtextstream.h>
#include <kdebug.h>
#include "Graph.h"
#include "Point.h"

#ifdef HAVE_VTK
// vtk header
#endif

class GraphVTK: public Graph
{
public:
	GraphVTK(QString n="", QString l="",LRange r[3]=0, int t=PVTK, Style st=0, 
		Symbol sy=Symbol(), int nr=0);
	LRange getRange(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	QStringList Info();

	int getObject() { return object; }
	void setObject(int o) { object = o; }
	QColor getColor() { return color; }
	void setColor(QColor c) { color=c; }
	bool getBoxed() { return boxed; }
	void setBoxed(bool b) { boxed = b; }

	void save(QTextStream *t);
	void open(QTextStream *t,int version);
private:
	LRange *range;
	int object;		// type of object : 0-cone,1-cube,2-sphere,3-cylinder,4-point
	QColor color;	// object color
	bool boxed;		// draw box
};

#endif // GRAPHVTK_H
