//LabPlot : HistListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "HistListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_histogram.h>
#endif

HistListDialog::HistListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Hist Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n(" From : "),hb);
	ale = new KLineEdit(QString("0"),hb);
	ale->setValidator(new QDoubleValidator(ale));
	new QLabel(i18n(" To : "),hb);
	ble = new KLineEdit(QString("0"),hb);
	ble->setValidator(new QDoubleValidator(ble));
	hb = new QHBox(tab1);
	new QLabel(i18n(" Bins : "),hb);
	binle = new KLineEdit(QString("100"),hb);
	binle->setValidator(new QIntValidator(binle));

	updateRange();
	QObject::connect(lv,SIGNAL(selectionChanged()),SLOT(updateRange()));

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void HistListDialog::apply_clicked() {
#ifdef HAVE_GSL	
	// TODO : all selected graphs
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *data = g->getData();

		int bins = (binle->text()).toInt();
		double xmin=0, xmax=1, ymin=0, ymax=1;
		double a=(ale->text()).toDouble();
		double b=(ble->text()).toDouble();

		gsl_histogram *h = gsl_histogram_alloc (bins);
		gsl_histogram_set_ranges_uniform (h, a, b);

		for (int i = 0;i<nx;i++)
             		gsl_histogram_increment(h,data[i].Y());

		for (int i = 0;i<bins;i++) {
			double x = i;
			double y = gsl_histogram_get (h,i);
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
           	}

		gsl_histogram_free (h);
		
		// create the new graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("histogram (")+QString::number(bins)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,bins);
		p->addGraph2D(ng);
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();
#else
		KMessageBox::error(this, i18n("Sorry. Your installation doesn't support the GSL!"));
#endif
}
