//LabPlot : Image.cc

#include <iostream>
#include <qimage.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include "Image.h"

using namespace std;

Image::Image(Point p,QString n, double s, double a) {
	pos = p;
	name = n;
	scale = s;
	angle = a;
}

QStringList Image::Info() {
	QStringList s;

	s << QString::number(pos.X())+"/"+QString::number(pos.Y());
	s << name;
	s << QString::number(scale);
	s << QString::number(angle);

	return s;
}

// draw the image on the worksheet
void Image::draw(QPainter *p, double X, double Y) {
	//kdDebug()<<"DRAW Image \n";

	if (name.length()>0) {
		int x = (int) (pos.X()*X);
		int y = (int) (pos.Y()*Y);
		QImage *image = new QImage(name);
		if (!image) { 
			kdDebug()<<"Error opening image !\n";
		}
		else {
			QImage tmpimage = image->smoothScale((int)(image->width()*scale),
				(int)(image->height()*scale),QImage::ScaleMin);
			p->translate(x,y);
			p->rotate(angle);
			p->drawImage(0,0,tmpimage);
			p->rotate(-angle);
			p->translate(-x,-y);
		}
	}
}

// save
void Image::save(QTextStream *t) {
	*t<<pos.X()<<' '<<pos.Y()<<endl;
	*t<<name<<endl;
	*t<<scale<<' '<<angle<<endl;
}

// open
void Image::open(QTextStream *t,int version) {
	double x,y;
	
	*t>>x>>y;
	pos.setPoint(x,y);
	t->readLine();
	name=t->readLine();
	*t>>scale>>angle;

	kdDebug()<<"X/Y :"<<x<<' '<<y<<endl;
	kdDebug()<<"IMAGE :"<<name<<' '<<scale<<' '<<angle<<endl;
}

bool Image::inside(int x, int y, int w, int h) {
	if(name.length() == 0)
		return FALSE;
		
	QImage *image = new QImage(name);
	
	if (x>pos.X()*w && x<pos.X()*w+image->width()*scale &&
		y>pos.Y()*h && y<pos.Y()*h+image->height()*scale )
		return TRUE;

	return FALSE;
}
