//LabPlot : InfoDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "InfoDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_statistics.h>
#endif

using namespace std;

InfoDialog::InfoDialog(Worksheet *p, const char *name, int item)
	: Dialog(p, name)
{
	setCaption(i18n("Data Info")+i18n(" : ")+QString(name));

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	Graph *g = gl->getGraph(item);
	GRAPHType s = gl->getStruct(item);
	LRange *range= new LRange[4];
	int nx=0,ny=0,number=0;

	if (s==GRAPH2D) {
		range[0]=gl->getGraph2D(item)->getRange(0);
		range[1]=gl->getGraph2D(item)->getRange(1);
		nx=g->Number();
		number=nx;
		ny=1;
	}
	else if (s==GRAPH3D) {
		Graph3D *graph3d = gl->getGraph3D(item);
		range[0]=graph3d->getRange(0);
		range[1]=graph3d->getRange(1);
		range[2]=graph3d->getRange(2);
		nx=graph3d->NX();
		ny=graph3d->NY();
		number=nx*ny;
	}
	else if (s==GRAPH4D) {
		Graph4D *graph4d = gl->getGraph4D(item);
		range[0]=graph4d->getRange(0);
		range[1]=graph4d->getRange(1);
		range[2]=graph4d->getRange(2);
		range[3]=graph4d->getRange(3);
		number=g->Number();
		nx=number;
		ny=1;
	}
	else if (s==GRAPHM) {
		GraphM *graphm = gl->getGraphM(item);
		range[0]=graphm->getRange(0);
		range[1]=graphm->getRange(1);
		range[2]=graphm->getRange(2);
		nx=graphm->NX();
		ny=graphm->NY();
		number=nx*ny;
	}

	QLabel *tmp;
	QGroupBox *gb1 = new QGroupBox(1,QGroupBox::Horizontal,i18n("Graph"),vbox);
	QHBox *hb = new QHBox(gb1);
	new QLabel(i18n("Name : "),hb);
	tmp = new QLabel(g->Name(),hb);
	tmp->setAlignment(Qt::AlignRight );

	QString t;
	if (g->Type() == P2D)
		t=i18n("2D");
	else if (g->Type() == PSURFACE)
		t=i18n("SURFACE");
	else if (g->Type() == P3D)
		t=i18n("3D");
		
	hb = new QHBox(gb1);
	new QLabel(i18n("Type : "),hb);
	tmp = new QLabel(t,hb);
	tmp->setAlignment(Qt::AlignRight );
	hb = new QHBox(gb1);
	new QLabel(i18n("X Range : "),hb);
	tmp = new QLabel(QString::number(range[0].Min()) + " .. " +QString::number(range[0].Max()),hb);
	tmp->setAlignment(Qt::AlignRight );
	hb = new QHBox(gb1);
	new QLabel(i18n("Y Range : "),hb);
	tmp = new QLabel(QString::number(range[1].Min()) + " .. " + QString::number(range[1].Max()),hb);
	tmp->setAlignment(Qt::AlignRight );
	if (s == GRAPH3D || s == GRAPHM) {
		hb = new QHBox(gb1);
		new QLabel(i18n("Z Range : "),hb);
		tmp = new QLabel(QString::number(range[2].Min()) + " .. " + QString::number(range[2].Max()),hb);
		tmp->setAlignment(Qt::AlignRight );
	}
	if (s == GRAPH4D) {
		hb = new QHBox(gb1);
		new QLabel(i18n("T Range : "),hb);
		tmp = new QLabel(QString::number(range[3].Min()) + " .. " + QString::number(range[3].Max()),hb);
		tmp->setAlignment(Qt::AlignRight );
	}
	
	hb = new QHBox(gb1);
	new QLabel(i18n("Dimension : "),hb);
	tmp = new QLabel(QString::number(nx)+QString(" / ")+QString::number(ny),hb);
	tmp->setAlignment(Qt::AlignRight );

#ifdef HAVE_GSL
	QGroupBox *gb2 = new QGroupBox(1,QGroupBox::Horizontal,i18n("Data"),vbox);
	double *xdata=0, *ydata=0, *zdata=0, *tdata=0;

	if (s == GRAPH2D) {
		xdata = new double[number];
		ydata = new double[number];
		for (int i=0;i<nx;i++) {
			Graph2D *graph2d = gl->getGraph2D(item);
			Point *data = graph2d->getData();
			xdata[i] = data[i].X();
			ydata[i] = data[i].Y();
		}
	}
	else if (s == GRAPH3D) {
		xdata = new double[number];
		ydata = new double[number];
		zdata = new double[number];
		for (int i=0;i<nx*ny;i++) {
			Graph3D *graph3d = gl->getGraph3D(item);
			Point3D *data = graph3d->getData();
			xdata[i] = data[i].X();
			ydata[i] = data[i].Y();
			zdata[i] = data[i].Z();
		}
	}
	else if (s == GRAPH4D) {
		xdata = new double[number];
		ydata = new double[number];
		zdata = new double[number];
		tdata = new double[number];
		for (int i=0;i<nx*ny;i++) {
			Graph4D *graph4d = gl->getGraph4D(item);
			Point4D *data = graph4d->getData();
			xdata[i] = data[i].X();
			ydata[i] = data[i].Y();
			zdata[i] = data[i].Z();
			tdata[i] = data[i].T();
		}
	}
	else if (s == GRAPHM) {
		GraphM *graphm = gl->getGraphM(item);
		zdata = graphm->getData();
	}
	
	double max,min;
	int max_index,min_index;

	if (s != GRAPHM) {
		hb = new QHBox(gb2);
		new QLabel(i18n("X Min/Max (index) :"),hb);
		max = gsl_stats_max(xdata,1,number);
		max_index = gsl_stats_max_index(xdata,1,number)+1;
		min = gsl_stats_min(xdata,1,number);
		min_index = gsl_stats_min_index(xdata,1,number)+1;
		tmp = new QLabel(QString::number(min)+" ( @ "+QString::number(min_index)+i18n(" ) ")+
				i18n(" / ")+ QString::number(max)+" ( @ "+QString::number(max_index)+i18n(" ) "),hb);
		tmp->setAlignment(Qt::AlignRight );

		hb = new QHBox(gb2);
		new QLabel(i18n("Y Min/Max (index) :"),hb);
		max = gsl_stats_max(ydata,1,number);
		max_index = gsl_stats_max_index(ydata,1,number)+1;
		min = gsl_stats_min(ydata,1,number);
		min_index = gsl_stats_min_index(ydata,1,number)+1;
		tmp = new QLabel(QString::number(min)+" ( @ "+QString::number(min_index)+i18n(" ) ")+
				i18n(" / ")+ QString::number(max)+" ( @ "+QString::number(max_index)+i18n(" ) "),hb);
		tmp->setAlignment(Qt::AlignRight );
	}
	if(s == GRAPH3D || s == GRAPHM || s == GRAPH4D) {
		hb = new QHBox(gb2);
		new QLabel(i18n("Z Min/Max (index) :"),hb);
		max = gsl_stats_max(zdata,1,number);
		max_index = gsl_stats_max_index(zdata,1,number)+1;
		min = gsl_stats_min(zdata,1,number);
		min_index = gsl_stats_min_index(zdata,1,number)+1;
		tmp = new QLabel(QString::number(min)+" ( @ "+QString::number(min_index)+" ) "+
				i18n(" / ")+ QString::number(max)+" ( @ "+QString::number(max_index)+" ) ",hb);
		tmp->setAlignment(Qt::AlignRight );
	}
	if(s == GRAPH4D) {
		hb = new QHBox(gb2);
		new QLabel(i18n("T Min/Max (index) :"),hb);
		max = gsl_stats_max(tdata,1,number);
		max_index = gsl_stats_max_index(tdata,1,number)+1;
		min = gsl_stats_min(tdata,1,number);
		min_index = gsl_stats_min_index(tdata,1,number)+1;
		tmp = new QLabel(QString::number(min)+" ( @ "+QString::number(min_index)+" ) "+
				i18n(" / ")+ QString::number(max)+" ( @ "+QString::number(max_index)+" ) ",hb);
		tmp->setAlignment(Qt::AlignRight );
	}

	hb = new QHBox(gb2);
	if(s == GRAPH2D)
		new QLabel(i18n("X/Y Mean :"),hb);
	else if(s == GRAPH3D) 
		new QLabel(i18n("X/Y/Z Mean :"),hb);
	else if(s == GRAPH4D) 
		new QLabel(i18n("X/Y/Z/T Mean :"),hb);
	else if(s == GRAPHM) 
		new QLabel(i18n("Mean :"),hb);
	double xmean = gsl_stats_mean(xdata,1,number);
	double ymean = gsl_stats_mean(ydata,1,number);
	if(s == GRAPH2D)
		tmp = new QLabel(QString::number(xmean)+i18n(" / ")+QString::number(ymean),hb);
	else if (s == GRAPH3D) {
		double zmean = gsl_stats_mean(zdata,1,number);
		tmp = new QLabel(QString::number(xmean)+i18n(" / ")+QString::number(ymean)+i18n(" / ")+ 
			QString::number(zmean),hb);
	}
	else if (s == GRAPH4D) {
		double zmean = gsl_stats_mean(zdata,1,number);
		double tmean = gsl_stats_mean(tdata,1,number);
		tmp = new QLabel(QString::number(xmean)+i18n(" / ")+QString::number(ymean)+i18n(" / ")+
			QString::number(zmean)+i18n(" / ")+QString::number(tmean),hb);	
	}
	else if(s == GRAPHM) {
		double zmean = gsl_stats_mean(zdata,1,number);
		tmp = new QLabel(QString::number(zmean),hb);
	}
	tmp->setAlignment(Qt::AlignRight );
	
	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y Variance :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z Variance :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T Variance :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("Variance :"),hb);
	double xvar = gsl_stats_variance(xdata,1,number);
	double yvar = gsl_stats_variance(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xvar)+i18n(" / ")+QString::number(yvar),hb);
	else if (s == GRAPH3D) {
		double zvar = gsl_stats_variance(zdata,1,number);
		tmp = new QLabel(QString::number(xvar)+i18n(" / ")+QString::number(yvar)+i18n(" / ")+QString::number(zvar),hb);
	}
	else if (s == GRAPH4D) {
		double zvar = gsl_stats_variance(zdata,1,number);
		double tvar = gsl_stats_variance(tdata,1,number);
		tmp = new QLabel(QString::number(xvar)+i18n(" / ")+QString::number(yvar)+i18n(" / ")+QString::number(zvar)+
			i18n(" / ")+QString::number(tvar),hb);
	}
	else if (s == GRAPHM) {
		double zvar = gsl_stats_variance(zdata,1,number);
		tmp = new QLabel(QString::number(zvar),hb);
	}
	tmp->setAlignment(Qt::AlignRight );
	
	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y Standard Deviation :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z Standard Deviation :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T Standard Deviation :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("Standard Deviation :"),hb);
	double xsd = gsl_stats_sd(xdata,1,number);
	double ysd = gsl_stats_sd(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xsd)+i18n(" / ")+QString::number(ysd),hb);
	else if (s == GRAPH3D) {
		double zsd = gsl_stats_sd(zdata,1,number);
		tmp = new QLabel(QString::number(xsd)+i18n(" / ")+QString::number(ysd)+i18n(" / ")+QString::number(zsd),hb);
	}
	else if (s == GRAPH4D) {
		double zsd = gsl_stats_sd(zdata,1,number);
		double tsd = gsl_stats_sd(tdata,1,number);
		tmp = new QLabel(QString::number(xsd)+i18n(" / ")+QString::number(ysd)+i18n(" / ")+QString::number(zsd)+
			i18n(" / ")+QString::number(tsd),hb);
	}
	else if (s == GRAPHM) {
		double zsd = gsl_stats_sd(zdata,1,number);
		tmp = new QLabel(QString::number(zsd),hb);
	}
	tmp->setAlignment(Qt::AlignRight );
	
	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y Absolute Deviation :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z Absolute Deviation :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T Absolute Deviation :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("Absolute Deviation :"),hb);
	double xabsdev = gsl_stats_absdev(xdata,1,number);
	double yabsdev = gsl_stats_absdev(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xabsdev)+i18n(" / ")+QString::number(yabsdev),hb);
	else if (s == GRAPH3D) {
		double zabsdev = gsl_stats_absdev(zdata,1,number);
		tmp = new QLabel(QString::number(xabsdev)+i18n(" / ")+QString::number(yabsdev)+i18n(" / ")+
			QString::number(zabsdev),hb);
	}
	else if (s == GRAPH4D) {
		double zabsdev = gsl_stats_absdev(zdata,1,number);
		double tabsdev = gsl_stats_absdev(tdata,1,number);
		tmp = new QLabel(QString::number(xabsdev)+i18n(" / ")+QString::number(yabsdev)+i18n(" / ")+
			QString::number(zabsdev)+i18n(" / ")+QString::number(tabsdev),hb);
	}
	else if (s == GRAPHM) {
		double zabsdev = gsl_stats_absdev(zdata,1,number);
		tmp = new QLabel(QString::number(zabsdev),hb);
	}
	
	tmp->setAlignment(Qt::AlignRight );
	
	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y Skewness :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z Skewness :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T Skewness :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("Skewness :"),hb);
	double xskew = gsl_stats_skew(xdata,1,number);
	double yskew = gsl_stats_skew(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xskew)+i18n(" / ")+QString::number(yskew),hb);
	else if (s == GRAPH3D) {
		double zskew = gsl_stats_skew(zdata,1,number);
		tmp = new QLabel(QString::number(xskew)+i18n(" / ")+QString::number(yskew)+i18n(" / ")+
			QString::number(zskew),hb);
	}
	else if (s == GRAPH4D) {
		double zskew = gsl_stats_skew(zdata,1,number);
		double tskew = gsl_stats_skew(tdata,1,number);
		tmp = new QLabel(QString::number(xskew)+i18n(" / ")+QString::number(yskew)+i18n(" / ")+
			QString::number(zskew)+i18n(" / ")+QString::number(tskew),hb);
	}
	else if (s == GRAPHM) {
		double zskew = gsl_stats_skew(zdata,1,number);
		tmp = new QLabel(QString::number(zskew),hb);
	}
	tmp->setAlignment(Qt::AlignRight );

	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y Kurtosis :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z Kurtosis :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T Kurtosis :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("Kurtosis :"),hb);
	double xkurt = gsl_stats_kurtosis(xdata,1,number);
	double ykurt = gsl_stats_kurtosis(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xkurt)+i18n(" / ")+QString::number(ykurt),hb);
	else if (s == GRAPH3D) {
		double zkurt = gsl_stats_kurtosis(zdata,1,number);
		tmp = new QLabel(QString::number(xkurt)+i18n(" / ")+QString::number(ykurt)+i18n(" / ")+
			QString::number(zkurt),hb);
	}
	else if (s == GRAPH4D) {
		double zkurt = gsl_stats_kurtosis(zdata,1,number);
		double tkurt = gsl_stats_kurtosis(tdata,1,number);
		tmp = new QLabel(QString::number(xkurt)+i18n(" / ")+QString::number(ykurt)+i18n(" / ")+
			QString::number(zkurt)+i18n(" / ")+QString::number(tkurt),hb);
	}
	else if (s == GRAPHM) {
		double zkurt = gsl_stats_kurtosis(zdata,1,number);
		tmp = new QLabel(QString::number(zkurt),hb);
	}
	tmp->setAlignment(Qt::AlignRight );
	
	hb = new QHBox(gb2);
	if (s == GRAPH2D)
		new QLabel(i18n("X/Y lag-1 Autocorrelation :"),hb);
	else if (s == GRAPH3D)
		new QLabel(i18n("X/Y/Z lag-1 Autocorrelation :"),hb);
	else if (s == GRAPH4D)
		new QLabel(i18n("X/Y/Z/T lag-1 Autocorrelation :"),hb);
	else if (s == GRAPHM)
		new QLabel(i18n("lag-1 Autocorrelation :"),hb);
	double xauto = gsl_stats_lag1_autocorrelation(xdata,1,number);
	double yauto = gsl_stats_lag1_autocorrelation(ydata,1,number);
	if (s == GRAPH2D)
		tmp = new QLabel(QString::number(xauto)+i18n(" / ")+QString::number(yauto),hb);
	else if (s == GRAPH3D) {
		double zauto = gsl_stats_lag1_autocorrelation(zdata,1,number);
		tmp = new QLabel(QString::number(xauto)+i18n(" / ")+QString::number(yauto)+i18n(" / ")+
			QString::number(zauto),hb);
	}
	else if (s == GRAPH4D) {
		double zauto = gsl_stats_lag1_autocorrelation(zdata,1,number);
		double tauto = gsl_stats_lag1_autocorrelation(tdata,1,number);
		tmp = new QLabel(QString::number(xauto)+i18n(" / ")+QString::number(yauto)+i18n(" / ")+
			QString::number(zauto)+i18n(" / ")+QString::number(tauto),hb);
	}
	else if (s == GRAPHM) {
		double zauto = gsl_stats_lag1_autocorrelation(zdata,1,number);
		tmp = new QLabel(QString::number(zauto),hb);
	}
	tmp->setAlignment(Qt::AlignRight );
	
	if (s != GRAPHM) {
		hb = new QHBox(gb2);
		new QLabel(i18n("X vs. Y Covariance :"),hb);
		tmp = new QLabel(QString::number(gsl_stats_covariance(xdata,1,ydata,1,number)),hb);
		tmp->setAlignment(Qt::AlignRight );
	}
#endif

	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	
	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}
