//LabPlot: Label.cc

#include <iostream>
#include <qbrush.h>
#include <qpalette.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qmime.h>
#include <qstylesheet.h>
#include <kdebug.h>
#include "Label.h"

using namespace std;

Label::Label(QString string, QFont font, QColor color) {
	t = string;
	f = font;
	c = color;
	x=y=0;
	richtext = new QSimpleRichText(t,f);
	boxed=false;
}

QStringList Label::Info() {
	QStringList s;
	
        s << QString::number(x) + "/" + QString::number(y);

	return s;
}

void Label::save(QTextStream *ts) {
	t.replace( QRegExp(QString("\n")), QString("") ); // strip all newlines from t
	*ts<<t<<endl;
	
	*ts<<f.family()<<endl;
	*ts<<f.pointSize()<<' ';
	*ts<<f.weight()<<' '<<f.italic()<<endl;
	
	*ts<<c.name()<<endl;
	
	*ts<<x<<' '<<y<<endl;
	*ts<<(int)boxed<<endl;
}
void Label::open(QTextStream *ts,int version) {
	QString title, family, color;
	int pointsize, weight, italic;
	double tmpx,tmpy;

	kdDebug()<<"Label::open()"<<endl;

	ts->readLine();
	t=ts->readLine();

	if(version>3) {
		family=ts->readLine();
		*ts>>pointsize>>weight>>italic;
	}
	else {
		*ts>>family>>pointsize>>weight>>italic;
	}

	f=QFont(family,pointsize,weight,italic);

	kdDebug()<<"Label : "<<t<<endl;
	kdDebug()<<"(family/pointsize/weight/italic) : "<<family<<' '<<pointsize<<' '<<weight<<' '<<italic<<endl;

	if (version>3) {
		*ts>>color;
		c=color;
		*ts>>tmpx>>tmpy;
		x=tmpx;
		y=tmpy;
	}
	if (version>8) {
		*ts>>italic;
		boxed = italic;
	}
	else
		boxed = false;
}

void Label::draw(QPainter *p,Point pos, Point size, int w, int h) {
	// resize font with plot size
	QFont tmp = f;
	int tmpsize = f.pointSize();
	tmp.setPointSize((int)(size.X()*tmpsize));
	richtext = new QSimpleRichText(t,tmp);
	// this solves the auto wrap problem !
	richtext->setWidth(p,500);
	
	if(boxed) {
		p->setPen(QColor("black"));
		p->drawRect((int)((pos.X()+x*size.X())*w-5),(int)((pos.Y()+y*size.Y())*h),richtext->widthUsed(),richtext->height());
	}

	richtext->draw(p,(int)((pos.X()+x*size.X())*w),(int)((pos.Y()+y*size.Y())*h),QRect(),QColorGroup());
}

void Label::drawY(QPainter *p,Point pos,Point size,int w, int h,double phi) {
	// resize font with plot size
	QFont tmp = f;
	int tmpsize = f.pointSize();
	tmp.setPointSize((int)(size.X()*tmpsize));
	richtext = new QSimpleRichText(t,tmp);
	richtext->setWidth(p,500);
	
	p->translate((pos.X()+x*size.X())*w,(pos.Y()+y*size.Y())*h);
	p->rotate(phi);
	
	if (boxed) {
		p->setPen(QColor("black"));
		p->drawRect(-5,0,richtext->widthUsed(),richtext->height());
	}
	richtext->draw(p,0,0,QRect(),QColorGroup());
}

//! return true if mouse inside (x0,y0)
bool Label::inside(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x));	// left
	int x2 = (int)(x1+richtext->widthUsed());		// right
	int y1 = (int)(h*(pos.Y()+size.Y()*y));	// top
	int y2 = (int)(y1+richtext->height());		// botton
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return TRUE;
	return FALSE;
}

bool Label::insideY(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x));		// left
	int x2 = (int)(x1+richtext->widthUsed());	// right
	int y2 = (int)(h*(pos.Y()+size.Y()*y));		// top
	int y1 = (int)(y2-richtext->widthUsed());		// botton

	//kdDebug()<<"Label::insideY()  X/Y    X1/X2 | Y1/Y2"<<endl;
	//kdDebug()<<"       "<<x0<<' '<<y0<<"   "<<x1<<'/'<<x2<<" | "<<y1<<'/'<<y2<<endl;
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return TRUE;
	return FALSE;
}

bool Label::insideZ(int x0, int y0, Point pos, Point size, int w, int h) {
	int x1 = (int)(w*(pos.X()+size.X()*x)-richtext->height());
	int x2 = (int)(w*(pos.X()+size.X()*x)+richtext->width());
	int y1 = (int)(h*(pos.Y()+size.Y()*y)-richtext->height());
	int y2 = (int)(h*(pos.Y()+size.Y()*y)+richtext->width());
	
	if (x0>x1 && x0<x2 && y0>y1 && y0<y2 )
		return TRUE;
	return FALSE;
}
