//LabPlot : RegressionListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "RegressionListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_fit.h>
#include <gsl/gsl_multifit.h>
#endif

using namespace std;

static const char *weightitems[] = {I18N_NOOP("equal"),I18N_NOOP("y"),I18N_NOOP("y^2"),
	I18N_NOOP("1/y"),I18N_NOOP("1/y^2"),0};
static const char *modelitems[] = {I18N_NOOP("linear"),I18N_NOOP("quadratic"),I18N_NOOP("cubic"),
	I18N_NOOP("4-th order"),I18N_NOOP("5-th order"),I18N_NOOP("6-th order"),I18N_NOOP("7-th order"),
	I18N_NOOP("8-th order"),I18N_NOOP("9-th order"),I18N_NOOP("10-th order"),0};

enum Weight {WEQUAL,WY,WYY,W1Y,W1YY};
enum Model {MLINEAR,MQUADRATIC,MCUBIC,M4ORDER,M5ORDER,M6ORDER,M7ORDER,M8ORDER,M9ORDER,M10ORDER};

RegressionListDialog::RegressionListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Regression Dialog"));

	Plot *plot = p->getPlot(p->getAPI());

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	regioncb = new QCheckBox(i18n("use Region "),hb);
	if(plot->getRegionMin() != plot->getRegionMax() )
		regioncb->setChecked(true);
	else
	regioncb->setChecked(false);
	new QLabel(i18n("( From "),hb);
	regionminle = new KLineEdit(QString::number(plot->getRegionMin()),hb);
	regionminle->setValidator(new QDoubleValidator(regionminle));
	new QLabel(i18n(" To "),hb);
	regionmaxle = new KLineEdit(QString::number(plot->getRegionMax()),hb);
	regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
	new QLabel(i18n(" )"),hb);

	hb = new QHBox(tab1);
	new QLabel(i18n("Model : "),hb);
        modelcb = new KComboBox(hb);
        modelcb->insertStrList(modelitems);
        modelcb->setCurrentItem(0);

	hb = new QHBox(tab1);
	new QLabel(i18n("Weight : "),hb);
        weightcb = new KComboBox(hb);
        weightcb->insertStrList(weightitems);
        weightcb->setCurrentItem(0);

	hb = new QHBox(tab1);
	new QLabel(i18n("Number of Points for regression function : "),hb);
	GraphList *gl = plot->getGraphList();
	GRAPHType s = gl->getStruct(0);
	int number=100;
	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(0);
		number = g->Number();
	}
	numberle = new KLineEdit(QString::number(number),hb);
	numberle->setValidator(new QIntValidator(numberle));

	hb = new QHBox(tab1);
	new QLabel(i18n("Range of regression function : "),hb);
	LRange *range = plot->getRanges();
	minle = new KLineEdit(QString::number(range[0].Min()),hb);
	minle->setValidator(new QDoubleValidator(minle));
	new QLabel(i18n(" .. "),hb);
	maxle = new KLineEdit(QString::number(range[0].Max()),hb);
	maxle->setValidator(new QDoubleValidator(maxle));


	hb = new QHBox(tab1);
	infocb = new QCheckBox(i18n("Show Info"),hb);
	infocb->setChecked(true);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void RegressionListDialog::apply_clicked() {
#ifdef HAVE_GSL
	// TODO : all selected graphs
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);
	QString info;

	int numberx = numberle->text().toInt();
	Point *ptr = new Point[numberx];

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *data = g->getData();
		QString fun;
		int N=0;

		double xmin=0, xmax=1, ymin=0, ymax=1;
		if (modelcb->currentItem() == MLINEAR) {
			double* xdata = new double[nx];
			double* ydata = new double[nx];
			double* weight = new double[nx];
			double c0, c1, cov00, cov01, cov11, chisq;
			double sum=1;

			// create weight
			for (int i=0;i<nx;i++) {
				if (weightcb->currentItem() == WY)
					weight[i]=data[i].Y();
				else if(weightcb->currentItem() == WYY)
					weight[i]=data[i].Y()*data[i].Y();
				else if(weightcb->currentItem() == W1Y) {
					if (data[i].Y() != 0)
						weight[i]=1.0/data[i].Y();
					else
						weight[i]=0.0;
				}
				else if(weightcb->currentItem() == W1YY) {
					if (data[i].Y() != 0)
						weight[i]=1.0/(data[i].Y()*data[i].Y());
					else
						weight[i]=0.0;
				}

				sum += weight[i];
			}

			// create data
			for (int i=0;i<nx;i++) {
				double x = data[i].X();
				double y = data[i].Y();
				if(!regioncb->isChecked() || x > regionminle->text().toDouble() && x < regionmaxle->text().toDouble()) {
					xdata[N]=x;
					ydata[N]=y;
					if (weightcb->currentItem() != WEQUAL)
						weight[N]=weight[i]/sum;
					N++;
				}
			}

			// fit
			if (weightcb->currentItem() == WEQUAL) {
				gsl_fit_linear (xdata, 1, ydata,1, N,
						&c0,&c1,&cov00,&cov01,&cov11,&chisq);
			}
			else  {
				gsl_fit_wlinear (xdata, 1, weight, 1, ydata,1, N,
						&c0,&c1,&cov00,&cov01,&cov11,&chisq);
			}


			// info
			info += "best fit: y = "+QString::number(c0)+" + "+QString::number(c1)+" x\n";
			info += "covariance matrix:\n";
			info += "  [ " +QString::number(cov00)+", "+QString::number(cov01)+"\n";

			info += "    " +QString::number(cov01)+", "+QString::number(cov11)+" ]\n";
			info += "chisq = " + QString::number(chisq);

			double rangemin=minle->text().toDouble();
			double rangemax=maxle->text().toDouble();
			for (int i = 0;i<numberx;i++) {
				double x = rangemin+i*(rangemax-rangemin)/(double)(numberx-1);
				double y = c0 + c1*x;

				// new ranges
				if (i==0) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}

				ptr[i].setPoint(x,y);
			}
			fun = "y = "+QString::number(c0)+" + "+QString::number(c1)+" x";
		}
		else {	// non linear
			int order = modelcb->currentItem()+2;	// item -> order
			double chisq, sum=0;
			gsl_matrix *X, *cov;
			gsl_vector *yy, *w, *c;

			#define C(i) (gsl_vector_get(c,(i)))
			#define W(i) (gsl_vector_get(w,(i)))
			#define XX(i) (gsl_vector_get(X,(i)))
			#define COV(i,j) (gsl_matrix_get(cov,(i),(j)))

			w = gsl_vector_alloc (nx);

			for (int i=0;i<nx;i++) {
				double x = data[i].X();
				double y = data[i].Y();
				if(!regioncb->isChecked() || x > regionminle->text().toDouble() && x < regionmaxle->text().toDouble()) {
					if (weightcb->currentItem() == WY)
						gsl_vector_set (w, N, y);
					else if(weightcb->currentItem() == WYY)
						gsl_vector_set (w, N, y*y);
					else if(weightcb->currentItem() == W1Y) {
						if (y != 0)
							gsl_vector_set (w, N, 1.0/y);
						else
							gsl_vector_set (w, N, 0.0);
					}
					else if(weightcb->currentItem() == W1YY) {
						if (y != 0)
							gsl_vector_set (w, N, 1.0/(y*y));
						else
							gsl_vector_set (w, N, 0.0);
					}

					sum +=	W(N);
					N++;
				}
			}

			X = gsl_matrix_alloc (N, order);
			yy = gsl_vector_alloc (N);
			c = gsl_vector_alloc (order);
			cov = gsl_matrix_alloc (order, order);

			N=0;
			for (int i = 0; i < nx; i++) {
				double x = data[i].X();
				double y = data[i].Y();
				if(!regioncb->isChecked() || x > regionminle->text().toDouble() && x < regionmaxle->text().toDouble()) {
					for (int j=0;j<order;j++)
						gsl_matrix_set(X,N,j,pow(x,j));

				 	gsl_vector_set (yy, N, y);
				 	gsl_vector_set (w, N, W(N)/sum);
					// err weight
					//gsl_vector_set (w, i, 1.0/(ei*ei));
					N++;
				}
			}

			gsl_multifit_linear_workspace * work = gsl_multifit_linear_alloc (N, order);
			if (weightcb->currentItem() == WEQUAL)
				gsl_multifit_linear (X, yy, c, cov,&chisq, work);
			else
				gsl_multifit_wlinear (X, w, yy, c, cov,&chisq, work);
			gsl_multifit_linear_free(work);

			info += "best fit: y = "+QString::number(C(0))+" + "+QString::number(C(1))+" x ";
			for (int i=2;i<order;i++)
				info += " + "+ QString::number(C(i)) + " x^" + QString::number(i);
			info += "\ncovariance matrix:\n";
			for (int j=0;j<order;j++) {
				for (int i=0;i<order;i++)
					info += QString::number(COV(j,i))+",";
				info +="\n";
			}
			info += "chisq = " + QString::number(chisq);

			double rangemin=minle->text().toDouble();
			double rangemax=maxle->text().toDouble();
			for (int i = 0;i<numberx;i++) {
				double x = rangemin+i*(rangemax-rangemin)/(double)(numberx-1);
				double y = 0;
				for (int j=0;j<order;j++)
					y += C(j)*pow(x,j);

				// new ranges
				if (i==0) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}

				ptr[i].setPoint(x,y);
			}
			fun = QString::number(order-1)+"th order regression";
		}

		// create the new graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,numberx);
		p->addGraph2D(ng);
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}


	updateList();

	if (infocb->isChecked())
		KMessageBox::information(0,info);
#else
		KMessageBox::error(this, i18n("Sorry. Your installation doesn't support the GSL!"));
#endif
}
