//LabPlot : RichTextWidget.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qvalidator.h>
#include <kpushbutton.h>
#include <qgroupbox.h>
#include <klocale.h>
#include "RichTextWidget.h"

RichTextWidget::RichTextWidget(QWidget *parent, Label *label, const char *name)
	: QWidget(parent)
{
	l = label;

	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),parent);

        QHBox *hb = new QHBox(gb);
	new QLabel(i18n("Position : "),hb);
	boxedcb = new QCheckBox(i18n("Boxed"),hb);
	QObject::connect(boxedcb,SIGNAL(toggled(bool)),this,SLOT(boxedChanged(bool)));
	
	hb = new QHBox(gb);
        new QLabel(QString("x : "),hb);
        xle = new KLineEdit(QString::number(l->X()),hb);
        xle->setValidator(new QDoubleValidator(0.0,1.0,3,xle));
        new QLabel(QString(" y : "),hb);
        yle = new KLineEdit(QString::number(l->Y()),hb);
        yle->setValidator(new QDoubleValidator(0.0,1.0,3,yle));
	
	hb = new QHBox(gb);
	new QLabel(i18n("Font : "),hb); 
	titleFont = new KLineEdit(QString(""),hb);
	titleFont->setMaximumWidth(200);
	KPushButton *newtitleFont = new KPushButton(i18n("Change"),hb);
	QObject::connect(newtitleFont,SIGNAL(clicked()),SLOT(selectFont()));

	hb = new QHBox(gb);
	bold = new QToolButton(hb);
	QFont f1( QString("Adobe Times"), 12, QFont::Bold );
    	bold->setFont( f1 );
	bold->setText(QString("B"));
	bold->setToggleButton(TRUE);
	bold->setOn(FALSE);
	QObject::connect(bold,SIGNAL(clicked()),SLOT(toggleBold()));

	italic = new QToolButton(hb);
	QFont f2( QString("Adobe Times"), 12);
	f2.setItalic(TRUE);
    	italic->setFont( f2 );
	italic->setText(QString("I"));
	italic->setToggleButton(TRUE);
	italic->setOn(FALSE);
	QObject::connect(italic,SIGNAL(clicked()),SLOT(toggleItalic()));

	underline = new QToolButton(hb);
	QFont f3( QString("Adobe Times"), 12);
	f3.setUnderline(TRUE);
    	underline->setFont( f3 );
	underline->setText(QString("U"));
	underline->setToggleButton(TRUE);
	underline->setOn(FALSE);
	QObject::connect(underline,SIGNAL(clicked()),SLOT(toggleUnderline()));

	superscript = new QToolButton(hb);
	superscript->setText(QString("x"));
	superscript->setToggleButton(TRUE);
	superscript->setOn(FALSE);
	QObject::connect(superscript,SIGNAL(clicked()),SLOT(toggleSuperscript()));

	subscript = new QToolButton(hb);
	subscript->setText(QString("x_2"));
	subscript->setToggleButton(TRUE);
	subscript->setOn(FALSE);
	QObject::connect(subscript,SIGNAL(clicked()),SLOT(toggleSubscript()));

	hb = new QHBox(gb);
	kcb = new KColorButton(l->color(),hb);
	kcb->setMaximumWidth(150);
	QObject::connect(kcb,SIGNAL(changed(const QColor &)),this,SLOT(setTEColor()));
	
	KPushButton *smallgreekpb = new KPushButton( QString("\341"), hb );
	sgletters = new KPopupMenu();
	sgletters->setFont(QFont(QString("Greek Times")));
	QObject::connect(sgletters,SIGNAL(activated(int)),SLOT(insertGChar(int)));
	smallgreekpb->setPopup(sgletters);
	for (int i=0;i<25;i++) {
		sgletters->insertItem(QString(QChar(i+225)),i+225);
	}
	KPushButton *biggreekpb = new KPushButton( QString("\303"), hb );
	bgletters = new KPopupMenu();
	bgletters->setFont(QFont(QString("Greek Times")));
	QObject::connect(bgletters,SIGNAL(activated(int)),SLOT(insertGChar(int)));
	biggreekpb->setPopup(bgletters);
	for (int i=0;i<24;i++) {
		bgletters->insertItem(QString(QChar(i+193)),i+193);
	}
	KPushButton *otherpb = new KPushButton(QString("\243"), hb );
	oletters = new KPopupMenu();
	QObject::connect(oletters,SIGNAL(activated(int)),SLOT(insertChar(int)));
	otherpb->setPopup(oletters);
	for (int i=0;i<222;i++) {
		oletters->insertItem(QString(QChar(i+161)),i+1161);	// +1000 to avoid crossing with greeks 
	}
	
	smallgreekpb->setMaximumWidth(40);
	biggreekpb->setMaximumWidth(40);
	otherpb->setMaximumWidth(40);
	smallgreekpb->setFont(QFont(QString("Greek Times")));
	biggreekpb->setFont(QFont(QString("Greek Times")));
	otherpb->setFont(QFont(QString("Greek Times")));

	te = new QTextEdit(gb);
	te->setTextFormat(Qt::RichText);
	update();
}

void RichTextWidget::update() {
	kdDebug()<<"RTW::update()"<<endl;
        kdDebug()<<"Setting x/y line edits to "<<l->X()<<'/'<<l->Y()<<endl;
	
	boxedcb->setChecked(l->Boxed());
	xle->setText(QString::number(l->X()));
	yle->setText(QString::number(l->Y()));
	
	te->setFont(l->font());
	titleFont->setText(l->font().family() + " " + QString::number(l->font().pointSize()));
	te->setText(l->title());
	kcb->setColor(l->color());
}

void RichTextWidget::insertChar(int ch) {
	te->setFamily(QString("Adobe Times"));
	te->insert(QString(QChar(ch-1000)));
}

void RichTextWidget::insertGChar(int ch) {
	te->setFamily(QString("Greek Times"));
	te->insert(QString(QChar(ch)));
}

void RichTextWidget::toggleBold() {
	if(bold->isOn()) {
		bold->setOn(FALSE);
		te->setBold(TRUE);
	}
	else {
		bold->setOn(TRUE);
		te->setBold(FALSE);
	}
	bold->toggle();
}

void RichTextWidget::toggleItalic() {
	if(italic->isOn()) {
		italic->setOn(FALSE);
		te->setItalic(TRUE);
	}
	else {
		italic->setOn(TRUE);
		te->setItalic(FALSE);
	}
	italic->toggle();
}

void RichTextWidget::toggleUnderline() {
	if(underline->isOn()) {
		underline->setOn(FALSE);
		te->setUnderline(TRUE);
	}
	else {
		underline->setOn(TRUE);
		te->setUnderline(FALSE);
	}
	underline->toggle();
}

void RichTextWidget::toggleSuperscript() {
	if(superscript->isOn()) {
		superscript->setOn(FALSE);
		te->setVerticalAlignment(QTextEdit::AlignSuperScript);
	}
	else {
		superscript->setOn(TRUE);
		te->setVerticalAlignment(QTextEdit::AlignNormal);
	}
	superscript->toggle();
}

void RichTextWidget::toggleSubscript() {
	if(subscript->isOn()) {
		subscript->setOn(FALSE);
		te->setVerticalAlignment(QTextEdit::AlignSubScript);
	}
	else {
		subscript->setOn(TRUE);
		te->setVerticalAlignment(QTextEdit::AlignNormal);
	}
	subscript->toggle();
}

void RichTextWidget::selectFont() {
    bool ok;
    // first time it doesn't work with helvetia font !
    QFont f = QFontDialog::getFont( &ok,l->font() ,this );
    if ( ok ) {
	l->setFont(f);
	titleFont->setText(f.family()+ " " + QString::number(f.pointSize()));
	te->setFont(f);
    }
}

void RichTextWidget::setTEColor() {
	QColor c = kcb->color();
	l->setColor(c);
	te->setColor(c);
}

void RichTextWidget::apply() {
	l->setTitle(te->text());
	l->setPosition(xle->text().toDouble(),yle->text().toDouble());
	l->setBoxed(boxedcb->isChecked());
}
