//LabPlot : Symbol.h

#ifndef SYMBOL_H
#define SYMBOL_H

#include <qcolor.h>
#include "defs.h"

class Symbol {
public:
	Symbol(SType t=SNONE, QColor c="blue", int s=5, FType f=FNONE, QColor fc="red", int b=1);
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	void draw(QPainter *p,int X, int Y);
	SType getType() { return type; }
	void setType(int t) { type = (SType) t; }
	QColor getColor() { return color; }
	void setColor(QString c) {color = QColor(c); }
	int getSize() { return size; }
	void setSize(int s) { size = s; }
	FType getFill() { return fill; }
	void setFill(FType f) { fill = f; }
	QColor getFillColor() { return fillcolor; }
	void setFillColor(QString fc) { fillcolor = QColor(fc); }
	int getBrush() { return brush;}
	void setBrush(int b) { brush = b; }
private:
	SType type;
	QColor color;
	int size;
	FType fill;
	QColor fillcolor;
	int brush;
};

#endif //SYMBOL_H
