//LabPlot : ConvolutionListDialog.h

#ifndef CONVOLUTIONLISTDIALOG_H
#define CONVOLUTIONLISTDIALOG_H

#include "ListDialog.h"

class ConvolutionListDialog : public ListDialog
{
	Q_OBJECT
public:
	ConvolutionListDialog(MainWin *mw, const char *name);
public slots:
	void setType(bool t=false) {type->setCurrentItem(t); }		//!< convolute or deconvolute
	void setSet1(int s) { set1ni->setValue(s); }			//!< set first set to use
	void setSet2(int s) { set2ni->setValue(s); }			//!< set second set to use
	void setXValues(int v) { xvalue->setCurrentItem(v); }		//!< set x value
	int Apply() { return apply_clicked(); }
private:
	KIntNumInput *set1ni, *set2ni;
	KComboBox *type, *xvalue;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // CONVOLUTIONLISTDIALOG_H
