//LabPlot : PeriodicListDialog.cc

#include "PeriodicListDialog.h"
#include "source.h"
#include "defs.h"

using namespace std;

PeriodicListDialog::PeriodicListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Periodic Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Periodic" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Period :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nni = new KIntNumInput(config->readNumEntry("Period",3),hb);
	nni->setRange(1,INF,1,false);

	hb = new QHBox(tab1);
	averagecb = new QCheckBox(i18n("Average"),hb);
	averagecb->setChecked(config->readBoolEntry("Average",true));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));
		
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PeriodicListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Periodic" );
	
	config->writeEntry("Period", nni->value());
	config->writeEntry("Average", averagecb->isChecked());
}

int PeriodicListDialog::apply_clicked() {
	int n = nni->value();

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		if(n >= table->numRows()) {
			KMessageBox::error(this,i18n("n bigger than number of rows!\nPlease use a smaller value."));
			return -1;
		}
		
		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(!table->text(i,table->numCols()-1).isEmpty()) {
				empty =false;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<n;i++) {
			double sum=0;
			for (int j=0;j<table->numRows()/n;j++) {
				sum+=table->text(i+j*n,col).toDouble();
			}
			if(averagecb->isChecked())
				sum /= table->numRows()/n;
			
			// insert into last column
			table->setText(i,newcol,QString::number(sum));
		}
		return 0;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType st = gl->getStruct(item);

	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->value(),(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}
	
	double x,y,z=0,t,xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[n];
		Point *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// do periodic
		for (int i = 0;i<n;i++) {
			x = a[i].X();
			y = 0;
			for (int j=0;j<nx/n;j++) {
				y+=a[i+j*n].Y();
			}
			if(averagecb->isChecked())
				y /= nx/n;

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("periodic (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		if(n>nx)	n=nx;
		Point3D *ptr = new Point3D[n];
		Point3D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		cout<< "TYPE : "<<(int)type<<endl;
		
		if(type != P2D) {
			//TODO
			KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
			return -2;
		}
		
		for (int i = 0;i<n;i++) {
			x = a[i].X();
			y = 0;
			
			for (int j=0;j<nx/n;j++) {
				y+=a[i+j*n].Y();
				z+=a[i+j*n].Z();
			}
			if(averagecb->isChecked()) {
				y /= nx/n;
				z /= nx/n;
			}

			ptr[i].setPoint(x,y,z);
		}
		
		mw->calculateRanges3D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("periodic (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());
		
		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,1);
		ng->setNumberX((int)(g->NX()/n));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		bool gtype = g->Type();
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx];
		Point4D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		if (type != P2D) {	// ?
			KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
			return -3;
		}
		
		for (int i = 0;i<n;i++) {
			x = a[i].X();
			y = 0;z=0;t=0;
			
			for (int j=0;j<nx/n;j++) {
				y+=a[i+j*n].Y();
				z+=a[i+j*n].Z();
				t+=a[i+j*n].T();
			}
			if(averagecb->isChecked()) {
				y /= nx/n;
				z /= nx/n;
				t /= nx/n;
			}

			ptr[i].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);

		// create the new Graph
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);
		
		QString fun = QString(i18n("periodic (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());
		
		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,gtype);
		mw->addGraph4D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPHM) {		// PSURFACE and P3D
		GraphM *g = gl->getGraphM(item);
		int N = g->Number();
		int nx = g->NX();
		int ny = g->NY();
		double *ptr = new double[N];
		//double *a = g->Data();

		if(n >= nx || n >= ny) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// TODO : periodic functions
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
		return -3;

		// create the new Graph
		LRange range[3];
		range[0] = LRange(1,nx);
		range[1] = LRange(1,ny);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("periodic (")+QString::number(n)+i18n(") of ")+g->getLabel()->simpleTitle());

		GraphM *ng = new GraphM(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx/n,ny/n);
		mw->addGraphM(ng,sheetcb->currentItem(),type);
	}

	updateList();
	
	return 0;
}
