;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: org.langband.vanilla -*-

#|

DESC: variants/vanilla/config/flavours.lisp - flavours for vanilla variant
Copyright (c) 2000-2002 - Stig Erik Sand

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

|#

(in-package :org.langband.vanilla)

(define-flavour-type '<potion> :text-char #\!)
(define-flavour-type '<ring> :text-char #\=)
(define-flavour-type '<amulet> :text-char #\")
(define-flavour-type '<staff> :text-char #\_)
(define-flavour-type '<wand> :text-char #\-)
(define-flavour-type '<rod> :text-char #\-)
(define-flavour-type '<mushroom> :text-char #\,)
;; scrolls are defined at the end of this file and in various.lisp


;; the potion flavours
(define-basic-flavour '<potion> "clear" :text-attr #\w :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 26))
(define-basic-flavour '<potion> "light brown" :text-attr #\U :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 13))
(define-basic-flavour '<potion> "icky green" :text-attr #\g :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 17))
(define-basic-flavour '<potion> "azure" :text-attr #\B :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 4))
(define-basic-flavour '<potion> "blue" :text-attr #\b :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 5))
(define-basic-flavour '<potion> "blue speckled" :text-attr #\b :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 6))
(define-basic-flavour '<potion> "black" :text-attr #\D :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 0))
(define-basic-flavour '<potion> "brown" :text-attr #\u :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 8))
(define-basic-flavour '<potion> "brown speckled" :text-attr #\u :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 35))
(define-basic-flavour '<potion> "bubbling" :text-attr #\W :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 56))
(define-basic-flavour '<potion> "chartreuse" :text-attr #\G :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 17))
(define-basic-flavour '<potion> "cloudy" :text-attr #\w :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 0))
(define-basic-flavour '<potion> "copper speckled" :text-attr #\U :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 19))
(define-basic-flavour '<potion> "crimson" :text-attr #\r :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 18))
(define-basic-flavour '<potion> "cyan" :text-attr #\B :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 4))
(define-basic-flavour '<potion> "dark blue" :text-attr #\b :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 15))
(define-basic-flavour '<potion> "dark green" :text-attr #\g :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 17))
(define-basic-flavour '<potion> "dark red" :text-attr #\r :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 30))
(define-basic-flavour '<potion> "gold speckled" :text-attr #\y :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 49))
(define-basic-flavour '<potion> "green" :text-attr #\g :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 21))
(define-basic-flavour '<potion> "green speckled" :text-attr #\g :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 27))
(define-basic-flavour '<potion> "grey" :text-attr #\s :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 24))
(define-basic-flavour '<potion> "grey speckled" :text-attr #\s :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 48))
(define-basic-flavour '<potion> "hazy" :text-attr #\W :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 2))
(define-basic-flavour '<potion> "indigo" :text-attr #\v :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 46))
(define-basic-flavour '<potion> "light blue" :text-attr #\B :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 26))
(define-basic-flavour '<potion> "light green" :text-attr #\G :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 21))
(define-basic-flavour '<potion> "magenta" :text-attr #\r :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 41))
(define-basic-flavour '<potion> "metallic blue" :text-attr #\b :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 5))
(define-basic-flavour '<potion> "metallic red" :text-attr #\r :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 28))
(define-basic-flavour '<potion> "metallic green" :text-attr #\g :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 31))
(define-basic-flavour '<potion> "metallic purple" :text-attr #\v :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 32))
(define-basic-flavour '<potion> "misty" :text-attr #\W :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 33))
(define-basic-flavour '<potion> "orange" :text-attr #\o :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 13))
(define-basic-flavour '<potion> "orange speckled" :text-attr #\o :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 35))
(define-basic-flavour '<potion> "pink" :text-attr #\R :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 37))
(define-basic-flavour '<potion> "pink speckled" :text-attr #\R :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 53))
(define-basic-flavour '<potion> "puce" :text-attr #\v :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 40))
(define-basic-flavour '<potion> "purple" :text-attr #\v :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 39))
(define-basic-flavour '<potion> "purple speckled" :text-attr #\v :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 40))
(define-basic-flavour '<potion> "red" :text-attr #\r :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 57))
(define-basic-flavour '<potion> "red speckled" :text-attr #\r :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 41))
(define-basic-flavour '<potion> "silver speckled" :text-attr #\W :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 48))
(define-basic-flavour '<potion> "smoky" :text-attr #\D :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 23))
(define-basic-flavour '<potion> "tangerine" :text-attr #\o :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 3))
(define-basic-flavour '<potion> "violet" :text-attr #\v :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 32))
(define-basic-flavour '<potion> "vermilion" :text-attr #\r :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 47))
(define-basic-flavour '<potion> "white" :text-attr #\w :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 48))
(define-basic-flavour '<potion> "yellow" :text-attr #\y :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 58))
(define-basic-flavour '<potion> "violet speckled" :text-attr #\v :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 46))
(define-basic-flavour '<potion> "pungent" :text-attr #\R :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 13))
(define-basic-flavour '<potion> "clotted red" :text-attr #\r :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 3))
(define-basic-flavour '<potion> "viscous pink" :text-attr #\R :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 36))
(define-basic-flavour '<potion> "oily yellow" :text-attr #\y :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 11))
(define-basic-flavour '<potion> "gloopy green" :text-attr #\g :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 17))
(define-basic-flavour '<potion> "shimmering" :text-attr #\v :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 46))
(define-basic-flavour '<potion> "coagulated crimson" :text-attr #\r :text-char #\!    :x-attr (tile-file 11) :x-char (tile-number 18))
(define-basic-flavour '<potion> "yellow speckled" :text-attr #\y :text-char #\!	      :x-attr (tile-file 11) :x-char (tile-number 49))
(define-basic-flavour '<potion> "gold" :text-attr #\y :text-char #\!		      :x-attr (tile-file 11) :x-char (tile-number 58))


;; the mushrooms
(define-basic-flavour '<mushroom> "blue" :text-attr #\b :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 13))
(define-basic-flavour '<mushroom> "black" :text-attr #\D :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 7))
(define-basic-flavour '<mushroom> "black spotted" :text-attr #\D :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 15))
(define-basic-flavour '<mushroom> "brown" :text-attr #\u :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 23))
(define-basic-flavour '<mushroom> "dark blue" :text-attr #\b :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 13))
(define-basic-flavour '<mushroom> "dark green" :text-attr #\g :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 12))
(define-basic-flavour '<mushroom> "dark red" :text-attr #\r :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 11))
(define-basic-flavour '<mushroom> "yellow" :text-attr #\y :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 18))
(define-basic-flavour '<mushroom> "furry" :text-attr #\W :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 16))
(define-basic-flavour '<mushroom> "green" :text-attr #\g :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 21))
(define-basic-flavour '<mushroom> "grey" :text-attr #\s :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 16))
(define-basic-flavour '<mushroom> "light blue" :text-attr #\B :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 22))
(define-basic-flavour '<mushroom> "light green" :text-attr #\G :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 21))
(define-basic-flavour '<mushroom> "violet" :text-attr #\v :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 17))
(define-basic-flavour '<mushroom> "red" :text-attr #\r :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 20))
(define-basic-flavour '<mushroom> "slimy" :text-attr #\s :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 19))
(define-basic-flavour '<mushroom> "tan" :text-attr #\U :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 23))
(define-basic-flavour '<mushroom> "white" :text-attr #\w :text-char #\,		      :x-attr (tile-file 5) :x-char (tile-number 8))
(define-basic-flavour '<mushroom> "white spotted" :text-attr #\w :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 16))
(define-basic-flavour '<mushroom> "wrinkled" :text-attr #\u :text-char #\,	      :x-attr (tile-file 5) :x-char (tile-number 14))

;; the wand flavours

(define-basic-flavour '<wand> "aluminium" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 0))
(define-basic-flavour '<wand> "cast iron" :text-attr #\D :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 6))
(define-basic-flavour '<wand> "chromium" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 7))
(define-basic-flavour '<wand> "copper" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 6))
(define-basic-flavour '<wand> "gold" :text-attr #\y :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 8))
(define-basic-flavour '<wand> "iron" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 5))
(define-basic-flavour '<wand> "magnesium" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 8))
(define-basic-flavour '<wand> "molybdenum" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 7))
(define-basic-flavour '<wand> "nickel" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 4))
(define-basic-flavour '<wand> "rusty" :text-attr #\r :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 5))
(define-basic-flavour '<wand> "silver" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 0))
(define-basic-flavour '<wand> "steel" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 1))
(define-basic-flavour '<wand> "tin" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 1))
(define-basic-flavour '<wand> "titanium" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 6))
(define-basic-flavour '<wand> "tungsten" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 6))
(define-basic-flavour '<wand> "zirconium" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 7))
(define-basic-flavour '<wand> "zinc" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 4))
(define-basic-flavour '<wand> "aluminum-plated" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 11))
(define-basic-flavour '<wand> "copper-plated" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<wand> "gold-plated" :text-attr #\y :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 17))
(define-basic-flavour '<wand> "nickel-plated" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<wand> "silver-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<wand> "steel-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 12))
(define-basic-flavour '<wand> "tin-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 17))
(define-basic-flavour '<wand> "zinc-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<wand> "mithril-plated" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<wand> "mithril" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 16))
(define-basic-flavour '<wand> "runed" :text-attr #\u :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 11))
(define-basic-flavour '<wand> "bronze" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<wand> "brass" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<wand> "platinum" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<wand> "lead" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<wand> "lead-plated" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<wand> "ivory" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 17))
(define-basic-flavour '<wand> "pewter" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))


;; staff flavours
(define-basic-flavour '<staff> "aspen" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "balsa" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "banyan" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "birch" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 18))
(define-basic-flavour '<staff> "cedar" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "cottonwood" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 21))
(define-basic-flavour '<staff> "cypress" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "dogwood" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 24))
(define-basic-flavour '<staff> "elm" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "eucalyptus" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 24))
(define-basic-flavour '<staff> "hemlock" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "hickory" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "ironwood" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 21))
(define-basic-flavour '<staff> "locust" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "mahogany" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "maple" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "mulberry" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "oak" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "pine" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 24))
(define-basic-flavour '<staff> "redwood" :text-attr #\r :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "rosewood" :text-attr #\r :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 18))
(define-basic-flavour '<staff> "spruce" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 18))
(define-basic-flavour '<staff> "sycamore" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "teak" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 18))
(define-basic-flavour '<staff> "walnut" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "mistletoe" :text-attr #\g :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "hawthorn" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 20))
(define-basic-flavour '<staff> "bamboo" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 24))
(define-basic-flavour '<staff> "silver" :text-attr #\W :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 23))
(define-basic-flavour '<staff> "runed" :text-attr #\u :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 24))
(define-basic-flavour '<staff> "golden" :text-attr #\g :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "ashen" :text-attr #\s :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 21))
(define-basic-flavour '<staff> "gnarled" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 19))
(define-basic-flavour '<staff> "ivory" :text-attr #\w :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 22))
(define-basic-flavour '<staff> "willow" :text-attr #\U :text-char #\_ :x-attr (tile-file 12) :x-char (tile-number 21))

;; amulet flavours

(define-basic-flavour '<amulet> "amber" :text-attr #\y :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 29))
(define-basic-flavour '<amulet> "driftwood" :text-attr #\U :text-char #\"	      :x-attr (tile-file 8) :x-char (tile-number 36))
(define-basic-flavour '<amulet> "coral" :text-attr #\w :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 39))
(define-basic-flavour '<amulet> "agate" :text-attr #\W :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 25))
(define-basic-flavour '<amulet> "ivory" :text-attr #\w :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 24))
(define-basic-flavour '<amulet> "obsidian" :text-attr #\D :text-char #\"	      :x-attr (tile-file 8) :x-char (tile-number 27))
(define-basic-flavour '<amulet> "bone" :text-attr #\w :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 24))
(define-basic-flavour '<amulet> "brass" :text-attr #\U :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 34))
(define-basic-flavour '<amulet> "bronze" :text-attr #\U :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 31))
(define-basic-flavour '<amulet> "pewter" :text-attr #\s :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 32))
(define-basic-flavour '<amulet> "tortoise shell" :text-attr #\u :text-char #\"	      :x-attr (tile-file 8) :x-char (tile-number 30))
(define-basic-flavour '<amulet> "golden" :text-attr #\y :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 28))
(define-basic-flavour '<amulet> "azure" :text-attr #\B :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 37))
(define-basic-flavour '<amulet> "crystal" :text-attr #\w :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 24))
(define-basic-flavour '<amulet> "silver" :text-attr #\W :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 25))
(define-basic-flavour '<amulet> "copper" :text-attr #\U :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 34))
(define-basic-flavour '<amulet> "carved oak" :text-attr #\u :text-char #\"	      :x-attr (tile-file 8) :x-char (tile-number 39))
(define-basic-flavour '<amulet> "dragon tooth" :text-attr #\W :text-char #\"	      :x-attr (tile-file 8) :x-char (tile-number 24))
(define-basic-flavour '<amulet> "ruby" :text-attr #\r :text-char #\"		      :x-attr (tile-file 8) :x-char (tile-number 31))
(define-basic-flavour '<amulet> "mithril" :text-attr #\B :text-char #\"               :x-attr (tile-file 8) :x-char (tile-number 37))
(define-basic-flavour '<amulet> "adamant" :text-attr #\G :text-char #\"               :x-attr (tile-file 8) :x-char (tile-number 34))
(define-basic-flavour '<amulet> "flint stone" :text-attr #\s :text-char #\"           :x-attr (tile-file 8) :x-char (tile-number 26))
(define-basic-flavour '<amulet> "sea shell" :text-attr #\B :text-char #\"             :x-attr (tile-file 8) :x-char (tile-number 37))
(define-basic-flavour '<amulet> "mother-of-pearl" :text-attr #\W :text-char #\"       :x-attr (tile-file 8) :x-char (tile-number 25))

;; ring flavours

(define-basic-flavour '<ring> "adamantite" :text-attr #\G :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 12))
(define-basic-flavour '<ring> "alexandrite" :text-attr #\g :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 4))
(define-basic-flavour '<ring> "amethyst" :text-attr #\v :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 9))
(define-basic-flavour '<ring> "aquamarine" :text-attr #\B :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 13))
(define-basic-flavour '<ring> "azurite" :text-attr #\B :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 13))
(define-basic-flavour '<ring> "beryl" :text-attr #\G :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 12))
(define-basic-flavour '<ring> "bloodstone" :text-attr #\r :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 3))
(define-basic-flavour '<ring> "calcite" :text-attr #\w :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 0))
(define-basic-flavour '<ring> "carnelian" :text-attr #\r :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 3))
(define-basic-flavour '<ring> "corundum" :text-attr #\s :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 8))
(define-basic-flavour '<ring> "diamond" :text-attr #\w :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 0))
(define-basic-flavour '<ring> "emerald" :text-attr #\g :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 4))
(define-basic-flavour '<ring> "fluorite" :text-attr #\G :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 12))
(define-basic-flavour '<ring> "garnet" :text-attr #\r :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 3))
(define-basic-flavour '<ring> "granite" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "jade" :text-attr #\G :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 12))
(define-basic-flavour '<ring> "jasper" :text-attr #\u :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 6))
(define-basic-flavour '<ring> "lapis lazuli" :text-attr #\b :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 5))
(define-basic-flavour '<ring> "malachite" :text-attr #\g :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 4))
(define-basic-flavour '<ring> "marble" :text-attr #\w :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 0))
(define-basic-flavour '<ring> "moonstone" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "onyx" :text-attr #\R :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 11))
(define-basic-flavour '<ring> "opal" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "pearl" :text-attr #\w :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 0))
(define-basic-flavour '<ring> "quartz" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "quartzite" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "rhodonite" :text-attr #\R :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 11))
(define-basic-flavour '<ring> "ruby" :text-attr #\r :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 3))
(define-basic-flavour '<ring> "sapphire" :text-attr #\b :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 5))
(define-basic-flavour '<ring> "tiger eye" :text-attr #\y :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 10))
(define-basic-flavour '<ring> "topaz" :text-attr #\y :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 10))
(define-basic-flavour '<ring> "turquoise" :text-attr #\B :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 13))
(define-basic-flavour '<ring> "zircon" :text-attr #\U :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 14))
(define-basic-flavour '<ring> "platinum" :text-attr #\w :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 0))
(define-basic-flavour '<ring> "bronze" :text-attr #\U :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 14))
(define-basic-flavour '<ring> "gold" :text-attr #\y :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 10))
(define-basic-flavour '<ring> "obsidian" :text-attr #\D :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "silver" :text-attr #\W :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "tortoise shell" :text-attr #\u :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 6))
(define-basic-flavour '<ring> "mithril" :text-attr #\B :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 13))
(define-basic-flavour '<ring> "jet" :text-attr #\D :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 1))
(define-basic-flavour '<ring> "engagement" :text-attr #\y :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 10))
(define-basic-flavour '<ring> "plain gold" :text-attr #\y :text-char #\= :x-attr (tile-file 8) :x-char (tile-number 23))
;; rod flavours

(define-basic-flavour '<rod> "aluminum" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "cast iron" :text-attr #\D :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "chromium" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "copper" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "gold" :text-attr #\y :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 17))
(define-basic-flavour '<rod> "iron" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<rod> "magnesium" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "molybdenum" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 16))
(define-basic-flavour '<rod> "nickel" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<rod> "rusty" :text-attr #\r :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 12))
(define-basic-flavour '<rod> "silver" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 9))
(define-basic-flavour '<rod> "steel" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "tin" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 16))
(define-basic-flavour '<rod> "titanium" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 11))
(define-basic-flavour '<rod> "tungsten" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 11))
(define-basic-flavour '<rod> "zirconium" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 11))
(define-basic-flavour '<rod> "zinc" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<rod> "aluminum-plated" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "copper-plated" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<rod> "gold-plated" :text-attr #\y :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "nickel-plated" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<rod> "silver-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "steel-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "tin-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 9))
(define-basic-flavour '<rod> "zinc-plated" :text-attr #\W :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 12))
(define-basic-flavour '<rod> "mithril-plated" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 16))
(define-basic-flavour '<rod> "mithril" :text-attr #\B :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 16))
(define-basic-flavour '<rod> "runed" :text-attr #\u :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 10))
(define-basic-flavour '<rod> "bronze" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 14))
(define-basic-flavour '<rod> "brass" :text-attr #\U :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<rod> "platinum" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 13))
(define-basic-flavour '<rod> "lead" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 12))
(define-basic-flavour '<rod> "lead-plated" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))
(define-basic-flavour '<rod> "ivory" :text-attr #\w :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 17))
(define-basic-flavour '<rod> "pewter" :text-attr #\s :text-char #\- :x-attr (tile-file 12) :x-char (tile-number 15))


;; the scroll functionality is in various.lisp and is compiled. 
;; time to add the scroll flavour type
(define-flavour-type '<scroll> :generator-fn #'van-generate-scroll-flavour
		     :text-char #\?)

