# !Turkce,Turkish! -*-coding: iso-8859-9;-*-
# Turkish support for language-env.
# Copyright (C) 2004  Recai Oktas <roktas@omu.edu.tr>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.


# ------------------------------------------------------------------
# Font sets for some encodings to be included in the Xresource file.
#
# You must define the package which provides that font.  It is
# suggested that there should be at least _six_ different variant in
# each family, so that a font resource assignment can take place in
# the following order: font, font1, font2, font3, font4 and font5.
# ------------------------------------------------------------------

our %XFONTSET = (
	# --------------------------------------------------------------
	# Unicode fonts.
	# --------------------------------------------------------------
	'UTF-8' => {
		'terminus' => {
			'package' => 'xfonts-terminus',
			'xlfd' => [
			'-xos4-terminus-bold-r-normal--20-*-*-*-*-*-iso10646-1',
			'-xos4-terminus-medium-r-normal--14-*-*-*-*-*-iso10646-1',
			'-xos4-terminus-medium-r-normal--16-*-*-*-*-*-iso10646-1',
			'-xos4-terminus-medium-r-normal--20-*-*-*-*-*-iso10646-1',
			'-xos4-terminus-medium-r-normal--24-*-*-*-*-*-iso10646-1',
			'-xos4-terminus-medium-r-normal--28-*-*-*-*-*-iso10646-1'
			]
		},
		'misc-fixed' => {
			'package' => 'xfonts-base',
			'xlfd' => [
			'-misc-fixed-medium-r-normal--20-*-*-*-*-*-iso10646-1',
			'-misc-fixed-medium-r-normal--13-*-*-*-*-*-iso10646-1',
			'-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso10646-1',
			'-misc-fixed-medium-r-normal--15-*-*-*-*-*-iso10646-1',
			'-misc-fixed-bold-r-normal--15-*-*-*-*-*-iso10646-1',
			'-misc-fixed-medium-r-normal--20-*-*-*-*-*-iso10646-1'
			]
		}
	},

	# --------------------------------------------------------------
	# ISO-8859-9 (Turkish) encoded fonts.
	# --------------------------------------------------------------
	'ISO-8859-9' => {
		'terminus' => {
			'package' => 'xfonts-terminus',
			'xlfd' => [
			'-xos4-terminus-bold-r-normal--20-*-*-*-*-*-iso8859-9',
			'-xos4-terminus-medium-r-normal--14-*-*-*-*-*-iso8859-9',
			'-xos4-terminus-medium-r-normal--16-*-*-*-*-*-iso8859-9',
			'-xos4-terminus-medium-r-normal--20-*-*-*-*-*-iso8859-9',
			'-xos4-terminus-medium-r-normal--24-*-*-*-*-*-iso8859-9',
			'-xos4-terminus-medium-r-normal--28-*-*-*-*-*-iso8859-9'
			]
		},
		'misc-fixed' => {
			'package' => 'xfonts-base-transcoded',
			'xlfd' => [
			'-misc-fixed-medium-r-normal--20-*-*-*-*-*-iso8859-9',
			'-misc-fixed-medium-r-normal--13-*-*-*-*-*-iso8859-9',
			'-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso8859-9',
			'-misc-fixed-medium-r-normal--15-*-*-*-*-*-iso8859-9',
			'-misc-fixed-bold-r-normal--15-*-*-*-*-*-iso8859-9',
			'-misc-fixed-medium-r-normal--20-*-*-*-*-*-iso8859-9'
			]
		}
	}
);


# ---------------------------------------------------
# fontsel() is a subroutine to select a font family
# from the given font set of a certain encoding.  This
# can be used to determine the various font resources
# in Xresource files.  Selection will be made by calling
# Sub::select depending on the availability of fonts.  
# Note that in case of a single available item, no
# question will be directed to user, which makes this
# subroutine somewhat smarter.  Refer to the fontset
# hash data structure for other details.
#
# Return value:
#  Selected font name.
#
# Four parameters are given.
#  The 1st parameter is the fontset hash of some
#  encoding.
#  The 2nd parameter is a string of ordered font list.  
#  The first _available_ font from this list will be
#  the default choice in the font selection, or it
#  will be directly returned if no alternative exists.
#  An optional '!' character which will be removed
#  later, may be used in font names.  During the hash
#  look up, it will be utilized to signal that the
#  package it belongs to must be added to install list.
#  Also note that if there is no available font, the
#  first font in the list will be returned as the
#  fallback default.
#  The 3nd and the 4th parameters are the usual args
#  of Sub::select, that is, messages written in ASCII
#  and in local codeset.
# ---------------------------------------------------

BEGIN {
	# Static hash to store the availability status.
	# Well, an overkill for such a simple job?
	# Calling Sub::isinstalled() for every font would
	# just disturb me otherwise ;-)
	my %PackageStatus;

	sub fontsel(\%$$$)
	{
		my (%set) = %{ $_[0] };
		my @fonts = split ' ', $_[1];
		
		my @avails = ();
		# Determine available packages, and add list on demand.
		foreach $f (@fonts) {
			# Add to install list, if not available?
			$f =~ s/!// if ($addlist = ($f =~ /!/));

			# Skip if no such font exists in hash.
			next unless (exists($set{$f}));

			# Create a status entry in the packages list.
			$p = $set{$f}->{'package'};
			if (! defined($PackageStatus{$p})) {
				$PackageStatus{$p} = &Sub::isinstalled($p);
			}
				
			# Now, check the availability from the static list.
			if ($PackageStatus{$p}) {
				# Put it to local available list.
				push @avails, $f;
			} else {
				# Add to install list, if it is told to do so.
				if ($addlist) {
					@::RequiredPackageList = (@::RequiredPackageList, $p);
				}
			}
		}

		# Do the selection based on the available fonts.
		if (scalar(@avails) == 1) {
			# Don't ask for a single item, font order does matter here.
			$retval = pop @avails;
		} elsif (scalar(@avails) > 1) {
			# Ask for a choice if alternatives are available.
			my $choices;
			foreach $f (@avails) { $choices .= sprintf '%d: %s   ', ++$num, $f }
			$c = &Sub::select(
				$_[2] . $choices . "\n", $_[3] . $choices . "\n", $num, 1);
			$retval = @avails[$c - 1];
		} else {
			# Fallback to the first item as default.
			$retval = @fonts[0]; $retval =~ s/!//g;
		}

		return  $retval;
	}
}


# ---------------------------------------------------
# isNC() is a subroutine to check Native Character 
# Environment.
#
# The meaning of return value is:
#   0: not Native Character Environment, and
#   1: Native Character Environment.
#
# Three parameters are given.
#  The first one is the name of the script.
#  The second one is the command option given to the
#  script.
#  The third one is $main::opt_N, which inhibits to
#  fork another set-language-env.
# ---------------------------------------------------
sub isNC($$$)
{
	my $reply;

        print STDERR "\n           \n";
        print STDERR "Yukaridaki Turkce karakterleri gorebiliyor musunuz? [e/H] ";
        $reply = <>;

        if ($reply =~ /e|E/) {
                return 1;
        }

        return 0;
}


# ---------------------------------------------------
# initialize() is a subroutine to initialize Sub:: 
# variables with/without dialog.
# Any variables in Sub:: package can be set here to
# be used in dot.*.pl files.
# ---------------------------------------------------
sub initialize()
{
	# ----------------------------------------------------------
	# Encoding selection.
	# ----------------------------------------------------------
	$c = &Sub::select(
		"\nLutfen ayarlarda goz onune alinacak ontanimli " .
		"karakter kodlamasini secin.\n1: ISO-8859-9   2: UTF-8\n",
		"\nLtfen ayarlarda gz nne alnacak ntanml " .
		"karakter kodlamasn sein.\n1: ISO-8859-9   2: UTF-8\n", 2, 1);

	if ($c == 1) {
		$Sub::ENCODING = "ISO-8859-9"; $Sub::ALTENCODING = "UTF-8";
		$Sub::LOCALE = "tr_TR";
	} elsif ($c == 2) {
		$Sub::ENCODING = "UTF-8";      $Sub::ALTENCODING = "ISO-8859-9";
		$Sub::LOCALE = "tr_TR.UTF-8";
	}

	# ----------------------------------------------------------
	# X font selection.
	# ----------------------------------------------------------
	
	my $suggested = 'terminus !misc-fixed';
	my %xfont = ( 'ISO-8859-9' => '', 'UTF-8' => '');

	foreach $e ($Sub::ENCODING, $Sub::ALTENCODING) {
		$suggested = $f if (exists $XFONTSET{$e}{$f});
		$f = &fontsel($XFONTSET{$e}, $suggested,
			"\nLutfen X Window ucbirimlerinde " .
			"kullanilacak bir $e yazitipi secin.\n",
			"\nLtfen X Window ubirimlerinde " .
			"kullanlacak bir $e yaztipi sein.\n");
		$xfont{$e} = $f;
	}

	@Sub::XFONT_ISO = @{ $XFONTSET{'ISO-8859-9'}{$xfont{'ISO-8859-9'}}{'xlfd'} };
	@Sub::XFONT_UNI = @{ $XFONTSET{'UTF-8'}{$xfont{'UTF-8'}}{'xlfd'} };
	# We don't use this yet.
	@Sub::XFONT     = @{ $XFONTSET{$xfont{$Sub::ENCODING}}{'xlfd'} };
	

	# ----------------------------------------------------------
	# Extra features.
	# ----------------------------------------------------------

	&Sub::disp(
		"\nTurkce klavye ve sanal ucbirimlerde (VT) Turkce yazitipleri\n" . 
		"gibi bazi temel ayarlarin sistem genelinde root tarafindan\n" . 
		"yapildigi varsayilmaktadir.  Root haklarina sahip degilseniz\n" .
		"veya sozu edilen ayarlarin nasil yapilacagina dair bir fikriniz\n" .
		"yoksa, bu ayarlarin kullanici hesabiniz dahilinde yapilmasi da\n" .
		"mumkun olabilir.  Sisteminiz bu acidan zaten sorunsuz ise\n" .
		"genisletilmis ayarlara gerek yoktur.\n",
		"\nTrke klavye ve sanal ubirimlerde (VT) Trke yaztipleri\n" . 
		"gibi baz temel ayarlarn sistem genelinde root tarafndan\n" . 
		"yapld varsaylmaktadr.  Root haklarna sahip deilseniz\n" .
		"veya sz edilen ayarlarn nasl yaplacana dair bir fikriniz\n" .
		"yoksa, bu ayarlarn kullanc hesabnz dahilinde yaplmas da\n" .
		"mmkn olabilir.  Sisteminiz bu adan zaten sorunsuz ise\n" .
		"geniletilmi ayarlara gerek yoktur.\n");
	
	$Sub::EXTENDED = &Sub::noyes(
		"\nGenisletilmis ayarlari uygulamak ister misiniz?\n",
		"\nGeniletilmi ayarlar uygulamak ister misiniz?\n");

	if ($Sub::EXTENDED) {
		# --------------------------------------------------
		# Keyboard selection.
		# --------------------------------------------------
		$c = &Sub::select(
			"\nKlavye duzenini secin.\n" .
			"1: Turkce Q klavye   2: Turkce F klavye\n",
			"\nKlavye dzenini sein.\n" .
			"1: Trke Q klavye   2: Trke F klavye\n", 2, 1);

		if ($c == 1) {
			$Sub::XKEYB = "basic"; $Sub::XKEYB_OPTS = "caps:shift";
			$Sub::CKEYB = "trq"    if ($Sub::ENCODING eq "ISO-8859-9");
			$Sub::CKEYB = "trqu"   if ($Sub::ENCODING eq "UTF-8");
		} elsif ($c == 2) {
			$Sub::XKEYB = "tr_f";  $Sub::XKEYB_OPTS = "caps:shift";
			$Sub::CKEYB = "trf"    if ($Sub::ENCODING eq "ISO-8859-9");
			$Sub::CKEYB = "trfu"   if ($Sub::ENCODING eq "UTF-8");
		}
	
		# --------------------------------------------------
		# Console font selection.
		# --------------------------------------------------
		$Sub::CFONT = "iso09.f16";
		if (&Sub::isinstalled("console-terminus")) {
			if ($xfont{$Sub::ENCODING} =~ "terminus" || &Sub::yesno(
					"\nSanal ucbirimlerde (VT) Terminus " .
					"yazitipini kullanmak ister misiniz?",
					"\nSanal ubirimlerde (VT) Terminus " .
					"yaztipini kullanmak ister misiniz?")) {
				$Sub::CFONT = "ter-916f";
			}
		}
		
		if (&Sub::isinstalled("gdm") ||	&Sub::isinstalled("kdm") ||
			&Sub::isinstalled("wdm")) {
			&Sub::disp(
				"\nUYARI: Genisletilmis ayarlarin tam etkili olabilmesi\n" .
				"icin sisteminizde kullandiginiz X ekran yoneticisinin\n" .
				"(gdm, kdm veya wdm) ev dizinindeki .xsession betigini\n" .
				"calistirmasi gerekiyor.  Bir sorunla karsilasirsaniz\n" .
				"ekran yoneticisinin oturum seceneklerinden buna uygun\n" .
				"secenegi etkinlestirmeniz gerekecektir.\n" .
				"\nDevam etmek icin herhangi bir tusa basin.\n",
				"\nUYARI: Geniletilmi ayarlarn tam etkili olabilmesi\n" .
				"iin sisteminizde kullandnz X ekran yneticisinin\n" .
				"(gdm, kdm veya wdm) ev dizinindeki .xsession betiini\n" .
				"altrmas gerekiyor.  Bir sorunla karlarsanz\n" .
				"ekran yneticisinin oturum seeneklerinden buna uygun\n" .
				"seenei etkinletirmeniz gerekecektir.\n" .
				"\nDevam etmek iin herhangi bir tua basn.\n");
			$dummy = <STDIN>;
		}
	}
	
	# ----------------------------------------------------------
	# The usual language-env stuff.
	# ----------------------------------------------------------
	
	&Sub::addlist("locales");
	&Sub::addlist("fonty");
	&Sub::addlist("manpages-tr");
	&Sub::addlist("util-linux-locales");

	if (&Sub::isinstalled("xserver-.*")) {

		# KDE.
		if (&Sub::isinstalled("kdebase")) {
			&Sub::addlist("kde-i18n-tr");
		}
		
		# Koffice.
		if (&Sub::isinstalled("koffice")) {
			&Sub::addlist("koffice-i18n-tr");
		}
		
		# Openoffice.
		if (&Sub::isinstalled("openoffice.org")) {
			&Sub::addlist("openoffice.org-l10n-tr");
		}
	}
	
	return 0;
}


# ---------------------------------------------------
# sourceset2displayset() is a subroutine to convert a 
# string from Source Character Codeset into Display 
# Character Codeset.
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	return $_[0];
}


# ---------------------------------------------------
# analcode() is a subroutine to guess the codeset of
# string given by a parameter.  The meaning of the
# result value is same to convcode().
# ---------------------------------------------------
sub analcode($)
{
	return 0;
}


# ---------------------------------------------------
# Convert the given string from its codeset into the
# given codeset.  The string is given by the 1st 
# parameter and the codeset is given by the 2nd 
# parameter.  The actual value of the 2nd parameter
# has to be the same as the return value of analcode
# subroutine.
# ---------------------------------------------------
sub convcode($$)
{
	return $_[0];
}


# ---------------------------------------------------
# Hash variables containing translated messages.
# ---------------------------------------------------

%messages = (

"\nPush [Enter] key to End.\n" =>
"\nIslemi sonlandirmak icin [Enter] tusuna basin.\n\000" .
"\nlemi sonlandrmak iin [Enter] tuuna basn.\n" ,

"Now obtaining package list...\n" =>
"Paket listesi hazirlaniyor...\n\000" .
"Paket listesi hazrlanyor...\n" ,

"Do setting? " =>
"Ayarlansin mi? \000" .
"Ayarlansn m? " ,

"Setting is not done.\n" =>
"Ayarlama yapilmadi.\n\000" .
"Ayarlama yaplmad.\n" ,

"Do setting...\n" =>
"Ayarlama yapiliyor...\n\000" .
"Ayarlama yaplyor...\n" ,

"Cannot read \"%s\".\n" =>
"\"%s\" okunamiyor.\n\000" .
"\"%s\" okunamyor.\n" ,

"Making a new file \"%s\"...\n" =>
"Yeni bir \"%s\" dosyasi olusturuluyor...\n\000" .
"Yeni bir \"%s\" dosyas oluturuluyor...\n" ,

"Cannot open \"%s\".\n" =>
"\"%s\" acilamiyor.\n\000" .
"\"%s\" alamyor.\n" ,

"Cannot write to \"%s\".\n" =>
"\"%s\" dosyasina yazilamiyor.\n\000" .
"\"%s\" dosyasna yazlamyor.\n" ,

"Cannot lock \"%s\".\n" =>
"\"%s\" dosyasina erisim engellenemiyor.\n\000" .
"\"%s\" dosyasna eriim engellenemiyor.\n" ,

"Cannot close \"%s\".\n" =>
"\"%s\" dosyasi kapatilamiyor.\n\000" .
"\"%s\" dosyas kapatlamyor.\n" ,

"Install the following packages.\n" =>
"Asagidaki paketleri kurmaniz onerilir.\n\000" .
"Aadaki paketleri kurmanz nerilir.\n" ,

"   Setting is now done.  To activate these settings,\n" .
"logout and login.\n" .
"   Read each dotfile and confirm the modification.\n" .
"If you don't like the setting, modify directly or\n" .
"add overriding setting after 'language-env end' line.\n" .
"   Read /usr/share/doc/language-env/README.* for detail.\n" =>
"   Yapilandirma tamamlandi.  Ayarlari etkinlestirmek icin\n" .
"oturumdan cikin ve tekrar girin.\n" .
"   Yapilandirma dosyalarini okuyun ve degisiklikleri kontrol edin.\n" .
"Begenmediginiz bir ayar varsa, dogrudan o kismi degistirebilir veya\n" .
"'language-env end' satirindan sonra kendi ayar satirinizi ekleyebilirsiniz.\n" .
"   Ayrintilar icin /usr/share/doc/language-env/README.tr dosyasini okuyun.\n\000" .
"   Yaplandrma tamamland.  Ayarlar etkinletirmek iin\n" .
"oturumdan kn ve tekrar girin.\n" .
"   Yaplandrma dosyalarn okuyun ve deiiklikleri kontrol edin.\n" .
"Beenmediiniz bir ayar varsa, dorudan o ksm deitirebilir veya\n" .
"'language-env end' satrndan sonra kendi ayar satrnz ekleyebilirsiniz.\n" .
"   Ayrntlar iin /usr/share/doc/language-env/README.tr dosyasn okuyun.\n" ,

"Usage: set-language-env [options]\n" .
"  -l language : Specify language (otherwise choose from menu)\n" .
"  -h          : This help message\n" .
"  -v          : 'verbose mode'\n" .
"  -s          : Display list of supported languages and exit\n" .
"  -r          : Remove all settings\n" .
"  -N          : Never fork another set-language-env (for internal use)\n" .
"  -c          : Don't use native character set (for internal use)\n" .
"  -C          : Use native character set (for internal use)\n" .
"  -E          : Setting for /etc/skel directory (root user only)\n" =>
"Kullanim: set-language-env [secenekler]\n" .
"  -l dil : Dili gir (aksi halde menu'den secilecek)\n" .
"  -h     : Bu yardim metni\n" .
"  -v     : 'ayrinti ver' kipi\n" .
"  -s     : Desteklenen dilleri listele ve cik\n" .
"  -r     : Butun ayarlari sil\n" .
"  -N     : Baska bir set-language-env sureci calistirilma (ic kullanima yonelik)\n" .
"  -c     : Anadil karakter setini kullanma (ic kullanima yonelik)\n" .
"  -C     : Anadil karakter ortamini kullan (ic kullanima yonelik)\n" .
"  -E     : Ayarlari /etc/skel dizinde yap (sadece root icin)\n\000" .
"Kullanm: set-language-env [seenekler]\n" .
"  -l dil : Dili gir (aksi halde men'den seilecek)\n" .
"  -h     : Bu yardm metni\n" .
"  -v     : 'ayrnt ver' kipi\n" .
"  -s     : Desteklenen dilleri listele ve k\n" .
"  -r     : Btn ayarlar sil\n" .
"  -N     : Baka bir set-language-env sreci altrma (i kullanma ynelik)\n" .
"  -c     : Anadil karakter setini kullanma (i kullanma ynelik)\n" .
"  -C     : Anadil karakter ortamn kullan (i kullanma ynelik)\n" .
"  -E     : Ayarlar /etc/skel dizinde yap (sadece root iin)\n" ,

"Install the following locales.\n" =>
"Asagidaki yerelleri kurmalisiniz.\n\000" .
"Aadaki yerelleri kurmalsnz.\n" ,

"(Edit /etc/locale.gen and invoke locale-gen)\n" =>
"(/etc/locale.gen dosyasini duzenleyin ve locale-gen'i calistirin)\n\000" .
"(/etc/locale.gen dosyasn dzenleyin ve locale-gen'i altrn)\n" ,

"" =>
"\000" .
""

);

# ---------------------------------------------------
# These variables describe which characters to be used
# for user input to express 'yes' and 'no' in native 
# language.
# ---------------------------------------------------
$yes_upper = "E";
$yes_lower = "e";
$no_upper = "H";
$no_lower = "h";

# ---------------------------------------------------
# The needed locales.
# ---------------------------------------------------
$need_locale = 'tr_TR.ISO-8859-9(tr_TR.ISO-8859-9!ISO-8859-9) tr_TR.UTF-8(tr_TR.UTF-8!UTF-8)';
