/*
* Copyright 2012
* Iván Eixarch <ivan@sinanimodelucro.org>
* https://github.com/joker-x/languages4translatewiki
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
* MA 02110-1301, USA.
*/

;(function(exports){

/* PRIVATE */

//embed object json
//no accesible directly, you must use isValid, getAllLanguageCode or getLanguageInfo
var langs = {
"attribute":{"nativeName":0},
"rtl":["ar","dv","fa","ha","he","ks","ku","ps","ur","yi"],
"lang":{
"sxu":["Säggssch"],
"rtm":["Faeag Rotuma"],
"wls":["Faka'uvea"],
"twd":["Tweants"],
"trp":["Kokborok (Tripuri)"],
"pko":["Pökoot"],
"pru":["Prūsiskan"],
"test":["Test (site admin only)"],
"swb":["Shikomoro"],
"njo":["Ao"],
"mni":["মেইতেই লোন্"],
"ttt":["Tati"],
"yrl":["ñe'engatú"],
"krl":["Karjala"],
"mwv":["Behase Mentawei"],
"niu":["ko e vagahau Niuē"],
"bew":["Bahasa Betawi"],
"rw":["Kinyarwanda"],
"slr":["Salırça"],
"ryu":["ʔucināguci"],
"gom":["कोंकणी/Konknni "],
"gom-deva":["कोंकणी"],
"gom-latn":["Konknni"],
"akz":["Albaamo innaaɬiilka"],
"kgp":["Kaingáng"],
"hu-formal":["Magyar (magázó)"],
"kea":["Kabuverdianu"],
"ady":["Адыгэбзэ / Adygabze"],
"ady-cyrl":["Адыгэбзэ"],
"tsd":["Τσακωνικά"],
"arq":["Dziri"],
"gcf":["Guadeloupean Creole French"],
"lld":["Ladin"],
"ruq-grek":["Megleno-Romanian (Greek script)"],
"ydd":["Eastern Yiddish"],
"tzm":["ⵜⴰⵎⴰⵣⵉⵖⵜ"],
"bto":["Iriga Bicolano"],
"rap":["arero rapa nui"],
"bfq":["படகா"],
"guc":["Wayúu"],
"mui":["Musi"],
"kbd-latn":["Qabardjajəbza"],
"ase":["American sign language"],
"es-419":["español de America Latina"],
"mnc":["ᠮᠠᠨᠵᡠ ᡤᡳᠰᡠᠨ"],
"aro":["Araona"],
"hif-deva":["फ़ीजी हिन्दी"],
"gah":["Alekano"],
"rki":["ရခိုင်"],
"es-formal":["español (formal)"],
"nqo":["ߒߞߏ"],
"gbz":["Dari"],
"gur":["Gurenɛ"],
"yrk":["Ненэцяʼ вада"],
"esu":["Yup'ik"],
"saz":["ꢱꣃꢬꢵꢯ꣄ꢡ꣄ꢬꢵ"],
"hsn":["湘语"],
"yua":["Maaya T'aan"],
"tkr":["ЦӀаьхна миз"],
"aeb":["   زَوُن"],
"pis":["Pijin"],
"ppl":["Nawat"],
"shn":["လိၵ်ႈတႆး"],
"bbc":["Batak Toba/Batak autonym unknown"],
"bbc-latn":["Batak Toba"],
"mfe":["Morisyen"],
"ksf":["Bafia"],
"hne":["छत्तीसगढ़ी"],
"sly":["Bahasa Selayar"],
"ahr":["अहिराणी"],
"mic":["Mi'kmaq"],
"mnw":["ဘာသာ မန်"],
"rut":["мыхIабишды чIел"],
"acf":["Saint Lucian Creole French"],
"azb":["تورکجه"],
"izh":["ižoran keel"],
"ban":["ᬩᬲᬩᬮᬶ"],
"nl-be":["nl-be"],
"qqq":["Message documentation"],
"ike":["ᐃᓄᒃᑎᑐᑦ/inuktitut"],
"aa":["Qafár af"],
"ab":["Аҧсшәа"],
"ace":["Acèh"],
"af":["Afrikaans"],
"ak":["Akan"],
"aln":["Gegë"],
"als":["Tosk"],
"am":["አማርኛ"],
"an":["aragonés"],
"ang":["Ænglisc"],
"anp":["अङ्गिका"],
"ar":["العربية"],
"arc":["ܐܪܡܝܐ"],
"arn":["mapudungun"],
"ary":["Maġribi"],
"arz":["مصرى"],
"as":["অসমীয়া"],
"ast":["asturianu"],
"av":["авар"],
"avk":["Kotava"],
"ay":["Aymar aru"],
"az":["azərbaycanca"],
"ba":["башҡортса"],
"bar":["Boarisch"],
"bat-smg":["žemaitėška"],
"bcc":["بلوچی مکرانی"],
"bcl":["Bikol Central"],
"be":["беларуская"],
"be-tarask":["беларуская (тарашкевіца)‎"],
"be-x-old":["беларуская (тарашкевіца)‎"],
"bg":["български"],
"bh":["भोजपुरी"],
"bho":["भोजपुरी"],
"bi":["Bislama"],
"bjn":["Bahasa Banjar"],
"bm":["bamanankan"],
"bn":["বাংলা"],
"bo":["བོད་ཡིག"],
"bpy":["বিষ্ণুপ্রিয়া মণিপুরী"],
"bqi":["بختياري"],
"br":["brezhoneg"],
"brh":["Bráhuí"],
"bs":["bosanski"],
"bug":["ᨅᨔ ᨕᨘᨁᨗ"],
"bxr":["буряад"],
"ca":["català"],
"cbk-zam":["Chavacano de Zamboanga"],
"cdo":["Mìng-dĕ̤ng-ngṳ̄"],
"ce":["нохчийн"],
"ceb":["Cebuano"],
"ch":["Chamoru"],
"cho":["Choctaw"],
"chr":["ᏣᎳᎩ"],
"chy":["Tsetsêhestâhese"],
"ckb":["کوردی"],
"co":["corsu"],
"cps":["Capiceño"],
"cr":["Nēhiyawēwin / ᓀᐦᐃᔭᐍᐏᐣ"],
"crh":["qırımtatarca"],
"crh-latn":["qırımtatarca (Latin)‎"],
"crh-cyrl":["къырымтатарджа (Кирилл)‎"],
"cs":["česky"],
"csb":["kaszëbsczi"],
"cu":["словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ"],
"cv":["Чӑвашла"],
"cy":["Cymraeg"],
"da":["dansk"],
"de":["Deutsch"],
"de-at":["Österreichisches Deutsch"],
"de-ch":["Schweizer Hochdeutsch"],
"de-formal":["Deutsch (Sie-Form)‎"],
"diq":["Zazaki"],
"dsb":["dolnoserbski"],
"dtp":["Dusun Bundu-liwan"],
"dv":["ދިވެހިބަސް"],
"dz":["ཇོང་ཁ"],
"ee":["eʋegbe"],
"egl":["Emiliàn"],
"el":["Ελληνικά"],
"eml":["emiliàn e rumagnòl"],
"en":["English"],
"en-ca":["Canadian English"],
"en-gb":["British English"],
"eo":["Esperanto"],
"es":["español"],
"et":["eesti"],
"eu":["euskara"],
"ext":["estremeñu"],
"fa":["فارسی"],
"ff":["Fulfulde"],
"fi":["suomi"],
"fit":["meänkieli"],
"fiu-vro":["Võro"],
"fj":["Na Vosa Vakaviti"],
"fo":["føroyskt"],
"fr":["français"],
"frc":["français cadien"],
"frp":["arpetan"],
"frr":["Nordfriisk"],
"fur":["furlan"],
"fy":["Frysk"],
"ga":["Gaeilge"],
"gag":["Gagauz"],
"gan":["贛語"],
"gan-hans":["赣语（简体）‎"],
"gan-hant":["贛語（繁體）‎"],
"gd":["Gàidhlig"],
"gl":["galego"],
"glk":["گیلکی"],
"gn":["Avañe'ẽ"],
"got":["Gothic"],
"grc":["Ἀρχαία ἑλληνικὴ"],
"gsw":["Alemannisch"],
"gu":["ગુજરાતી"],
"gv":["Gaelg"],
"ha":["Hausa"],
"hak":["Hak-kâ-fa"],
"haw":["Hawai`i"],
"he":["עברית"],
"hi":["हिन्दी"],
"hif":["Fiji Hindi"],
"hif-latn":["Fiji Hindi"],
"hil":["Ilonggo"],
"ho":["Hiri Motu"],
"hr":["hrvatski"],
"hsb":["hornjoserbsce"],
"ht":["Kreyòl ayisyen"],
"hu":["magyar"],
"hy":["Հայերեն"],
"hz":["Otsiherero"],
"ia":["interlingua"],
"id":["Bahasa Indonesia"],
"ie":["Interlingue"],
"ig":["Igbo"],
"ii":["ꆇꉙ"],
"ik":["Iñupiak"],
"ike-cans":["ᐃᓄᒃᑎᑐᑦ"],
"ike-latn":["inuktitut"],
"ilo":["Ilokano"],
"inh":["ГӀалгӀай"],
"io":["Ido"],
"is":["íslenska"],
"it":["italiano"],
"iu":["ᐃᓄᒃᑎᑐᑦ/inuktitut"],
"ja":["日本語"],
"jam":["Patois"],
"jbo":["Lojban"],
"jut":["jysk"],
"jv":["Basa Jawa"],
"ka":["ქართული"],
"kaa":["Qaraqalpaqsha"],
"kab":["Taqbaylit"],
"kbd":["Адыгэбзэ"],
"kbd-cyrl":["Адыгэбзэ"],
"kg":["Kongo"],
"khw":["کھوار"],
"ki":["Gĩkũyũ"],
"kiu":["Kırmancki"],
"kj":["Kwanyama"],
"kk":["қазақша"],
"kk-arab":["قازاقشا (تٴوتە)‏"],
"kk-cyrl":["қазақша (кирил)‎"],
"kk-latn":["qazaqşa (latın)‎"],
"kk-cn":["قازاقشا (جۇنگو)‏"],
"kk-kz":["қазақша (Қазақстан)‎"],
"kk-tr":["qazaqşa (Türkïya)‎"],
"kl":["kalaallisut"],
"km":["ភាសាខ្មែរ"],
"kn":["ಕನ್ನಡ"],
"ko":["한국어"],
"ko-kp":["한국어 (조선)"],
"koi":["Перем Коми"],
"kr":["Kanuri"],
"krc":["къарачай-малкъар"],
"kri":["Krio"],
"krj":["Kinaray-a"],
"ks":["कॉशुर / کٲشُر"],
"ks-arab":["کٲشُر"],
"ks-deva":["कॉशुर"],
"ksh":["Ripoarisch"],
"ku":["Kurdî"],
"ku-latn":["Kurdî (latînî)‎"],
"ku-arab":["كوردي (عەرەبی)‏"],
"kv":["коми"],
"kw":["kernowek"],
"ky":["Кыргызча"],
"la":["Latina"],
"lad":["Ladino"],
"lb":["Lëtzebuergesch"],
"lbe":["лакку"],
"lez":["лезги"],
"lfn":["Lingua Franca Nova"],
"lg":["Luganda"],
"li":["Limburgs"],
"lij":["Ligure"],
"liv":["Līvõ kēļ"],
"lmo":["lumbaart"],
"ln":["lingála"],
"lo":["ລາວ"],
"loz":["Silozi"],
"lt":["lietuvių"],
"ltg":["latgaļu"],
"lus":["Mizo ţawng"],
"lv":["latviešu"],
"lzh":["文言"],
"lzz":["Lazuri"],
"mai":["मैथिली"],
"map-bms":["Basa Banyumasan"],
"mdf":["мокшень"],
"mg":["Malagasy"],
"mh":["Ebon"],
"mhr":["олык марий"],
"mi":["Māori"],
"min":["Baso Minangkabau"],
"mk":["македонски"],
"ml":["മലയാളം"],
"mn":["монгол"],
"mo":["молдовеняскэ"],
"mr":["मराठी"],
"mrj":["кырык мары"],
"ms":["Bahasa Melayu"],
"mt":["Malti"],
"mus":["Mvskoke"],
"mwl":["Mirandés"],
"my":["မြန်မာဘာသာ"],
"myv":["эрзянь"],
"mzn":["مازِرونی"],
"na":["Dorerin Naoero"],
"nah":["Nāhuatl"],
"nan":["Bân-lâm-gú"],
"nap":["Nnapulitano"],
"nb":["norsk (bokmål)‎"],
"nds":["Plattdüütsch"],
"nds-nl":["Nedersaksies"],
"ne":["नेपाली"],
"new":["नेपाल भाषा"],
"ng":["Oshiwambo"],
"nl":["Nederlands"],
"nl-informal":["Nederlands (informeel)‎"],
"nn":["norsk (nynorsk)‎"],
"no":["norsk (bokmål)‎"],
"nov":["Novial"],
"nrm":["Nouormand"],
"nso":["Sesotho sa Leboa"],
"nv":["Diné bizaad"],
"ny":["Chi-Chewa"],
"oc":["occitan"],
"om":["Oromoo"],
"or":["ଓଡ଼ିଆ"],
"os":["Ирон"],
"pa":["ਪੰਜਾਬੀ"],
"pag":["Pangasinan"],
"pam":["Kapampangan"],
"pap":["Papiamentu"],
"pcd":["Picard"],
"pdc":["Deitsch"],
"pdt":["Plautdietsch"],
"pfl":["Pälzisch"],
"pi":["पाळि"],
"pih":["Norfuk / Pitkern"],
"pl":["polski"],
"pms":["Piemontèis"],
"pnb":["پنجابی"],
"pnt":["Ποντιακά"],
"prg":["Prūsiskan"],
"ps":["پښتو"],
"pt":["português"],
"pt-br":["português do Brasil"],
"qu":["Runa Simi"],
"qug":["Runa shimi"],
"rgn":["Rumagnôl"],
"rif":["Tarifit"],
"rm":["rumantsch"],
"rmy":["Romani"],
"rn":["Kirundi"],
"ro":["română"],
"roa-rup":["Armãneashce"],
"roa-tara":["tarandíne"],
"ru":["русский"],
"rue":["русиньскый"],
"rup":["Armãneashce"],
"ruq":["Vlăheşte"],
"ruq-cyrl":["Влахесте"],
"ruq-latn":["Vlăheşte"],
"sa":["संस्कृतम्"],
"sah":["саха тыла"],
"sat":["Santali"],
"sc":["sardu"],
"scn":["sicilianu"],
"sco":["Scots"],
"sd":["سنڌي"],
"sdc":["Sassaresu"],
"se":["sámegiella"],
"sei":["Cmique Itom"],
"sg":["Sängö"],
"sgs":["žemaitėška"],
"sh":["srpskohrvatski / српскохрватски"],
"shi":["Tašlḥiyt/ⵜⴰⵛⵍⵃⵉⵜ"],
"shi-tfng":["ⵜⴰⵛⵍⵃⵉⵜ"],
"shi-latn":["Tašlḥiyt"],
"si":["සිංහල"],
"simple":["Simple English"],
"sk":["slovenčina"],
"sl":["slovenščina"],
"sli":["Schläsch"],
"sm":["Gagana Samoa"],
"sma":["Åarjelsaemien"],
"sn":["chiShona"],
"so":["Soomaaliga"],
"sq":["shqip"],
"sr":["српски / srpski"],
"sr-ec":["српски (ћирилица)‎"],
"sr-el":["srpski (latinica)‎"],
"srn":["Sranantongo"],
"ss":["SiSwati"],
"st":["Sesotho"],
"stq":["Seeltersk"],
"su":["Basa Sunda"],
"sv":["svenska"],
"sw":["Kiswahili"],
"szl":["ślůnski"],
"ta":["தமிழ்"],
"tcy":["ತುಳು"],
"te":["తెలుగు"],
"tet":["tetun"],
"tg":["тоҷикӣ"],
"tg-cyrl":["тоҷикӣ"],
"tg-latn":["tojikī"],
"th":["ไทย"],
"ti":["ትግርኛ"],
"tk":["Türkmençe"],
"tl":["Tagalog"],
"tly":["толышә зывон"],
"tn":["Setswana"],
"to":["lea faka-Tonga"],
"tokipona":["Toki Pona"],
"tpi":["Tok Pisin"],
"tr":["Türkçe"],
"tru":["Ṫuroyo"],
"ts":["Xitsonga"],
"tt":["татарча/tatarça"],
"tt-cyrl":["татарча"],
"tt-latn":["tatarça"],
"tum":["chiTumbuka"],
"tw":["Twi"],
"ty":["Reo Mā`ohi"],
"tyv":["тыва дыл"],
"udm":["удмурт"],
"ug":["ئۇيغۇرچە / Uyghurche"],
"ug-arab":["ئۇيغۇرچە"],
"ug-latn":["Uyghurche"],
"uk":["українська"],
"ur":["اردو"],
"uz":["oʻzbekcha"],
"ve":["Tshivenda"],
"vec":["vèneto"],
"vep":["vepsän kel’"],
"vi":["Tiếng Việt"],
"vls":["West-Vlams"],
"vmf":["Mainfränkisch"],
"vo":["Volapük"],
"vot":["Vaďďa"],
"vro":["Võro"],
"wa":["walon"],
"war":["Winaray"],
"wo":["Wolof"],
"wuu":["吴语"],
"xal":["хальмг"],
"xh":["isiXhosa"],
"xmf":["მარგალური"],
"yi":["ייִדיש"],
"yo":["Yorùbá"],
"yue":["粵語"],
"za":["Vahcuengh"],
"zea":["Zeêuws"],
"zh":["中文"],
"zh-classical":["文言"],
"zh-cn":["中文（中国大陆）‎"],
"zh-hans":["中文（简体）‎"],
"zh-hant":["中文（繁體）‎"],
"zh-hk":["中文（香港）‎"],
"zh-min-nan":["Bân-lâm-gú"],
"zh-mo":["中文（澳門）‎"],
"zh-my":["中文（马来西亚）‎"],
"zh-sg":["中文（新加坡）‎"],
"zh-tw":["中文（台灣）‎"],
"zh-yue":["粵語"],
"zu":["isiZulu"]}
}
//return string "ltr" if the language is written from left to right or "rtl" in other case
var getLangDirection = function(langcode) {
  var result = "ltr";
  if (langs.rtl.indexOf(langcode) != -1) result = "rtl";
  return result;
};

/* PUBLIC */

//return boolean value, true if langcode is supported
exports.isValid = function(langcode) {
  return langs.lang.hasOwnProperty(langcode);
};

//return array with all the language codes supported
exports.getAllLanguageCode = function() {
  var result = [];
  for (langcode in langs.lang) {
    result.push(langcode);
  }
  return result;
};

//return object {"nativeName", "direction"}
//if langcode isn't supported return {}
exports.getLanguageInfo = function(langcode) {
  var result = {};
  if (exports.isValid(langcode)) {
    var lang = langs.lang[langcode];
    for (attr in langs['attribute']) {
      result[attr] = lang[langs['attribute'][attr]];
    }
    result['direction']=getLangDirection(langcode);
  }
  return result;
};

//allow executing by nodejs in the server or by javascript in the browser
})(typeof exports === 'undefined'? this['languages']={}: exports);
