/** \mainpage langupdate

langupdate is a frontend for the Emdebian implementation of 'tdebs' - a
method for splitting translation files out of packages and into a separate
repository, organised by language and program, allowing individual users to
only install translations files for the locales supported on their own
machine.

\section disc Disc space is not cheap

Debian packages collate all available translations
into a single package which can easily lead to 250Mb of unused translation files
on a typical installation. Emdebian generates a single package for every translation
of each Emdebian package, leading to a tenfold increase in the number of binary
packages built from each source package. To solve this problem, langupdate 
supports a secondary apt cache so that the main apt cache can be kept as small as
possible.

langupdate then queries the secondary apt cache to get a list of all translation
packages (tdebs) that match the list of locales supported on the device. This 
list is then compared with the list of installed binaries. The translation packages
that match the installed package are then installed with apt-get.

\section language Why C and C++? 

Because there's no direct hook into apt-get upgrade and no easy 
way of reading the apt-cache from C without forking a call to apt-cache 
itself. So I use libapt-pkg which is a C++ library. The rest of the code is C 
because I prefer to use the memory management of glib2. If anyone fancies porting
langupdate to just C++ for use on devices that do not have room for libglib2.0-0,
patches are welcome.

langupdate uses a temporary file for the sources.list and updates it from the
list of supported locales each time langupdate is run, i.e. it combines the
effects of 'apt-get update' with 'apt-get upgrade'. tdeb packages have no 
dependencies so 'dist-upgrade' is not required.

*/

