/* ex: set ts=4 noet: */
/* TODO: remove date/time from debug messages; makes it impossible to use them to debug date/time functions */

#include <assert.h> /* sanity checking */
#include "types.h"

#include <stdarg.h> /* va_list */
#include <stdio.h> /* [v]snprintf */
#if defined(WIN32) && !defined(TIGER)
	#include <time.h>
#endif
#include "misc.h" /* snprintf */
#ifdef UTIL_NOSTDOUT
	#include "sock.h"
#endif
#include "debug.h"

/* on the tiger we have limited space in the serial no., this is how
 * many of the file's chars we show */
#define TIGER_DEBUG_FILE_LASTCHARS	8

/* verbose output */
#undef V
#define V(file, line, msg) do { \
		if (Verbosity >= UTIL_VERBOSE){ \
			OUTF("%s\n", msg); \
		} \
	} while (0)

/* very verbose output */
#undef VV
#define VV(file, line, msg) do { \
		if (Verbosity >= UTIL_VERY_VERBOSE){ \
			OUTF("%s\n", msg); \
		} \
	} while (0)

/* very very verbose output */
#undef VVV
#define VVV(file, line, msg) do { \
		if (Verbosity >= UTIL_VERY_VERY_VERBOSE){ \
			OUTF("%s\n", msg); \
		} \
	} while (0)

/*
 * 
 */
void DEBUGF(const char *file, unsigned int line, const char *format, ...)
{
#if defined(_DEBUG)
	va_list args;
	va_start(args, format);
	_DEBUGF(file, line, "DEBUG: ", format, args);
	va_end(args);
#endif
}

/*
 * 
 */
void PRINTF(const char *format, ...)
{
	va_list args;
	va_start(args, format);
	_PRINTF(format, args);
	va_end(args);
}

/*
 * an error has occurred
 * FIXME: make this work on tiger
 */
void ERRORF(const char *file, unsigned int line, const char *format, ...)
{
#if !defined(UTIL_NOSTDOUT)
	va_list args;

	va_start(args, format);
	_DEBUGF(file, line, "ERROR: ", format, args);
	va_end(args);
#endif
}

/*
 *
 */
void WARNF(const char *file, unsigned int line, const char *format, ...)
{
#if !defined(UTIL_NOSTDOUT)
	va_list args;

	va_start(args, format);
	_DEBUGF(file, line, "WARN: ", format, args);
	va_end(args);
#endif
}


/*
 *
 */
void FATALF(const char *file, unsigned int line, const char *format, ...)
{
#if defined(_DEBUG) && !defined(UTIL_NOSTDOUT)
	va_list args;

	va_start(args, format);
	_DEBUGF(file, line, "FATAL: ", format, args);
	va_end(args);
#endif
}

/*
 * code thought to be unreachable has in fact been reached
 */
void UNREACHABLE(const char *file, unsigned int line, const char *format, ...)
{
	va_list args;
#ifdef _DEBUG
	assert(NULL != file);
	assert(NULL != format);
#endif
	va_start(args, format);
	_DEBUGF(file, line, "*** UNREACHABLE *** ", format, args);
	va_end(args);
}

/*
 * conditions thought once to be impossible do in fact exist
 */
void IMPOSSIBLE(const char *file, unsigned int line, const char *format, ...)
{
	va_list args;
#ifdef _DEBUG
	assert(NULL != file);
	assert(NULL != format);
#endif
	va_start(args, format);
	_DEBUGF(file, line, "*** IMPOSSIBLE *** ", format, args);
	va_end(args);
}

/*
 * the programmer has forgotten to do something, not do something or passed us something invalid
 */
void PROGRAMMER_OOPS(const char *file, unsigned int line, const char *format, ...)
{
	va_list args;
#ifdef _DEBUG
	assert(NULL != file);
	assert(NULL != format);
#endif
	va_start(args, format);
	_DEBUGF(file, line, "*** PROGRAMMER OOPS *** ", format, args);
	va_end(args);
}

/*
 * underlying call all [A-Z]+F() calls make
 */
void _DEBUGF(const char *file, unsigned int line, const char *level,
	const char *format, va_list args)
{
	/* first part */
	ERRF("%s", level);
	/* second part */
	vfprintf(stderr, format, args);
	/* don't require a newline in the format we're given */
	#ifdef _DEBUG
		ERRF(" [%s:%d]\n", file, line);
	#else
		ERRF("\n");
	#endif
}

/*
 * a version of _DEBUGF that doesn't take a timestamp
 */
void _DEBUGF_NOTIME(const char *file, unsigned int line, const char *level,
	const char *format, va_list args)
{
#ifndef UTIL_NOSTDOUT
	/* first part */
	ERRF("%s", level);
	/* second part */
	vfprintf(stderr, format, args);
	/* don't require a newline in the format we're given */
	ERRF(" [%s:%d]\n", file, line);
#endif
}

/*
 * underlying call to OUTF
 */
void _PRINTF(const char *format, va_list args)
{
#ifndef UTIL_NOSTDOUT
	vfprintf(stdout, format, args);
	OUTFLUSH();
#endif
}


/*
 * util version of printf()
 */
void OUTF(const char *format, ...)
{
	va_list args;
	va_start(args, format);
#ifdef UTIL_NOSTDOUT /* no stdout or stderr */
	/* PRINTF can write to socket if possible */
	_PRINTF(format, args);
#else /* print to regular stderr */
	vfprintf(stdout, format, args);
#endif
	va_end(args);
}

/*
 * util version of fprintf(stderr, ...)
 */
void ERRF(const char *format, ...)
{
	va_list args;
	va_start(args, format);
#ifdef UTIL_NOSTDOUT /* no stdout or stderr */
	/* PRINTF can write to socket if possible */
	_PRINTF(format, args);
#else /* print to regular stderr */
	vfprintf(stderr, format, args);
#endif
	va_end(args);
}

