/* -*-C-*-

$Id: if-params.h,v 1.2 2003/01/20 20:48:34 cph Exp $

Copyright 2002 Massachusetts Institute of Technology

This file is part of laptop-net.

Laptop-net is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Laptop-net is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with laptop-net; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef IF_PARAMS_H
#define IF_PARAMS_H

#include <netinet/in.h>

struct if_params
{
  short flags;
  unsigned int addr_flags;
  struct sockaddr_in addr;
  struct sockaddr_in dstaddr;
  struct sockaddr_in broadaddr;
  struct sockaddr_in netmask;
};

#define IFP_VALID_ADDR 0x1
#define IFP_VALID_DSTADDR 0x2
#define IFP_VALID_BROADADDR 0x4
#define IFP_VALID_NETMASK 0x8
#define IFP_VALID_ALL 0xF

#define IFP_ALL_ADDRESSES_VALID(ifp)					\
  ((((ifp) -> addr_flags) & IFP_VALID_ALL) == IFP_VALID_ALL)

extern int read_interface_configuration (const char *, struct if_params *);
extern int write_interface_configuration (const char *, struct if_params *);

#endif /* not IF_PARAMS_H */
