/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.24
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifndef SWIG_TEMPLATE_DISAMBIGUATOR
#  if defined(__SUNPRO_CC) 
#    define SWIG_TEMPLATE_DISAMBIGUATOR template
#  else
#    define SWIG_TEMPLATE_DISAMBIGUATOR 
#  endif
#endif


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }



#if defined(SWIGRUBY) || defined (PHP_VERSION)
/* Ruby and PHP pollute the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <lasso/lasso_config.h>
#include <lasso/lasso.h>
#include <lasso/xml/lib_assertion.h>
#include <lasso/xml/saml_attribute_value.h>

#ifdef LASSO_WSF_ENABLED
#include <lasso/xml/disco_resource_id.h>
#include <lasso/xml/disco_encrypted_resource_id.h>
#endif



#define bool int
#define false 0
#define true 1



/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif




static void build_exception_msg(int errorCode, char *errorMsg) {
	if (errorCode > 0)
		sprintf(errorMsg, "%d / Lasso Warning: %s", errorCode, lasso_strerror(errorCode));
	else
		sprintf(errorMsg, "%d / Lasso Error: %s", errorCode, lasso_strerror(errorCode));
}




typedef struct {
void *fix;} DowncastableNode;

DowncastableNode *downcast_node(LassoNode *node) {
	return (DowncastableNode *) node;
}



#include <lasso/errors.h>



static void add_key_to_array(char *key, gpointer pointer, GPtrArray *array)
{
        g_ptr_array_add(array, g_strdup(key));
}

static void add_node_to_array(gpointer node, GPtrArray *array)
{
	if (node != NULL)
		g_object_ref(node);
        g_ptr_array_add(array, node);
}

static void add_string_to_array(char *string, GPtrArray *array)
{
	if (string != NULL)
		string = g_strdup(string);
        g_ptr_array_add(array, string);
}

static void add_xml_to_array(xmlNode *xmlnode, GPtrArray *array)
{
	xmlOutputBufferPtr buf;
	gchar *xmlString;

	buf = xmlAllocOutputBuffer(NULL);
	if (buf == NULL)
		xmlString = NULL;
	else {
		xmlNodeDumpOutput(buf, NULL, xmlnode, 0, 1, NULL);
		xmlOutputBufferFlush(buf);
		if (buf->conv == NULL)
			xmlString = g_strdup(buf->buffer->content);
		else
			xmlString = g_strdup(buf->conv->content);
		xmlOutputBufferClose(buf);
	}
	g_ptr_array_add(array, xmlString);
}

static void free_node_array_item(gpointer node, gpointer unused)
{
	if (node != NULL)
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(node))
			lasso_node_destroy(LASSO_NODE(node));
		else
			g_object_unref(node);
}

static void free_node_list_item(gpointer node, gpointer unused)
{
	if (node != NULL)
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(node))
			lasso_node_destroy(LASSO_NODE(node));
		else
			g_object_unref(node);
}

static void free_string_list_item(char *string, gpointer unused)
{
	if (string != NULL)
		g_free(string);
}

static void free_xml_list_item(xmlNode *xmlnode, gpointer unused)
{
	if (xmlnode != NULL)
		xmlFreeNode(xmlnode);
}

static gpointer get_node(gpointer node)
{
	return node == NULL ? NULL : g_object_ref(node);
}

static GPtrArray *get_node_list(GList *nodeList) {
	GPtrArray *nodeArray;

	if (nodeList == NULL)
		return NULL;
	nodeArray = g_ptr_array_sized_new(g_list_length(nodeList));
	g_list_foreach(nodeList, (GFunc) add_node_to_array, nodeArray);
	return nodeArray;
}

static GPtrArray *get_string_list(GList *stringList) {
	GPtrArray *stringArray;

	if (stringList == NULL)
		return NULL;
	stringArray = g_ptr_array_sized_new(g_list_length(stringList));
	g_list_foreach(stringList, (GFunc) add_string_to_array, stringArray);
	return stringArray;
}

static GPtrArray *get_xml_list(GList *xmlList) {
	GPtrArray *xmlArray;

	if (xmlList == NULL)
		return NULL;
	xmlArray = g_ptr_array_sized_new(g_list_length(xmlList));
	g_list_foreach(xmlList, (GFunc) add_xml_to_array, xmlArray);
	return xmlArray;
}

static char* get_xml_string(xmlNode *xmlnode)
{
	xmlOutputBufferPtr buf;
	char *xmlString;

	if (xmlnode == NULL) {
		return NULL;
	}

	buf = xmlAllocOutputBuffer(NULL);
	if (buf == NULL)
		xmlString = NULL;
	else {
		xmlNodeDumpOutput(buf, NULL, xmlnode, 0, 1, NULL);
		xmlOutputBufferFlush(buf);
		if (buf->conv == NULL)
			xmlString = g_strdup(buf->buffer->content);
		else
			xmlString = g_strdup(buf->conv->content);
		xmlOutputBufferClose(buf);
	}
	xmlFreeNode(xmlnode);
	return xmlString;
}

static xmlNode *get_string_xml(const char *string) {
	xmlDoc *doc;
	xmlNode *node;

	doc = xmlReadDoc(string, NULL, NULL, XML_PARSE_NONET);
	node = xmlDocGetRootElement(doc);
	if (node != NULL)
		node = xmlCopyNode(node, 1);
	xmlFreeDoc(doc);

	return node;
}

static void set_node(gpointer *nodePointer, gpointer value)
{
	if (*nodePointer != NULL)
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(*nodePointer))
			lasso_node_destroy(LASSO_NODE(*nodePointer));
		else
			g_object_unref(*nodePointer);
	*nodePointer = value == NULL ? NULL : g_object_ref(value);
}

static void set_node_list(GList **nodeListPointer, GPtrArray *nodeArray) {
	if (*nodeListPointer != NULL) {
		g_list_foreach(*nodeListPointer, (GFunc) free_node_list_item, NULL);
		g_list_free(*nodeListPointer);
	}
	if (nodeArray == NULL)
		*nodeListPointer = NULL;
	else {
		gpointer node;
		int index;

		for (index = 0; index < nodeArray->len; index ++) {
			node = g_ptr_array_index(nodeArray, index);
			if (node != NULL)
				g_object_ref(node);
			*nodeListPointer = g_list_append(*nodeListPointer, node);
		}
	}
}

static void set_string(char **pointer, char *value)
{
	if (*pointer != NULL)
		g_free(*pointer);
	*pointer = value == NULL ? NULL : strdup(value);
}

static void set_string_list(GList **stringListPointer, GPtrArray *stringArray) {
	if (*stringListPointer != NULL) {
		g_list_foreach(*stringListPointer, (GFunc) free_string_list_item, NULL);
		g_list_free(*stringListPointer);
	}
	if (stringArray == NULL)
		*stringListPointer = NULL;
	else {
		char *string;
		int index;

		for (index = 0; index < stringArray->len; index ++) {
			string = g_ptr_array_index(stringArray, index);
			if (string != NULL)
				string = g_strdup(string);
			*stringListPointer = g_list_append(*stringListPointer, string);
		}
	}
}

static void set_xml_list(GList **xmlListPointer, GPtrArray *xmlArray) {
	if (*xmlListPointer != NULL) {
		g_list_foreach(*xmlListPointer, (GFunc) free_xml_list_item, NULL);
		g_list_free(*xmlListPointer);
	}
	if (xmlArray == NULL)
		*xmlListPointer = NULL;
	else {
		xmlDoc *doc;
		int index;
		xmlNode *node;
		char *xmlString;

		for (index = 0; index < xmlArray->len; index ++) {
			xmlString = g_ptr_array_index(xmlArray, index);
			if (xmlString == NULL)
				node = NULL;
			else {
				doc = xmlReadDoc(g_ptr_array_index(xmlArray, index), NULL, NULL,
						 XML_PARSE_NONET);
				if (doc == NULL)
					continue;
				node = xmlDocGetRootElement(doc);
				if (node != NULL)
					node = xmlCopyNode(node, 1);
				xmlFreeDoc(doc);
			}
			*xmlListPointer = g_list_append(*xmlListPointer, node);
		}
	}
}

static void set_xml_string(xmlNode **xmlnode, const char* string)
{
	xmlDoc *doc;
	xmlNode *node;

	doc = xmlReadDoc(string, NULL, NULL, XML_PARSE_NONET);
	node = xmlDocGetRootElement(doc);
	if (node != NULL)
		node = xmlCopyNode(node, 1);
	xmlFreeDoc(doc);

	if (*xmlnode)
		xmlFreeNode(*xmlnode);

	*xmlnode = node;
}






/* Constructors, destructors & static methods implementations */

#define new_LassoNode lasso_node_new
#define delete_LassoNode lasso_node_destroy

/* Methods implementations */

#define LassoNode_dump(self) lasso_node_dump(LASSO_NODE(self))



typedef GPtrArray LassoNodeList;

static void LassoNodeList_append(LassoNodeList *self,LassoNode *item){
			if (item != NULL)
				g_object_ref(item);
			g_ptr_array_add(self, item);
		}
static void *LassoNodeList_cast(LassoNodeList *self){
			return self;
		}
static LassoNodeList *NodeList_frompointer(void *nodeArray){
			return (LassoNodeList *) nodeArray;
		}
static LassoNode *LassoNodeList_getItem(LassoNodeList *self,int index){
			LassoNode *item;

			item = g_ptr_array_index(self, index);
			if (item != NULL)
				g_object_ref(item);
			return item;
		}
static int LassoNodeList_length(LassoNodeList *self){
			return self->len;
		}
static void LassoNodeList_setItem(LassoNodeList *self,int index,LassoNode *item){
			LassoNode **itemPointer = (LassoNode **) &g_ptr_array_index(self, index);
			if (*itemPointer != NULL)
				/* Test added to help debugging. */
				if (LASSO_IS_NODE(*itemPointer))
					lasso_node_destroy(LASSO_NODE(*itemPointer));
				else
					g_object_unref(*itemPointer);
			if (item == NULL)
				*itemPointer = NULL;
			else
				*itemPointer = g_object_ref(item);
		}


/* Constructors, destructors & static methods implementations */

#define new_LassoNodeList g_ptr_array_new

void delete_LassoNodeList(GPtrArray *self) {
	g_ptr_array_foreach(self, (GFunc) free_node_array_item, NULL);
	g_ptr_array_free(self, false);
}



typedef GPtrArray LassoStringList;

static void LassoStringList_append(LassoStringList *self,char *item){
			if (item != NULL)
				item = g_strdup(item);
			g_ptr_array_add(self, item);
		}
static void *LassoStringList_cast(LassoStringList *self){
			return self;
		}
static LassoStringList *StringList_frompointer(void *stringArray){
			return (LassoStringList *) stringArray;
		}
static char *LassoStringList_getItem(LassoStringList *self,int index){
			return g_ptr_array_index(self, index);
		}
static int LassoStringList_length(LassoStringList *self){
			return self->len;
		}
static void LassoStringList_setItem(LassoStringList *self,int index,char *item){
			char **itemPointer = (char **) &g_ptr_array_index(self, index);
			if (*itemPointer != NULL)
				g_free(*itemPointer);
			if (item == NULL)
				*itemPointer = NULL;
			else
				*itemPointer = g_strdup(item);
		}


/* Constructors, destructors & static methods implementations */

#define new_LassoStringList g_ptr_array_new
#define delete_LassoStringList(self) g_ptr_array_free(self, true)




/* Attributes implementations */
/* Assertion */
#define LassoSamlAdvice_get_Assertion(self) get_node((self)->Assertion)
#define LassoSamlAdvice_Assertion_get(self) get_node((self)->Assertion)
#define LassoSamlAdvice_set_Assertion(self, value) set_node((gpointer *) &(self)->Assertion, (value))
#define LassoSamlAdvice_Assertion_set(self, value) set_node((gpointer *) &(self)->Assertion, (value))

/* assertionIdReference */
#define LassoSamlAdvice_get_assertionIdReference(self) get_string_list((self)->AssertionIDReference)
#define LassoSamlAdvice_assertionIdReference_get(self) get_string_list((self)->AssertionIDReference)
#define LassoSamlAdvice_set_assertionIdReference(self, value) set_string_list(&(self)->AssertionIDReference, (value))
#define LassoSamlAdvice_assertionIdReference_set(self, value) set_string_list(&(self)->AssertionIDReference, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAdvice lasso_saml_advice_new
#define delete_LassoSamlAdvice(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAdvice_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* Advice */
#define LassoSamlAssertion_get_Advice(self) get_node((self)->Advice)
#define LassoSamlAssertion_Advice_get(self) get_node((self)->Advice)
#define LassoSamlAssertion_set_Advice(self, value) set_node((gpointer *) &(self)->Advice, (value))
#define LassoSamlAssertion_Advice_set(self, value) set_node((gpointer *) &(self)->Advice, (value))

/* AttributeStatement */
#define LassoSamlAssertion_get_AttributeStatement(self) get_node((self)->AttributeStatement)
#define LassoSamlAssertion_AttributeStatement_get(self) get_node((self)->AttributeStatement)
#define LassoSamlAssertion_set_AttributeStatement(self, value) set_node((gpointer *) &(self)->AttributeStatement, (value))
#define LassoSamlAssertion_AttributeStatement_set(self, value) set_node((gpointer *) &(self)->AttributeStatement, (value))

/* AuthenticationStatement */
#define LassoSamlAssertion_get_AuthenticationStatement(self) get_node((self)->AuthenticationStatement)
#define LassoSamlAssertion_AuthenticationStatement_get(self) get_node((self)->AuthenticationStatement)
#define LassoSamlAssertion_set_AuthenticationStatement(self, value) set_node((gpointer *) &(self)->AuthenticationStatement, (value))
#define LassoSamlAssertion_AuthenticationStatement_set(self, value) set_node((gpointer *) &(self)->AuthenticationStatement, (value))

/* Conditions */
#define LassoSamlAssertion_get_Conditions(self) get_node((self)->Conditions)
#define LassoSamlAssertion_Conditions_get(self) get_node((self)->Conditions)
#define LassoSamlAssertion_set_Conditions(self, value) set_node((gpointer *) &(self)->Conditions, (value))
#define LassoSamlAssertion_Conditions_set(self, value) set_node((gpointer *) &(self)->Conditions, (value))

/* SubjectStatement */
#define LassoSamlAssertion_get_SubjectStatement(self) get_node((self)->SubjectStatement)
#define LassoSamlAssertion_SubjectStatement_get(self) get_node((self)->SubjectStatement)
#define LassoSamlAssertion_set_SubjectStatement(self, value) set_node((gpointer *) &(self)->SubjectStatement, (value))
#define LassoSamlAssertion_SubjectStatement_set(self, value) set_node((gpointer *) &(self)->SubjectStatement, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAssertion lasso_saml_assertion_new
#define delete_LassoSamlAssertion(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAssertion_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlAttributeDesignator */

/* AttributeName */
#define LassoSamlAttribute_get_AttributeName(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName
#define LassoSamlAttribute_AttributeName_get(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName
#define LassoSamlAttribute_set_AttributeName(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName, (value))
#define LassoSamlAttribute_AttributeName_set(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName, (value))

/* AttributeNamespace */
#define LassoSamlAttribute_get_AttributeNamespace(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace
#define LassoSamlAttribute_AttributeNamespace_get(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace
#define LassoSamlAttribute_set_AttributeNamespace(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace, (value))
#define LassoSamlAttribute_AttributeNamespace_set(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace, (value))

/* Attributes implementations */

/* AttributeValue */
#define LassoSamlAttribute_get_AttributeValue(self) get_node_list((self)->AttributeValue)
#define LassoSamlAttribute_AttributeValue_get(self) get_node_list((self)->AttributeValue)
#define LassoSamlAttribute_set_AttributeValue(self, value) set_node_list(&(self)->AttributeValue, (value))
#define LassoSamlAttribute_AttributeValue_set(self, value) set_node_list(&(self)->AttributeValue, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttribute lasso_saml_attribute_new
#define delete_LassoSamlAttribute(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttribute_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeDesignator lasso_saml_attribute_designator_new
#define delete_LassoSamlAttributeDesignator(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeDesignator_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlSubjectStatementAbstract */

/* Subject */
#define LassoSamlAttributeStatement_get_Subject(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlAttributeStatement_Subject_get(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlAttributeStatement_set_Subject(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))
#define LassoSamlAttributeStatement_Subject_set(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))

/* Attributes Implementations */

/* Attribute */
#define LassoSamlAttributeStatement_get_Attribute(self) get_node_list((self)->Attribute)
#define LassoSamlAttributeStatement_Attribute_get(self) get_node_list((self)->Attribute)
#define LassoSamlAttributeStatement_set_Attribute(self, value) set_node_list(&(self)->Attribute, (value))
#define LassoSamlAttributeStatement_Attribute_set(self, value) set_node_list(&(self)->Attribute, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeStatement lasso_saml_attribute_statement_new
#define delete_LassoSamlAttributeStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* any */
#define LassoSamlAttributeValue_get_any(self) get_node_list((self)->any)
#define LassoSamlAttributeValue_any_get(self) get_node_list((self)->any)
#define LassoSamlAttributeValue_set_any(self, value) set_node_list(&(self)->any, (value))
#define LassoSamlAttributeValue_any_set(self, value) set_node_list(&(self)->any, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeValue lasso_saml_attribute_value_new
#define delete_LassoSamlAttributeValue(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeValue_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* audience */
#define LassoSamlAudienceRestrictionCondition_get_audience(self) get_string_list((self)->Audience)
#define LassoSamlAudienceRestrictionCondition_audience_get(self) get_string_list((self)->Audience)
#define LassoSamlAudienceRestrictionCondition_set_audience(self, value) set_string_list(&(self)->Audience, (value))
#define LassoSamlAudienceRestrictionCondition_audience_set(self, value) set_string_list(&(self)->Audience, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAudienceRestrictionCondition lasso_saml_audience_restriction_condition_new
#define delete_LassoSamlAudienceRestrictionCondition(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAudienceRestrictionCondition_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* AuthorityBinding */
#define LassoSamlAuthenticationStatement_get_AuthorityBinding(self) get_node_list((self)->AuthorityBinding)
#define LassoSamlAuthenticationStatement_AuthorityBinding_get(self) get_node_list((self)->AuthorityBinding)
#define LassoSamlAuthenticationStatement_set_AuthorityBinding(self, value) set_node_list(&(self)->AuthorityBinding, (value))
#define LassoSamlAuthenticationStatement_AuthorityBinding_set(self, value) set_node_list(&(self)->AuthorityBinding, (value))

/* SubjectLocality */
#define LassoSamlAuthenticationStatement_get_SubjectLocality(self) get_node((self)->SubjectLocality)
#define LassoSamlAuthenticationStatement_SubjectLocality_get(self) get_node((self)->SubjectLocality)
#define LassoSamlAuthenticationStatement_set_SubjectLocality(self, value) set_node((gpointer *) &(self)->SubjectLocality, (value))
#define LassoSamlAuthenticationStatement_SubjectLocality_set(self, value) set_node((gpointer *) &(self)->SubjectLocality, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAuthenticationStatement lasso_saml_authentication_statement_new
#define delete_LassoSamlAuthenticationStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAuthenticationStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAuthorityBinding lasso_saml_authority_binding_new
#define delete_LassoSamlAuthorityBinding(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAuthorityBinding_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlConditionAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* AudienceRestrictionCondition */
#define LassoSamlConditions_get_AudienceRestrictionCondition(self) get_node_list((self)->AudienceRestrictionCondition)
#define LassoSamlConditions_AudienceRestrictionCondition_get(self) get_node_list((self)->AudienceRestrictionCondition)
#define LassoSamlConditions_set_AudienceRestrictionCondition(self, value) set_node_list(&(self)->AudienceRestrictionCondition, (value))
#define LassoSamlConditions_AudienceRestrictionCondition_set(self, value) set_node_list(&(self)->AudienceRestrictionCondition, (value))

/* Condition */
#define LassoSamlConditions_get_Condition(self) get_node_list((self)->Condition)
#define LassoSamlConditions_Condition_get(self) get_node_list((self)->Condition)
#define LassoSamlConditions_set_Condition(self, value) set_node_list(&(self)->Condition, (value))
#define LassoSamlConditions_Condition_set(self, value) set_node_list(&(self)->Condition, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlConditions lasso_saml_conditions_new
#define delete_LassoSamlConditions(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlConditions_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlNameIdentifier lasso_saml_name_identifier_new
#define delete_LassoSamlNameIdentifier(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlNameIdentifier_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlStatementAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* NameIdentifier */
#define LassoSamlSubject_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoSamlSubject_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoSamlSubject_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoSamlSubject_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* SubjectConfirmation */
#define LassoSamlSubject_get_SubjectConfirmation(self) get_node((self)->SubjectConfirmation)
#define LassoSamlSubject_SubjectConfirmation_get(self) get_node((self)->SubjectConfirmation)
#define LassoSamlSubject_set_SubjectConfirmation(self, value) set_node((gpointer *) &(self)->SubjectConfirmation, (value))
#define LassoSamlSubject_SubjectConfirmation_set(self, value) set_node((gpointer *) &(self)->SubjectConfirmation, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubject lasso_saml_subject_new
#define delete_LassoSamlSubject(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubject_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* confirmationMethod */
#define LassoSamlSubjectConfirmation_get_confirmationMethod(self) get_string_list((self)->ConfirmationMethod)
#define LassoSamlSubjectConfirmation_confirmationMethod_get(self) get_string_list((self)->ConfirmationMethod)
#define LassoSamlSubjectConfirmation_set_confirmationMethod(self, value) set_string_list(&(self)->ConfirmationMethod, (value))
#define LassoSamlSubjectConfirmation_confirmationMethod_set(self, value) set_string_list(&(self)->ConfirmationMethod, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectConfirmation lasso_saml_subject_confirmation_new
#define delete_LassoSamlSubjectConfirmation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectConfirmation_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectLocality lasso_saml_subject_locality_new
#define delete_LassoSamlSubjectLocality(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectLocality_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlSubjectStatementAbstract */

/* Subject */
#define LassoSamlSubjectStatement_get_Subject(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlSubjectStatement_Subject_get(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlSubjectStatement_set_Subject(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))
#define LassoSamlSubjectStatement_Subject_set(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectStatement lasso_saml_subject_statement_new
#define delete_LassoSamlSubjectStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* Subject */
#define LassoSamlSubjectStatementAbstract_get_Subject(self) get_node((self)->Subject)
#define LassoSamlSubjectStatementAbstract_Subject_get(self) get_node((self)->Subject)
#define LassoSamlSubjectStatementAbstract_set_Subject(self, value) set_node((gpointer *) &(self)->Subject, (value))
#define LassoSamlSubjectStatementAbstract_Subject_set(self, value) set_node((gpointer *) &(self)->Subject, (value))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectStatementAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoSamlpRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoSamlpRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoSamlpRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoSamlpRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoSamlpRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlpRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlpRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlpRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoSamlpRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoSamlpRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoSamlpRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoSamlpRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoSamlpRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoSamlpRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoSamlpRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoSamlpRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoSamlpRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoSamlpRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoSamlpRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoSamlpRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoSamlpRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoSamlpRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoSamlpRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoSamlpRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoSamlpRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoSamlpRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoSamlpRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoSamlpRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoSamlpRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoSamlpRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoSamlpRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoSamlpRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoSamlpRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoSamlpRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoSamlpRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoSamlpRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpRequest lasso_samlp_request_new
#define delete_LassoSamlpRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* RespondWith */
#define LassoSamlpRequestAbstract_get_RespondWith(self) get_string_list((self)->RespondWith)
#define LassoSamlpRequestAbstract_RespondWith_get(self) get_string_list((self)->RespondWith)
#define LassoSamlpRequestAbstract_set_RespondWith(self, value) set_string_list(&(self)->RespondWith, (value))
#define LassoSamlpRequestAbstract_RespondWith_set(self, value) set_string_list(&(self)->RespondWith, (value))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpRequestAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpResponseAbstract */

/* certificate_file */
#define LassoSamlpResponse_get_certificate_file(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file
#define LassoSamlpResponse_certificate_file_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file
#define LassoSamlpResponse_set_certificate_file(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file, (value))
#define LassoSamlpResponse_certificate_file_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file, (value))

/* InResponseTo */
#define LassoSamlpResponse_get_InResponseTo(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo
#define LassoSamlpResponse_InResponseTo_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo
#define LassoSamlpResponse_set_InResponseTo(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo, (value))
#define LassoSamlpResponse_InResponseTo_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo, (value))

/* IssueInstant */
#define LassoSamlpResponse_get_IssueInstant(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant
#define LassoSamlpResponse_IssueInstant_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant
#define LassoSamlpResponse_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlpResponse_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoSamlpResponse_get_MajorVersion(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion
#define LassoSamlpResponse_MajorVersion_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion
#define LassoSamlpResponse_set_MajorVersion(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion = (value)
#define LassoSamlpResponse_MajorVersion_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoSamlpResponse_get_MinorVersion(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion
#define LassoSamlpResponse_MinorVersion_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion
#define LassoSamlpResponse_set_MinorVersion(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion = (value)
#define LassoSamlpResponse_MinorVersion_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoSamlpResponse_get_private_key_file(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file
#define LassoSamlpResponse_private_key_file_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file
#define LassoSamlpResponse_set_private_key_file(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file, (value))
#define LassoSamlpResponse_private_key_file_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file, (value))

/* Recipient */
#define LassoSamlpResponse_get_Recipient(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient
#define LassoSamlpResponse_Recipient_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient
#define LassoSamlpResponse_set_Recipient(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient, (value))
#define LassoSamlpResponse_Recipient_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient, (value))

/* ResponseID */
#define LassoSamlpResponse_get_ResponseID(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID
#define LassoSamlpResponse_ResponseID_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID
#define LassoSamlpResponse_set_ResponseID(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID, (value))
#define LassoSamlpResponse_ResponseID_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID, (value))

/* sign_method */
#define LassoSamlpResponse_get_sign_method(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method
#define LassoSamlpResponse_sign_method_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method
#define LassoSamlpResponse_set_sign_method(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method = (value)
#define LassoSamlpResponse_sign_method_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoSamlpResponse_get_sign_type(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type
#define LassoSamlpResponse_sign_type_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type
#define LassoSamlpResponse_set_sign_type(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type = (value)
#define LassoSamlpResponse_sign_type_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type = (value)

/* Attributes Implementations */

/* Assertion */
#define LassoSamlpResponse_get_Assertion(self) get_node_list((self)->Assertion)
#define LassoSamlpResponse_Assertion_get(self) get_node_list((self)->Assertion)
#define LassoSamlpResponse_set_Assertion(self, value) set_node_list(&(self)->Assertion, (value))
#define LassoSamlpResponse_Assertion_set(self, value) set_node_list(&(self)->Assertion, (value))

/* Status */
#define LassoSamlpResponse_get_Status(self) get_node((self)->Status)
#define LassoSamlpResponse_Status_get(self) get_node((self)->Status)
#define LassoSamlpResponse_set_Status(self, value) set_node((gpointer *) &(self)->Status, (value))
#define LassoSamlpResponse_Status_set(self, value) set_node((gpointer *) &(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpResponse lasso_samlp_response_new
#define delete_LassoSamlpResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlpResponseAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* StatusCode */
#define LassoSamlpStatus_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlpStatus_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlpStatus_set_StatusCode(self, value) set_node((gpointer *) &(self)->StatusCode, (value))
#define LassoSamlpStatus_StatusCode_set(self, value) set_node((gpointer *) &(self)->StatusCode, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpStatus lasso_samlp_status_new
#define delete_LassoSamlpStatus(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpStatus_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* StatusCode */
#define LassoSamlpStatusCode_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlpStatusCode_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlpStatusCode_set_StatusCode(self, value) set_node((gpointer *) &(self)->StatusCode, (value))
#define LassoSamlpStatusCode_StatusCode_set(self, value) set_node((gpointer *) &(self)->StatusCode, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpStatusCode lasso_samlp_status_code_new
#define delete_LassoSamlpStatusCode(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpStatusCode_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlAssertion */

/* Advice */
#define LassoLibAssertion_get_Advice(self) get_node(LASSO_SAML_ASSERTION(self)->Advice)
#define LassoLibAssertion_Advice_get(self) get_node(LASSO_SAML_ASSERTION(self)->Advice)
#define LassoLibAssertion_set_Advice(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Advice, (value))
#define LassoLibAssertion_Advice_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Advice, (value))

/* AssertionID */
#define LassoLibAssertion_get_AssertionID(self) LASSO_SAML_ASSERTION(self)->AssertionID
#define LassoLibAssertion_AssertionID_get(self) LASSO_SAML_ASSERTION(self)->AssertionID
#define LassoLibAssertion_set_AssertionID(self, value) set_string(&LASSO_SAML_ASSERTION(self)->AssertionID, (value))
#define LassoLibAssertion_AssertionID_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->AssertionID, (value))

/* AttributeStatement */
#define LassoLibAssertion_get_AttributeStatement(self) get_node(LASSO_SAML_ASSERTION(self)->AttributeStatement)
#define LassoLibAssertion_AttributeStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->AttributeStatement)
#define LassoLibAssertion_set_AttributeStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AttributeStatement, (value))
#define LassoLibAssertion_AttributeStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AttributeStatement, (value))

/* AuthenticationStatement */
#define LassoLibAssertion_get_AuthenticationStatement(self) get_node(LASSO_SAML_ASSERTION(self)->AuthenticationStatement)
#define LassoLibAssertion_AuthenticationStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->AuthenticationStatement)
#define LassoLibAssertion_set_AuthenticationStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AuthenticationStatement, (value))
#define LassoLibAssertion_AuthenticationStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AuthenticationStatement, (value))

/* certificate_file */
#define LassoLibAssertion_get_certificate_file(self) LASSO_SAML_ASSERTION(self)->certificate_file
#define LassoLibAssertion_certificate_file_get(self) LASSO_SAML_ASSERTION(self)->certificate_file
#define LassoLibAssertion_set_certificate_file(self, value) set_string(&LASSO_SAML_ASSERTION(self)->certificate_file, (value))
#define LassoLibAssertion_certificate_file_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->certificate_file, (value))

/* Conditions */
#define LassoLibAssertion_get_Conditions(self) get_node(LASSO_SAML_ASSERTION(self)->Conditions)
#define LassoLibAssertion_Conditions_get(self) get_node(LASSO_SAML_ASSERTION(self)->Conditions)
#define LassoLibAssertion_set_Conditions(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Conditions, (value))
#define LassoLibAssertion_Conditions_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Conditions, (value))

/* IssueInstant */
#define LassoLibAssertion_get_IssueInstant(self) LASSO_SAML_ASSERTION(self)->IssueInstant
#define LassoLibAssertion_IssueInstant_get(self) LASSO_SAML_ASSERTION(self)->IssueInstant
#define LassoLibAssertion_set_IssueInstant(self, value) set_string(&LASSO_SAML_ASSERTION(self)->IssueInstant, (value))
#define LassoLibAssertion_IssueInstant_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->IssueInstant, (value))

/* Issuer */
#define LassoLibAssertion_get_Issuer(self) LASSO_SAML_ASSERTION(self)->Issuer
#define LassoLibAssertion_Issuer_get(self) LASSO_SAML_ASSERTION(self)->Issuer
#define LassoLibAssertion_set_Issuer(self, value) set_string(&LASSO_SAML_ASSERTION(self)->Issuer, (value))
#define LassoLibAssertion_Issuer_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->Issuer, (value))

/* MajorVersion */
#define LassoLibAssertion_get_MajorVersion(self) LASSO_SAML_ASSERTION(self)->MajorVersion
#define LassoLibAssertion_MajorVersion_get(self) LASSO_SAML_ASSERTION(self)->MajorVersion
#define LassoLibAssertion_set_MajorVersion(self, value) LASSO_SAML_ASSERTION(self)->MajorVersion = (value)
#define LassoLibAssertion_MajorVersion_set(self, value) LASSO_SAML_ASSERTION(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibAssertion_get_MinorVersion(self) LASSO_SAML_ASSERTION(self)->MinorVersion
#define LassoLibAssertion_MinorVersion_get(self) LASSO_SAML_ASSERTION(self)->MinorVersion
#define LassoLibAssertion_set_MinorVersion(self, value) LASSO_SAML_ASSERTION(self)->MinorVersion = (value)
#define LassoLibAssertion_MinorVersion_set(self, value) LASSO_SAML_ASSERTION(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibAssertion_get_private_key_file(self) LASSO_SAML_ASSERTION(self)->private_key_file
#define LassoLibAssertion_private_key_file_get(self) LASSO_SAML_ASSERTION(self)->private_key_file
#define LassoLibAssertion_set_private_key_file(self, value) set_string(&LASSO_SAML_ASSERTION(self)->private_key_file, (value))
#define LassoLibAssertion_private_key_file_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->private_key_file, (value))

/* sign_method */
#define LassoLibAssertion_get_sign_method(self) LASSO_SAML_ASSERTION(self)->sign_method
#define LassoLibAssertion_sign_method_get(self) LASSO_SAML_ASSERTION(self)->sign_method
#define LassoLibAssertion_set_sign_method(self, value) LASSO_SAML_ASSERTION(self)->sign_method = (value)
#define LassoLibAssertion_sign_method_set(self, value) LASSO_SAML_ASSERTION(self)->sign_method = (value)

/* sign_type */
#define LassoLibAssertion_get_sign_type(self) LASSO_SAML_ASSERTION(self)->sign_type
#define LassoLibAssertion_sign_type_get(self) LASSO_SAML_ASSERTION(self)->sign_type
#define LassoLibAssertion_set_sign_type(self, value) LASSO_SAML_ASSERTION(self)->sign_type = (value)
#define LassoLibAssertion_sign_type_set(self, value) LASSO_SAML_ASSERTION(self)->sign_type = (value)

/* SubjectStatement */
#define LassoLibAssertion_get_SubjectStatement(self) get_node(LASSO_SAML_ASSERTION(self)->SubjectStatement)
#define LassoLibAssertion_SubjectStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->SubjectStatement)
#define LassoLibAssertion_set_SubjectStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->SubjectStatement, (value))
#define LassoLibAssertion_SubjectStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->SubjectStatement, (value))

/* Implementations of methods inherited from SamlAssertion */

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAssertion lasso_lib_assertion_new
#define delete_LassoLibAssertion(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibAssertion_newFull lasso_lib_assertion_new_full
#else
#define LibAssertion_newFull lasso_lib_assertion_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibAssertion_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibAuthnRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibAuthnRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibAuthnRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibAuthnRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibAuthnRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibAuthnRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibAuthnRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibAuthnRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibAuthnRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibAuthnRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibAuthnRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibAuthnRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibAuthnRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibAuthnRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibAuthnRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibAuthnRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibAuthnRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibAuthnRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibAuthnRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibAuthnRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibAuthnRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibAuthnRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibAuthnRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibAuthnRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibAuthnRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibAuthnRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibAuthnRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibAuthnRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibAuthnRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibAuthnRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibAuthnRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibAuthnRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibAuthnRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibAuthnRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibAuthnRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibAuthnRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes Implementations */

/* Extension */
#define LassoLibAuthnRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibAuthnRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibAuthnRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibAuthnRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* RequestAuthnContext */
#define LassoLibAuthnRequest_get_RequestAuthnContext(self) get_node((self)->RequestAuthnContext)
#define LassoLibAuthnRequest_RequestAuthnContext_get(self) get_node((self)->RequestAuthnContext)
#define LassoLibAuthnRequest_set_RequestAuthnContext(self, value) set_node((gpointer *) &(self)->RequestAuthnContext, (value))
#define LassoLibAuthnRequest_RequestAuthnContext_set(self, value) set_node((gpointer *) &(self)->RequestAuthnContext, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAuthnRequest lasso_lib_authn_request_new
#define delete_LassoLibAuthnRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibAuthnRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpResponse */

/* Extension */
#define LassoLibAuthnResponse_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibAuthnResponse_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibAuthnResponse_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibAuthnResponse_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* Status */
#define LassoLibAuthnResponse_get_Status(self) get_node(LASSO_SAMLP_RESPONSE(self)->Status)
#define LassoLibAuthnResponse_Status_get(self) get_node(LASSO_SAMLP_RESPONSE(self)->Status)
#define LassoLibAuthnResponse_set_Status(self, value) set_node((gpointer *) &LASSO_SAMLP_RESPONSE(self)->Status, (value))
#define LassoLibAuthnResponse_Status_set(self, value) set_node((gpointer *) &LASSO_SAMLP_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAuthnResponse lasso_lib_authn_response_new
#define delete_LassoLibAuthnResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibAuthnResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibFederationTerminationNotification_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibFederationTerminationNotification_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibFederationTerminationNotification_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibFederationTerminationNotification_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibFederationTerminationNotification_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibFederationTerminationNotification_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibFederationTerminationNotification_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibFederationTerminationNotification_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibFederationTerminationNotification_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibFederationTerminationNotification_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibFederationTerminationNotification_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibFederationTerminationNotification_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibFederationTerminationNotification_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibFederationTerminationNotification_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibFederationTerminationNotification_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibFederationTerminationNotification_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibFederationTerminationNotification_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibFederationTerminationNotification_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibFederationTerminationNotification_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibFederationTerminationNotification_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibFederationTerminationNotification_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibFederationTerminationNotification_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibFederationTerminationNotification_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibFederationTerminationNotification_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibFederationTerminationNotification_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibFederationTerminationNotification_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibFederationTerminationNotification_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibFederationTerminationNotification_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibFederationTerminationNotification_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibFederationTerminationNotification_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibFederationTerminationNotification_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibFederationTerminationNotification_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibFederationTerminationNotification_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibFederationTerminationNotification_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibFederationTerminationNotification_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibFederationTerminationNotification_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibFederationTerminationNotification_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibFederationTerminationNotification_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibFederationTerminationNotification_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibFederationTerminationNotification_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* NameIdentifier */
#define LassoLibFederationTerminationNotification_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoLibFederationTerminationNotification_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoLibFederationTerminationNotification_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoLibFederationTerminationNotification_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibFederationTerminationNotification lasso_lib_federation_termination_notification_new
#define delete_LassoLibFederationTerminationNotification(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibFederationTerminationNotification_newFull lasso_lib_federation_termination_notification_new_full
#else
#define LibFederationTerminationNotification_newFull lasso_lib_federation_termination_notification_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibFederationTerminationNotification_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibLogoutRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibLogoutRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibLogoutRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibLogoutRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibLogoutRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibLogoutRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibLogoutRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibLogoutRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibLogoutRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibLogoutRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibLogoutRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibLogoutRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibLogoutRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibLogoutRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibLogoutRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibLogoutRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibLogoutRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibLogoutRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibLogoutRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibLogoutRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibLogoutRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibLogoutRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibLogoutRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibLogoutRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibLogoutRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibLogoutRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibLogoutRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibLogoutRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibLogoutRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibLogoutRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibLogoutRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibLogoutRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibLogoutRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibLogoutRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibLogoutRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibLogoutRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibLogoutRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibLogoutRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibLogoutRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibLogoutRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* nameIdentifier */
#define LassoLibLogoutRequest_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoLibLogoutRequest_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoLibLogoutRequest_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoLibLogoutRequest_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibLogoutRequest lasso_lib_logout_request_new
#define delete_LassoLibLogoutRequest(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibLogoutRequest_newFull lasso_lib_logout_request_new_full
#else
#define LibLogoutRequest_newFull lasso_lib_logout_request_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibLogoutRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from LibStatusResponse */

/* Extension */
#define LassoLibLogoutResponse_get_Extension(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibLogoutResponse_Extension_get(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibLogoutResponse_set_Extension(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))
#define LassoLibLogoutResponse_Extension_set(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))

/* providerId */
#define LassoLibLogoutResponse_get_ProviderID(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibLogoutResponse_ProviderID_get(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibLogoutResponse_set_ProviderID(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))
#define LassoLibLogoutResponse_ProviderID_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))

/* RelayState */
#define LassoLibLogoutResponse_get_RelayState(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibLogoutResponse_RelayState_get(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibLogoutResponse_set_RelayState(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))
#define LassoLibLogoutResponse_RelayState_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))

/* Status */
#define LassoLibLogoutResponse_get_Status(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibLogoutResponse_Status_get(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibLogoutResponse_set_Status(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))
#define LassoLibLogoutResponse_Status_set(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibLogoutResponse lasso_lib_logout_response_new
#define delete_LassoLibLogoutResponse(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibLogoutResponse_newFull lasso_lib_logout_response_new_full
#else
#define LibLogoutResponse_newFull lasso_lib_logout_response_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibLogoutResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibRegisterNameIdentifierRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibRegisterNameIdentifierRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibRegisterNameIdentifierRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibRegisterNameIdentifierRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibRegisterNameIdentifierRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibRegisterNameIdentifierRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibRegisterNameIdentifierRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibRegisterNameIdentifierRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibRegisterNameIdentifierRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibRegisterNameIdentifierRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibRegisterNameIdentifierRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibRegisterNameIdentifierRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibRegisterNameIdentifierRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibRegisterNameIdentifierRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibRegisterNameIdentifierRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibRegisterNameIdentifierRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibRegisterNameIdentifierRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibRegisterNameIdentifierRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibRegisterNameIdentifierRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibRegisterNameIdentifierRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibRegisterNameIdentifierRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibRegisterNameIdentifierRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibRegisterNameIdentifierRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibRegisterNameIdentifierRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibRegisterNameIdentifierRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibRegisterNameIdentifierRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibRegisterNameIdentifierRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibRegisterNameIdentifierRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibRegisterNameIdentifierRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibRegisterNameIdentifierRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibRegisterNameIdentifierRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibRegisterNameIdentifierRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibRegisterNameIdentifierRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibRegisterNameIdentifierRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibRegisterNameIdentifierRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibRegisterNameIdentifierRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibRegisterNameIdentifierRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibRegisterNameIdentifierRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibRegisterNameIdentifierRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibRegisterNameIdentifierRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* idpProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_IDPProvidedNameIdentifier(self) get_node((self)->IDPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_get(self) get_node((self)->IDPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_IDPProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->IDPProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->IDPProvidedNameIdentifier, (value))

/* oldProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_OldProvidedNameIdentifier(self) get_node((self)->OldProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_get(self) get_node((self)->OldProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_OldProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->OldProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->OldProvidedNameIdentifier, (value))

/* spProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_SPProvidedNameIdentifier(self) get_node((self)->SPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_get(self) get_node((self)->SPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_SPProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->SPProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->SPProvidedNameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRegisterNameIdentifierRequest lasso_lib_register_name_identifier_request_new
#define delete_LassoLibRegisterNameIdentifierRequest(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibRegisterNameIdentifierRequest_newFull lasso_lib_register_name_identifier_request_new_full
#else
#define LibRegisterNameIdentifierRequest_newFull lasso_lib_register_name_identifier_request_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibRegisterNameIdentifierRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from LibStatusResponse */

/* Extension */
#define LassoLibRegisterNameIdentifierResponse_get_Extension(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibRegisterNameIdentifierResponse_Extension_get(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibRegisterNameIdentifierResponse_set_Extension(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))
#define LassoLibRegisterNameIdentifierResponse_Extension_set(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))

/* providerId */
#define LassoLibRegisterNameIdentifierResponse_get_ProviderID(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibRegisterNameIdentifierResponse_ProviderID_get(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibRegisterNameIdentifierResponse_set_ProviderID(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))
#define LassoLibRegisterNameIdentifierResponse_ProviderID_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))

/* RelayState */
#define LassoLibRegisterNameIdentifierResponse_get_RelayState(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibRegisterNameIdentifierResponse_RelayState_get(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibRegisterNameIdentifierResponse_set_RelayState(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))
#define LassoLibRegisterNameIdentifierResponse_RelayState_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))

/* Status */
#define LassoLibRegisterNameIdentifierResponse_get_Status(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibRegisterNameIdentifierResponse_Status_get(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibRegisterNameIdentifierResponse_set_Status(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))
#define LassoLibRegisterNameIdentifierResponse_Status_set(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRegisterNameIdentifierResponse lasso_lib_register_name_identifier_response_new
#define delete_LassoLibRegisterNameIdentifierResponse(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLibRegisterNameIdentifierResponse_newFull lasso_lib_register_name_identifier_response_new_full
#else
#define LibRegisterNameIdentifierResponse_newFull lasso_lib_register_name_identifier_response_new_full
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoLibRegisterNameIdentifierResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* authnContextClassRef */
#define LassoLibRequestAuthnContext_get_authnContextClassRef(self) get_string_list((self)->AuthnContextClassRef)
#define LassoLibRequestAuthnContext_authnContextClassRef_get(self) get_string_list((self)->AuthnContextClassRef)
#define LassoLibRequestAuthnContext_set_authnContextClassRef(self, value) set_string_list(&(self)->AuthnContextClassRef, (value))
#define LassoLibRequestAuthnContext_authnContextClassRef_set(self, value) set_string_list(&(self)->AuthnContextClassRef, (value))

/* authnContextStatementRef */
#define LassoLibRequestAuthnContext_get_authnContextStatementRef(self) get_string_list((self)->AuthnContextStatementRef)
#define LassoLibRequestAuthnContext_authnContextStatementRef_get(self) get_string_list((self)->AuthnContextStatementRef)
#define LassoLibRequestAuthnContext_set_authnContextStatementRef(self, value) set_string_list(&(self)->AuthnContextStatementRef, (value))
#define LassoLibRequestAuthnContext_authnContextStatementRef_set(self, value) set_string_list(&(self)->AuthnContextStatementRef, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRequestAuthnContext lasso_lib_request_authn_context_new
#define delete_LassoLibRequestAuthnContext(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibRequestAuthnContext_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* Extension */
#define LassoLibStatusResponse_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibStatusResponse_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibStatusResponse_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibStatusResponse_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* Status */
#define LassoLibStatusResponse_get_Status(self) get_node((self)->Status)
#define LassoLibStatusResponse_Status_get(self) get_node((self)->Status)
#define LassoLibStatusResponse_set_Status(self, value) set_node((gpointer *) &(self)->Status, (value))
#define LassoLibStatusResponse_Status_set(self, value) set_node((gpointer *) &(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibStatusResponse lasso_lib_status_response_new
#define delete_LassoLibStatusResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibStatusResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoProvider lasso_provider_new
#define delete_LassoProvider(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoProvider_newFromDump lasso_provider_new_from_dump
#else
#define Provider_newFromDump lasso_provider_new_from_dump
#endif

/* Implementations of methods inherited from LassoNode */

#define LassoProvider_dump(self) lasso_node_dump(LASSO_NODE(self))

/* Methods implementations */

#define LassoProvider_acceptHttpMethod lasso_provider_accept_http_method
#define LassoProvider_getAssertionConsumerServiceUrl lasso_provider_get_assertion_consumer_service_url
#define LassoProvider_getBase64SuccinctId lasso_provider_get_base64_succinct_id
#define LassoProvider_getFirstHttpMethod lasso_provider_get_first_http_method
#define LassoProvider_getMetadataOne lasso_provider_get_metadata_one
#define LassoProvider_hasProtocolProfile lasso_provider_has_protocol_profile
#define LassoProvider_getOrganization(self) get_xml_string(lasso_provider_get_organization(self))




/* Implementations of attributes inherited from Provider */

/* providerId */
#define LassoServer_get_ProviderID(self) LASSO_PROVIDER(self)->ProviderID
#define LassoServer_ProviderID_get(self) LASSO_PROVIDER(self)->ProviderID
#define LassoServer_set_ProviderID(self, value) set_string(&LASSO_PROVIDER(self)->ProviderID, (value))
#define LassoServer_ProviderID_set(self, value) set_string(&LASSO_PROVIDER(self)->ProviderID, (value))

/* ca_cert_chain */
#define LassoServer_get_ca_cert_chain(self) LASSO_PROVIDER(self)->ca_cert_chain
#define LassoServer_ca_cert_chain_get(self) LASSO_PROVIDER(self)->ca_cert_chain
#define LassoServer_set_ca_cert_chain(self, value) set_string(&LASSO_PROVIDER(self)->ca_cert_chain, (value))
#define LassoServer_ca_cert_chain_set(self, value) set_string(&LASSO_PROVIDER(self)->ca_cert_chain, (value))

/* metadata_filename */
#define LassoServer_get_metadata_filename(self) LASSO_PROVIDER(self)->metadata_filename
#define LassoServer_metadata_filename_get(self) LASSO_PROVIDER(self)->metadata_filename
#define LassoServer_set_metadata_filename(self, value) set_string(&LASSO_PROVIDER(self)->metadata_filename, (value))
#define LassoServer_metadata_filename_set(self, value) set_string(&LASSO_PROVIDER(self)->metadata_filename, (value))

/* public_key */
#define LassoServer_get_public_key(self) LASSO_PROVIDER(self)->public_key
#define LassoServer_public_key_get(self) LASSO_PROVIDER(self)->public_key
#define LassoServer_set_public_key(self, value) set_string(&LASSO_PROVIDER(self)->public_key, (value))
#define LassoServer_public_key_set(self, value) set_string(&LASSO_PROVIDER(self)->public_key, (value))

/* role */
#define LassoServer_get_role(self) LASSO_PROVIDER(self)->role
#define LassoServer_role_get(self) LASSO_PROVIDER(self)->role
#define LassoServer_set_role(self, value) LASSO_PROVIDER(self)->role = value
#define LassoServer_role_set(self, value) LASSO_PROVIDER(self)->role = value

/* Attributes implementations */

/* providerIds */
#define LassoServer_get_providerIds LassoServer_providerIds_get
LassoStringList *LassoServer_providerIds_get(LassoServer *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->providers));
	g_hash_table_foreach(self->providers, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoServer lasso_server_new
#define delete_LassoServer(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoServer_newFromDump lasso_server_new_from_dump
#else
#define Server_newFromDump lasso_server_new_from_dump
#endif

/* Implementations of methods inherited from Provider */

#define LassoServer_acceptHttpMethod(server, remote_provider, protocol_type, http_method, initiate_profile) lasso_provider_accept_http_method(LASSO_PROVIDER(server), remote_provider, protocol_type, http_method, initiate_profile)
#define LassoServer_getAssertionConsumerServiceUrl(server, service_id) lasso_provider_get_assertion_consumer_service_url(LASSO_PROVIDER(server), service_id)
#define LassoServer_getBase64SuccinctId(server) lasso_provider_get_base64_succinct_id(LASSO_PROVIDER(server))
#define LassoServer_getFirstHttpMethod(server, remote_provider, protocol_type) lasso_provider_get_first_http_method(LASSO_PROVIDER(server), remote_provider, protocol_type)
#define LassoServer_getMetadataOne(server, name) lasso_provider_get_metadata_one(LASSO_PROVIDER(server), name)
#define LassoServer_hasProtocolProfile(server, protocol_type, protocol_profile) lasso_provider_has_protocol_profile(LASSO_PROVIDER(server), protocol_type, protocol_profile)
#define LassoServer_getOrganization(server) get_xml_string(lasso_provider_get_organization(LASSO_PROVIDER(server)))

/* Methods implementations */

#define LassoServer_addProvider lasso_server_add_provider
#define LassoServer_addService lasso_server_add_service
#define LassoServer_dump lasso_server_dump
#define LassoServer_getProvider lasso_server_get_provider
#define LassoServer_getService lasso_server_get_service




/* Attributes implementations */

/* localNameIdentifier */
#define LassoFederation_get_local_nameIdentifier(self) get_node((self)->local_nameIdentifier)
#define LassoFederation_local_nameIdentifier_get(self) get_node((self)->local_nameIdentifier)
#define LassoFederation_set_local_nameIdentifier(self, value) set_node((gpointer *) &(self)->local_nameIdentifier, (value))
#define LassoFederation_local_nameIdentifier_set(self, value) set_node((gpointer *) &(self)->local_nameIdentifier, (value))

/* remoteNameIdentifier */
#define LassoFederation_get_remote_nameIdentifier(self) get_node((self)->remote_nameIdentifier)
#define LassoFederation_remote_nameIdentifier_get(self) get_node((self)->remote_nameIdentifier)
#define LassoFederation_set_remote_nameIdentifier(self, value) set_node((gpointer *) &(self)->remote_nameIdentifier, (value))
#define LassoFederation_remote_nameIdentifier_set(self, value) set_node((gpointer *) &(self)->remote_nameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoFederation lasso_federation_new
#define delete_LassoFederation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoFederation_dump(self) lasso_node_dump(LASSO_NODE(self))

/* Methods implementations */

#define LassoFederation_buildLocalNameIdentifier lasso_federation_build_local_name_identifier
#define LassoFederation_verifyNameIdentifier lasso_federation_verify_name_identifier




/* Attributes implementations */

/* providerIds */
#define LassoIdentity_get_providerIds LassoIdentity_providerIds_get
LassoStringList *LassoIdentity_providerIds_get(LassoIdentity *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->federations));
	g_hash_table_foreach(self->federations, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoIdentity lasso_identity_new
#define delete_LassoIdentity(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoIdentity_newFromDump lasso_identity_new_from_dump
#else
#define Identity_newFromDump lasso_identity_new_from_dump
#endif

/* Methods implementations */

#define LassoIdentity_dump lasso_identity_dump
#define LassoIdentity_getFederation lasso_identity_get_federation

#ifdef LASSO_WSF_ENABLED
#define LassoIdentity_addResourceOffering lasso_identity_add_resource_offering
#define LassoIdentity_removeResourceOffering lasso_identity_remove_resource_offering

LassoNodeList *LassoIdentity_getOfferings(LassoIdentity *self, const char *service_type) {
	GPtrArray *array = NULL;
	GList *list;

	list = lasso_identity_get_offerings(self, service_type);
	if (list) {
		array = get_node_list(list);
		g_list_foreach(list, (GFunc) free_node_list_item, NULL);
		g_list_free(list);
	}
	return array;
}
#endif




/* Attributes implementations */

/* providerIds */
#define LassoSession_get_providerIds LassoSession_providerIds_get
LassoStringList *LassoSession_providerIds_get(LassoSession *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->assertions));
	g_hash_table_foreach(self->assertions, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoSession lasso_session_new
#define delete_LassoSession(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoSession_newFromDump lasso_session_new_from_dump
#else
#define Session_newFromDump lasso_session_new_from_dump
#endif

/* Methods implementations */

#define LassoSession_dump lasso_session_dump

LassoNodeList *LassoSession_getAssertions(LassoSession *self, char *providerId) {
	GPtrArray *assertionsArray;
	GList *assertionsList;

	assertionsList = lasso_session_get_assertions(self, providerId);
	if (assertionsList) {
		assertionsArray = get_node_list(assertionsList);
		g_list_foreach(assertionsList, (GFunc) free_node_list_item, NULL);
		g_list_free(assertionsList);
	} else
		assertionsArray = NULL;
	return assertionsArray;
}




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoDefederation_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoDefederation_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoDefederation_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoDefederation_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoDefederation_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoDefederation_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoDefederation_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoDefederation_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoDefederation_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoDefederation_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoDefederation_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoDefederation_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoDefederation_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoDefederation_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoDefederation_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoDefederation_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoDefederation_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoDefederation_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoDefederation_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoDefederation_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoDefederation_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoDefederation_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoDefederation_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoDefederation_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoDefederation_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoDefederation_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoDefederation_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoDefederation_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoDefederation_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoDefederation_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoDefederation_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoDefederation_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoDefederation_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoDefederation_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoDefederation_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoDefederation_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoDefederation_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoDefederation_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoDefederation lasso_defederation_new
#define delete_LassoDefederation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoDefederation_setIdentityFromDump(LassoDefederation *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoDefederation_setSessionFromDump(LassoDefederation *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoDefederation_buildNotificationMsg lasso_defederation_build_notification_msg
#define LassoDefederation_initNotification lasso_defederation_init_notification
#define LassoDefederation_processNotificationMsg lasso_defederation_process_notification_msg
#define LassoDefederation_validateNotification lasso_defederation_validate_notification




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLogin_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogin_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogin_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLogin_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoLogin_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLogin_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLogin_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLogin_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLogin_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLogin_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLogin_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLogin_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLogin_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLogin_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLogin_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogin_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogin_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLogin_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLogin_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogin_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogin_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLogin_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLogin_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogin_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogin_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLogin_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLogin_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogin_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogin_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLogin_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLogin_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogin_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogin_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLogin_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLogin_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogin_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogin_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLogin_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLogin lasso_login_new
#define delete_LassoLogin(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLogin_newFromDump lasso_login_new_from_dump
#else
#define Login_newFromDump lasso_login_new_from_dump
#endif

/* Implementations of methods inherited from Profile */

int LassoLogin_setIdentityFromDump(LassoLogin *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLogin_setSessionFromDump(LassoLogin *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLogin_acceptSso lasso_login_accept_sso
#define LassoLogin_buildAssertion lasso_login_build_assertion
#define LassoLogin_buildArtifactMsg lasso_login_build_artifact_msg
#define LassoLogin_buildAuthnRequestMsg lasso_login_build_authn_request_msg
#define LassoLogin_buildAuthnResponseMsg lasso_login_build_authn_response_msg
#define LassoLogin_buildRequestMsg lasso_login_build_request_msg
#define LassoLogin_buildResponseMsg lasso_login_build_response_msg
#define LassoLogin_dump lasso_login_dump
#define LassoLogin_initAuthnRequest lasso_login_init_authn_request
#define LassoLogin_initRequest lasso_login_init_request
#define LassoLogin_initIdpInitiatedAuthnRequest lasso_login_init_idp_initiated_authn_request
#define LassoLogin_mustAskForConsent lasso_login_must_ask_for_consent
#define LassoLogin_mustAuthenticate lasso_login_must_authenticate
#define LassoLogin_processAuthnRequestMsg lasso_login_process_authn_request_msg
#define LassoLogin_processAuthnResponseMsg lasso_login_process_authn_response_msg
#define LassoLogin_processRequestMsg lasso_login_process_request_msg
#define LassoLogin_processResponseMsg lasso_login_process_response_msg
#define LassoLogin_setEncryptedResourceId lasso_login_set_encryptedResourceId 
#define LassoLogin_setResourceId lasso_login_set_resourceId
#define LassoLogin_validateRequestMsg lasso_login_validate_request_msg




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLogout_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogout_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogout_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLogout_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoLogout_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLogout_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLogout_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLogout_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLogout_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLogout_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLogout_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLogout_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLogout_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLogout_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLogout_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogout_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogout_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLogout_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLogout_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogout_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogout_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLogout_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLogout_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogout_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogout_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLogout_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLogout_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogout_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogout_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLogout_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLogout_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogout_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogout_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLogout_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLogout_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogout_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogout_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLogout_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLogout lasso_logout_new
#define delete_LassoLogout(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoLogout_newFromDump lasso_logout_new_from_dump
#else
#define Logout_newFromDump lasso_logout_new_from_dump
#endif

/* Implementations of methods inherited from Profile */

int LassoLogout_setIdentityFromDump(LassoLogout *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLogout_setSessionFromDump(LassoLogout *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLogout_buildRequestMsg lasso_logout_build_request_msg
#define LassoLogout_buildResponseMsg lasso_logout_build_response_msg
#define LassoLogout_dump lasso_logout_dump
#define LassoLogout_getNextProviderId lasso_logout_get_next_providerID
#define LassoLogout_initRequest lasso_logout_init_request
#define LassoLogout_processRequestMsg lasso_logout_process_request_msg
#define LassoLogout_processResponseMsg lasso_logout_process_response_msg
#define LassoLogout_resetProviderIdIndex lasso_logout_reset_providerID_index
#define LassoLogout_validateRequest lasso_logout_validate_request




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLecp_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLecp_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLecp_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLecp_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoLecp_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLecp_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLecp_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLecp_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLecp_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLecp_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLecp_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLecp_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLecp_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLecp_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLecp_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLecp_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLecp_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLecp_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLecp_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLecp_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLecp_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLecp_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLecp_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLecp_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLecp_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLecp_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLecp_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLecp_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLecp_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLecp_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLecp_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLecp_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLecp_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLecp_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLecp_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLecp_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLecp_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLecp_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLecp lasso_lecp_new
#define delete_LassoLecp(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoLecp_setIdentityFromDump(LassoLecp *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLecp_setSessionFromDump(LassoLecp *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Implementations of methods inherited from Login */

int LassoLecp_buildAssertion(LassoLecp *self, char *authenticationMethod,
		char *authenticationInstant, char *reauthenticateOnOrAfter, char *notBefore,
		char *notOnOrAfter) {
	return lasso_login_build_assertion(LASSO_LOGIN(self), authenticationMethod,
			authenticationInstant, reauthenticateOnOrAfter, notBefore, notOnOrAfter);
}

#ifdef LASSO_WSF_ENABLED
int LassoLecp_setEncryptedResourceId(LassoLecp *self,
		LassoDiscoEncryptedResourceID *encryptedResourceId) {
	return lasso_login_set_encryptedResourceId(LASSO_LOGIN(self), encryptedResourceId);
}
#endif

int LassoLecp_setResourceId(LassoLecp *self, char *content) {
	return lasso_login_set_resourceId(LASSO_LOGIN(self), content);
}

int LassoLecp_validateRequestMsg(LassoLecp *self, gboolean authenticationResult,
		gboolean isConsentObtained) {
	return lasso_login_validate_request_msg(LASSO_LOGIN(self), authenticationResult,
			isConsentObtained);
}

/* Methods implementations */

#define LassoLecp_buildAuthnRequestEnvelopeMsg lasso_lecp_build_authn_request_envelope_msg
#define LassoLecp_buildAuthnRequestMsg lasso_lecp_build_authn_request_msg
#define LassoLecp_buildAuthnResponseEnvelopeMsg lasso_lecp_build_authn_response_envelope_msg
#define LassoLecp_buildAuthnResponseMsg lasso_lecp_build_authn_response_msg
#define LassoLecp_initAuthnRequest lasso_lecp_init_authn_request
#define LassoLecp_processAuthnRequestEnvelopeMsg lasso_lecp_process_authn_request_envelope_msg
#define LassoLecp_processAuthnRequestMsg lasso_lecp_process_authn_request_msg
#define LassoLecp_processAuthnResponseEnvelopeMsg lasso_lecp_process_authn_response_envelope_msg




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoNameIdentifierMapping_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoNameIdentifierMapping_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoNameIdentifierMapping_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoNameIdentifierMapping_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoNameIdentifierMapping_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoNameIdentifierMapping_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoNameIdentifierMapping_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoNameIdentifierMapping_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoNameIdentifierMapping_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoNameIdentifierMapping_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoNameIdentifierMapping_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameIdentifierMapping_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameIdentifierMapping_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoNameIdentifierMapping_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoNameIdentifierMapping_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameIdentifierMapping_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameIdentifierMapping_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoNameIdentifierMapping_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoNameIdentifierMapping_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameIdentifierMapping_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameIdentifierMapping_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoNameIdentifierMapping_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoNameIdentifierMapping_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameIdentifierMapping_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameIdentifierMapping_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoNameIdentifierMapping_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoNameIdentifierMapping_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameIdentifierMapping_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameIdentifierMapping_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoNameIdentifierMapping_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoNameIdentifierMapping_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoNameIdentifierMapping_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoNameIdentifierMapping lasso_name_identifier_mapping_new
#define delete_LassoNameIdentifierMapping(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoNameIdentifierMapping_setIdentityFromDump(LassoNameIdentifierMapping *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoNameIdentifierMapping_setSessionFromDump(LassoNameIdentifierMapping *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoNameIdentifierMapping_buildRequestMsg lasso_name_identifier_mapping_build_request_msg
#define LassoNameIdentifierMapping_buildResponseMsg lasso_name_identifier_mapping_build_response_msg
#define LassoNameIdentifierMapping_initRequest lasso_name_identifier_mapping_init_request
#define LassoNameIdentifierMapping_processRequestMsg lasso_name_identifier_mapping_process_request_msg
#define LassoNameIdentifierMapping_processResponseMsg lasso_name_identifier_mapping_process_response_msg
#define LassoNameIdentifierMapping_validateRequest lasso_name_identifier_mapping_validate_request




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoNameRegistration_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameRegistration_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameRegistration_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoNameRegistration_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* isIdentityDirty */
#define LassoNameRegistration_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoNameRegistration_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoNameRegistration_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoNameRegistration_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoNameRegistration_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoNameRegistration_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoNameRegistration_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoNameRegistration_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoNameRegistration_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoNameRegistration_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoNameRegistration_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameRegistration_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameRegistration_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoNameRegistration_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoNameRegistration_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameRegistration_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameRegistration_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoNameRegistration_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoNameRegistration_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameRegistration_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameRegistration_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoNameRegistration_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoNameRegistration_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameRegistration_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameRegistration_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoNameRegistration_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoNameRegistration_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameRegistration_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameRegistration_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoNameRegistration_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoNameRegistration_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameRegistration_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameRegistration_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoNameRegistration_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Attributes implementations */

/* oldNameIdentifier */
#define LassoNameRegistration_get_oldNameIdentifier(self) get_node((self)->oldNameIdentifier)
#define LassoNameRegistration_oldNameIdentifier_get(self) get_node((self)->oldNameIdentifier)
#define LassoNameRegistration_set_oldNameIdentifier(self, value) set_node((gpointer *) &(self)->oldNameIdentifier, (value))
#define LassoNameRegistration_oldNameIdentifier_set(self, value) set_node((gpointer *) &(self)->oldNameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoNameRegistration lasso_name_registration_new
#define delete_LassoNameRegistration(self) lasso_node_destroy(LASSO_NODE(self))
#ifdef PHP_VERSION
#define LassoNameRegistration_newFromDump lasso_name_registration_new_from_dump
#else
#define NameRegistration_newFromDump lasso_name_registration_new_from_dump
#endif

/* Implementations of methods inherited from Profile */

int LassoNameRegistration_setIdentityFromDump(LassoNameRegistration *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoNameRegistration_setSessionFromDump(LassoNameRegistration *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoNameRegistration_buildRequestMsg lasso_name_registration_build_request_msg
#define LassoNameRegistration_buildResponseMsg lasso_name_registration_build_response_msg
#define LassoNameRegistration_dump lasso_name_registration_dump
#define LassoNameRegistration_initRequest lasso_name_registration_init_request
#define LassoNameRegistration_processRequestMsg lasso_name_registration_process_request_msg
#define LassoNameRegistration_processResponseMsg lasso_name_registration_process_response_msg
#define LassoNameRegistration_validateRequest lasso_name_registration_validate_request



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1WSF_1SUPPORT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jobject JNICALL Java_com_entrouvert_lasso_lassoJNI_downcast_1node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jobject jresult = 0 ;
    LassoNode *arg1 = (LassoNode *) 0 ;
    DowncastableNode *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNode **)&jarg1; 
    result = (DowncastableNode *)downcast_node(arg1);
    
    {
        char classPath[256];
        jclass clazz;
        char *name;
        
        name = (char *) G_OBJECT_TYPE_NAME(result);
        name += 5; /* Skip "Lasso" prefix. */
        sprintf(classPath, "com/entrouvert/lasso/%s", name);
        clazz = (*jenv)->FindClass(jenv, classPath);
        if (clazz) {
            jmethodID mid = (*jenv)->GetMethodID(jenv, clazz, "<init>", "(JZ)V");
            if (mid)
            *(void**)&jresult = (*jenv)->NewObject(jenv, clazz, mid, result, false);
        }
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_NONE;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1ANY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_ANY;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1IDP_1INITIATED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_IDP_INITIATED;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1GET(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_GET;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1POST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_POST;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1REDIRECT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_REDIRECT;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1HTTP_1METHOD_1SOAP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoHttpMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoHttpMethod)LASSO_HTTP_METHOD_SOAP;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1OBTAINED(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:obtained";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1OBTAINED_1PRIOR(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:obtained:prior";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1OBTAINED_1CURRENT_1IMPLICIT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:obtained:current:implicit";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1OBTAINED_1CURRENT_1EXPLICIT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:obtained:current:explicit";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1UNAVAILABLE(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:unavailable";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1CONSENT_1INAPPLICABLE(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:inapplicable";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1NAMEID_1POLICY_1TYPE_1NONE(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "none";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1NAMEID_1POLICY_1TYPE_1ONE_1TIME(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "onetime";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1NAMEID_1POLICY_1TYPE_1FEDERATED(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "federated";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1NAMEID_1POLICY_1TYPE_1ANY(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "any";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1BRWS_1ART(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/brws-art";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1BRWS_1POST(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/brws-post";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1BRWS_1LECP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/lecp";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1IDP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1IDP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1SP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1SP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1RNI_1IDP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1RNI_1IDP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1RNI_1SP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1RNI_1SP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1SLO_1IDP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1SLO_1IDP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1SLO_1SP_1HTTP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1PROTOCOL_1PROFILE_1SLO_1SP_1SOAP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1PROTOCOL_1PROFILE_1BRWS_1ART(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoLoginProtocolProfile result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_ART;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1PROTOCOL_1PROFILE_1BRWS_1POST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoLoginProtocolProfile result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_POST;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1PROTOCOL_1PROFILE_1BRWS_1LECP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoLoginProtocolProfile result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_LECP;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROVIDER_1ROLE_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoProviderRole result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoProviderRole)LASSO_PROVIDER_ROLE_NONE;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROVIDER_1ROLE_1SP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoProviderRole result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoProviderRole)LASSO_PROVIDER_ROLE_SP;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROVIDER_1ROLE_1IDP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoProviderRole result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoProviderRole)LASSO_PROVIDER_ROLE_IDP;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1INVALID(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_INVALID;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1LOGIN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_LOGIN;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1LOGOUT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_LOGOUT;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1DEFEDERATION(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_DEFEDERATION;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1NAME_1REGISTRATION(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_NAME_REGISTRATION;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1NAME_1IDENTIFIER_1MAPPING(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_NAME_IDENTIFIER_MAPPING;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1LECP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_LECP;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1DISCO_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_DISCO_QUERY;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1DISCO_1MODIFY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_DISCO_MODIFY;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1DST_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_DST_QUERY;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1DST_1MODIFY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_DST_MODIFY;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1REQUEST_1TYPE_1SASL_1REQUEST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoRequestType)LASSO_REQUEST_TYPE_SASL_REQUEST;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1INTERNET_1PROTOCOL(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/InternetProtocol";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1INTERNET_1PROTOCOL_1PASSWORD(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/InternetProtocolPassword";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1ONE_1FACTOR_1UNREGISTERED(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileOneFactorUnregistered";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1TWO_1FACTOR_1UNREGISTERED(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileTwoFactorUnregistered";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1ONE_1FACTOR_1CONTRACT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileOneFactorContract";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1TWO_1FACTOR_1CONTRACT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileTwoFactorContract";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PASSWORD(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/Password";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PASSWORD_1PROTECTED_1TRANSPORT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PREVIOUS_1SESSION(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/PreviousSession";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SMARTCARD(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SMARTCARD_1PKI(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/SmartcardPKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SOFTWARE_1PKI(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/SoftwarePKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1TIME_1SYNC_1TOKEN(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/TimeSyncToken";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1COMPARISON_1EXACT(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "exact";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1COMPARISON_1MINIMUM(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "minimum";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1COMPARISON_1MAXIMUM(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "maximum";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LIB_1AUTHN_1CONTEXT_1COMPARISON_1BETTER(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "better";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1PASSWORD(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:password";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1KERBEROS(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:1510";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1SECURE_1REMOTE_1PASSWORD(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:2945";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1HARDWARE_1TOKEN(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1SMARTCARD_1PKI(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:2246";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1SOFTWARE_1PKI(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1PGP(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:PGP";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHODS_1PKI(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:SPKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1XKMS(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:XKMS";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1XMLD_1SIG(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:3075";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1UNSPECIFIED(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:unspecified";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SAML_1AUTHENTICATION_1METHOD_1LIBERTY(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:ac:2003-08";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SIGNATURE_1METHOD_1RSA_1SHA1(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSignatureMethod)LASSO_SIGNATURE_METHOD_RSA_SHA1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SIGNATURE_1METHOD_1DSA_1SHA1(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSignatureMethod)LASSO_SIGNATURE_METHOD_DSA_SHA1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1ERROR_1UNDEFINED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1ERROR_1UNIMPLEMENTED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1NODE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1NODE_1CONTENT_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -11;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1ATTR_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -12;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1ATTR_1VALUE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -13;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 101;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1INVALID_1SIGNATURE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 102;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1TMPL_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -103;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1CONTEXT_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -104;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1PUBLIC_1KEY_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -105;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1PRIVATE_1KEY_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -106;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1CERTIFICATE_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -107;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -108;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1KEYS_1MNGR_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -109;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1KEYS_1MNGR_1INIT_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -110;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1VERIFICATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -111;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1CA_1CERT_1CHAIN_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -112;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1INVALID_1SIGALG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -113;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1DIGEST_1COMPUTE_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -114;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LASSO_1DS_1ERROR_1SIGNATURE_1TEMPLATE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -115;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SERVER_1ERROR_1PROVIDER_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -201;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SERVER_1ERROR_1ADD_1PROVIDER_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -202;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGOUT_1ERROR_1UNSUPPORTED_1PROFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -301;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -401;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1POST_1MSG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -402;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1SOAP_1MSG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -403;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1MISSING_1REQUEST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -404;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1HTTP_1METHOD(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -405;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1PROTOCOLPROFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -406;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1MSG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -407;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1MISSING_1REMOTE_1PROVIDERID(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -408;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1UNSUPPORTED_1PROFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -409;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1UNKNOWN_1PROFILE_1URL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -410;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1IDENTITY_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -411;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1FEDERATION_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -412;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1NAME_1IDENTIFIER_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -413;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BUILDING_1QUERY_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -414;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BUILDING_1REQUEST_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -415;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BUILDING_1MESSAGE_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -416;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BUILDING_1RESPONSE_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -417;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1SESSION_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -418;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BAD_1IDENTITY_1DUMP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -419;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1BAD_1SESSION_1DUMP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -420;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LASSO_1PARAM_1ERROR_1BAD_1TYPE_1OR_1NULL_1OBJ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -501;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PARAM_1ERROR_1INVALID_1VALUE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -502;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LASSO_1PARAM_1ERROR_1CHECK_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -503;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1FEDERATION_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 601;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1CONSENT_1NOT_1OBTAINED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 602;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1INVALID_1NAMEIDPOLICY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -603;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1REQUEST_1DENIED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 604;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1INVALID_1SIGNATURE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 605;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1UNSIGNED_1AUTHN_1REQUEST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 606;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1STATUS_1NOT_1SUCCESS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 607;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGIN_1ERROR_1UNKNOWN_1PRINCIPAL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 608;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DEFEDERATION_1ERROR_1MISSING_1NAME_1IDENTIFIER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -700;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_init(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lasso_init();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_shutdown(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lasso_shutdown();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1CHECK_1VERSION_1EXACT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoCheckVersionMode result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoCheckVersionMode)LASSO_CHECK_VERSION_EXACT;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1CHECK_1VERSIONABI_1COMPATIBLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoCheckVersionMode result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoCheckVersionMode)LASSO_CHECK_VERSIONABI_COMPATIBLE;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1CHECK_1VERSION_1NUMERIC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    LassoCheckVersionMode result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoCheckVersionMode)LASSO_CHECK_VERSION_NUMERIC;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_checkVersion(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
    jint jresult = 0 ;
    int arg1 ;
    int arg2 ;
    int arg3 ;
    LassoCheckVersionMode arg4 = (LassoCheckVersionMode) LASSO_CHECK_VERSION_NUMERIC ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (LassoCheckVersionMode)jarg4; 
    result = (int)lasso_check_version(arg1,arg2,arg3,(LassoCheckVersionMode )arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_registerDstService(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    lasso_register_dst_service((char const *)arg1,(char const *)arg2);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Node(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoNode *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoNode *)new_LassoNode();
    
    *(LassoNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoNode *arg1 = (LassoNode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNode **)&jarg1; 
    delete_LassoNode(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Node_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNode *arg1 = (LassoNode *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNode **)&jarg1; 
    result = (char *)LassoNode_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NodeList(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoNodeList *)new_LassoNodeList();
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NodeList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    delete_LassoNodeList(arg1);
    
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    LassoNode *arg2 = (LassoNode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    arg2 = *(LassoNode **)&jarg2; 
    LassoNodeList_append(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    result = (void *)LassoNodeList_cast(arg1);
    
    *(void **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)&jarg1; 
    result = (LassoNodeList *)NodeList_frompointer(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1getItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    int arg2 ;
    LassoNode *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        if (arg2 < 0 || arg2 >= arg1->len) {
            char errorMsg[256];
            sprintf(errorMsg, "%d", arg2);
            SWIG_exception(SWIG_IndexError, errorMsg);
        }
        result = (LassoNode *)LassoNodeList_getItem(arg1,arg2);
        
    }
    *(LassoNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1length(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    result = (int)LassoNodeList_length(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1setItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    LassoNodeList *arg1 = (LassoNodeList *) 0 ;
    int arg2 ;
    LassoNode *arg3 = (LassoNode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNodeList **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(LassoNode **)&jarg3; 
    {
        if (arg2 < 0 || arg2 >= arg1->len) {
            char errorMsg[256];
            sprintf(errorMsg, "%d", arg2);
            SWIG_exception(SWIG_IndexError, errorMsg);
        }
        LassoNodeList_setItem(arg1,arg2,arg3);
        
    }
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1StringList(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoStringList *)new_LassoStringList();
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1StringList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    delete_LassoStringList(arg1);
    
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoStringList_append(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    result = (void *)LassoStringList_cast(arg1);
    
    *(void **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)&jarg1; 
    result = (LassoStringList *)StringList_frompointer(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1getItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        if (arg2 < 0 || arg2 >= arg1->len) {
            char errorMsg[256];
            sprintf(errorMsg, "%d", arg2);
            SWIG_exception(SWIG_IndexError, errorMsg);
        }
        result = (char *)LassoStringList_getItem(arg1,arg2);
        
    }
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1length(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    result = (int)LassoStringList_length(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1setItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    LassoStringList *arg1 = (LassoStringList *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoStringList **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        if (arg2 < 0 || arg2 >= arg1->len) {
            char errorMsg[256];
            sprintf(errorMsg, "%d", arg2);
            SWIG_exception(SWIG_IndexError, errorMsg);
        }
        LassoStringList_setItem(arg1,arg2,arg3);
        
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAdvice_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    LassoSamlAssertion *arg2 = (LassoSamlAssertion *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    arg2 = *(LassoSamlAssertion **)&jarg2; 
    LassoSamlAdvice_set_Assertion(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAdvice_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    LassoSamlAssertion *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    result = (LassoSamlAssertion *)LassoSamlAdvice_get_Assertion(arg1);
    
    *(LassoSamlAssertion **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAdvice_1assertionIdReference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoSamlAdvice_set_assertionIdReference(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAdvice_1assertionIdReference(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    result = (LassoStringList *)LassoSamlAdvice_get_assertionIdReference(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAdvice(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAdvice *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAdvice *)new_LassoSamlAdvice();
    
    *(LassoSamlAdvice **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAdvice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    delete_LassoSamlAdvice(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAdvice **)&jarg1; 
    result = (char *)LassoSamlAdvice_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1assertionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AssertionID) free((char*)arg1->AssertionID);
        if (arg2) {
            arg1->AssertionID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AssertionID,arg2);
        } else {
            arg1->AssertionID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1assertionId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *) ((arg1)->AssertionID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->certificate_file) free((char*)arg1->certificate_file);
        if (arg2) {
            arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->certificate_file,arg2);
        } else {
            arg1->certificate_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *) ((arg1)->certificate_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
        if (arg2) {
            arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->IssueInstant,arg2);
        } else {
            arg1->IssueInstant = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *) ((arg1)->IssueInstant);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1issuer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Issuer) free((char*)arg1->Issuer);
        if (arg2) {
            arg1->Issuer = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Issuer,arg2);
        } else {
            arg1->Issuer = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1issuer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *) ((arg1)->Issuer);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MajorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (int) ((arg1)->MajorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MinorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (int) ((arg1)->MinorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->private_key_file) free((char*)arg1->private_key_file);
        if (arg2) {
            arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->private_key_file,arg2);
        } else {
            arg1->private_key_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *) ((arg1)->private_key_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    if (arg1) (arg1)->sign_method = (LassoSignatureMethod )arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSignatureMethod) ((arg1)->sign_method);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->sign_type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result =  ((arg1)->sign_type);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1advice(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAdvice *arg2 = (LassoSamlAdvice *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = *(LassoSamlAdvice **)&jarg2; 
    LassoSamlAssertion_set_Advice(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1advice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAdvice *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSamlAdvice *)LassoSamlAssertion_get_Advice(arg1);
    
    *(LassoSamlAdvice **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1attributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAttributeStatement *arg2 = (LassoSamlAttributeStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = *(LassoSamlAttributeStatement **)&jarg2; 
    LassoSamlAssertion_set_AttributeStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1attributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAttributeStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSamlAttributeStatement *)LassoSamlAssertion_get_AttributeStatement(arg1);
    
    *(LassoSamlAttributeStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1authenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAuthenticationStatement *arg2 = (LassoSamlAuthenticationStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = *(LassoSamlAuthenticationStatement **)&jarg2; 
    LassoSamlAssertion_set_AuthenticationStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1authenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlAuthenticationStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSamlAuthenticationStatement *)LassoSamlAssertion_get_AuthenticationStatement(arg1);
    
    *(LassoSamlAuthenticationStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1conditions(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlConditions *arg2 = (LassoSamlConditions *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = *(LassoSamlConditions **)&jarg2; 
    LassoSamlAssertion_set_Conditions(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1conditions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlConditions *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSamlConditions *)LassoSamlAssertion_get_Conditions(arg1);
    
    *(LassoSamlConditions **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAssertion_1subjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlSubjectStatement *arg2 = (LassoSamlSubjectStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    arg2 = *(LassoSamlSubjectStatement **)&jarg2; 
    LassoSamlAssertion_set_SubjectStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAssertion_1subjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    LassoSamlSubjectStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (LassoSamlSubjectStatement *)LassoSamlAssertion_get_SubjectStatement(arg1);
    
    *(LassoSamlSubjectStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAssertion(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAssertion *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAssertion *)new_LassoSamlAssertion();
    
    *(LassoSamlAssertion **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    delete_LassoSamlAssertion(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAssertion **)&jarg1; 
    result = (char *)LassoSamlAssertion_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttribute_1attributeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlAttribute_set_AttributeName(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttribute_1attributeName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    result = (char *)LassoSamlAttribute_get_AttributeName(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttribute_1attributeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlAttribute_set_AttributeNamespace(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttribute_1attributeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    result = (char *)LassoSamlAttribute_get_AttributeNamespace(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttribute_1attributeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlAttribute_set_AttributeValue(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttribute_1attributeValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    result = (LassoNodeList *)LassoSamlAttribute_get_AttributeValue(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttribute(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAttribute *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAttribute *)new_LassoSamlAttribute();
    
    *(LassoSamlAttribute **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    delete_LassoSamlAttribute(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttribute **)&jarg1; 
    result = (char *)LassoSamlAttribute_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttributeDesignator_1attributeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AttributeName) free((char*)arg1->AttributeName);
        if (arg2) {
            arg1->AttributeName = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AttributeName,arg2);
        } else {
            arg1->AttributeName = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttributeDesignator_1attributeName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    result = (char *) ((arg1)->AttributeName);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttributeDesignator_1attributeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AttributeNamespace) free((char*)arg1->AttributeNamespace);
        if (arg2) {
            arg1->AttributeNamespace = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AttributeNamespace,arg2);
        } else {
            arg1->AttributeNamespace = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttributeDesignator_1attributeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    result = (char *) ((arg1)->AttributeNamespace);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeDesignator(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAttributeDesignator *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAttributeDesignator *)new_LassoSamlAttributeDesignator();
    
    *(LassoSamlAttributeDesignator **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeDesignator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    delete_LassoSamlAttributeDesignator(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeDesignator **)&jarg1; 
    result = (char *)LassoSamlAttributeDesignator_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttributeStatement_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    arg2 = *(LassoSamlSubject **)&jarg2; 
    LassoSamlAttributeStatement_set_Subject(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttributeStatement_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    LassoSamlSubject *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    result = (LassoSamlSubject *)LassoSamlAttributeStatement_get_Subject(arg1);
    
    *(LassoSamlSubject **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttributeStatement_1attribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlAttributeStatement_set_Attribute(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttributeStatement_1attribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    result = (LassoNodeList *)LassoSamlAttributeStatement_get_Attribute(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeStatement(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAttributeStatement *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAttributeStatement *)new_LassoSamlAttributeStatement();
    
    *(LassoSamlAttributeStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    delete_LassoSamlAttributeStatement(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeStatement **)&jarg1; 
    result = (char *)LassoSamlAttributeStatement_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAttributeValue_1any(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeValue **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlAttributeValue_set_any(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAttributeValue_1any(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeValue **)&jarg1; 
    result = (LassoNodeList *)LassoSamlAttributeValue_get_any(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeValue(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAttributeValue *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAttributeValue *)new_LassoSamlAttributeValue();
    
    *(LassoSamlAttributeValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeValue **)&jarg1; 
    delete_LassoSamlAttributeValue(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeValue_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAttributeValue **)&jarg1; 
    result = (char *)LassoSamlAttributeValue_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAudienceRestrictionCondition_1audience(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAudienceRestrictionCondition **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoSamlAudienceRestrictionCondition_set_audience(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAudienceRestrictionCondition_1audience(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAudienceRestrictionCondition **)&jarg1; 
    result = (LassoStringList *)LassoSamlAudienceRestrictionCondition_get_audience(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAudienceRestrictionCondition(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAudienceRestrictionCondition *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAudienceRestrictionCondition *)new_LassoSamlAudienceRestrictionCondition();
    
    *(LassoSamlAudienceRestrictionCondition **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAudienceRestrictionCondition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAudienceRestrictionCondition **)&jarg1; 
    delete_LassoSamlAudienceRestrictionCondition(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAudienceRestrictionCondition_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAudienceRestrictionCondition **)&jarg1; 
    result = (char *)LassoSamlAudienceRestrictionCondition_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthenticationStatement_1authenticationInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AuthenticationInstant) free((char*)arg1->AuthenticationInstant);
        if (arg2) {
            arg1->AuthenticationInstant = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AuthenticationInstant,arg2);
        } else {
            arg1->AuthenticationInstant = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthenticationStatement_1authenticationInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    result = (char *) ((arg1)->AuthenticationInstant);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthenticationStatement_1authenticationMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AuthenticationMethod) free((char*)arg1->AuthenticationMethod);
        if (arg2) {
            arg1->AuthenticationMethod = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AuthenticationMethod,arg2);
        } else {
            arg1->AuthenticationMethod = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthenticationStatement_1authenticationMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    result = (char *) ((arg1)->AuthenticationMethod);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthenticationStatement_1authorityBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlAuthenticationStatement_set_AuthorityBinding(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthenticationStatement_1authorityBinding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    result = (LassoNodeList *)LassoSamlAuthenticationStatement_get_AuthorityBinding(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthenticationStatement_1subjectLocality(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    LassoSamlSubjectLocality *arg2 = (LassoSamlSubjectLocality *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    arg2 = *(LassoSamlSubjectLocality **)&jarg2; 
    LassoSamlAuthenticationStatement_set_SubjectLocality(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthenticationStatement_1subjectLocality(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    LassoSamlSubjectLocality *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    result = (LassoSamlSubjectLocality *)LassoSamlAuthenticationStatement_get_SubjectLocality(arg1);
    
    *(LassoSamlSubjectLocality **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAuthenticationStatement(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAuthenticationStatement *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAuthenticationStatement *)new_LassoSamlAuthenticationStatement();
    
    *(LassoSamlAuthenticationStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAuthenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    delete_LassoSamlAuthenticationStatement(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthenticationStatement **)&jarg1; 
    result = (char *)LassoSamlAuthenticationStatement_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthorityBinding_1authorityKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AuthorityKind) free((char*)arg1->AuthorityKind);
        if (arg2) {
            arg1->AuthorityKind = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AuthorityKind,arg2);
        } else {
            arg1->AuthorityKind = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthorityBinding_1authorityKind(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    result = (char *) ((arg1)->AuthorityKind);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthorityBinding_1location(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Location) free((char*)arg1->Location);
        if (arg2) {
            arg1->Location = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Location,arg2);
        } else {
            arg1->Location = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthorityBinding_1location(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    result = (char *) ((arg1)->Location);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlAuthorityBinding_1binding(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Binding) free((char*)arg1->Binding);
        if (arg2) {
            arg1->Binding = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Binding,arg2);
        } else {
            arg1->Binding = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlAuthorityBinding_1binding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    result = (char *) ((arg1)->Binding);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAuthorityBinding(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlAuthorityBinding *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlAuthorityBinding *)new_LassoSamlAuthorityBinding();
    
    *(LassoSamlAuthorityBinding **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAuthorityBinding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    delete_LassoSamlAuthorityBinding(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlAuthorityBinding **)&jarg1; 
    result = (char *)LassoSamlAuthorityBinding_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditionAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlConditionAbstract *arg1 = (LassoSamlConditionAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditionAbstract **)&jarg1; 
    result = (char *)LassoSamlConditionAbstract_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlConditions_1notBefore(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->NotBefore) free((char*)arg1->NotBefore);
        if (arg2) {
            arg1->NotBefore = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->NotBefore,arg2);
        } else {
            arg1->NotBefore = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlConditions_1notBefore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    result = (char *) ((arg1)->NotBefore);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlConditions_1notOnOrAfter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
        if (arg2) {
            arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->NotOnOrAfter,arg2);
        } else {
            arg1->NotOnOrAfter = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlConditions_1notOnOrAfter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    result = (char *) ((arg1)->NotOnOrAfter);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlConditions_1audienceRestrictionCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlConditions_set_AudienceRestrictionCondition(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlConditions_1audienceRestrictionCondition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    result = (LassoNodeList *)LassoSamlConditions_get_AudienceRestrictionCondition(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlConditions_1condition(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlConditions_set_Condition(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlConditions_1condition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    result = (LassoNodeList *)LassoSamlConditions_get_Condition(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlConditions(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlConditions *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlConditions *)new_LassoSamlConditions();
    
    *(LassoSamlConditions **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlConditions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    delete_LassoSamlConditions(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlConditions **)&jarg1; 
    result = (char *)LassoSamlConditions_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlNameIdentifier_1content(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->content) free((char*)arg1->content);
        if (arg2) {
            arg1->content = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->content,arg2);
        } else {
            arg1->content = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlNameIdentifier_1content(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    result = (char *) ((arg1)->content);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlNameIdentifier_1format(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Format) free((char*)arg1->Format);
        if (arg2) {
            arg1->Format = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Format,arg2);
        } else {
            arg1->Format = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlNameIdentifier_1format(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    result = (char *) ((arg1)->Format);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlNameIdentifier_1nameQualifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->NameQualifier) free((char*)arg1->NameQualifier);
        if (arg2) {
            arg1->NameQualifier = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->NameQualifier,arg2);
        } else {
            arg1->NameQualifier = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlNameIdentifier_1nameQualifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    result = (char *) ((arg1)->NameQualifier);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlNameIdentifier(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlNameIdentifier *)new_LassoSamlNameIdentifier();
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    delete_LassoSamlNameIdentifier(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlNameIdentifier **)&jarg1; 
    result = (char *)LassoSamlNameIdentifier_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlStatementAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlStatementAbstract *arg1 = (LassoSamlStatementAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlStatementAbstract **)&jarg1; 
    result = (char *)LassoSamlStatementAbstract_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubject_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoSamlSubject_set_NameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubject_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoSamlSubject_get_NameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubject_1subjectConfirmation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    LassoSamlSubjectConfirmation *arg2 = (LassoSamlSubjectConfirmation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    arg2 = *(LassoSamlSubjectConfirmation **)&jarg2; 
    LassoSamlSubject_set_SubjectConfirmation(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubject_1subjectConfirmation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    LassoSamlSubjectConfirmation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    result = (LassoSamlSubjectConfirmation *)LassoSamlSubject_get_SubjectConfirmation(arg1);
    
    *(LassoSamlSubjectConfirmation **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubject(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlSubject *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlSubject *)new_LassoSamlSubject();
    
    *(LassoSamlSubject **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    delete_LassoSamlSubject(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubject **)&jarg1; 
    result = (char *)LassoSamlSubject_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectConfirmation_1subjectConfirmationData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->SubjectConfirmationData) free((char*)arg1->SubjectConfirmationData);
        if (arg2) {
            arg1->SubjectConfirmationData = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->SubjectConfirmationData,arg2);
        } else {
            arg1->SubjectConfirmationData = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectConfirmation_1subjectConfirmationData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    result = (char *) ((arg1)->SubjectConfirmationData);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectConfirmation_1confirmationMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoSamlSubjectConfirmation_set_confirmationMethod(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectConfirmation_1confirmationMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    result = (LassoStringList *)LassoSamlSubjectConfirmation_get_confirmationMethod(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectConfirmation(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlSubjectConfirmation *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlSubjectConfirmation *)new_LassoSamlSubjectConfirmation();
    
    *(LassoSamlSubjectConfirmation **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectConfirmation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    delete_LassoSamlSubjectConfirmation(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectConfirmation **)&jarg1; 
    result = (char *)LassoSamlSubjectConfirmation_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectLocality_1dnsAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->DNSAddress) free((char*)arg1->DNSAddress);
        if (arg2) {
            arg1->DNSAddress = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->DNSAddress,arg2);
        } else {
            arg1->DNSAddress = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectLocality_1dnsAddress(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    result = (char *) ((arg1)->DNSAddress);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectLocality_1ipAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->IPAddress) free((char*)arg1->IPAddress);
        if (arg2) {
            arg1->IPAddress = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->IPAddress,arg2);
        } else {
            arg1->IPAddress = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectLocality_1ipAddress(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    result = (char *) ((arg1)->IPAddress);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectLocality(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlSubjectLocality *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlSubjectLocality *)new_LassoSamlSubjectLocality();
    
    *(LassoSamlSubjectLocality **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectLocality(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    delete_LassoSamlSubjectLocality(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectLocality **)&jarg1; 
    result = (char *)LassoSamlSubjectLocality_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectStatement_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
    LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatement **)&jarg1; 
    arg2 = *(LassoSamlSubject **)&jarg2; 
    LassoSamlSubjectStatement_set_Subject(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectStatement_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
    LassoSamlSubject *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatement **)&jarg1; 
    result = (LassoSamlSubject *)LassoSamlSubjectStatement_get_Subject(arg1);
    
    *(LassoSamlSubject **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectStatement(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlSubjectStatement *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlSubjectStatement *)new_LassoSamlSubjectStatement();
    
    *(LassoSamlSubjectStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatement **)&jarg1; 
    delete_LassoSamlSubjectStatement(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatement **)&jarg1; 
    result = (char *)LassoSamlSubjectStatement_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlSubjectStatementAbstract_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
    LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatementAbstract **)&jarg1; 
    arg2 = *(LassoSamlSubject **)&jarg2; 
    LassoSamlSubjectStatementAbstract_set_Subject(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlSubjectStatementAbstract_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
    LassoSamlSubject *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatementAbstract **)&jarg1; 
    result = (LassoSamlSubject *)LassoSamlSubjectStatementAbstract_get_Subject(arg1);
    
    *(LassoSamlSubject **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatementAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlSubjectStatementAbstract **)&jarg1; 
    result = (char *)LassoSamlSubjectStatementAbstract_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1assertionArtifact(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AssertionArtifact) free((char*)arg1->AssertionArtifact);
        if (arg2) {
            arg1->AssertionArtifact = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AssertionArtifact,arg2);
        } else {
            arg1->AssertionArtifact = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1assertionArtifact(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *) ((arg1)->AssertionArtifact);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpRequest_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *)LassoSamlpRequest_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpRequest_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *)LassoSamlpRequest_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoSamlpRequest_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (int)LassoSamlpRequest_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoSamlpRequest_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (int)LassoSamlpRequest_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpRequest_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *)LassoSamlpRequest_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpRequest_set_RequestID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *)LassoSamlpRequest_get_RequestID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoSamlpRequest_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (LassoStringList *)LassoSamlpRequest_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoSamlpRequest_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (LassoSignatureMethod)LassoSamlpRequest_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoSamlpRequest_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = LassoSamlpRequest_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpRequest(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlpRequest *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlpRequest *)new_LassoSamlpRequest();
    
    *(LassoSamlpRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    delete_LassoSamlpRequest(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequest **)&jarg1; 
    result = (char *)LassoSamlpRequest_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->certificate_file) free((char*)arg1->certificate_file);
        if (arg2) {
            arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->certificate_file,arg2);
        } else {
            arg1->certificate_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (char *) ((arg1)->certificate_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
        if (arg2) {
            arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->IssueInstant,arg2);
        } else {
            arg1->IssueInstant = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (char *) ((arg1)->IssueInstant);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MajorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (int) ((arg1)->MajorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MinorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (int) ((arg1)->MinorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->private_key_file) free((char*)arg1->private_key_file);
        if (arg2) {
            arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->private_key_file,arg2);
        } else {
            arg1->private_key_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (char *) ((arg1)->private_key_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RequestID) free((char*)arg1->RequestID);
        if (arg2) {
            arg1->RequestID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RequestID,arg2);
        } else {
            arg1->RequestID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (char *) ((arg1)->RequestID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    if (arg1) (arg1)->sign_method = (LassoSignatureMethod )arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (LassoSignatureMethod) ((arg1)->sign_method);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->sign_type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result =  ((arg1)->sign_type);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpRequestAbstract_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoSamlpRequestAbstract_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpRequestAbstract_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (LassoStringList *)LassoSamlpRequestAbstract_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpRequestAbstract **)&jarg1; 
    result = (char *)LassoSamlpRequestAbstract_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1inResponseTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_InResponseTo(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1inResponseTo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_InResponseTo(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoSamlpResponse_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (int)LassoSamlpResponse_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoSamlpResponse_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (int)LassoSamlpResponse_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1recipient(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_Recipient(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1recipient(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_Recipient(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1responseId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoSamlpResponse_set_ResponseID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1responseId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_get_ResponseID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoSamlpResponse_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (LassoSignatureMethod)LassoSamlpResponse_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoSamlpResponse_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = LassoSamlpResponse_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoNodeList *arg2 = (LassoNodeList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    arg2 = *(LassoNodeList **)&jarg2; 
    LassoSamlpResponse_set_Assertion(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (LassoNodeList *)LassoSamlpResponse_get_Assertion(arg1);
    
    *(LassoNodeList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    arg2 = *(LassoSamlpStatus **)&jarg2; 
    LassoSamlpResponse_set_Status(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (LassoSamlpStatus *)LassoSamlpResponse_get_Status(arg1);
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpResponse(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlpResponse *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlpResponse *)new_LassoSamlpResponse();
    
    *(LassoSamlpResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    delete_LassoSamlpResponse(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponse **)&jarg1; 
    result = (char *)LassoSamlpResponse_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->certificate_file) free((char*)arg1->certificate_file);
        if (arg2) {
            arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->certificate_file,arg2);
        } else {
            arg1->certificate_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->certificate_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1inResponseTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->InResponseTo) free((char*)arg1->InResponseTo);
        if (arg2) {
            arg1->InResponseTo = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->InResponseTo,arg2);
        } else {
            arg1->InResponseTo = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1inResponseTo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->InResponseTo);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
        if (arg2) {
            arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->IssueInstant,arg2);
        } else {
            arg1->IssueInstant = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->IssueInstant);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MajorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (int) ((arg1)->MajorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->MinorVersion = arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (int) ((arg1)->MinorVersion);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->private_key_file) free((char*)arg1->private_key_file);
        if (arg2) {
            arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->private_key_file,arg2);
        } else {
            arg1->private_key_file = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->private_key_file);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1recipient(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Recipient) free((char*)arg1->Recipient);
        if (arg2) {
            arg1->Recipient = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Recipient,arg2);
        } else {
            arg1->Recipient = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1recipient(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->Recipient);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1responseId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ResponseID) free((char*)arg1->ResponseID);
        if (arg2) {
            arg1->ResponseID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ResponseID,arg2);
        } else {
            arg1->ResponseID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1responseId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *) ((arg1)->ResponseID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    if (arg1) (arg1)->sign_method = (LassoSignatureMethod )arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (LassoSignatureMethod) ((arg1)->sign_method);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpResponseAbstract_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->sign_type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpResponseAbstract_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result =  ((arg1)->sign_type);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpResponseAbstract **)&jarg1; 
    result = (char *)LassoSamlpResponseAbstract_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpStatus_1statusMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->StatusMessage) free((char*)arg1->StatusMessage);
        if (arg2) {
            arg1->StatusMessage = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->StatusMessage,arg2);
        } else {
            arg1->StatusMessage = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpStatus_1statusMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    result = (char *) ((arg1)->StatusMessage);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpStatus_1statusCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    LassoSamlpStatusCode *arg2 = (LassoSamlpStatusCode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    arg2 = *(LassoSamlpStatusCode **)&jarg2; 
    LassoSamlpStatus_set_StatusCode(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpStatus_1statusCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    LassoSamlpStatusCode *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    result = (LassoSamlpStatusCode *)LassoSamlpStatus_get_StatusCode(arg1);
    
    *(LassoSamlpStatusCode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpStatus(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlpStatus *)new_LassoSamlpStatus();
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    delete_LassoSamlpStatus(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatus **)&jarg1; 
    result = (char *)LassoSamlpStatus_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpStatusCode_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->Value) free((char*)arg1->Value);
        if (arg2) {
            arg1->Value = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->Value,arg2);
        } else {
            arg1->Value = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpStatusCode_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    result = (char *) ((arg1)->Value);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1SamlpStatusCode_1statusCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    LassoSamlpStatusCode *arg2 = (LassoSamlpStatusCode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    arg2 = *(LassoSamlpStatusCode **)&jarg2; 
    LassoSamlpStatusCode_set_StatusCode(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SamlpStatusCode_1statusCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    LassoSamlpStatusCode *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    result = (LassoSamlpStatusCode *)LassoSamlpStatusCode_get_StatusCode(arg1);
    
    *(LassoSamlpStatusCode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpStatusCode(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSamlpStatusCode *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSamlpStatusCode *)new_LassoSamlpStatusCode();
    
    *(LassoSamlpStatusCode **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpStatusCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    delete_LassoSamlpStatusCode(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSamlpStatusCode **)&jarg1; 
    result = (char *)LassoSamlpStatusCode_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1advice(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAdvice *arg2 = (LassoSamlAdvice *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = *(LassoSamlAdvice **)&jarg2; 
    LassoLibAssertion_set_Advice(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1advice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAdvice *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSamlAdvice *)LassoLibAssertion_get_Advice(arg1);
    
    *(LassoSamlAdvice **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1assertionId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAssertion_set_AssertionID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1assertionId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_get_AssertionID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1attributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAttributeStatement *arg2 = (LassoSamlAttributeStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = *(LassoSamlAttributeStatement **)&jarg2; 
    LassoLibAssertion_set_AttributeStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1attributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAttributeStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSamlAttributeStatement *)LassoLibAssertion_get_AttributeStatement(arg1);
    
    *(LassoSamlAttributeStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1authenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAuthenticationStatement *arg2 = (LassoSamlAuthenticationStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = *(LassoSamlAuthenticationStatement **)&jarg2; 
    LassoLibAssertion_set_AuthenticationStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1authenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlAuthenticationStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSamlAuthenticationStatement *)LassoLibAssertion_get_AuthenticationStatement(arg1);
    
    *(LassoSamlAuthenticationStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAssertion_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1conditions(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlConditions *arg2 = (LassoSamlConditions *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = *(LassoSamlConditions **)&jarg2; 
    LassoLibAssertion_set_Conditions(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1conditions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlConditions *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSamlConditions *)LassoLibAssertion_get_Conditions(arg1);
    
    *(LassoSamlConditions **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAssertion_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1issuer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAssertion_set_Issuer(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1issuer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_get_Issuer(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibAssertion_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (int)LassoLibAssertion_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibAssertion_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (int)LassoLibAssertion_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAssertion_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoLibAssertion_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSignatureMethod)LassoLibAssertion_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoLibAssertion_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = LassoLibAssertion_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAssertion_1subjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlSubjectStatement *arg2 = (LassoSamlSubjectStatement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    arg2 = *(LassoSamlSubjectStatement **)&jarg2; 
    LassoLibAssertion_set_SubjectStatement(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAssertion_1subjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    LassoSamlSubjectStatement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (LassoSamlSubjectStatement *)LassoLibAssertion_get_SubjectStatement(arg1);
    
    *(LassoSamlSubjectStatement **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAssertion(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibAssertion *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibAssertion *)new_LassoLibAssertion();
    
    *(LassoLibAssertion **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    delete_LassoLibAssertion(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    char *arg5 = (char *) 0 ;
    LassoLibAssertion *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return 0;
        }
    }
    result = (LassoLibAssertion *)LibAssertion_newFull(arg1,arg2,arg3,arg4,arg5);
    
    *(LassoLibAssertion **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAssertion **)&jarg1; 
    result = (char *)LassoLibAssertion_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1affiliationId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AffiliationID) free((char*)arg1->AffiliationID);
        if (arg2) {
            arg1->AffiliationID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AffiliationID,arg2);
        } else {
            arg1->AffiliationID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1affiliationId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->AffiliationID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1assertionConsumerServiceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AssertionConsumerServiceID) free((char*)arg1->AssertionConsumerServiceID);
        if (arg2) {
            arg1->AssertionConsumerServiceID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AssertionConsumerServiceID,arg2);
        } else {
            arg1->AssertionConsumerServiceID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1assertionConsumerServiceId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->AssertionConsumerServiceID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->consent) free((char*)arg1->consent);
        if (arg2) {
            arg1->consent = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->consent,arg2);
        } else {
            arg1->consent = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->consent);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1forceAuthn(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    if (arg1) (arg1)->ForceAuthn = arg2;
    
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1forceAuthn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (bool) ((arg1)->ForceAuthn);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1isPassive(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    if (arg1) (arg1)->IsPassive = arg2;
    
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1isPassive(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (bool) ((arg1)->IsPassive);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1nameIdPolicy(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->NameIDPolicy) free((char*)arg1->NameIDPolicy);
        if (arg2) {
            arg1->NameIDPolicy = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->NameIDPolicy,arg2);
        } else {
            arg1->NameIDPolicy = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1nameIdPolicy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->NameIDPolicy);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProtocolProfile) free((char*)arg1->ProtocolProfile);
        if (arg2) {
            arg1->ProtocolProfile = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProtocolProfile,arg2);
        } else {
            arg1->ProtocolProfile = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->ProtocolProfile);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAuthnRequest_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *)LassoLibAuthnRequest_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAuthnRequest_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *)LassoLibAuthnRequest_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibAuthnRequest_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (int)LassoLibAuthnRequest_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibAuthnRequest_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (int)LassoLibAuthnRequest_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAuthnRequest_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *)LassoLibAuthnRequest_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibAuthnRequest_set_RequestID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *)LassoLibAuthnRequest_get_RequestID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibAuthnRequest_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibAuthnRequest_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoLibAuthnRequest_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (LassoSignatureMethod)LassoLibAuthnRequest_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoLibAuthnRequest_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = LassoLibAuthnRequest_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibAuthnRequest_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibAuthnRequest_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnRequest_1requestAuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoLibRequestAuthnContext *arg2 = (LassoLibRequestAuthnContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    arg2 = *(LassoLibRequestAuthnContext **)&jarg2; 
    LassoLibAuthnRequest_set_RequestAuthnContext(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnRequest_1requestAuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    LassoLibRequestAuthnContext *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (LassoLibRequestAuthnContext *)LassoLibAuthnRequest_get_RequestAuthnContext(arg1);
    
    *(LassoLibRequestAuthnContext **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAuthnRequest(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibAuthnRequest *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibAuthnRequest *)new_LassoLibAuthnRequest();
    
    *(LassoLibAuthnRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    delete_LassoLibAuthnRequest(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnRequest **)&jarg1; 
    result = (char *)LassoLibAuthnRequest_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnResponse_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->consent) free((char*)arg1->consent);
        if (arg2) {
            arg1->consent = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->consent,arg2);
        } else {
            arg1->consent = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnResponse_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (char *) ((arg1)->consent);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibAuthnResponse_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (LassoStringList *)LassoLibAuthnResponse_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibAuthnResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    arg2 = *(LassoSamlpStatus **)&jarg2; 
    LassoLibAuthnResponse_set_Status(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibAuthnResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (LassoSamlpStatus *)LassoLibAuthnResponse_get_Status(arg1);
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAuthnResponse(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoLibAuthnRequest *arg2 = (LassoLibAuthnRequest *) 0 ;
    LassoLibAuthnResponse *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = *(LassoLibAuthnRequest **)&jarg2; 
    result = (LassoLibAuthnResponse *)new_LassoLibAuthnResponse(arg1,arg2);
    
    *(LassoLibAuthnResponse **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAuthnResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    delete_LassoLibAuthnResponse(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibAuthnResponse **)&jarg1; 
    result = (char *)LassoLibAuthnResponse_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->consent) free((char*)arg1->consent);
        if (arg2) {
            arg1->consent = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->consent,arg2);
        } else {
            arg1->consent = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *) ((arg1)->consent);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibFederationTerminationNotification_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *)LassoLibFederationTerminationNotification_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibFederationTerminationNotification_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *)LassoLibFederationTerminationNotification_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibFederationTerminationNotification_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (int)LassoLibFederationTerminationNotification_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibFederationTerminationNotification_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (int)LassoLibFederationTerminationNotification_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibFederationTerminationNotification_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *)LassoLibFederationTerminationNotification_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibFederationTerminationNotification_set_RequestID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *)LassoLibFederationTerminationNotification_get_RequestID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibFederationTerminationNotification_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (LassoStringList *)LassoLibFederationTerminationNotification_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoLibFederationTerminationNotification_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (LassoSignatureMethod)LassoLibFederationTerminationNotification_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoLibFederationTerminationNotification_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = LassoLibFederationTerminationNotification_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibFederationTerminationNotification_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (LassoStringList *)LassoLibFederationTerminationNotification_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibFederationTerminationNotification_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLibFederationTerminationNotification_set_NameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibFederationTerminationNotification_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLibFederationTerminationNotification_get_NameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibFederationTerminationNotification(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibFederationTerminationNotification *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibFederationTerminationNotification *)new_LassoLibFederationTerminationNotification();
    
    *(LassoLibFederationTerminationNotification **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibFederationTerminationNotification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    delete_LassoLibFederationTerminationNotification(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    LassoSignatureType arg3 ;
    LassoSignatureMethod arg4 ;
    LassoLibFederationTerminationNotification *result;
    LassoSignatureType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    argp3 = *(LassoSignatureType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return 0;
    }
    arg3 = *argp3; 
    arg4 = (LassoSignatureMethod)jarg4; 
    result = (LassoLibFederationTerminationNotification *)LibFederationTerminationNotification_newFull(arg1,arg2,arg3,(LassoSignatureMethod )arg4);
    
    *(LassoLibFederationTerminationNotification **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibFederationTerminationNotification **)&jarg1; 
    result = (char *)LassoLibFederationTerminationNotification_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->consent) free((char*)arg1->consent);
        if (arg2) {
            arg1->consent = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->consent,arg2);
        } else {
            arg1->consent = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *) ((arg1)->consent);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1notOnOrAfter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
        if (arg2) {
            arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->NotOnOrAfter,arg2);
        } else {
            arg1->NotOnOrAfter = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1notOnOrAfter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *) ((arg1)->NotOnOrAfter);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1sessionIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->SessionIndex) free((char*)arg1->SessionIndex);
        if (arg2) {
            arg1->SessionIndex = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->SessionIndex,arg2);
        } else {
            arg1->SessionIndex = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1sessionIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *) ((arg1)->SessionIndex);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutRequest_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *)LassoLibLogoutRequest_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutRequest_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *)LassoLibLogoutRequest_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibLogoutRequest_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (int)LassoLibLogoutRequest_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibLogoutRequest_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (int)LassoLibLogoutRequest_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutRequest_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *)LassoLibLogoutRequest_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutRequest_set_RequestID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *)LassoLibLogoutRequest_get_RequestID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibLogoutRequest_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibLogoutRequest_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoLibLogoutRequest_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (LassoSignatureMethod)LassoLibLogoutRequest_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoLibLogoutRequest_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = LassoLibLogoutRequest_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibLogoutRequest_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibLogoutRequest_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutRequest_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLibLogoutRequest_set_NameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutRequest_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLibLogoutRequest_get_NameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibLogoutRequest(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibLogoutRequest *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibLogoutRequest *)new_LassoLibLogoutRequest();
    
    *(LassoLibLogoutRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibLogoutRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    delete_LassoLibLogoutRequest(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    LassoSignatureType arg3 ;
    LassoSignatureMethod arg4 ;
    LassoLibLogoutRequest *result;
    LassoSignatureType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    argp3 = *(LassoSignatureType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return 0;
    }
    arg3 = *argp3; 
    arg4 = (LassoSignatureMethod)jarg4; 
    result = (LassoLibLogoutRequest *)LibLogoutRequest_newFull(arg1,arg2,arg3,(LassoSignatureMethod )arg4);
    
    *(LassoLibLogoutRequest **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutRequest **)&jarg1; 
    result = (char *)LassoLibLogoutRequest_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibLogoutResponse_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    result = (LassoStringList *)LassoLibLogoutResponse_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutResponse_set_ProviderID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    result = (char *)LassoLibLogoutResponse_get_ProviderID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibLogoutResponse_set_RelayState(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    result = (char *)LassoLibLogoutResponse_get_RelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibLogoutResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    arg2 = *(LassoSamlpStatus **)&jarg2; 
    LassoLibLogoutResponse_set_Status(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibLogoutResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    result = (LassoSamlpStatus *)LassoLibLogoutResponse_get_Status(arg1);
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibLogoutResponse(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibLogoutResponse *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibLogoutResponse *)new_LassoLibLogoutResponse();
    
    *(LassoLibLogoutResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibLogoutResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    delete_LassoLibLogoutResponse(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoLibLogoutRequest *arg3 = (LassoLibLogoutRequest *) 0 ;
    LassoSignatureType arg4 ;
    LassoSignatureMethod arg5 ;
    LassoLibLogoutResponse *result;
    LassoSignatureType *argp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(LassoLibLogoutRequest **)&jarg3; 
    argp4 = *(LassoSignatureType **)&jarg4; 
    if (!argp4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return 0;
    }
    arg4 = *argp4; 
    arg5 = (LassoSignatureMethod)jarg5; 
    result = (LassoLibLogoutResponse *)LibLogoutResponse_newFull(arg1,(char const *)arg2,arg3,arg4,(LassoSignatureMethod )arg5);
    
    *(LassoLibLogoutResponse **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibLogoutResponse **)&jarg1; 
    result = (char *)LassoLibLogoutResponse_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierRequest_set_certificate_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1certificateFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierRequest_get_certificate_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierRequest_set_IssueInstant(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1issueInstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierRequest_get_IssueInstant(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_MajorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1majorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (int)LassoLibRegisterNameIdentifierRequest_get_MajorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = (int)jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_MinorVersion(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1minorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (int)LassoLibRegisterNameIdentifierRequest_get_MinorVersion(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierRequest_set_private_key_file(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1privateKeyFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierRequest_get_private_key_file(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierRequest_set_RequestID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1requestId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierRequest_get_RequestID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_RespondWith(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1respondWith(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibRegisterNameIdentifierRequest_get_RespondWith(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_sign_method(arg1,(LassoSignatureMethod )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1signMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoSignatureMethod)LassoLibRegisterNameIdentifierRequest_get_sign_method(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSignatureType arg2 ;
    LassoSignatureType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    argp2 = *(LassoSignatureType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return ;
    }
    arg2 = *argp2; 
    LassoLibRegisterNameIdentifierRequest_set_sign_type(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1signType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSignatureType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = LassoLibRegisterNameIdentifierRequest_get_sign_type(arg1);
    
    {
        LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
        memmove(resultptr, &result, sizeof(LassoSignatureType));
        *(LassoSignatureType **)&jresult = resultptr;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoStringList *)LassoLibRegisterNameIdentifierRequest_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1idpProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_IDPProvidedNameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1idpProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_get_IDPProvidedNameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1oldProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_OldProvidedNameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1oldProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_get_OldProvidedNameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierRequest_1spProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLibRegisterNameIdentifierRequest_set_SPProvidedNameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierRequest_1spProvidedNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_get_SPProvidedNameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRegisterNameIdentifierRequest(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibRegisterNameIdentifierRequest *)new_LassoLibRegisterNameIdentifierRequest();
    
    *(LassoLibRegisterNameIdentifierRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRegisterNameIdentifierRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    delete_LassoLibRegisterNameIdentifierRequest(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    LassoSamlNameIdentifier *arg3 = (LassoSamlNameIdentifier *) 0 ;
    LassoSamlNameIdentifier *arg4 = (LassoSamlNameIdentifier *) 0 ;
    LassoSignatureType arg5 ;
    LassoSignatureMethod arg6 ;
    LassoLibRegisterNameIdentifierRequest *result;
    LassoSignatureType *argp5 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    arg3 = *(LassoSamlNameIdentifier **)&jarg3; 
    arg4 = *(LassoSamlNameIdentifier **)&jarg4; 
    argp5 = *(LassoSignatureType **)&jarg5; 
    if (!argp5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return 0;
    }
    arg5 = *argp5; 
    arg6 = (LassoSignatureMethod)jarg6; 
    result = (LassoLibRegisterNameIdentifierRequest *)LibRegisterNameIdentifierRequest_newFull(arg1,arg2,arg3,arg4,arg5,(LassoSignatureMethod )arg6);
    
    *(LassoLibRegisterNameIdentifierRequest **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierRequest **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierRequest_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibRegisterNameIdentifierResponse_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    result = (LassoStringList *)LassoLibRegisterNameIdentifierResponse_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierResponse_set_ProviderID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierResponse_get_ProviderID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLibRegisterNameIdentifierResponse_set_RelayState(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierResponse_get_RelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRegisterNameIdentifierResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    arg2 = *(LassoSamlpStatus **)&jarg2; 
    LassoLibRegisterNameIdentifierResponse_set_Status(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRegisterNameIdentifierResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    result = (LassoSamlpStatus *)LassoLibRegisterNameIdentifierResponse_get_Status(arg1);
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRegisterNameIdentifierResponse(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibRegisterNameIdentifierResponse *)new_LassoLibRegisterNameIdentifierResponse();
    
    *(LassoLibRegisterNameIdentifierResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRegisterNameIdentifierResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    delete_LassoLibRegisterNameIdentifierResponse(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoLibRegisterNameIdentifierRequest *arg3 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
    LassoSignatureType arg4 ;
    LassoSignatureMethod arg5 ;
    LassoLibRegisterNameIdentifierResponse *result;
    LassoSignatureType *argp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(LassoLibRegisterNameIdentifierRequest **)&jarg3; 
    argp4 = *(LassoSignatureType **)&jarg4; 
    if (!argp4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
        return 0;
    }
    arg4 = *argp4; 
    arg5 = (LassoSignatureMethod)jarg5; 
    result = (LassoLibRegisterNameIdentifierResponse *)LibRegisterNameIdentifierResponse_newFull(arg1,arg2,arg3,arg4,(LassoSignatureMethod )arg5);
    
    *(LassoLibRegisterNameIdentifierResponse **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRegisterNameIdentifierResponse **)&jarg1; 
    result = (char *)LassoLibRegisterNameIdentifierResponse_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRequestAuthnContext_1authnContextComparison(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->AuthnContextComparison) free((char*)arg1->AuthnContextComparison);
        if (arg2) {
            arg1->AuthnContextComparison = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->AuthnContextComparison,arg2);
        } else {
            arg1->AuthnContextComparison = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRequestAuthnContext_1authnContextComparison(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    result = (char *) ((arg1)->AuthnContextComparison);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRequestAuthnContext_1authnContextClassRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibRequestAuthnContext_set_authnContextClassRef(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRequestAuthnContext_1authnContextClassRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    result = (LassoStringList *)LassoLibRequestAuthnContext_get_authnContextClassRef(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibRequestAuthnContext_1authnContextStatementRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibRequestAuthnContext_set_authnContextStatementRef(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibRequestAuthnContext_1authnContextStatementRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    result = (LassoStringList *)LassoLibRequestAuthnContext_get_authnContextStatementRef(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRequestAuthnContext(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibRequestAuthnContext *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibRequestAuthnContext *)new_LassoLibRequestAuthnContext();
    
    *(LassoLibRequestAuthnContext **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRequestAuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    delete_LassoLibRequestAuthnContext(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibRequestAuthnContext **)&jarg1; 
    result = (char *)LassoLibRequestAuthnContext_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibStatusResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibStatusResponse_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibStatusResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->RelayState) free((char*)arg1->RelayState);
        if (arg2) {
            arg1->RelayState = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->RelayState,arg2);
        } else {
            arg1->RelayState = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibStatusResponse_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    result = (char *) ((arg1)->RelayState);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibStatusResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    LassoStringList *arg2 = (LassoStringList *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    arg2 = *(LassoStringList **)&jarg2; 
    LassoLibStatusResponse_set_Extension(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibStatusResponse_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    result = (LassoStringList *)LassoLibStatusResponse_get_Extension(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LibStatusResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    arg2 = *(LassoSamlpStatus **)&jarg2; 
    LassoLibStatusResponse_set_Status(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LibStatusResponse_1status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    LassoSamlpStatus *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    result = (LassoSamlpStatus *)LassoLibStatusResponse_get_Status(arg1);
    
    *(LassoSamlpStatus **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibStatusResponse(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoLibStatusResponse *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoLibStatusResponse *)new_LassoLibStatusResponse();
    
    *(LassoLibStatusResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibStatusResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    delete_LassoLibStatusResponse(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLibStatusResponse **)&jarg1; 
    result = (char *)LassoLibStatusResponse_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Provider_1caCertChain(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ca_cert_chain) free((char*)arg1->ca_cert_chain);
        if (arg2) {
            arg1->ca_cert_chain = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ca_cert_chain,arg2);
        } else {
            arg1->ca_cert_chain = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Provider_1caCertChain(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *) ((arg1)->ca_cert_chain);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Provider_1metadataFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->metadata_filename) free((char*)arg1->metadata_filename);
        if (arg2) {
            arg1->metadata_filename = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->metadata_filename,arg2);
        } else {
            arg1->metadata_filename = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Provider_1metadataFilename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *) ((arg1)->metadata_filename);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Provider_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->ProviderID) free((char*)arg1->ProviderID);
        if (arg2) {
            arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->ProviderID,arg2);
        } else {
            arg1->ProviderID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Provider_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *) ((arg1)->ProviderID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Provider_1publicKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->public_key) free((char*)arg1->public_key);
        if (arg2) {
            arg1->public_key = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->public_key,arg2);
        } else {
            arg1->public_key = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Provider_1publicKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *) ((arg1)->public_key);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Provider_1role(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    LassoProviderRole arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    arg2 = (LassoProviderRole)jarg2; 
    if (arg1) (arg1)->role = (LassoProviderRole )arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Provider_1role(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    LassoProviderRole result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (LassoProviderRole) ((arg1)->role);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Provider(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    jlong jresult = 0 ;
    LassoProviderRole arg1 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    LassoProvider *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (LassoProviderRole)jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (LassoProvider *)new_LassoProvider((LassoProviderRole )arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
    
    *(LassoProvider **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Provider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    delete_LassoProvider(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoProvider *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoProvider *)Provider_newFromDump(arg1);
    
    *(LassoProvider **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *)LassoProvider_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1acceptHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jboolean jarg5) {
    jboolean jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    LassoProvider *arg2 = (LassoProvider *) 0 ;
    LassoMdProtocolType arg3 ;
    LassoHttpMethod arg4 ;
    bool arg5 ;
    bool result;
    LassoMdProtocolType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    arg2 = *(LassoProvider **)&jarg2; 
    argp3 = *(LassoMdProtocolType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg3 = *argp3; 
    arg4 = (LassoHttpMethod)jarg4; 
    arg5 = jarg5 ? true : false; 
    result = (bool)LassoProvider_acceptHttpMethod(arg1,arg2,arg3,(LassoHttpMethod )arg4,arg5);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getAssertionConsumerServiceUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)LassoProvider_getAssertionConsumerServiceUrl(arg1,arg2);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getBase64SuccinctId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *)LassoProvider_getBase64SuccinctId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getOrganization(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    result = (char *)LassoProvider_getOrganization(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getFirstHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    LassoProvider *arg2 = (LassoProvider *) 0 ;
    LassoMdProtocolType arg3 ;
    LassoHttpMethod result;
    LassoMdProtocolType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    arg2 = *(LassoProvider **)&jarg2; 
    argp3 = *(LassoMdProtocolType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg3 = *argp3; 
    result = (LassoHttpMethod)LassoProvider_getFirstHttpMethod(arg1,arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getMetadataOne(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)LassoProvider_getMetadataOne(arg1,arg2);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1hasProtocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jboolean jresult = 0 ;
    LassoProvider *arg1 = (LassoProvider *) 0 ;
    LassoMdProtocolType arg2 ;
    char *arg3 = (char *) 0 ;
    bool result;
    LassoMdProtocolType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoProvider **)&jarg1; 
    argp2 = *(LassoMdProtocolType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg2 = *argp2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (bool)LassoProvider_hasProtocolProfile(arg1,arg2,arg3);
    
    jresult = (jboolean)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1certificate(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->certificate) free((char*)arg1->certificate);
        if (arg2) {
            arg1->certificate = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->certificate,arg2);
        } else {
            arg1->certificate = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1certificate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *) ((arg1)->certificate);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1privateKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->private_key) free((char*)arg1->private_key);
        if (arg2) {
            arg1->private_key = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->private_key,arg2);
        } else {
            arg1->private_key = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1privateKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *) ((arg1)->private_key);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1privateKeyPassword(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->private_key_password) free((char*)arg1->private_key_password);
        if (arg2) {
            arg1->private_key_password = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->private_key_password,arg2);
        } else {
            arg1->private_key_password = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1privateKeyPassword(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *) ((arg1)->private_key_password);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1signatureMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoSignatureMethod arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = (LassoSignatureMethod)jarg2; 
    if (arg1) (arg1)->signature_method = (LassoSignatureMethod )arg2;
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1signatureMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoSignatureMethod result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoSignatureMethod) ((arg1)->signature_method);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1caCertChain(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoServer_set_ca_cert_chain(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1caCertChain(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_get_ca_cert_chain(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1metadataFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoServer_set_metadata_filename(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1metadataFilename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_get_metadata_filename(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoServer_set_ProviderID(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_get_ProviderID(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1publicKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoServer_set_public_key(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1publicKey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_get_public_key(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Server_1role(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoProviderRole arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = (LassoProviderRole)jarg2; 
    LassoServer_set_role(arg1,(LassoProviderRole )arg2);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1role(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoProviderRole result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoProviderRole)LassoServer_get_role(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1providerIds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoStringList *)LassoServer_get_providerIds(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Server(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    jlong jresult = 0 ;
    char *arg1 = (char *) NULL ;
    char *arg2 = (char *) NULL ;
    char *arg3 = (char *) NULL ;
    char *arg4 = (char *) NULL ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (LassoServer *)new_LassoServer(arg1,arg2,arg3,arg4);
    
    *(LassoServer **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    delete_LassoServer(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoServer *)Server_newFromDump(arg1);
    
    *(LassoServer **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1acceptHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jboolean jarg5) {
    jboolean jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoProvider *arg2 = (LassoProvider *) 0 ;
    LassoMdProtocolType arg3 ;
    LassoHttpMethod arg4 ;
    bool arg5 ;
    bool result;
    LassoMdProtocolType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = *(LassoProvider **)&jarg2; 
    argp3 = *(LassoMdProtocolType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg3 = *argp3; 
    arg4 = (LassoHttpMethod)jarg4; 
    arg5 = jarg5 ? true : false; 
    result = (bool)LassoServer_acceptHttpMethod(arg1,arg2,arg3,(LassoHttpMethod )arg4,arg5);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getAssertionConsumerServiceUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)LassoServer_getAssertionConsumerServiceUrl(arg1,arg2);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getBase64SuccinctId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_getBase64SuccinctId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getOrganization(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_getOrganization(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getFirstHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoProvider *arg2 = (LassoProvider *) 0 ;
    LassoMdProtocolType arg3 ;
    LassoHttpMethod result;
    LassoMdProtocolType *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = *(LassoProvider **)&jarg2; 
    argp3 = *(LassoMdProtocolType **)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg3 = *argp3; 
    result = (LassoHttpMethod)LassoServer_getFirstHttpMethod(arg1,arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getMetadataOne(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)LassoServer_getMetadataOne(arg1,arg2);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1hasProtocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jboolean jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoMdProtocolType arg2 ;
    char *arg3 = (char *) 0 ;
    bool result;
    LassoMdProtocolType *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    argp2 = *(LassoMdProtocolType **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoMdProtocolType");
        return 0;
    }
    arg2 = *argp2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (bool)LassoServer_hasProtocolProfile(arg1,arg2,arg3);
    
    jresult = (jboolean)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1addProvider(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
    jint jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoProviderRole arg2 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) NULL ;
    char *arg5 = (char *) NULL ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = (LassoProviderRole)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoServer_addProvider(arg1,(LassoProviderRole )arg2,arg3,arg4,arg5);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getProvider(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoProvider *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoProvider *)LassoServer_getProvider(arg1,arg2);
    
    *(LassoProvider **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Federation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->remote_providerID) free((char*)arg1->remote_providerID);
        if (arg2) {
            arg1->remote_providerID = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->remote_providerID,arg2);
        } else {
            arg1->remote_providerID = 0;
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Federation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    result = (char *) ((arg1)->remote_providerID);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Federation_1localNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoFederation_set_local_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Federation_1localNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoFederation_get_local_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Federation_1remoteNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoFederation_set_remote_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Federation_1remoteNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoFederation_get_remote_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Federation(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoFederation *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoFederation *)new_LassoFederation(arg1);
    
    *(LassoFederation **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Federation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    delete_LassoFederation(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    result = (char *)LassoFederation_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1buildLocalNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    LassoFederation_buildLocalNameIdentifier(arg1,arg2,arg3,arg4);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1verifyNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    LassoFederation *arg1 = (LassoFederation *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoFederation **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    result = (bool)LassoFederation_verifyNameIdentifier(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Identity_1isDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    result = (bool) ((arg1)->is_dirty);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Identity_1providerIds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    result = (LassoStringList *)LassoIdentity_get_providerIds(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Identity(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoIdentity *)new_LassoIdentity();
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    delete_LassoIdentity(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoIdentity *)Identity_newFromDump(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    result = (char *)LassoIdentity_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1getFederation(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoFederation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoFederation *)LassoIdentity_getFederation(arg1,arg2);
    
    *(LassoFederation **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Session_1isDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    result = (bool) ((arg1)->is_dirty);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Session_1providerIds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    LassoStringList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    result = (LassoStringList *)LassoSession_get_providerIds(arg1);
    
    *(LassoStringList **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Session(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSession *)new_LassoSession();
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSession *arg1 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    delete_LassoSession(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoSession *)Session_newFromDump(arg1);
    
    *(LassoSession **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    result = (char *)LassoSession_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1getAssertions(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoNodeList *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoNodeList *)LassoSession_getAssertions(arg1,arg2);
    
    *(LassoNodeList **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_getRequestTypeFromSoapMsg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jint jresult = 0 ;
    char *arg1 = (char *) 0 ;
    LassoRequestType result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoRequestType)lasso_profile_get_request_type_from_soap_msg(arg1);
    
    jresult = (jint)result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_isLibertyQuery(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jboolean jresult = 0 ;
    char *arg1 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (bool)lasso_profile_is_liberty_query(arg1);
    
    jresult = (jboolean)result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoDefederation_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoIdentity *)LassoDefederation_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (bool)LassoDefederation_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (bool)LassoDefederation_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoDefederation_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoDefederation_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoDefederation_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoDefederation_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoDefederation_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoDefederation_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoDefederation_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoDefederation_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoServer *)LassoDefederation_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoDefederation_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoSession *)LassoDefederation_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoDefederation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoDefederation *)new_LassoDefederation(arg1);
    
    *(LassoDefederation **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    delete_LassoDefederation(arg1);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1buildNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_buildNotificationMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1initNotification(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 = (char *) NULL ;
    LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (LassoHttpMethod)jarg3; 
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_initNotification(arg1,arg2,(LassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1processNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_processNotificationMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1validateNotification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoDefederation_validateNotification(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1assertionArtifact(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *) ((arg1)->assertionArtifact);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoLoginProtocolProfile result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoLoginProtocolProfile) ((arg1)->protocolProfile);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLogin_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoIdentity *)LassoLogin_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLogin_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLogin_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogin_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoLogin_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoLogin_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoLogin_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoLogin_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoLogin_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoServer *)LassoLogin_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLogin_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoSession *)LassoLogin_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoLogin *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoLogin *)new_LassoLogin(arg1);
    
    *(LassoLogin **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    delete_LassoLogin(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoLogin *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoLogin *)Login_newFromDump(arg1,arg2);
    
    *(LassoLogin **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1acceptSso(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_acceptSso(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildArtifactMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoHttpMethod arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = (LassoHttpMethod)jarg2; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildArtifactMsg(arg1,(LassoHttpMethod )arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    char *arg5 = (char *) 0 ;
    char *arg6 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return 0;
        }
    }
    {
        arg6 = 0;
        if (jarg6) {
            arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
            if (!arg6) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildAssertion(arg1,arg2,arg3,arg4,arg5,arg6);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildAuthnRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildAuthnResponseMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_buildResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) NULL ;
    LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_REDIRECT ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (LassoHttpMethod)jarg3; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_initAuthnRequest(arg1,arg2,(LassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_REDIRECT ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (LassoHttpMethod)jarg3; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_initRequest(arg1,arg2,(LassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initIdpInitiatedAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) NULL ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_initIdpInitiatedAuthnRequest(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1mustAskForConsent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_mustAskForConsent(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1mustAuthenticate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_mustAuthenticate(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_processAuthnRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_processAuthnResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_processRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_processResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setResourceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_setResourceId(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1validateRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jboolean jarg3) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool arg2 ;
    bool arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    arg3 = jarg3 ? true : false; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogin_validateRequestMsg(arg1,arg2,arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLogout_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoIdentity *)LassoLogout_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (bool)LassoLogout_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (bool)LassoLogout_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLogout_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLogout_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogout_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoLogout_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoLogout_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoLogout_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoLogout_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoLogout_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoServer *)LassoLogout_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLogout_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoSession *)LassoLogout_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoLogout *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoLogout *)new_LassoLogout(arg1);
    
    *(LassoLogout **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    delete_LassoLogout(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoLogout *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoLogout *)Logout_newFromDump(arg1,arg2);
    
    *(LassoLogout **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_buildResponseMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1getNextProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_getNextProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) NULL ;
    LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (LassoHttpMethod)jarg3; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_initRequest(arg1,arg2,(LassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_processRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_processResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1resetProviderIdIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_resetProviderIdIndex(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLogout_validateRequest(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLecp_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoIdentity *)LassoLecp_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (bool)LassoLecp_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (bool)LassoLecp_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoLecp_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoLecp_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLecp_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoLecp_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoLecp_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoLecp_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoLecp_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoLecp_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoServer *)LassoLecp_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLecp_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoSession *)LassoLecp_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoLecp *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoLecp *)new_LassoLecp(arg1);
    
    *(LassoLecp **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    delete_LassoLecp(arg1);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    char *arg5 = (char *) 0 ;
    char *arg6 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return 0;
        }
    }
    {
        arg6 = 0;
        if (jarg6) {
            arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
            if (!arg6) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_buildAssertion(arg1,arg2,arg3,arg4,arg5,arg6);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setResourceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_setResourceId(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1validateRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jboolean jarg3) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    bool arg2 ;
    bool arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    arg3 = jarg3 ? true : false; 
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_validateRequestMsg(arg1,arg2,arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_buildAuthnRequestEnvelopeMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_buildAuthnRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_buildAuthnResponseEnvelopeMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_buildAuthnResponseMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) NULL ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_initAuthnRequest(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_processAuthnRequestEnvelopeMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_processAuthnRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoLecp_processAuthnResponseEnvelopeMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1targetNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (char *) ((arg1)->targetNameIdentifier);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoNameIdentifierMapping_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoIdentity *)LassoNameIdentifierMapping_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (bool)LassoNameIdentifierMapping_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (bool)LassoNameIdentifierMapping_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (char *)LassoNameIdentifierMapping_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (char *)LassoNameIdentifierMapping_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoNameIdentifierMapping_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoNameIdentifierMapping_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoNameIdentifierMapping_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (char *)LassoNameIdentifierMapping_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoNameIdentifierMapping_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoNameIdentifierMapping_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoNameIdentifierMapping_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoNameIdentifierMapping_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoNameIdentifierMapping_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoServer *)LassoNameIdentifierMapping_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameIdentifierMapping_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoNameIdentifierMapping_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameIdentifierMapping_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    result = (LassoSession *)LassoNameIdentifierMapping_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NameIdentifierMapping(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoNameIdentifierMapping *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoNameIdentifierMapping *)new_LassoNameIdentifierMapping(arg1);
    
    *(LassoNameIdentifierMapping **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NameIdentifierMapping(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    delete_LassoNameIdentifierMapping(arg1);
    
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_buildResponseMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) NULL ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_initRequest(arg1,arg2,arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_processRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_processResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameIdentifierMapping **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameIdentifierMapping_validateRequest(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoNameRegistration_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoIdentity *)LassoNameRegistration_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (bool)LassoNameRegistration_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (bool)LassoNameRegistration_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (char *)LassoNameRegistration_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (char *)LassoNameRegistration_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (char *)LassoNameRegistration_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoNameRegistration_set_nameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoNameRegistration_get_nameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoNameRegistration_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (char *)LassoNameRegistration_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlpRequestAbstract *arg2 = (LassoSamlpRequestAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoSamlpRequestAbstract **)&jarg2; 
    LassoNameRegistration_set_request(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlpRequestAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoSamlpRequestAbstract *)LassoNameRegistration_get_request(arg1);
    
    *(LassoSamlpRequestAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1response(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlpResponseAbstract *arg2 = (LassoSamlpResponseAbstract *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoSamlpResponseAbstract **)&jarg2; 
    LassoNameRegistration_set_response(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlpResponseAbstract *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoSamlpResponseAbstract *)LassoNameRegistration_get_response(arg1);
    
    *(LassoSamlpResponseAbstract **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoServer *arg2 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoServer **)&jarg2; 
    LassoNameRegistration_set_server(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoServer *)LassoNameRegistration_get_server(arg1);
    
    *(LassoServer **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoNameRegistration_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoSession *)LassoNameRegistration_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1NameRegistration_1oldNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    arg2 = *(LassoSamlNameIdentifier **)&jarg2; 
    LassoNameRegistration_set_oldNameIdentifier(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1NameRegistration_1oldNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    LassoSamlNameIdentifier *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (LassoSamlNameIdentifier *)LassoNameRegistration_get_oldNameIdentifier(arg1);
    
    *(LassoSamlNameIdentifier **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NameRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoNameRegistration *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoNameRegistration *)new_LassoNameRegistration(arg1);
    
    *(LassoNameRegistration **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NameRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    delete_LassoNameRegistration(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoNameRegistration *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoNameRegistration *)NameRegistration_newFromDump(arg1,arg2);
    
    *(LassoNameRegistration **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_buildResponseMsg(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    result = (char *)LassoNameRegistration_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    g_free(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (LassoHttpMethod)jarg3; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_initRequest(arg1,arg2,(LassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_processRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_processResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoNameRegistration **)&jarg1; 
    {
        int errorCode;
        errorCode = result = (int)LassoNameRegistration_validateRequest(arg1);
        
        if (errorCode) {
            char errorMsg[256];
            int swig_error = SWIG_RuntimeError;
            if (errorCode == -501 || 
            errorCode == -501) {
                swig_error = SWIG_ValueError;
            }
            build_exception_msg(errorCode, errorMsg);
            SWIG_exception(swig_error, errorMsg);
        }
    }
    jresult = (jint)result; 
    return jresult;
}


#ifdef __cplusplus
}
#endif

