TEMPLATE = app
TARGET = killer
QT -= core gui
CONFIG -= qt
CONFIG += console

include( ../../definitions.pro.inc )

HEADERS = stdafx.h

SOURCES = stdafx.cpp \
          KillProcess.h \
          Killer.cpp

LIBS -= -lLastFmTools$$EXT
LIBS += -lshell32 -luser32
          
# Link CRT statically into exe as we need to run it from Temp
QMAKE_CXXFLAGS_RELEASE -= -MD
QMAKE_CXXFLAGS_RELEASE += -MT

# Don't want Unicode as that might not work on Win98
DEFINES -= UNICODE          

TOOLS_DIR = $$ROOT_DIR\tools

# Set up target for the automatic version updating
versionTarget.target   = dummy
versionTarget.commands = $${TOOLS_DIR}\VersionUpdater.exe version.h $$VERSION_UPDATE_PATTERN \
						 Killer.rc			$${BUILD_DIR}/Killer.i.rc \
						 trustInfo.manifest $${BUILD_DIR}/trustInfo.i.manifest

# Tell qmake that this targets should get built
QMAKE_EXTRA_TARGETS += versionTarget

# Ensure this target is built before the main target
PRE_TARGETDEPS += $$versionTarget.target

RC_FILE = $${BUILD_DIR}/Killer.i.rc

COMPILER_IS_2005 = $$system( echo %QMAKESPEC% | find \"msvc2005\" )
isEmpty( COMPILER_IS_2005 ) {
	# If we're building with 2003.NET, no manifest will have been embedded so use -outputresource
	QMAKE_POST_LINK = mt.exe -manifest $${BUILD_DIR}/trustInfo.i.manifest \
				             -outputresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"
} else {
	# If we're building with 2005, the linker has embedded a manifest and we need -updateresource
	QMAKE_POST_LINK = mt.exe -manifest $${BUILD_DIR}/trustInfo.i.manifest \
				             -updateresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"
}
