/***************************************************************************
 *   Copyright (C) 2007 by                                                 *
 *      Philipp Maihart, Last.fm Ltd <phil@last.fm>                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef TAGLISTWIDGET_H
#define TAGLISTWIDGET_H

#include <QtGui>
#include <QtCore>
#include <QMenu>

namespace Tags
{
    enum SortOrder
    {
        MostPopularOrder,
        AscendingOrder,
        DescendingOrder
    };
}

class TagListWidget : public QListWidget
{
    Q_OBJECT
    
    public:
        TagListWidget( QWidget* parent = 0 );
        void setSortOrder( Tags::SortOrder sortOrder );
        Tags::SortOrder sortOrder() { return m_sortOrder; };
        virtual void addItem( const QString & label );
        virtual void addItems( const QStringList & labels );
    
    private:
        QMenu m_sortTagsMenu;
        QStringList m_tags;
        Tags::SortOrder m_sortOrder;
        
        QAction* m_actionSortMostPopular;
        QAction* m_actionSortAZ;
        QAction* m_actionSortZA;
        
    private slots:
        void showSortContextMenu( const QPoint& point );
    
        void sortAZ();
        void sortZA();
        void sortMostPopular();
};

#endif // TAGLISTWIDGET_H
