/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Erik Jalevik, Last.fm Ltd <erik@last.fm>                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef TRACKPROGRESSFRAME_H
#define TRACKPROGRESSFRAME_H

#include "progressframe.h"
#include <QToolTip>

class TrackProgressFrame : public ProgressFrame
{
    Q_OBJECT

public:

    TrackProgressFrame( QWidget *parent = 0 );

    // Either radio or local media player
    void setMode( TrackInfo::Source mode );
    
    void setScrobbledGradient( const QLinearGradient& sg ) { m_scrobbledGradient = sg; }
    void setTrackLength( int len ) { m_trackLength = len; }
    void setScrobblingEnabled( bool en );

public slots:

    void setNewTrack( const MetaData& track );

protected:

    virtual void mouseMoveEvent( QMouseEvent* event );
    virtual void mousePressEvent( QMouseEvent* event );

    virtual void paintEvent( QPaintEvent * event );
    virtual QRect paintClock( QPainter* painter, QRect rect );

private:

    bool isScrobblable();

    TrackInfo::Source m_mode;
    int m_trackLength;
    QLinearGradient m_scrobbledGradient;
    bool m_scrobblingEnabled;
    bool m_scrobbled;

    // Keeps track of the user clicks of the clock, if false shows scrobble time
    bool m_clockShowsTrackTime;

private slots:

};

#endif // TRACKPROGRESSFRAME_H
