/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef CONFIGWIZARD_H
#define CONFIGWIZARD_H

#ifdef WIN32
    #include "simplewizard_win.h"
#else
    #include "simplewizard_mac.h"
#endif

#include "wizardinfopage.h"
#include "wizardloginpage.h"
#include "wizardprogresspage.h"
#include "wizardselectpluginpage.h"
#include "wizardbootstrappage.h"
#include "wizardconfirmpage.h"
#include "wizardmediadeviceconfirmpage.h"
#include "updateinfogetter.h"
#include "autoupdater.h"
#include "mediadevices/mediadevice.h"

#include <vector>

#ifdef WIN32
    typedef SimpleWizardWin BaseWizard;
#else
    typedef SimpleWizardMac BaseWizard;
#endif


class ConfigWizard : public BaseWizard
{
    Q_OBJECT

public:

    enum Mode
    {
        Login,
        Plugin,
        MediaDevice
    };

    ConfigWizard(
        QWidget* parent = 0,
        Mode     mode = Login,
        QString  uid = "");

    static bool isWizardRunning() { return s_wizardRunning; }

protected:

    virtual QWidget*
    createPage(
        int index);

    virtual QString
    headerForPage(
        int index);

    virtual void
    reject();


public slots:
    virtual int
    exec();


protected slots:

    virtual void
    backButtonClicked();

    virtual void
    nextButtonClicked();


private:

    /*********************************************************************/ /**
        Start downloading plugins. Returns true if plugin downloaded started,
        false otherwise.
    **************************************************************************/
    bool
    downloadPlugins();

    /*********************************************************************/ /**
        On Windows this will return false is we're on a limited user account.
    **************************************************************************/
    bool
    canUserRunWizard();

    WizardInfoPage*             m_page1;
    WizardLoginPage*            m_page2;
    WizardInfoPage*             m_page3;
    WizardProgressPage*         m_page4;
    WizardSelectPluginPage*     m_page5;
    WizardProgressPage*         m_page6;
    WizardBootstrapAskPage*     m_page7;
    WizardMediaDeviceAskPage*   m_page8;
    WizardBootstrapPage*        m_page9;
    WizardInfoPage*             m_page10;

    Mode m_mode;

    // Set if the wizard is starting from a later page than 1
    int m_pageOffset;

    CUpdateInfoGetter       m_infoGetter;
    CAutoUpdater            m_updater;
    MediaDevices            m_mediaDevices;
    QString                 m_uid;
    bool                    m_bootstrapAllowed;
    bool                    m_didBootstrap;
    static bool             s_wizardRunning;

    std::vector<CPluginInfo> mAvailPlugins;

    std::vector<CComponentInfo*> mDownloadTasks;

    QString m_introHeader;
    QString m_introInfo;
    QString m_notAllowedInfo;
    QString m_loginHeader;
    QString m_detectExplainHeader;
    QString m_detectExplainInfo;
    QString m_detectHeader;
    QString m_detectInfo;
    QString m_selectHeader;
    QString m_downloadHeader;
    QString m_doneHeader;
    QString m_bootstrapHeader;
    QString m_bootstrapInfo;
    QString m_bootstrapQuestion;
    QString m_mediaDeviceHeader;
    QString m_mediaDeviceQuestion;
    QString m_doneInfoFirstRun;
    QString m_doneInfoPlugin;
    QString m_doneInfoMediaDeviceYes;
    QString m_doneInfoMediaDeviceNo;
    QString m_doneInfoBootstrapExtra;
    
private slots:

    /*********************************************************************/ /**
        Called by LoginPage when it has finished verifying the user details
        against the server.
    **************************************************************************/
    void
    loginVerified(
        bool valid,
        bool bootstrap);

    /*********************************************************************/ /**
        Called by web service when it's finished with the handshake.
    **************************************************************************/
    void
    handshakeFinished();

    /*********************************************************************/ /**
        Called by UpdateInfoGetter when the plugin info has finished
        downloading.
    **************************************************************************/
    void
    pluginInfoDone(
        bool error,
        QString errorMsg);

    /*********************************************************************/ /**
        Called by AutoUpdater when the plugins are downloaded and installed.
    **************************************************************************/
    void
    pluginDownloadDone(
        bool error,
        QString errorMsg);

    void bootstrapDone();

};

#endif // CONFIGWIZARD_H
