/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Max Howell, Last.fm Ltd <max@last.fm>                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "containerutils.h"
#include "http.h"
#include "logger.h"
#include "Request.h"
#include "utils.h"
#include "WebService.h"


//TODO rename RecentTracksRequest (NOTE the plural)


RecentTracksRequest::RecentTracksRequest( RequestType type, const char *key )
        : Request( type, key )
        , m_key( key )
{}

RecentTracksRequest::RecentTracksRequest()
        : Request( TypeRecentTracks, "RecentTracksRequest" )
        , m_key( "recenttracks" )
{}

void
RecentTracksRequest::start()
{
    get( "/1.0/user/" + CUtils::UrlEncodeItem( The::webService()->currentUsername() ) + "/" + m_key + ".xml" );
}

void
RecentTracksRequest::success( QByteArray data )
{
    QDomDocument document;
    document.setContent( data );

    QDomNodeList values = document.elementsByTagName( "track" );
    for ( int i = 0; i < values.count(); i++ )
    {
        Track track;
        track.setArtist( values.item( i ).namedItem( "artist" ).toElement().text() );
        track.setTitle(  values.item( i ).namedItem( "name" ).toElement().text() );

        m_tracks += track;
    }
}
