/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Max Howell, Last.fm Ltd <max@last.fm>                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "logger.h"
#include "Request.h"
#include "Settings.h"
#include "XmlRpc.h"

UserPicturesRequest::UserPicturesRequest()
        : Request( TypeUserPictures, "UserPictures" )
{}

UserPicturesRequest*
UserPicturesRequest::fetchCurrentUser()
{
    UserPicturesRequest *r = new UserPicturesRequest;
    r->setNames( QStringList() << The::currentUsername() );
    r->start();
    
    return r;
}

void
UserPicturesRequest::start()
{
    XmlRpc xmlrpc;
    xmlrpc.setMethod( "getAvatarUrls" );
    xmlrpc << m_names;
    request( xmlrpc );
}

void
UserPicturesRequest::success( QByteArray data )
{
    QList<QVariant> retVals;
    QString error;
    bool parsed = XmlRpc::parse( data, retVals, error );

    if (!parsed) {
        setFailed( WebRequestResult_Custom, "Couldn't parse" ); //TODO mxcl proof XmlRpc Parsing should be handled by baseclass
        LOGL( 1, error );
        return;
    }

    if (retVals.at( 0 ).type() != QVariant::List) {
        setFailed( WebRequestResult_Custom, "Result wasn't an <array>." ); //TODO mxcl setError should log
        return;
    }

    QList<QVariant> array = retVals.at( 0 ).toList();

    foreach( QVariant val, array ) {
        QMap<QString, QVariant> map = val.toMap();

        QString user = map.value( "name" ).toString();
        QString url = map.value( "avatar" ).toString();
        m_urls.insert( user, url );
    }
}
