/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "confirmdialog.h"
#include "containerutils.h"
#include "Settings.h"
#include "logger.h"


ConfirmDialog::ConfirmDialog( Operation op, QString text, QWidget *parent )
        : QDialog( parent, Qt::Sheet )
        , m_op( op )
{
    /// if a drop operation asks for a confirm, cursor is set
    /// to a drag mode, so we have to override it for duration
    qApp->setOverrideCursor( Qt::ArrowCursor );

    ui.setupUi( this );

    // Want etched, not flat
    ui.line->setFrameShadow( QFrame::Sunken );

    setText( text );

    switch ( m_op )
    {
        case Tag:
            setIcon( dataPath( "buttons/tag.png" ) );
            m_opString = "tag";
            break;

        case Recommend:
            setIcon( dataPath( "buttons/recommend.png" ) );
            m_opString = "recommend";
            break;

        case Love:
            setIcon( dataPath( "buttons/love.png" ) );
            m_opString = "love";
            break;

        case Ban:
            setIcon( dataPath( "buttons/ban.png" ) );
            m_opString = "ban";            
            break;

        case Quit:
            setIcon( dataPath( "app_55.png" ) );
            m_opString = "quit";
          #ifndef WIN32
            ui.yesButton->setText( tr("Quit") );
            ui.noButton->setText( tr("Cancel") );  
          #endif
            break;
		
		#ifdef Q_WS_MAC
			case DockRestart:
				setIcon( dataPath( "app_55.png" ) );
				m_opString = "dock";
				break;
		#endif
    }

  #ifdef Q_WS_MAC
    ui.line->hide();
  #endif  
    
    connect( ui.yesButton, SIGNAL(clicked()), SLOT(accept()) );
    connect( ui.noButton,  SIGNAL(clicked()), SLOT(reject()) );

    adjustSize();
}


ConfirmDialog::~ConfirmDialog()
{
    ///@see ctor   
    qApp->restoreOverrideCursor();
}


void
ConfirmDialog::setIcon( const QPixmap& icon )
{
    ui.iconLabel->setPixmap( icon );
}

void
ConfirmDialog::setIcon( const QString& file )
{
    ui.iconLabel->setPixmap( QPixmap( file ).scaled(
            32, 32, Qt::IgnoreAspectRatio, Qt::SmoothTransformation) );
}

void
ConfirmDialog::setText( const QString& text )
{
    ui.messageLabel->setText( text );
}

bool
ConfirmDialog::isDontAskChecked()
{
    return ui.dontAskCheck->checkState() == Qt::Checked;
}

int
ConfirmDialog::exec()
{
    return The::settings().isDontAsk( m_opString )
            ? QDialog::Accepted
            : QDialog::exec();
}

void
ConfirmDialog::accept()
{
    saveCheckState();

    QDialog::accept();
}

void
ConfirmDialog::reject()
{
    saveCheckState();

    QDialog::reject();
}

void
ConfirmDialog::saveCheckState()
{
    The::settings().setDontAsk( m_opString, isDontAskChecked() );
}
