/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

// REFACTOR Obviously this file shouldn't be in lib tools with a name like
// container utils but the services provided must be in a shared DLL for
// it to work. The whole libLastFMTools is a complete mess anyway.

#ifndef CONTAINERUTILS_H
#define CONTAINERUTILS_H

#include "lastfmtools_common.h"
#include <QString>
#include <QLocale>



#define CONTAINER_VERSION 1

#ifdef WIN32
    #define EXTENSION_PREFIX "ext_"
    #define SERVICE_PREFIX "srv_"
    #define DEBUG_SUFFIX "d"
    #define LIB_EXTENSION ".dll"

#elif defined Q_WS_X11
    #define EXTENSION_PREFIX "libext_"
    #define SERVICE_PREFIX "libsrv_"
    #define DEBUG_SUFFIX "_debug"
    #define LIB_EXTENSION ".so"

#elif defined Q_WS_MAC
    #define EXTENSION_PREFIX "libext_"
    #define SERVICE_PREFIX "libsrv_"
    #define DEBUG_SUFFIX "_debug"
    #define LIB_EXTENSION ".dylib"
#endif


MCEXP QString MD5Digest( const char *token );

MCEXP QString dataPath( QString file = "" );
MCEXP QString savePath( QString file );
MCEXP QString pluginPath( QString name );
MCEXP QString cachePath();

MCEXP QString QHttpStateToString(int state);

MCEXP class MediaDeviceInterface* iTunesDevice();
MCEXP QString qtLanguageToLfmLangCode(QLocale::Language qtLang);
MCEXP QString lfmLangCodeToIso639(QString code);

MCEXP bool installHelperApp();

MCEXP QString pathToCachedCopy( QString cacheKey );

#ifdef Q_WS_MAC
	QString getApplicationSupportFolder();
#endif

#endif // CONTAINERUTILS_H
