/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifdef WIN32

// This file contains legacy code that doesn't work with Unicode.
#undef UNICODE
#undef _UNICODE

#include "winutils.h"

//#include "logger.h"
#undef LOG
#undef LOGL
#define LOG(x, y)
#define LOGL(x, y)

#include "utils.h"

#include <QFile>
#include <QFileInfo>
#include <QSettings>
#include <QString>

#include <windows.h>
#include <shlobj.h>

#include <string>

using namespace std;

/******************************************************************************
    CreatePath
    
    Recursive function. We trace back up the tree until we reach a dir that
    exists, than do the work of creating the new dirs on the way back up.
******************************************************************************/
/*
void
CWinUtils::CreatePath(
    CString sPath)
{
    if(sPath.IsEmpty())
    {
        return;
    }

    // Remove ending / if it exists
    if (sPath.Right(1) == "\\")
    {
        sPath = sPath.Left(sPath.GetLength() - 1);
    }

    // Base case, if directory exists
    if (GetFileAttributes(sPath) != INVALID_FILE_ATTRIBUTES)
    {
        return;
    }

    // Recursive call, step one directory up
    int nFound = sPath.ReverseFind('\\');
    CreatePath(sPath.Left(nFound));

    // Actual work
    CreateDirectory(sPath,
                    NULL); // default security descriptor
}
*/
        
/******************************************************************************
    GetProgramFilesPath
******************************************************************************/
string
CWinUtils::GetProgramFilesPath()
{
    TCHAR acPath[MAX_PATH];

    // TODO: this call is dependant on a specific version of shell32.dll.
    // Need to degrade gracefully. Need to bundle SHFolder.exe with installer
    // and execute it on install for this to work on Win98.
    HRESULT h = SHGetFolderPath(NULL,
                                CSIDL_PROGRAM_FILES, 
                                NULL,
                                0, // current path
                                acPath);

    if (h != S_OK)
    {
        LOG(1, "Couldn't get Program Files dir, is this possibly Win 9x?\n");

        //throw logic_error("Couldn't get Program Files dir.");

        acPath[0] = '\0';
        return acPath;
    }

    string sPath(acPath);

    if (sPath[sPath.size() - 1] != '\\')
    {
        sPath.append("/");
    }

    return sPath;
}

/******************************************************************************
    GetTempPath
******************************************************************************/
/* use QDir::tempPath instead
string
CWinUtils::GetTempDir()
{
    TCHAR acTempPath[MAX_PATH];
    ::GetTempPath(MAX_PATH, acTempPath);

    string sTempPath(acTempPath);

    if (sTempPath[sTempPath.size() - 1] != '\\')
    {
        sTempPath.append("\\");
    }

    return sTempPath;
}
*/

/******************************************************************************
    IsLimitedUser
******************************************************************************/
bool
CWinUtils::IsLimitedUser()
{
    // Try and write to Program Files, if so we should be fine.
    string pf = GetProgramFilesPath();
    QString file = QString::fromStdString(pf) + "dummy";
    QFile f( file );
    if ( !f.open( QIODevice::WriteOnly ) )
    {
        LOG(3, "Couldn't open test file, it's a limited user.\n");
        return true;
    }
    else
    {
        f.close();
        QFile::remove(file);
        return false;
    }
}

/******************************************************************************
    FindDefaultPlayer
******************************************************************************/
QString
CWinUtils::FindDefaultPlayer()
{
    // Get mp3 progID
    QSettings regKey( "HKEY_LOCAL_MACHINE\\Software\\Classes\\.mp3", QSettings::NativeFormat );
    QString progId = regKey.value("Default").toString();

    // Look under progID
    QSettings progIdKey(
        QString( "HKEY_LOCAL_MACHINE\\Software\\Classes\\%1\\shell\\open\\command" ).arg( progId ),
        QSettings::NativeFormat );
    QString exeCmd = progIdKey.value("Default").toString();

    vector<string> separated;
    CUtils::ParseQuotedStrings( exeCmd.toStdString(), separated );

    QString path = separated.size() > 0 ? QString::fromStdString(separated.at(0)) : "";
    QFileInfo file(path);
    return file.fileName();
}

#endif // WIN32
