/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>
#include <QSqlQuery>
#include <QSqlResult>
#include <QSqlError>

#include "mediadevice.h"
#include "containerutils.h"
#include "logger.h"
#include "TrackInfo.h"
#include "Settings.h"
#include "../container.h"

#define ZLIB_WINAPI
#include "zlib.h"

#define ESC( token ) ( QString( token ).replace( "\'", "''" ) )
QString XML_VERSION = "1.0";

static const QString k_host = "moses.last.fm";


MediaDevices::MediaDevices()
    : m_http( 0 )
{
    m_savePath = savePath( "bootstrap.xml" );
    
  #ifndef LINUX
    m_gpod = iTunesDevice();

    connect( m_gpod, SIGNAL( progress( int, TrackInfo ) ),
             this,   SIGNAL( bootstrapProgress( int, TrackInfo ) ) );
  #else
    m_gpod = 0;
  #endif
}


MediaDevices::~MediaDevices()
{
    m_db.close();

    delete m_http;
}


void
MediaDevices::bootStrap()
{
    QFile file( m_savePath );
    file.open( QIODevice::WriteOnly | QIODevice::Text );

    QDomDocument newdoc;
    QDomElement submitQueue = newdoc.createElement( "bootstrap" );
    submitQueue.setAttribute( "product", "iTunes" );
    submitQueue.setAttribute( "version", XML_VERSION );

    TrackInfo track;
    if ( m_gpod )
    {
        qDebug() << "Reading iPod's tracks...";
        track = m_gpod->firstTrack( m_gpod->LibraryPath() );
        qDebug() << "Reading iPod's first track finished...";
    }

    while ( !track.isEmpty() )
    {
        qApp->processEvents();

        QDomElement i = track.toDomElement( newdoc );
        submitQueue.appendChild( i );
        track = m_gpod->nextTrack();
    }

    QDomNode submitNode = newdoc.importNode( submitQueue, true );
    newdoc.appendChild( submitNode );

    QTextStream stream( &file );
    stream.setCodec( "UTF-8" );
    stream << "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    stream << newdoc.toString();

    file.close();
    zipFiles();
    sendZip();

//     The::settings().bootstrapDone();
    emit bootstrapDone();
}


bool
MediaDevices::zipFiles()
{
    QString const out_filename = "LastFMBootstrap.gz";
    QDir temp = QDir::temp();

    temp.remove( out_filename );
    QString const out_path = temp.absolutePath() + '/' + out_filename;

    m_zipFile.setFileName( out_path );
    gzFile zip = gzopen( out_path.toLocal8Bit(), "wb" );
    if ( !zip )
        return false;

    QFile f( m_savePath );
    if ( !f.open( QIODevice::ReadOnly ) )
        return false;

    if ( gzputs( zip, f.readAll().data() ) == -1 )
        return false;

    gzclose( zip );
    f.close();

    return true;
}


void
MediaDevices::sendZip()
{
    if ( m_username.isEmpty() )
    {
        m_username = The::settings().currentUser().username();
        m_passMd5 = The::settings().currentUser().password();
    }

    if ( m_http )
        delete m_http;

    m_http = new Http( k_host, 80, this );
    connect( m_http, SIGNAL( requestFinished( int, bool ) ),
             this,   SLOT  ( sendFinished( int, bool ) ), Qt::QueuedConnection );
    connect( m_http, SIGNAL( dataSendProgress( int, int ) ),
             this,   SLOT  ( sendProgressMade( int, int ) ) );
    connect( m_http, SIGNAL( dataAvailable( const QByteArray& ) ),
             this,   SLOT  ( dataAvailable( const QByteArray& ) ) );
    connect( m_http, SIGNAL( responseHeaderReceived( QHttpResponseHeader ) ),
             this,   SLOT  ( headerReceived( QHttpResponseHeader ) ) );

    // Get Unix time
    time_t now;
    time( &now );
    QString time = QString::number( now );

    // Concatenate pw hash with time
    QString auth = m_passMd5 + time;
    QString authLower = m_passMd5.toLower() + time;
    // Hash the concatenated string to create auth code
    QString authMd5 = MD5Digest( auth.toUtf8() );
    QString authMd5Lower = MD5Digest( authLower.toUtf8() );

    QString path = QString( "/bootstrap/index.php?user=%1&time=%2&auth=%3&authlower=%4" )
        .arg( m_username, time, authMd5, authMd5Lower );

    QHttpRequestHeader header( "POST", path, 1, 1 );
    header.setValue( "Host", k_host );
    header.setValue( "Content-type", "multipart/form-data, boundary=AaB03x" );
    header.setValue( "Cache-Control", "no-cache" );
    header.setValue( "Accept", "*/*" );

    QByteArray bytes;
    bytes.append( "--AaB03x\r\n" );
    bytes.append( "content-disposition: " );
    bytes.append( "form-data; name=\"agency\"\r\n" );
    bytes.append( "\r\n" );
    bytes.append( "0\r\n" );
    bytes.append( "--AaB03x\r\n" );
    bytes.append( "content-disposition: " );
    bytes.append( "form-data; name=\"bootstrap\"; filename=\"" + m_zipFile.fileName() + "\"\r\n" );
    bytes.append( "Content-Transfer-Encoding: binary\r\n" );
    bytes.append( "\r\n" );

    m_zipFile.open( QIODevice::ReadOnly );
    bytes.append( m_zipFile.readAll() );
    m_zipFile.close();

    bytes.append( "\r\n" );
    bytes.append( "--AaB03x--" );
    header.setContentLength( bytes.length() );

    qDebug() << "Sending " << path;
    m_reqId = m_http->request( header, bytes );
}


void
MediaDevices::sendFinished( int id, bool error )
{
    if ( id != m_reqId )
        return;

    qDebug() << "Bootstrap.zip sent to last.fm!";
//     qDebug() << m_http->readAll();

    if ( error )
    {
    }
    else
    {
    }
}


void
MediaDevices::sendProgressMade( int /*done*/, int total )
{
    if ( total > 0 )
    {
//        int kbDownloaded = done / 1024;
//        int kbTotal = total / 1024;
    }
    else
    {
        // Can't find how to get the progress bar to just bounce back and forth
    }
}


void
MediaDevices::dataAvailable( QByteArray /*data*/ )
{
//     qDebug() << "dataAvailable";
//     qDebug() << data;
}


void
MediaDevices::headerReceived( const QHttpResponseHeader &/*resp*/ )
{
//     qDebug() << resp.statusCode() << resp.reasonPhrase() << resp.toString();
}
