/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>
#include <QTimer>

#include "containerutils.h"
#include "recommenddialog.h"
#include "Settings.h"
#include "WebService.h"
#include "WebService/Request.h"
#include "utils.h"


RecommendDialog::RecommendDialog( QWidget* parent ) :
        QDialog( parent, Qt::Dialog | Qt::Window )
{
    ui.setupUi( this );

    connect( &The::settings(), SIGNAL(userSwitched( UserSettings& )), SLOT(userChanged( UserSettings& )) );
    
    userChanged( The::settings().currentUser() );
	
    #ifdef Q_WS_MAC
        ui.messageEdit->setCurrentFont( ui.recommendTypeBox->font() );
        ui.messageEdit->setFont ( ui.recommendTypeBox->font() ); // Removes Mac bug with too small messageEdit text display
    #endif
}


void
RecommendDialog::setSong( MetaData metaData )
{
    m_metaData = metaData;

    ui.recommendTypeBox->setItemText( 0, tr( "Artist: %1" ).arg( metaData.artist() ) );
    ui.recommendTypeBox->setItemText( 1, tr( "Track: %1 - %2" ).arg( metaData.artist() ).arg( metaData.track() ) );
    
    if ( ui.recommendTypeBox->count() == 2 )
        ui.recommendTypeBox->addItem( tr( "Album: %1 - %2" ).arg( metaData.artist() ).arg( metaData.album() ) );
    else
        ui.recommendTypeBox->setItemText( 2, tr( "Album: %1 - %2" ).arg( metaData.artist() ).arg( metaData.album() ) );
}

void
RecommendDialog::setSong( Track track )
{
    m_metaData.setTrack( track.title() );
    m_metaData.setArtist( track.artist() );
    
    ui.recommendTypeBox->setItemText( 0, tr( "Artist: %1" ).arg( track.artist() ) );
    ui.recommendTypeBox->setItemText( 1, tr( "Track: %1 - %2" ).arg( track.artist() ).arg( track.title() ) );
    ui.recommendTypeBox->removeItem( 2 );
}


void
RecommendDialog::userChanged( UserSettings &user )
{
    ui.userEdit->clear(); // clear out previous user's friends
    ui.userEdit->addItem( tr("Loading...") ); // otherwise user will be confused by the empty list
    ui.userEdit->setEditText( user.lastRecommendee() );
    ui.recommendTypeBox->setCurrentIndex( user.lastRecommendType() );
}


int
RecommendDialog::exec()
{
    Q_DEBUG_BLOCK;

    ui.messageEdit->clear();
    
    FriendsRequest *friends = new FriendsRequest;
    connect( friends, SIGNAL(result( Request* )), SLOT(friendsReturn( Request* )) );
    friends->start();

    return QDialog::exec();
}


void
RecommendDialog::friendsReturn( Request *request )
{
    // preserve the editText as clear() clears that too
    QString const edit_text = ui.userEdit->currentText();
    QStringList const usernames = static_cast<FriendsRequest*>(request)->usernames();
    
    ui.userEdit->clear();
    ui.userEdit->addItems( usernames );
    ui.userEdit->setEditText( edit_text );
}


void
RecommendDialog::accept()
{
    RecommendRequest *recommend = new RecommendRequest;
    recommend->setTargetUsername( ui.userEdit->currentText() );
    recommend->setMessage( ui.messageEdit->toPlainText() );
    recommend->setArtist( m_metaData.artist() );
        
    switch (ui.recommendTypeBox->currentIndex())
    {
        case 0:
            recommend->setType( ItemArtist );
            break;
                
        case 1:
            recommend->setType( ItemTrack );
            recommend->setToken( m_metaData.track() );
            break;
                
        case 2:
            recommend->setType( ItemAlbum );
            recommend->setToken( m_metaData.album() );
            break;
    }
        
    recommend->start();
    
    UserSettings &user = The::settings().currentUser();
    user.setLastRecommendee( ui.userEdit->currentText() );
    user.setLastRecommendType( ui.recommendTypeBox->currentIndex() );
    
    QDialog::accept();
}
