/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>

#include "simplewizard_mac.h"
#include "containerutils.h"

SimpleWizardMac::SimpleWizardMac(
    QWidget *parent) :
        SimpleWizard(parent)
{
    uiInt.setupUi(&m_IntShell);
    ui.vboxLayout->insertWidget(0, &m_IntShell);
}

void
SimpleWizardMac::switchPage(
    QWidget* oldPage,
    QWidget* newPage)
{
//     qDebug() << "Switching wizard page!";
    // ui is the base class shell

    if (oldPage) {
        oldPage->hide();
        uiInt.pageFrame->layout()->removeWidget(oldPage);
    }

    uiInt.pageFrame->layout()->addWidget(newPage);
    uiInt.headerLabel->setText(headerForPage(currentPage()));

    newPage->show();
    newPage->setFocus();

    updateButtons();
}
