// Copyright 2007 Last.fm Ltd.
// Released under a GPL v2 license

#include <QtGlobal>
#include <QPainter>
#include <QStyleOption>
#include <QWidget>
#include "winstyleoverrides.h"


void
WinXPStyleOverrides::drawPrimitive( PrimitiveElement pe,
	                                const QStyleOption* opt,
                                    QPainter* p,
                                    const QWidget* w ) const
{
	if ( pe == PE_FrameStatusBar )
	{
		// We don't want no borders
	}
	else
	{
		QWindowsXPStyle::drawPrimitive(pe, opt, p, w);
	}
}

void
WinStyleOverrides::drawPrimitive( PrimitiveElement pe,
                                  const QStyleOption* opt,
                                  QPainter* p,
                                  const QWidget* w) const
{
	if ( pe == PE_FrameStatusBar )
	{
		// We don't want no borders
	}
	else
	{
		QWindowsStyle::drawPrimitive(pe, opt, p, w);
	}
}
