\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{beamer}
[2004/04/19 v2.20 Class for Typesetting a Beamer Presentation]

% Copyright 2003 by Till Tantau <tantau@users.sourceforge.net>.
%
% This program can be redistributed and/or modified under the terms
% of the GNU Public License, version 2.


%
% Global Declarations used by beamer in all modes
%
\newbox\beamer@tempbox
\newif\ifbeamer@blocks
\newif\ifbeamer@ams
\newif\ifbeamer@countsect
\beamer@blockstrue
\beamer@amstrue
\beamer@countsectfalse

\newcount\beamer@tempcount

\newcounter{beamerpauses}



%
% Versioning stuff
%
\newdimen\beamer@version
\beamer@version=2.20pt % It is only fitting, that the version should
                       % be given in points...
\def\beamer@endinputifotherversion#1{%
  \let\beamer@next=\relax%
  \ifdim#1<\beamer@version%
    \let\beamer@next=\endinput%
  \else%
    \ifdim#1>\beamer@version%
      \let\beamer@next=\endinput%
    \fi%
  \fi%
  \beamer@next}

\RequirePackage{beamerbasemodes}
% Setup modes and check for article option

\beamer@transferifnecessary

%
%
% Declarations used by beamer
%
%

% Public
\newdimen\headheight    % Total height of the headline (including depth)
\newdimen\headdp        % Depth of the headline
\newdimen\footheight    % Height of the footline
\newdimen\sidebarheight % Height of the sidebars

% Private
\newdimen\beamer@tempdim
\newdimen\beamer@finalheight
\newdimen\beamer@animht
\newdimen\beamer@animdp
\newdimen\beamer@animwd
\newdimen\beamer@leftmargin
\newdimen\beamer@rightmargin
\newdimen\beamer@leftsidebar
\newdimen\beamer@rightsidebar
\newdimen\beamer@boxsize
\newdimen\beamer@vboxoffset
\newdimen\beamer@descdefault
\newdimen\beamer@descdefaulttemp

\newskip\beamer@lastskip

\newbox\beamer@areabox
\newbox\beamer@animcurrent
\newbox\beamer@animshowbox
\newbox\beamer@sectionbox
\newbox\beamer@logobox
\newbox\beamer@linebox

\newcount\beamer@sectioncount
\newcount\beamer@subsectionmax
\newcount\beamer@sectionmax
\newcount\beamer@totalheads
\newcount\beamer@headcounter
\newcount\beamer@partstartpage
\newcount\beamer@sectionstartpage
\newcount\beamer@subsectionstartpage
\newcount\beamer@animationtempa
\newcount\beamer@animationtempb
\newcount\beamer@xpos
\newcount\beamer@ypos
\newcount\beamer@showpartnumber
\newcount\beamer@currentsubsection
\newcount\beamer@coveringdepth
\newcount\beamer@sectionadjust
\newcount\beamer@tocsectionnumber

\newif\ifbeamer@sansmath
\newif\ifbeamer@altmode
\newif\ifbeamer@notes
\newif\ifbeamer@notesnormals
\newif\ifbeamer@compress
\newif\ifbeamer@centered
\newif\ifbeamer@draftmode
\newif\ifbeamer@suppressreplacements % decides whether fonts should be substituted
\newif\ifbeamer@frameswithnotesonly
\newif\ifbeamer@ignorenonframe
\newif\ifbeamer@autopdfinfo

\RequirePackage{beamerbaseoptions}
% For option management



%
%
% Document options
%
%

\beamer@suppressreplacementsfalse
\beamer@altmodefalse
\beamer@notesfalse
\beamer@notesnormalstrue
\beamer@compressfalse
\beamer@draftmodefalse
\beamer@frameswithnotesonlyfalse
\beamer@ignorenonframefalse
\beamer@autopdfinfotrue

\DeclareOptionBeamer{usepdftitle}[true]{\csname beamer@autopdfinfo#1\endcsname}
\DeclareOptionBeamer{envcountsect}{\beamer@countsecttrue}
\DeclareOptionBeamer{notheorems}{\beamer@blocksfalse}
\DeclareOptionBeamer{noamsthm}{\beamer@blocksfalse\beamer@amsfalse}

\DeclareOptionBeamer{compress}
{\beamer@compresstrue}

\DeclareOptionBeamer{slidescentered}
{\beamer@centeredtrue}

\DeclareOptionBeamer{slidestop}
{\beamer@centeredfalse}

\DeclareOptionBeamer{blue}{\def\beamer@structurecolor{0.2,0.2,0.7}}
\DeclareOptionBeamer{red}{\def\beamer@structurecolor{0.7,0.2,0.2}}
\DeclareOptionBeamer{blackandwhite}{\def\beamer@structurecolor{0.2,0.2,0.2}}
\DeclareOptionBeamer{brown}{\def\beamer@structurecolor{0.66,0.4,0.166}}

\DeclareOptionBeamer{leqno}{\input{leqno.clo}}
\DeclareOptionBeamer{fleqn}{\input{fleqn.clo}}

\def\beamer@currentmode{beamer}
\DeclareOptionBeamer{handout}{\gdef\beamer@currentmode{handout}}
\DeclareOptionBeamer{trans}{\gdef\beamer@currentmode{trans}}

\DeclareOptionBeamer{notes}[show]{\csname beamer@notesaction@#1\endcsname}

\def\beamer@notesaction@hide{%
  \beamer@notesfalse}
\def\beamer@notesaction@show{%
  \beamer@notestrue}
\def\beamer@notesaction@only{%
  \beamer@notestrue
  \beamer@notesnormalsfalse
  \nofiles
}
\def\beamer@notesaction@onlyslideswithnotes{%
  \beamer@notestrue%
  \beamer@frameswithnotesonlytrue%
  \nofiles
}

\DeclareOptionBeamer{sans}{%
  \def\familydefault{\sfdefault}
  \def\mathfamilydefault{\sfdefault}
  \beamer@sansmathtrue
}
\DeclareOptionBeamer{serif}{%
  \def\familydefault{\rmdefault}
  \def\mathfamilydefault{\rmdefault}
  \beamer@sansmathfalse
}

\DeclareOptionBeamer{mathsans}{\def\mathfamilydefault{\sfdefault}\beamer@sansmathtrue}
\DeclareOptionBeamer{mathserif}{\def\mathfamilydefault{\rmdefault}\beamer@sansmathfalse}

\DeclareOptionBeamer{professionalfont}{\beamer@suppressreplacementstrue}

\DeclareOptionBeamer{pdftex}{}% Used by hyperref
\DeclareOptionBeamer{nativepdf}{}% Used by hyperref
\DeclareOptionBeamer{pdfmark}{}% Used by hyperref
\DeclareOptionBeamer{dvips}{}% Used by hyperref
\DeclareOptionBeamer{dviwindo}{}% Used by hyperref
\DeclareOptionBeamer{dvipsone}{}% Used by hyperref
\DeclareOptionBeamer{vtex}{}% Used by hyperref
\DeclareOptionBeamer{ps2pdf}{}% Used by hyperref

\DeclareOptionBeamer{ignorenonframetext}{\beamer@ignorenonframetrue}

\def\beamer@size{{size11.clo}}
\DeclareOptionBeamer{bigger}{\def\beamer@size{{size12.clo}}}
\DeclareOptionBeamer{smaller}{\def\beamer@size{{size10.clo}}}

\DeclareOptionBeamer{8pt}{\def\beamer@size{{size8.clo}}}
\DeclareOptionBeamer{9pt}{\def\beamer@size{{size9.clo}}}
\DeclareOptionBeamer{10pt}{\def\beamer@size{{size10.clo}}}
\DeclareOptionBeamer{11pt}{\def\beamer@size{{size11.clo}}}
\DeclareOptionBeamer{12pt}{\def\beamer@size{{size12.clo}}}
\DeclareOptionBeamer{14pt}{\def\beamer@size{{size14.clo}}}
\DeclareOptionBeamer{17pt}{\def\beamer@size{{size17.clo}}}
\DeclareOptionBeamer{20pt}{\def\beamer@size{{size20.clo}}}

\DeclareOptionBeamer{draft}{\beamer@draftmodetrue}
\AtBeginDocument{
  \ifbeamer@draftmode
  \gdef\beamer@foottemplate{%
    \color{black!25}%
    \kern-\Gm@lmargin\vrule width\paperwidth
    height\footheight\kern-\Gm@rmargin}
  \gdef\beamer@headtemplate{%
    \color{black!25}%
    \kern-\Gm@lmargin\vrule width\paperwidth
    height\headheight\kern-\Gm@rmargin}
  \gdef\beamer@leftsidebartemplate{%
    \color{black!20}%
    \vrule width \beamer@leftsidebar height\sidebarheight}
  \gdef\beamer@rightsidebartemplate{%
    \color{black!20}%
    \vrule width \beamer@rightsidebar height\sidebarheight}
  \gdef\beamer@leftsidebarbackground{}
  \gdef\beamer@rightsidebarbackground{}
  \fi
  }
\def\insertpagenumber{\thepage}

\def\beamer@activecjk{}
\def\beamer@hypercjk{}

\DeclareOptionBeamer{CJK}{\ExecuteOptionsBeamer{cjk}}
\DeclareOptionBeamer{cjk}{
  \def\beamer@hypercjk{\hypersetup{CJKbookmarks=true}}

  \def\beamer@activecjk{
    % Activate all >128 characters. 
    \count@=127
    \@whilenum\count@<255 \do{%
      \advance\count@ by 1
      \lccode`\~=\count@
      \catcode\count@=\active
      \lowercase{\def~{\kern1ex}}
    }
  }  
}


% obsolete options
\DeclareOptionBeamer{inrow}
{\ClassError{beamer}{``inrow'' no longer supported. Use ``compress'' instead.}{}}

\DeclareOptionBeamer{compressnotes}{%
  \ClassWarning{beamer}{``compressnotes'' option no longer supported. Use
    \noexpand\beamertemplatenotecompress instead}
  \AtBeginDocument{\beamertemplatenotecompress}}

\DeclareOptionBeamer{notesonly}{\ClassWarning{beamer}{``notesonly'' no
    longer supported. Use notes=only instead}\beamer@notesaction@only}



\PassOptionsToPackage{bookmarks=true,%
  bookmarksopen=true,%
  pdfborder={0 0 0},%
  pdfhighlight={/N},%
  linkbordercolor={.5 .5 .5}}{hyperref}
  
\DeclareOptionBeamer{pgf}{\PassOptionsToPackage{#1}{pgf}}
\DeclareOptionBeamer{hyperref}{\PassOptionsToPackage{#1}{hyperref}}
\DeclareOptionBeamer{color}{\PassOptionsToPackage{#1}{color}}
\DeclareOptionBeamer{xcolor}{\PassOptionsToPackage{#1}{xcolor}}

\def\beamer@loaducs{}

\DeclareOptionBeamer{ucs}{%
  \ifx\pdfoutput\@undefined
    \def\beamer@loaducs{
      \RequirePackage{ucs}%
      \AtBeginDocument{\PreloadUnicodePage{0}}%
      \AtBeginDocument{\PreloadUnicodePage{1}}%
    }
  \else
    \PassOptionsToPackage{pdftex,unicode}{hyperref}
    \def\beamer@loaducs{
      \RequirePackage[hyperref]{ucs}%
      \AtBeginDocument{\PreloadUnicodePage{0}}%
      \AtBeginDocument{\PreloadUnicodePage{1}}%
    }
  \fi
}
\DeclareOptionBeamer{utf8}{\ExecuteOptionsBeamer{ucs}%
  \g@addto@macro\beamer@loaducs{\RequirePackage[utf8]{inputenc}}%
}

%
% Process Options
%

\ExecuteOptionsBeamer{blue,sans,slidescentered}

\ProcessOptionsBeamer

% Filter class option list
\beamer@filterclassoptions


\RequirePackage{pgf}
% For all sorts of things...

\RequirePackage{xxcolor}
% For color management.

\RequirePackage{amssymb}
% For \blacktriangleright

\RequirePackage[%
  papersize={12.80cm,9.60cm},
  hmargin=1cm,%
  vmargin=0cm,%
  head=0.5cm,% will be changed later
  headsep=0pt,%
  foot=0.5cm% will be changed later
  ]{geometry}
% For the page layout

\RequirePackage[implicit=false]{hyperref}
% For hyperlinks

\hypersetup{pdfcreator={LaTeX with beamer class version \strip@pt\beamer@version}}

% Coding stuff
\beamer@loaducs
\beamer@hypercjk

\expandafter\input\beamer@size
\geometry{headsep=0pt}
\definecolor{structure}{rgb}{\beamer@structurecolor}


\RequirePackage{beamerbasecompatibility}
% Fixes other packages

\RequirePackage{beamerbasefont}
% Font stuff

% Defaults
\normalfont
\raggedright

\addtocontents{toc}{\protect\beamer@endinputifotherversion{\the\beamer@version}}
\addtocontents{nav}{\protect\beamer@endinputifotherversion{\the\beamer@version}}


\RequirePackage{beamerbasemisc}
% Miscellaneous commands

\RequirePackage{beamerbaseoverlay}
% Overlay stuff

\RequirePackage{beamerbasetitle}
% Commands for constructing the title page

\RequirePackage{beamerbasesection}
% Parts, sections, subsections, appendix

\RequirePackage{beamerbaseframe}
% Commands for constructing frames

\RequirePackage{beamerbaseframecomponents}
% Headlines, sidebars, columns

\RequirePackage{beamerbasecolor}
% Headlines, sidebars, columns

\RequirePackage{beamerbasenotes}
% Commands for adding notes

\RequirePackage{beamerbasetoc}
% Table of Contents Format

\RequirePackage{beamerbasetemplates}
% For default templates

\RequirePackage{beamerbaselocalstructure}
% Commands for local structure like alert, itemize, etc.

\RequirePackage{beamerbasenavigation}
% Navigation buttons

\RequirePackage{beamerbasetheorems}
% Navigation buttons




%
%
% Default Theme
%
%
 
                                % Title page
\beamertemplatelargetitlepage

                                % Part page
\beamertemplatelargepartpage

                                % Frame title
\beamertemplateboldcenterframetitle

                                % Sections in headline
\beamertemplatedarksectionheads

                                % Mini slides in headline
\beamertemplatecircleminiframe

                                % Entries in table of contents
\beamertemplateplaintoc

                                % Head
\useheadtemplate{%
  \vbox{%
  \vskip3pt%
  \beamerline{\insertnavigation{\paperwidth}}%
  \vskip1.5pt%
  \insertvrule{0.4pt}{structure!50!averagebackgroundcolor}}%
}

                                % Foot
\usefoottemplate{}

                                % Background
\beamertemplatesolidbackgroundcolor{white}

                                % Blocks
\beamertemplateboldblocks

                                % Theorems
\beamertemplatetheoremsunnumbered

                                % Enumerations
\beamertemplateenumeratealpha
\useenumeratetemplate{}{}
\usesubenumeratetemplate{\begin{small}}{\end{small}}
\usesubsubenumeratetemplate{\begin{footnotesize}}{\end{footnotesize}}

                                % Itemize
\beamertemplatetriangleitem
\useitemizetemplate{}{}
\usesubitemizetemplate{\begin{small}}{\end{small}}
\usesubsubitemizetemplate{\begin{footnotesize}}{\end{footnotesize}}

                                % Buttons
\beamertemplatesolidbuttons

                                % Navigation symbols
\beamertemplatenavigationsymbolshorizontal
\beamertemplaterightsidebarlogonavigation

                                % Continuations
\beamertemplatecontinuationroman

%%% Local Variables: 
%%% mode: latex
%%% TeX-master: "~/texmf/tex/latex/beamer/examples/beamerexample1.tex"
%%% End: 
