/*
 * TeXFilter.java
 */

package latexDraw.filters;

import java.io.File;

import javax.swing.filechooser.FileFilter;



/** 
 * This class define a filter for TeX files (*.tex)<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * 
 * 
 * <br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>>
 * history :<br>
 * 	- 09/02/05 : creation of this file<br>
 *  - 09/09/05 : version 0.5<br>
 *  - 10/09/05 : version 1<br>
 *  - 01/11/06 : version 1.5<br>
 *  - 01/20/06 : version 1.5.1<br>
 */
public class TeXFilter extends FileFilter
{
    /** The name of the extension of TeX file*/
    public final static String TEX_EXTENSION = ".tex"; //$NON-NLS-1$

	@Override
	public boolean accept(File file) 
	{
		return file.getName().endsWith(TEX_EXTENSION)|| file.isDirectory();
	}

	
	
	@Override
	public String getDescription() 
	{
		return "*" + TEX_EXTENSION;//$NON-NLS-1$
	}
}



