/* completion.c generated by valac 0.16.0, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Sébastien Wilmet
 *          Pieter Pareit
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define COMPLETION_PROVIDER_TYPE_ARGUMENT_CONTEXT (completion_provider_argument_context_get_type ())
typedef struct _CompletionProviderArgumentContext CompletionProviderArgumentContext;
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GSettings* _settings;
	GList* _proposals;
	GeeHashMap* _commands;
	GeeHashMap* _environments;
	CompletionProviderCompletionCommand _current_command;
	CompletionProviderCompletionArgument _current_arg;
	CompletionProviderCompletionChoice _current_choice;
	GdkPixbuf* _icon_cmd;
	GdkPixbuf* _icon_choice;
	GdkPixbuf* _icon_package_required;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
};

struct _CompletionProviderArgumentContext {
	gchar* cmd_name;
	gchar* arg_contents;
	GeeArrayList* args_types;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};


static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider__instance;
static CompletionProvider* completion_provider__instance = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
#define COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_PROVIDER, CompletionProviderPrivate))
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
GdkPixbuf* utils_get_pixbuf_from_stock (const gchar* stock_id, GtkIconSize size);
static void completion_provider_load_data (CompletionProvider* self);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter);
static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd);
static GType completion_provider_argument_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest);
static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info);
static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info);
static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context);
static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments);
static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg);
static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b);
static void completion_provider_init_calltip_window (CompletionProvider* self);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* latexila_get_active_window (Latexila* self);
static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents);
static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gchar* document_get_current_indentation (Document* self, GtkTextIter* iter);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
gchar* document_view_get_indentation_style (DocumentView* self);
static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter);
gboolean utils_string_get_prev_char (const gchar* str, gint* index, gunichar* c);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index);
static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd);
gchar* utils_load_file (GFile* file);
static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _vala_array_add10 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value);
static void _vala_array_add11 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length);
static void completion_provider_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	GSettings* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = utils_get_pixbuf_from_stock ("completion_cmd", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_cmd);
	self->priv->_icon_cmd = _tmp1_;
	_tmp2_ = utils_get_pixbuf_from_stock ("completion_choice", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_choice);
	self->priv->_icon_choice = _tmp2_;
	_tmp3_ = utils_get_pixbuf_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_package_required);
	self->priv->_icon_package_required = _tmp3_;
	completion_provider_load_data (self);
	return self;
}


static CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CompletionProvider* completion_provider_get_default (void) {
	CompletionProvider* result = NULL;
	CompletionProvider* _tmp0_;
	CompletionProvider* _tmp2_;
	CompletionProvider* _tmp3_;
	_tmp0_ = completion_provider__instance;
	if (_tmp0_ == NULL) {
		CompletionProvider* _tmp1_;
		_tmp1_ = completion_provider_new ();
		_g_object_unref0 (completion_provider__instance);
		completion_provider__instance = _tmp1_;
	}
	_tmp2_ = completion_provider__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (CompletionProvider*) base;
	_tmp0_ = g_strdup ("LaTeX");
	result = _tmp0_;
	return result;
}


static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	self = (CompletionProvider*) base;
	result = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
	return result;
}


static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	gboolean result = FALSE;
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter iter;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* buf;
	GtkTextBuffer* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkSourceCompletionContext* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GSettings* _tmp9_;
	gboolean _tmp10_ = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = gtk_text_iter_get_buffer (&iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buf = _tmp3_;
	_tmp4_ = buf;
	_tmp5_ = gtk_text_buffer_get_has_selection (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (buf);
		return result;
	}
	_tmp7_ = context;
	_tmp8_ = completion_provider_is_user_request (self, _tmp7_);
	if (_tmp8_) {
		result = TRUE;
		_g_object_unref0 (buf);
		return result;
	}
	_tmp9_ = self->priv->_settings;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "interactive-completion");
	result = _tmp10_;
	_g_object_unref0 (buf);
	return result;
}


/*************************************************************************/
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter iter;
	GtkTextIter _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* cmd;
	const gchar* _tmp4_;
	CompletionProviderArgumentContext info = {0};
	GtkTextIter _tmp7_;
	CompletionProviderArgumentContext _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	gboolean in_arg;
	gboolean _tmp10_;
	GtkSourceCompletionContext* _tmp13_;
	gboolean _tmp14_ = FALSE;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = completion_provider_get_latex_command_at_iter (self, &_tmp2_);
	cmd = _tmp3_;
	_tmp4_ = cmd;
	if (_tmp4_ != NULL) {
		GtkSourceCompletionContext* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = context;
		_tmp6_ = cmd;
		completion_provider_populate_command (self, _tmp5_, _tmp6_);
		_g_free0 (cmd);
		return;
	}
	_tmp7_ = iter;
	_tmp9_ = completion_provider_in_latex_command_argument (self, &_tmp7_, &_tmp8_);
	completion_provider_argument_context_destroy (&info);
	info = _tmp8_;
	in_arg = _tmp9_;
	_tmp10_ = in_arg;
	if (_tmp10_) {
		GtkSourceCompletionContext* _tmp11_;
		CompletionProviderArgumentContext _tmp12_;
		_tmp11_ = context;
		_tmp12_ = info;
		completion_provider_populate_argument (self, _tmp11_, &_tmp12_);
		completion_provider_argument_context_destroy (&info);
		_g_free0 (cmd);
		return;
	}
	_tmp13_ = context;
	_tmp14_ = completion_provider_is_user_request (self, _tmp13_);
	if (_tmp14_) {
		GtkSourceCompletionContext* _tmp15_;
		_tmp15_ = context;
		completion_provider_show_all_proposals (self, _tmp15_);
	} else {
		GtkSourceCompletionContext* _tmp16_;
		_tmp16_ = context;
		completion_provider_show_no_proposals (self, _tmp16_);
	}
	completion_provider_argument_context_destroy (&info);
	_g_free0 (cmd);
}


static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd) {
	GtkSourceCompletionContext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp8_;
	GtkSourceCompletionContext* _tmp10_;
	GList* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (cmd != NULL);
	_tmp0_ = context;
	_tmp1_ = completion_provider_is_user_request (self, _tmp0_);
	if (!_tmp1_) {
		guint min_nb_chars = 0U;
		GSettings* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		guint _tmp6_;
		_tmp2_ = self->priv->_settings;
		g_settings_get (_tmp2_, "interactive-completion-num", "u", &min_nb_chars);
		_tmp3_ = cmd;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = min_nb_chars;
		if (((guint) _tmp5_) <= _tmp6_) {
			GtkSourceCompletionContext* _tmp7_;
			_tmp7_ = context;
			completion_provider_show_no_proposals (self, _tmp7_);
			return;
		}
	}
	_tmp8_ = cmd;
	if (g_strcmp0 (_tmp8_, "\\") == 0) {
		GtkSourceCompletionContext* _tmp9_;
		_tmp9_ = context;
		completion_provider_show_all_proposals (self, _tmp9_);
		return;
	}
	_tmp10_ = context;
	_tmp11_ = self->priv->_proposals;
	_tmp12_ = cmd;
	completion_provider_show_filtered_proposals (self, _tmp10_, _tmp11_, _tmp12_);
}


static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info) {
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	CompletionProviderArgumentContext _tmp5_;
	GList* _tmp6_ = NULL;
	GList* proposals_to_filter;
	GList* _tmp7_;
	GtkSourceCompletionContext* _tmp15_;
	GList* _tmp16_;
	CompletionProviderArgumentContext _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *info;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	if (!_tmp3_) {
		GtkSourceCompletionContext* _tmp4_;
		_tmp4_ = context;
		completion_provider_show_no_proposals (self, _tmp4_);
		return;
	}
	_tmp5_ = *info;
	_tmp6_ = completion_provider_get_argument_proposals (self, &_tmp5_);
	proposals_to_filter = _tmp6_;
	_tmp7_ = proposals_to_filter;
	if (_tmp7_ == NULL) {
		GtkSourceCompletionContext* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = context;
		_tmp9_ = completion_provider_is_user_request (self, _tmp8_);
		if (_tmp9_) {
			CompletionProviderArgumentContext _tmp10_;
			const gchar* _tmp11_;
			CompletionProviderArgumentContext _tmp12_;
			GeeArrayList* _tmp13_;
			_tmp10_ = *info;
			_tmp11_ = _tmp10_.cmd_name;
			_tmp12_ = *info;
			_tmp13_ = _tmp12_.args_types;
			completion_provider_show_calltip_cmd_prototype (self, _tmp11_, _tmp13_);
		} else {
			GtkSourceCompletionContext* _tmp14_;
			_tmp14_ = context;
			completion_provider_show_no_proposals (self, _tmp14_);
		}
		return;
	}
	_tmp15_ = context;
	_tmp16_ = proposals_to_filter;
	_tmp17_ = *info;
	_tmp18_ = _tmp17_.arg_contents;
	completion_provider_show_filtered_proposals (self, _tmp15_, _tmp16_, _tmp18_);
}


static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context) {
	GList* result = NULL;
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_;
	CompletionProviderArgumentContext _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	CompletionProviderCompletionCommand* _tmp8_;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionCommand _tmp10_;
	CompletionProviderCompletionCommand cmd;
	CompletionProviderCompletionCommand _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* cmd_info;
	CompletionProviderCompletionCommand _tmp13_;
	CompletionProviderCompletionArgument* _tmp14_;
	gint _tmp14__length1;
	CompletionProviderArgumentContext _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_ = 0;
	gint arg_num;
	gint _tmp18_;
	CompletionProviderCompletionCommand _tmp19_;
	CompletionProviderCompletionArgument* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	CompletionProviderCompletionArgument _tmp22_;
	CompletionProviderCompletionArgument _tmp23_ = {0};
	CompletionProviderCompletionArgument arg;
	GList* items;
	CompletionProviderCompletionArgument _tmp24_;
	CompletionProviderCompletionChoice* _tmp25_;
	gint _tmp25__length1;
	GList* _tmp54_;
	GList* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg_context != NULL, NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *arg_context;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	g_return_val_if_fail (_tmp3_, NULL);
	_tmp4_ = self->priv->_commands;
	_tmp5_ = *arg_context;
	_tmp6_ = _tmp5_.cmd_name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp6_);
	_tmp8_ = (CompletionProviderCompletionCommand*) _tmp7_;
	completion_provider_completion_command_copy (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_completion_provider_completion_command_free0 (_tmp8_);
	cmd = _tmp10_;
	_tmp11_ = cmd;
	_tmp12_ = completion_provider_get_command_info (self, &_tmp11_, -1);
	cmd_info = _tmp12_;
	_tmp13_ = cmd;
	_tmp14_ = _tmp13_.args;
	_tmp14__length1 = _tmp13_.args_length1;
	_tmp15_ = *arg_context;
	_tmp16_ = _tmp15_.args_types;
	_tmp17_ = completion_provider_get_argument_num (self, _tmp14_, _tmp14__length1, _tmp16_);
	arg_num = _tmp17_;
	_tmp18_ = arg_num;
	if (_tmp18_ == (-1)) {
		result = NULL;
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	_tmp19_ = cmd;
	_tmp20_ = _tmp19_.args;
	_tmp20__length1 = _tmp19_.args_length1;
	_tmp21_ = arg_num;
	_tmp22_ = _tmp20_[_tmp21_ - 1];
	completion_provider_completion_argument_copy (&_tmp22_, &_tmp23_);
	arg = _tmp23_;
	items = NULL;
	_tmp24_ = arg;
	_tmp25_ = _tmp24_.choices;
	_tmp25__length1 = _tmp24_.choices_length1;
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
		choice_collection = _tmp25_;
		choice_collection_length1 = _tmp25__length1;
		for (choice_it = 0; choice_it < _tmp25__length1; choice_it = choice_it + 1) {
			CompletionProviderCompletionChoice _tmp26_ = {0};
			CompletionProviderCompletionChoice choice = {0};
			completion_provider_completion_choice_copy (&choice_collection[choice_it], &_tmp26_);
			choice = _tmp26_;
			{
				GdkPixbuf* pixbuf = NULL;
				gchar* arg_info;
				CompletionProviderCompletionChoice _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				CompletionProviderCompletionChoice _tmp45_;
				const gchar* _tmp46_;
				CompletionProviderCompletionChoice _tmp47_;
				const gchar* _tmp48_;
				GdkPixbuf* _tmp49_;
				const gchar* _tmp50_;
				GtkSourceCompletionItem* _tmp51_;
				GtkSourceCompletionItem* item;
				GtkSourceCompletionItem* _tmp52_;
				GtkSourceCompletionItem* _tmp53_;
				arg_info = NULL;
				_tmp27_ = choice;
				_tmp28_ = _tmp27_.package;
				if (_tmp28_ != NULL) {
					GdkPixbuf* _tmp29_;
					GdkPixbuf* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					CompletionProviderCompletionChoice _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp29_ = self->priv->_icon_package_required;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp30_;
					_tmp31_ = cmd_info;
					_tmp32_ = g_strconcat (_tmp31_, "\nPackage: ", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = choice;
					_tmp35_ = _tmp34_.package;
					_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
					_g_free0 (arg_info);
					arg_info = _tmp36_;
					_g_free0 (_tmp33_);
				} else {
					GdkPixbuf* _tmp37_;
					GdkPixbuf* _tmp38_;
					_tmp37_ = self->priv->_icon_choice;
					_tmp38_ = _g_object_ref0 (_tmp37_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp38_;
				}
				_tmp39_ = arg_info;
				_tmp40_ = g_strdup (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = _tmp41_;
				if (_tmp42_ == NULL) {
					const gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp43_ = cmd_info;
					_tmp44_ = g_strdup (_tmp43_);
					_g_free0 (_tmp41_);
					_tmp41_ = _tmp44_;
				}
				_tmp45_ = choice;
				_tmp46_ = _tmp45_.name;
				_tmp47_ = choice;
				_tmp48_ = _tmp47_.name;
				_tmp49_ = pixbuf;
				_tmp50_ = _tmp41_;
				_tmp51_ = gtk_source_completion_item_new (_tmp46_, _tmp48_, _tmp49_, _tmp50_);
				item = _tmp51_;
				_tmp52_ = item;
				_tmp53_ = _g_object_ref0 (_tmp52_);
				items = g_list_prepend (items, _tmp53_);
				_g_object_unref0 (item);
				_g_free0 (_tmp41_);
				_g_free0 (arg_info);
				_g_object_unref0 (pixbuf);
				completion_provider_completion_choice_destroy (&choice);
			}
		}
	}
	_tmp54_ = items;
	if (_tmp54_ == NULL) {
		result = NULL;
		completion_provider_completion_argument_destroy (&arg);
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
	_tmp55_ = items;
	result = _tmp55_;
	completion_provider_completion_argument_destroy (&arg);
	_g_free0 (cmd_info);
	completion_provider_completion_command_destroy (&cmd);
	return result;
}


static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GList* empty_proposals;
	GtkSourceCompletionContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	empty_proposals = NULL;
	_tmp0_ = context;
	gtk_source_completion_context_add_proposals (_tmp0_, GTK_SOURCE_COMPLETION_PROVIDER (self), empty_proposals, TRUE);
	__g_list_free__g_object_unref0_0 (empty_proposals);
}


static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GtkSourceCompletionContext* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = self->priv->_proposals;
	gtk_source_completion_context_add_proposals (_tmp0_, GTK_SOURCE_COMPLETION_PROVIDER (self), _tmp1_, TRUE);
}


static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GList* filtered_proposals;
	GList* _tmp6_;
	GList* _tmp17_;
	GtkSourceCompletionContext* _tmp22_;
	GList* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp1_ = prefix;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = prefix;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkSourceCompletionContext* _tmp4_;
		GList* _tmp5_;
		_tmp4_ = context;
		_tmp5_ = proposals_to_filter;
		gtk_source_completion_context_add_proposals (_tmp4_, GTK_SOURCE_COMPLETION_PROVIDER (self), _tmp5_, TRUE);
		return;
	}
	filtered_proposals = NULL;
	_tmp6_ = proposals_to_filter;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp6_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp7_;
			GtkSourceCompletionItem* item = NULL;
			_tmp7_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp7_;
			{
				GtkSourceCompletionItem* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_;
				_tmp8_ = item;
				g_object_get (_tmp8_, "text", &_tmp9_, NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_;
				_tmp12_ = prefix;
				_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp11_);
				if (_tmp14_) {
					GtkSourceCompletionItem* _tmp15_;
					GtkSourceCompletionItem* _tmp16_;
					_tmp15_ = item;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp16_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp17_ = filtered_proposals;
	if (_tmp17_ != NULL) {
		filtered_proposals = g_list_reverse (filtered_proposals);
	} else {
		const gchar* _tmp18_ = NULL;
		GtkSourceCompletionItem* _tmp19_;
		GtkSourceCompletionItem* dummy_proposal;
		GtkSourceCompletionItem* _tmp20_;
		GtkSourceCompletionItem* _tmp21_;
		_tmp18_ = _ ("No matching proposal");
		_tmp19_ = gtk_source_completion_item_new (_tmp18_, "", NULL, NULL);
		dummy_proposal = _tmp19_;
		_tmp20_ = dummy_proposal;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp21_);
		_g_object_unref0 (dummy_proposal);
	}
	_tmp22_ = context;
	_tmp23_ = filtered_proposals;
	gtk_source_completion_context_add_proposals (_tmp22_, GTK_SOURCE_COMPLETION_PROVIDER (self), _tmp23_, TRUE);
	__g_list_free__g_object_unref0_0 (filtered_proposals);
}


/*************************************************************************/
static void completion_provider_init_calltip_window (CompletionProvider* self) {
	Latexila* _tmp0_ = NULL;
	Latexila* app;
	GtkSourceCompletionInfo* _tmp1_;
	GtkSourceCompletionInfo* _tmp2_;
	GtkSourceCompletionInfo* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	GtkSourceCompletionInfo* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSourceCompletionInfo* _tmp9_;
	GtkLabel* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_get_default ();
	app = _tmp0_;
	_tmp1_ = gtk_source_completion_info_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_calltip_window);
	self->priv->_calltip_window = _tmp2_;
	_tmp3_ = self->priv->_calltip_window;
	_tmp4_ = latexila_get_active_window (app);
	_tmp5_ = _tmp4_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp5_);
	_tmp6_ = self->priv->_calltip_window;
	gtk_source_completion_info_set_sizing (_tmp6_, 800, 200, TRUE, TRUE);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_calltip_window_label = _tmp8_;
	_tmp9_ = self->priv->_calltip_window;
	_tmp10_ = self->priv->_calltip_window_label;
	gtk_source_completion_info_set_widget (_tmp9_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (app);
}


static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	CompletionProviderCompletionCommand* _tmp6_;
	CompletionProviderCompletionCommand _tmp7_ = {0};
	CompletionProviderCompletionCommand _tmp8_;
	CompletionProviderCompletionCommand command;
	CompletionProviderCompletionCommand _tmp9_;
	CompletionProviderCompletionArgument* _tmp10_;
	gint _tmp10__length1;
	GeeArrayList* _tmp11_;
	gint _tmp12_ = 0;
	gint arg_num;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg_cmd != NULL);
	g_return_if_fail (arguments != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = arg_cmd;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	g_return_if_fail (_tmp2_);
	_tmp3_ = self->priv->_commands;
	_tmp4_ = arg_cmd;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	_tmp6_ = (CompletionProviderCompletionCommand*) _tmp5_;
	completion_provider_completion_command_copy (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_completion_provider_completion_command_free0 (_tmp6_);
	command = _tmp8_;
	_tmp9_ = command;
	_tmp10_ = _tmp9_.args;
	_tmp10__length1 = _tmp9_.args_length1;
	_tmp11_ = arguments;
	_tmp12_ = completion_provider_get_argument_num (self, _tmp10_, _tmp10__length1, _tmp11_);
	arg_num = _tmp12_;
	_tmp13_ = arg_num;
	if (_tmp13_ != (-1)) {
		CompletionProviderCompletionCommand _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* info;
		const gchar* _tmp17_;
		_tmp14_ = command;
		_tmp15_ = arg_num;
		_tmp16_ = completion_provider_get_command_info (self, &_tmp14_, _tmp15_);
		info = _tmp16_;
		_tmp17_ = info;
		completion_provider_show_calltip_info (self, _tmp17_);
		_g_free0 (info);
	}
	completion_provider_completion_command_destroy (&command);
}


static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup) {
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	Latexila* _tmp3_ = NULL;
	Latexila* _tmp4_;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* _tmp8_;
	MainWindow* window;
	GtkSourceCompletionInfo* _tmp9_;
	GtkTextIter cursor_pos = {0};
	DocumentView* _tmp10_;
	DocumentView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* buffer;
	GtkTextMark* _tmp15_ = NULL;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_ = {0};
	GtkTextIter begin_arg_pos;
	GtkSourceCompletionInfo* _tmp19_;
	DocumentView* _tmp20_;
	DocumentView* _tmp21_;
	GtkTextIter _tmp22_;
	GtkSourceCompletionInfo* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ == NULL) {
		completion_provider_init_calltip_window (self);
	}
	_tmp1_ = self->priv->_calltip_window_label;
	_tmp2_ = markup;
	gtk_label_set_markup (_tmp1_, _tmp2_);
	_tmp3_ = latexila_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = latexila_get_active_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp4_);
	window = _tmp8_;
	_tmp9_ = self->priv->_calltip_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, (GtkWindow*) window);
	_tmp10_ = main_window_get_active_view (window);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	buffer = _tmp14_;
	_tmp15_ = gtk_text_buffer_get_insert (buffer);
	gtk_text_buffer_get_iter_at_mark (buffer, &_tmp16_, _tmp15_);
	cursor_pos = _tmp16_;
	_tmp17_ = cursor_pos;
	completion_provider_get_begin_arg_pos (self, &_tmp17_, &_tmp18_);
	begin_arg_pos = _tmp18_;
	_tmp19_ = self->priv->_calltip_window;
	_tmp20_ = main_window_get_active_view (window);
	_tmp21_ = _tmp20_;
	_tmp22_ = begin_arg_pos;
	gtk_source_completion_info_move_to_iter (_tmp19_, (GtkTextView*) _tmp21_, &_tmp22_);
	_tmp23_ = self->priv->_calltip_window;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	_g_object_unref0 (buffer);
	_g_object_unref0 (window);
}


void completion_provider_hide_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ != NULL) {
		GtkSourceCompletionInfo* _tmp1_;
		_tmp1_ = self->priv->_calltip_window;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}


/*************************************************************************/
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	gboolean result = FALSE;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* cmd;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp12_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = text;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = text;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp6_ = *iter;
	_tmp7_ = completion_provider_get_latex_command_at_iter (self, &_tmp6_);
	cmd = _tmp7_;
	_tmp9_ = cmd;
	if (_tmp9_ != NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = text;
		_tmp11_ = g_str_has_prefix (_tmp10_, "\\");
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		GtkSourceCompletionProposal* _tmp13_;
		GtkTextIter _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = proposal;
		_tmp14_ = *iter;
		_tmp15_ = cmd;
		completion_provider_activate_proposal_command_name (self, _tmp13_, &_tmp14_, _tmp15_);
	} else {
		CompletionProviderArgumentContext info = {0};
		GtkTextIter _tmp16_;
		CompletionProviderArgumentContext _tmp17_ = {0};
		gboolean _tmp18_ = FALSE;
		_tmp16_ = *iter;
		_tmp18_ = completion_provider_in_latex_command_argument (self, &_tmp16_, &_tmp17_);
		completion_provider_argument_context_destroy (&info);
		info = _tmp17_;
		if (_tmp18_) {
			GtkSourceCompletionProposal* _tmp19_;
			GtkTextIter _tmp20_;
			CompletionProviderArgumentContext _tmp21_;
			const gchar* _tmp22_;
			CompletionProviderArgumentContext _tmp23_;
			const gchar* _tmp24_;
			_tmp19_ = proposal;
			_tmp20_ = *iter;
			_tmp21_ = info;
			_tmp22_ = _tmp21_.cmd_name;
			_tmp23_ = info;
			_tmp24_ = _tmp23_.arg_contents;
			completion_provider_activate_proposal_argument_choice (self, _tmp19_, &_tmp20_, _tmp22_, _tmp24_);
		} else {
			g_warning ("completion.vala:383: Not in a LaTeX command argument.");
		}
		completion_provider_argument_context_destroy (&info);
	}
	result = TRUE;
	_g_free0 (cmd);
	_g_free0 (text);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd) {
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint _tmp7_;
	glong index_start;
	const gchar* _tmp8_;
	glong _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* text_to_insert;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* doc;
	GtkTextBuffer* _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextMark* _tmp18_ = NULL;
	GtkTextMark* _tmp19_;
	GtkTextMark* old_pos_mark;
	GtkTextBuffer* _tmp20_;
	GtkTextBuffer* _tmp21_;
	const gchar* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextIter old_pos_iter = {0};
	GtkTextBuffer* _tmp24_;
	GtkTextMark* _tmp25_;
	GtkTextIter _tmp26_ = {0};
	GtkTextBuffer* _tmp27_;
	GtkTextMark* _tmp28_;
	GtkTextIter match_end = {0};
	GtkTextIter _tmp29_;
	GtkTextIter _tmp30_ = {0};
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = cmd;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = cmd;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	_tmp7_ = _tmp2_;
	index_start = (glong) _tmp7_;
	_tmp8_ = text;
	_tmp9_ = index_start;
	_tmp10_ = text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_slice (_tmp8_, _tmp9_, (glong) _tmp12_);
	text_to_insert = _tmp13_;
	_tmp14_ = gtk_text_iter_get_buffer (iter);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	_tmp17_ = *iter;
	_tmp18_ = gtk_text_buffer_create_mark (_tmp16_, NULL, &_tmp17_, TRUE);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	old_pos_mark = _tmp19_;
	_tmp20_ = doc;
	gtk_text_buffer_begin_user_action (_tmp20_);
	_tmp21_ = doc;
	_tmp22_ = text_to_insert;
	gtk_text_buffer_insert (_tmp21_, iter, _tmp22_, -1);
	_tmp23_ = doc;
	gtk_text_buffer_end_user_action (_tmp23_);
	_tmp24_ = doc;
	_tmp25_ = old_pos_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp24_, &_tmp26_, _tmp25_);
	old_pos_iter = _tmp26_;
	_tmp27_ = doc;
	_tmp28_ = old_pos_mark;
	gtk_text_buffer_delete_mark (_tmp27_, _tmp28_);
	_tmp29_ = *iter;
	_tmp31_ = gtk_text_iter_forward_search (&old_pos_iter, "{", GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY, NULL, &_tmp30_, &_tmp29_);
	match_end = _tmp30_;
	if (_tmp31_) {
		GtkTextBuffer* _tmp32_;
		GtkTextIter _tmp33_;
		_tmp32_ = doc;
		_tmp33_ = match_end;
		gtk_text_buffer_place_cursor (_tmp32_, &_tmp33_);
	}
	_g_object_unref0 (old_pos_mark);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents) {
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint _tmp7_;
	glong index_start;
	const gchar* _tmp8_;
	glong _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* text_to_insert;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* doc;
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkTextBuffer* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (arg_cmd != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = arg_contents;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = arg_contents;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	_tmp7_ = _tmp2_;
	index_start = (glong) _tmp7_;
	_tmp8_ = text;
	_tmp9_ = index_start;
	_tmp10_ = text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_slice (_tmp8_, _tmp9_, (glong) _tmp12_);
	text_to_insert = _tmp13_;
	_tmp14_ = gtk_text_iter_get_buffer (iter);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	gtk_text_buffer_begin_user_action (_tmp16_);
	_tmp17_ = doc;
	_tmp18_ = text_to_insert;
	gtk_text_buffer_insert (_tmp17_, iter, _tmp18_, -1);
	_tmp19_ = arg_cmd;
	if (g_strcmp0 (_tmp19_, "\\begin") == 0) {
		const gchar* _tmp20_;
		GtkTextIter _tmp21_;
		_tmp20_ = text;
		_tmp21_ = *iter;
		completion_provider_close_environment (self, _tmp20_, &_tmp21_);
	} else {
	}
	_tmp22_ = doc;
	gtk_text_buffer_end_user_action (_tmp22_);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter) {
	GtkTextBuffer* _tmp0_ = NULL;
	Document* _tmp1_;
	Document* doc;
	gunichar _tmp2_ = 0U;
	Document* _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* cur_indent;
	Document* _tmp7_;
	DocumentTab* _tmp8_;
	DocumentView* _tmp9_;
	DocumentView* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* indent;
	GeeHashMap* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	CompletionProviderCompletionChoice* env;
	Document* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	CompletionProviderCompletionChoice* _tmp23_;
	gboolean _tmp26_;
	Document* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextMark* _tmp32_ = NULL;
	GtkTextMark* _tmp33_;
	GtkTextMark* cursor_pos;
	gboolean _tmp34_ = FALSE;
	CompletionProviderCompletionChoice* _tmp35_;
	gboolean _tmp38_;
	Document* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp45_;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_;
	Document* _tmp49_;
	GtkTextMark* _tmp50_;
	GtkTextIter _tmp51_ = {0};
	Document* _tmp52_;
	GtkTextMark* _tmp53_;
	Document* _tmp54_;
	GtkTextIter _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (env_name != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = gtk_text_iter_get_char (iter);
	if (_tmp2_ == ((gunichar) '}')) {
		gtk_text_iter_forward_char (iter);
	} else {
		Document* _tmp3_;
		_tmp3_ = doc;
		document_insert (_tmp3_, iter, "}", -1);
	}
	_tmp4_ = doc;
	_tmp5_ = *iter;
	_tmp6_ = document_get_current_indentation (_tmp4_, &_tmp5_);
	cur_indent = _tmp6_;
	_tmp7_ = doc;
	_tmp8_ = _tmp7_->tab;
	_tmp9_ = document_tab_get_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = document_view_get_indentation_style (_tmp10_);
	indent = _tmp11_;
	_tmp12_ = self->priv->_environments;
	_tmp13_ = env_name;
	_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
	env = (CompletionProviderCompletionChoice*) _tmp14_;
	_tmp15_ = doc;
	_tmp16_ = cur_indent;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = indent;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("\n", _tmp17_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	document_insert (_tmp15_, iter, _tmp21_, -1);
	_g_free0 (_tmp21_);
	_tmp23_ = env;
	if (_tmp23_ != NULL) {
		CompletionProviderCompletionChoice* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = env;
		_tmp25_ = (*_tmp24_).insert;
		_tmp22_ = _tmp25_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp26_ = _tmp22_;
	if (_tmp26_) {
		Document* _tmp27_;
		CompletionProviderCompletionChoice* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = doc;
		_tmp28_ = env;
		_tmp29_ = (*_tmp28_).insert;
		document_insert (_tmp27_, iter, _tmp29_, -1);
	}
	_tmp30_ = doc;
	_tmp31_ = *iter;
	_tmp32_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp30_, NULL, &_tmp31_, TRUE);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	cursor_pos = _tmp33_;
	_tmp35_ = env;
	if (_tmp35_ != NULL) {
		CompletionProviderCompletionChoice* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = env;
		_tmp37_ = (*_tmp36_).insert_after;
		_tmp34_ = _tmp37_ != NULL;
	} else {
		_tmp34_ = FALSE;
	}
	_tmp38_ = _tmp34_;
	if (_tmp38_) {
		Document* _tmp39_;
		CompletionProviderCompletionChoice* _tmp40_;
		const gchar* _tmp41_;
		_tmp39_ = doc;
		_tmp40_ = env;
		_tmp41_ = (*_tmp40_).insert_after;
		document_insert (_tmp39_, iter, _tmp41_, -1);
	}
	_tmp42_ = doc;
	_tmp43_ = cur_indent;
	_tmp44_ = string_to_string (_tmp43_);
	_tmp45_ = env_name;
	_tmp46_ = string_to_string (_tmp45_);
	_tmp47_ = g_strconcat ("\n", _tmp44_, "\\end{", _tmp46_, "}", NULL);
	_tmp48_ = _tmp47_;
	document_insert (_tmp42_, iter, _tmp48_, -1);
	_g_free0 (_tmp48_);
	_tmp49_ = doc;
	_tmp50_ = cursor_pos;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp49_, &_tmp51_, _tmp50_);
	*iter = _tmp51_;
	_tmp52_ = doc;
	_tmp53_ = cursor_pos;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp52_, _tmp53_);
	_tmp54_ = doc;
	_tmp55_ = *iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp54_, &_tmp55_);
	_g_object_unref0 (cursor_pos);
	_completion_provider_completion_choice_free0 (env);
	_g_free0 (indent);
	_g_free0 (cur_indent);
	_g_object_unref0 (doc);
}


/*************************************************************************/
static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result) {
	GtkTextIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint cur_index;
	gint _tmp5_;
	gint prev_index;
	gunichar cur_char = 0U;
	GtkTextIter _tmp19_;
	GtkTextIter begin_arg_pos;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (in_arg_pos != NULL);
	_tmp0_ = *in_arg_pos;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	cur_index = _tmp4_;
	_tmp5_ = cur_index;
	prev_index = _tmp5_;
	while (TRUE) {
		const gchar* _tmp6_;
		gunichar _tmp7_ = 0U;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gunichar _tmp11_;
		gboolean _tmp13_;
		gboolean _tmp17_;
		gint _tmp18_;
		_tmp6_ = text;
		_tmp8_ = utils_string_get_prev_char (_tmp6_, &prev_index, &_tmp7_);
		cur_char = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp11_ = cur_char;
		if (_tmp11_ == ((gunichar) '[')) {
			_tmp10_ = TRUE;
		} else {
			gunichar _tmp12_;
			_tmp12_ = cur_char;
			_tmp10_ = _tmp12_ == ((gunichar) '{');
		}
		_tmp13_ = _tmp10_;
		if (_tmp13_) {
			const gchar* _tmp14_;
			gint _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = text;
			_tmp15_ = cur_index;
			_tmp16_ = utils_char_is_escaped (_tmp14_, (glong) _tmp15_);
			_tmp9_ = !_tmp16_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp17_ = _tmp9_;
		if (_tmp17_) {
			break;
		}
		_tmp18_ = prev_index;
		cur_index = _tmp18_;
	}
	_tmp19_ = *in_arg_pos;
	begin_arg_pos = _tmp19_;
	_tmp20_ = cur_index;
	gtk_text_iter_set_visible_line_index (&begin_arg_pos, _tmp20_);
	gtk_text_iter_forward_char (&begin_arg_pos);
	*result = begin_arg_pos;
	_g_free0 (text);
	return;
}


static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = strlen (text);
	_tmp3_ = _tmp2_;
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, _tmp3_);
	result = _tmp4_;
	_g_free0 (text);
	return result;
}


static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint cur_index;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp0_ <= _tmp3_, NULL);
	_tmp4_ = index;
	cur_index = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = utils_string_get_prev_char (_tmp5_, &cur_index, NULL);
	if (!_tmp6_) {
		result = NULL;
		return result;
	}
	while (TRUE) {
		gunichar cur_char = 0U;
		gint _tmp7_;
		gint prev_index;
		const gchar* _tmp8_;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gboolean first_char;
		gunichar _tmp11_;
		gboolean _tmp19_ = FALSE;
		gunichar _tmp20_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp23_;
		gboolean _tmp24_;
		gint _tmp25_;
		_tmp7_ = cur_index;
		prev_index = _tmp7_;
		_tmp8_ = text;
		_tmp10_ = utils_string_get_prev_char (_tmp8_, &prev_index, &_tmp9_);
		cur_char = _tmp9_;
		first_char = !_tmp10_;
		_tmp11_ = cur_char;
		if (_tmp11_ == ((gunichar) '\\')) {
			const gchar* _tmp12_;
			gint _tmp13_;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			_tmp12_ = text;
			_tmp13_ = cur_index;
			_tmp14_ = utils_char_is_escaped (_tmp12_, (glong) _tmp13_);
			if (_tmp14_) {
				break;
			}
			_tmp15_ = text;
			_tmp16_ = cur_index;
			_tmp17_ = index;
			_tmp18_ = string_slice (_tmp15_, (glong) _tmp16_, (glong) _tmp17_);
			result = _tmp18_;
			return result;
		}
		_tmp20_ = cur_char;
		_tmp21_ = g_unichar_isalpha (_tmp20_);
		if (!_tmp21_) {
			gunichar _tmp22_;
			_tmp22_ = cur_char;
			_tmp19_ = _tmp22_ != ((gunichar) '*');
		} else {
			_tmp19_ = FALSE;
		}
		_tmp23_ = _tmp19_;
		if (_tmp23_) {
			break;
		}
		_tmp24_ = first_char;
		if (_tmp24_) {
			break;
		}
		_tmp25_ = prev_index;
		cur_index = _tmp25_;
	}
	result = NULL;
	return result;
}


static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info) {
	CompletionProviderArgumentContext _vala_info = {0};
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GtkTextIter _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* text;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint last_index;
	gint _tmp6_;
	gint cur_index;
	gboolean in_prev_arg;
	gunichar prev_arg_opening_bracket;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	completion_provider_argument_context_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (CompletionProviderArgumentContext));
	_g_free0 (_vala_info.cmd_name);
	_vala_info.cmd_name = NULL;
	_g_free0 (_vala_info.arg_contents);
	_vala_info.arg_contents = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL);
	_g_object_unref0 (_vala_info.args_types);
	_vala_info.args_types = _tmp0_;
	_tmp1_ = *iter;
	_tmp2_ = completion_provider_get_text_line_to_iter (self, &_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	last_index = _tmp5_;
	_tmp6_ = last_index;
	cur_index = _tmp6_;
	while (TRUE) {
		gint _tmp7_;
		gint prev_index;
		gunichar cur_char = 0U;
		const gchar* _tmp8_;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gboolean first_char;
		gboolean _tmp11_ = FALSE;
		gunichar _tmp12_;
		gboolean _tmp14_;
		gboolean opening_bracket;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		gboolean _tmp20_;
		gboolean _tmp29_;
		gint _tmp30_;
		_tmp7_ = cur_index;
		prev_index = _tmp7_;
		_tmp8_ = text;
		_tmp10_ = utils_string_get_prev_char (_tmp8_, &prev_index, &_tmp9_);
		cur_char = _tmp9_;
		first_char = !_tmp10_;
		_tmp12_ = cur_char;
		if (_tmp12_ == ((gunichar) '{')) {
			_tmp11_ = TRUE;
		} else {
			gunichar _tmp13_;
			_tmp13_ = cur_char;
			_tmp11_ = _tmp13_ == ((gunichar) '[');
		}
		_tmp14_ = _tmp11_;
		opening_bracket = _tmp14_;
		_tmp16_ = opening_bracket;
		if (_tmp16_) {
			const gchar* _tmp17_;
			gint _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp17_ = text;
			_tmp18_ = cur_index;
			_tmp19_ = utils_char_is_escaped (_tmp17_, (glong) _tmp18_);
			_tmp15_ = !_tmp19_;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp20_ = _tmp15_;
		if (_tmp20_) {
			CompletionProviderArgumentContext _tmp21_;
			GeeArrayList* _tmp22_;
			gunichar _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_ = NULL;
			gint _tmp28_;
			_tmp21_ = _vala_info;
			_tmp22_ = _tmp21_.args_types;
			_tmp23_ = cur_char;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp22_, 0, GINT_TO_POINTER (_tmp23_ == ((gunichar) '[')));
			_tmp24_ = text;
			_tmp25_ = cur_index;
			_tmp26_ = last_index;
			_tmp27_ = string_slice (_tmp24_, (glong) (_tmp25_ + 1), (glong) _tmp26_);
			_g_free0 (_vala_info.arg_contents);
			_vala_info.arg_contents = _tmp27_;
			_tmp28_ = prev_index;
			cur_index = _tmp28_;
			break;
		}
		_tmp29_ = first_char;
		if (_tmp29_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp30_ = prev_index;
		cur_index = _tmp30_;
	}
	in_prev_arg = FALSE;
	prev_arg_opening_bracket = (gunichar) '{';
	while (TRUE) {
		gint _tmp31_;
		gint prev_index;
		gunichar cur_char = 0U;
		const gchar* _tmp32_;
		gunichar _tmp33_ = 0U;
		gboolean _tmp34_ = FALSE;
		gboolean first_char;
		gboolean _tmp35_;
		gboolean _tmp66_;
		gint _tmp67_;
		_tmp31_ = cur_index;
		prev_index = _tmp31_;
		_tmp32_ = text;
		_tmp34_ = utils_string_get_prev_char (_tmp32_, &prev_index, &_tmp33_);
		cur_char = _tmp33_;
		first_char = !_tmp34_;
		_tmp35_ = in_prev_arg;
		if (_tmp35_) {
			gunichar _tmp36_;
			gunichar _tmp37_;
			_tmp36_ = cur_char;
			_tmp37_ = prev_arg_opening_bracket;
			if (_tmp36_ == _tmp37_) {
				const gchar* _tmp38_;
				gint _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp38_ = text;
				_tmp39_ = cur_index;
				_tmp40_ = utils_char_is_escaped (_tmp38_, (glong) _tmp39_);
				in_prev_arg = _tmp40_;
			}
		} else {
			gboolean _tmp41_ = FALSE;
			gunichar _tmp42_;
			gboolean _tmp44_;
			_tmp42_ = cur_char;
			if (_tmp42_ == ((gunichar) '}')) {
				_tmp41_ = TRUE;
			} else {
				gunichar _tmp43_;
				_tmp43_ = cur_char;
				_tmp41_ = _tmp43_ == ((gunichar) ']');
			}
			_tmp44_ = _tmp41_;
			if (_tmp44_) {
				const gchar* _tmp45_;
				gint _tmp46_;
				gboolean _tmp47_ = FALSE;
				gchar _tmp48_ = '\0';
				gunichar _tmp49_;
				gchar _tmp50_;
				CompletionProviderArgumentContext _tmp51_;
				GeeArrayList* _tmp52_;
				gunichar _tmp53_;
				_tmp45_ = text;
				_tmp46_ = cur_index;
				_tmp47_ = utils_char_is_escaped (_tmp45_, (glong) _tmp46_);
				if (_tmp47_) {
					result = FALSE;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				}
				in_prev_arg = TRUE;
				_tmp49_ = cur_char;
				if (_tmp49_ == ((gunichar) '}')) {
					_tmp48_ = '{';
				} else {
					_tmp48_ = '[';
				}
				_tmp50_ = _tmp48_;
				prev_arg_opening_bracket = (gunichar) _tmp50_;
				_tmp51_ = _vala_info;
				_tmp52_ = _tmp51_.args_types;
				_tmp53_ = cur_char;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp52_, 0, GINT_TO_POINTER (_tmp53_ == ((gunichar) ']')));
			} else {
				gboolean _tmp54_ = FALSE;
				gunichar _tmp55_;
				gboolean _tmp56_ = FALSE;
				gboolean _tmp58_;
				_tmp55_ = cur_char;
				_tmp56_ = g_unichar_isalpha (_tmp55_);
				if (_tmp56_) {
					_tmp54_ = TRUE;
				} else {
					gunichar _tmp57_;
					_tmp57_ = cur_char;
					_tmp54_ = _tmp57_ == ((gunichar) '*');
				}
				_tmp58_ = _tmp54_;
				if (_tmp58_) {
					const gchar* _tmp59_;
					gint _tmp60_;
					gchar* _tmp61_ = NULL;
					CompletionProviderArgumentContext _tmp62_;
					const gchar* _tmp63_;
					_tmp59_ = text;
					_tmp60_ = cur_index;
					_tmp61_ = completion_provider_get_latex_command_at_index (self, _tmp59_, _tmp60_ + 1);
					_g_free0 (_vala_info.cmd_name);
					_vala_info.cmd_name = _tmp61_;
					_tmp62_ = _vala_info;
					_tmp63_ = _tmp62_.cmd_name;
					result = _tmp63_ != NULL;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				} else {
					gunichar _tmp64_;
					gboolean _tmp65_ = FALSE;
					_tmp64_ = cur_char;
					_tmp65_ = g_unichar_isspace (_tmp64_);
					if (!_tmp65_) {
						result = FALSE;
						_g_free0 (text);
						if (info) {
							*info = _vala_info;
						} else {
							completion_provider_argument_context_destroy (&_vala_info);
						}
						return result;
					}
				}
			}
		}
		_tmp66_ = first_char;
		if (_tmp66_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp67_ = prev_index;
		cur_index = _tmp67_;
	}
	_g_free0 (text);
	if (info) {
		*info = _vala_info;
	} else {
		completion_provider_argument_context_destroy (&_vala_info);
	}
}


/*************************************************************************/
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context) {
	gboolean result = FALSE;
	GtkSourceCompletionContext* _tmp0_;
	GtkSourceCompletionActivation _tmp1_ = 0;
	GtkSourceCompletionActivation _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	g_object_get (_tmp0_, "activation", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}


static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b) {
	gint result = 0;
	GtkSourceCompletionItem* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkSourceCompletionItem* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	g_object_get (_tmp0_, "text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint line;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* doc;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	gtk_text_buffer_get_iter_at_line (doc, &_tmp3_, line);
	iter_start = _tmp3_;
	_tmp4_ = iter_start;
	_tmp5_ = *iter;
	_tmp6_ = gtk_text_buffer_get_text (doc, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (doc);
	return result;
}


static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg) {
	gchar* result = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* info;
	gint arg_num;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionCommand _tmp33_;
	const gchar* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	info = _tmp2_;
	arg_num = 1;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				gint _tmp6_;
				gint _tmp7_;
				CompletionProviderCompletionArgument _tmp10_;
				gboolean _tmp11_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp32_;
				_tmp6_ = arg_num;
				_tmp7_ = cur_arg;
				if (_tmp6_ == _tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = info;
					_tmp9_ = g_strconcat (_tmp8_, "<b>", NULL);
					_g_free0 (info);
					info = _tmp9_;
				}
				_tmp10_ = arg;
				_tmp11_ = _tmp10_.optional;
				if (_tmp11_) {
					const gchar* _tmp12_;
					CompletionProviderCompletionArgument _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp12_ = info;
					_tmp13_ = arg;
					_tmp14_ = _tmp13_.label;
					_tmp15_ = g_strconcat ("[", _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, "]", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
					_g_free0 (info);
					info = _tmp19_;
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				} else {
					const gchar* _tmp20_;
					CompletionProviderCompletionArgument _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp20_ = info;
					_tmp21_ = arg;
					_tmp22_ = _tmp21_.label;
					_tmp23_ = g_strconcat ("{", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "}", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
					_g_free0 (info);
					info = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				}
				_tmp28_ = arg_num;
				_tmp29_ = cur_arg;
				if (_tmp28_ == _tmp29_) {
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp30_ = info;
					_tmp31_ = g_strconcat (_tmp30_, "</b>", NULL);
					_g_free0 (info);
					info = _tmp31_;
				}
				_tmp32_ = arg_num;
				arg_num = _tmp32_ + 1;
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	_tmp33_ = *cmd;
	_tmp34_ = _tmp33_.package;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		CompletionProviderCompletionCommand _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp35_ = info;
		_tmp36_ = *cmd;
		_tmp37_ = _tmp36_.package;
		_tmp38_ = g_strconcat ("\nPackage: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_g_free0 (info);
		info = _tmp40_;
		_g_free0 (_tmp39_);
	}
	result = info;
	return result;
}


static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args) {
	gint result = 0;
	CompletionProviderCompletionArgument* _tmp0_;
	gint _tmp0__length1;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint num;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (args != NULL, 0);
	_tmp0_ = all_args;
	_tmp0__length1 = all_args_length1;
	_tmp1_ = args;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 < _tmp3_) {
		result = -1;
		return result;
	}
	num = 0;
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _arg_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_size;
		gint _arg_index;
		_tmp4_ = args;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			gboolean arg;
			gint _tmp27_;
			_tmp9_ = _arg_index;
			_arg_index = _tmp9_ + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = _arg_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			arg = GPOINTER_TO_INT (_tmp14_);
			while (TRUE) {
				CompletionProviderCompletionArgument* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				CompletionProviderCompletionArgument* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				CompletionProviderCompletionArgument _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				gint _tmp26_;
				_tmp15_ = all_args;
				_tmp15__length1 = all_args_length1;
				_tmp16_ = num;
				if (_tmp15__length1 <= _tmp16_) {
					result = -1;
					_g_object_unref0 (_arg_list);
					return result;
				}
				_tmp17_ = all_args;
				_tmp17__length1 = all_args_length1;
				_tmp18_ = num;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = _tmp19_.optional;
				_tmp21_ = arg;
				if (_tmp20_ == _tmp21_) {
					break;
				} else {
					CompletionProviderCompletionArgument* _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					CompletionProviderCompletionArgument _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = all_args;
					_tmp22__length1 = all_args_length1;
					_tmp23_ = num;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = _tmp24_.optional;
					if (!_tmp25_) {
						result = -1;
						_g_object_unref0 (_arg_list);
						return result;
					}
				}
				_tmp26_ = num;
				num = _tmp26_ + 1;
			}
			_tmp27_ = num;
			num = _tmp27_ + 1;
		}
		_g_object_unref0 (_arg_list);
	}
	result = num;
	return result;
}


static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd) {
	gchar* result = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* text_to_insert;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	text_to_insert = _tmp2_;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				CompletionProviderCompletionArgument _tmp6_;
				gboolean _tmp7_;
				_tmp6_ = arg;
				_tmp7_ = _tmp6_.optional;
				if (!_tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text_to_insert;
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
					_g_free0 (text_to_insert);
					text_to_insert = _tmp9_;
				}
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	result = text_to_insert;
	return result;
}


/*************************************************************************/
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	completion_provider_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	completion_provider_parser_end (self, context, element_name, error);
}


static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	completion_provider_parser_text (self, context, text, text_len, error);
}


static void completion_provider_load_data (CompletionProvider* self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* file;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* contents;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, completion_provider_completion_command_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_commands);
	self->priv->_commands = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, completion_provider_completion_choice_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_environments);
	self->priv->_environments = _tmp1_;
	_tmp2_ = g_build_filename (DATA_DIR, "completion.xml", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = utils_load_file (_tmp6_);
	contents = _tmp7_;
	_tmp8_ = contents;
	if (_tmp8_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return;
	}
	{
		GMarkupParser _tmp9_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp10_;
		GMarkupParseContext* _tmp11_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
		_tmp9_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
		_tmp9_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
		_tmp9_.passthrough = NULL;
		_tmp9_.error = NULL;
		parser = _tmp9_;
		_tmp10_ = parser;
		_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
		context = _tmp11_;
		_tmp12_ = context;
		_tmp13_ = contents;
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			goto __catch40_g_error;
		}
		self->priv->_proposals = g_list_sort (self->priv->_proposals, (GCompareFunc) completion_provider_compare_proposals);
		_g_markup_parse_context_free0 (context);
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("completion.vala:785: Impossible to load completion data: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally40:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
}


static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("commands")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_values;
				_tmp5__length1 = attr_values_length1;
				completion_provider_parser_add_command (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp5__length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				_tmp6_ = attr_names;
				_tmp6__length1 = attr_names_length1;
				_tmp7_ = attr_values;
				_tmp7__length1 = attr_values_length1;
				completion_provider_parser_add_argument (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp7__length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = attr_names;
				_tmp8__length1 = attr_names_length1;
				_tmp9_ = attr_values;
				_tmp9__length1 = attr_values_length1;
				completion_provider_parser_add_choice (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp9__length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("insert")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("insert_after"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("component"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GError* _tmp15_;
				GError* _tmp16_;
				_tmp10_ = name;
				_tmp11_ = g_strconcat ("unknown element \"", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_inner_error_ = _tmp16_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	memset (&self->priv->_current_command, 0, sizeof (CompletionProviderCompletionCommand));
	{
		gint attr_num;
		attr_num = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				static GQuark _tmp9_label2 = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = attr_num;
					attr_num = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = attr_num;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = attr_names;
				_tmp5__length1 = attr_names_length1;
				_tmp6_ = attr_num;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp11_ = attr_values;
							_tmp11__length1 = attr_values_length1;
							_tmp12_ = attr_num;
							_tmp13_ = _tmp11_[_tmp12_];
							_tmp14_ = g_strconcat ("\\", _tmp13_, NULL);
							_g_free0 (self->priv->_current_command.name);
							self->priv->_current_command.name = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp15_;
							gint _tmp15__length1;
							gint _tmp16_;
							const gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp15_ = attr_values;
							_tmp15__length1 = attr_values_length1;
							_tmp16_ = attr_num;
							_tmp17_ = _tmp15_[_tmp16_];
							_tmp18_ = g_strdup (_tmp17_);
							_g_free0 (self->priv->_current_command.package);
							self->priv->_current_command.package = _tmp18_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("environment")))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp19_;
							gint _tmp19__length1;
							gint _tmp20_;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							GError* _tmp26_;
							GError* _tmp27_;
							_tmp19_ = attr_names;
							_tmp19__length1 = attr_names_length1;
							_tmp20_ = attr_num;
							_tmp21_ = _tmp19_[_tmp20_];
							_tmp22_ = g_strconcat ("unknown command attribute \"", _tmp21_, NULL);
							_tmp23_ = _tmp22_;
							_tmp24_ = g_strconcat (_tmp23_, "\"", NULL);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp25_);
							_tmp27_ = _tmp26_;
							_g_free0 (_tmp25_);
							_g_free0 (_tmp23_);
							_inner_error_ = _tmp27_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	memset (&self->priv->_current_arg, 0, sizeof (CompletionProviderCompletionArgument));
	self->priv->_current_arg.optional = FALSE;
	{
		gint attr_num;
		attr_num = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = attr_num;
					attr_num = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = attr_num;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = attr_names;
				_tmp5__length1 = attr_names_length1;
				_tmp6_ = attr_num;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("label")))) {
					switch (0) {
						default:
						{
							gchar** _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp11_ = attr_values;
							_tmp11__length1 = attr_values_length1;
							_tmp12_ = attr_num;
							_tmp13_ = _tmp11_[_tmp12_];
							_tmp14_ = g_strdup (_tmp13_);
							_g_free0 (self->priv->_current_arg.label);
							self->priv->_current_arg.label = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("type")))) {
					switch (0) {
						default:
						{
							gchar** _tmp15_;
							gint _tmp15__length1;
							gint _tmp16_;
							const gchar* _tmp17_;
							_tmp15_ = attr_values;
							_tmp15__length1 = attr_values_length1;
							_tmp16_ = attr_num;
							_tmp17_ = _tmp15_[_tmp16_];
							self->priv->_current_arg.optional = g_strcmp0 (_tmp17_, "optional") == 0;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp18_;
							gint _tmp18__length1;
							gint _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							GError* _tmp25_;
							GError* _tmp26_;
							_tmp18_ = attr_names;
							_tmp18__length1 = attr_names_length1;
							_tmp19_ = attr_num;
							_tmp20_ = _tmp18_[_tmp19_];
							_tmp21_ = g_strconcat ("unknown argument attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	memset (&self->priv->_current_choice, 0, sizeof (CompletionProviderCompletionChoice));
	{
		gint attr_num;
		attr_num = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = attr_num;
					attr_num = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = attr_num;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = attr_names;
				_tmp5__length1 = attr_names_length1;
				_tmp6_ = attr_num;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp11_ = attr_values;
							_tmp11__length1 = attr_values_length1;
							_tmp12_ = attr_num;
							_tmp13_ = _tmp11_[_tmp12_];
							_tmp14_ = g_strdup (_tmp13_);
							_g_free0 (self->priv->_current_choice.name);
							self->priv->_current_choice.name = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp15_;
							gint _tmp15__length1;
							gint _tmp16_;
							const gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp15_ = attr_values;
							_tmp15__length1 = attr_values_length1;
							_tmp16_ = attr_num;
							_tmp17_ = _tmp15_[_tmp16_];
							_tmp18_ = g_strdup (_tmp17_);
							_g_free0 (self->priv->_current_choice.package);
							self->priv->_current_choice.package = _tmp18_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp19_;
							gint _tmp19__length1;
							gint _tmp20_;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							GError* _tmp26_;
							GError* _tmp27_;
							_tmp19_ = attr_names;
							_tmp19__length1 = attr_names_length1;
							_tmp20_ = attr_num;
							_tmp21_ = _tmp19_[_tmp20_];
							_tmp22_ = g_strconcat ("unknown choice attribute \"", _tmp21_, NULL);
							_tmp23_ = _tmp22_;
							_tmp24_ = g_strconcat (_tmp23_, "\"", NULL);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp25_);
							_tmp27_ = _tmp26_;
							_g_free0 (_tmp25_);
							_g_free0 (_tmp23_);
							_inner_error_ = _tmp27_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_add10 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add11 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				GdkPixbuf* _tmp4_ = NULL;
				CompletionProviderCompletionCommand _tmp5_;
				const gchar* _tmp6_;
				GdkPixbuf* _tmp9_;
				GdkPixbuf* _tmp10_;
				GdkPixbuf* pixbuf;
				CompletionProviderCompletionCommand _tmp11_;
				const gchar* _tmp12_;
				CompletionProviderCompletionCommand _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				GdkPixbuf* _tmp16_;
				CompletionProviderCompletionCommand _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GtkSourceCompletionItem* _tmp20_;
				GtkSourceCompletionItem* _tmp21_;
				GtkSourceCompletionItem* item;
				GtkSourceCompletionItem* _tmp22_;
				GtkSourceCompletionItem* _tmp23_;
				CompletionProviderCompletionCommand _tmp24_;
				CompletionProviderCompletionArgument* _tmp25_;
				gint _tmp25__length1;
				_tmp5_ = self->priv->_current_command;
				_tmp6_ = _tmp5_.package;
				if (_tmp6_ != NULL) {
					GdkPixbuf* _tmp7_;
					_tmp7_ = self->priv->_icon_package_required;
					_tmp4_ = _tmp7_;
				} else {
					GdkPixbuf* _tmp8_;
					_tmp8_ = self->priv->_icon_cmd;
					_tmp4_ = _tmp8_;
				}
				_tmp9_ = _tmp4_;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				pixbuf = _tmp10_;
				_tmp11_ = self->priv->_current_command;
				_tmp12_ = _tmp11_.name;
				_tmp13_ = self->priv->_current_command;
				_tmp14_ = completion_provider_get_command_text_to_insert (self, &_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = pixbuf;
				_tmp17_ = self->priv->_current_command;
				_tmp18_ = completion_provider_get_command_info (self, &_tmp17_, -1);
				_tmp19_ = _tmp18_;
				_tmp20_ = gtk_source_completion_item_new (_tmp12_, _tmp15_, _tmp16_, _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp15_);
				item = _tmp21_;
				_tmp22_ = item;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				self->priv->_proposals = g_list_append (self->priv->_proposals, _tmp23_);
				_tmp24_ = self->priv->_current_command;
				_tmp25_ = _tmp24_.args;
				_tmp25__length1 = _tmp24_.args_length1;
				if (0 < _tmp25__length1) {
					GeeHashMap* _tmp26_;
					CompletionProviderCompletionCommand _tmp27_;
					const gchar* _tmp28_;
					CompletionProviderCompletionCommand _tmp29_;
					_tmp26_ = self->priv->_commands;
					_tmp27_ = self->priv->_current_command;
					_tmp28_ = _tmp27_.name;
					_tmp29_ = self->priv->_current_command;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp28_, &_tmp29_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (pixbuf);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument* _tmp30_;
				gint _tmp30__length1;
				CompletionProviderCompletionArgument _tmp31_;
				CompletionProviderCompletionArgument _tmp32_ = {0};
				_tmp30_ = self->priv->_current_command.args;
				_tmp30__length1 = self->priv->_current_command.args_length1;
				_tmp31_ = self->priv->_current_arg;
				completion_provider_completion_argument_copy (&_tmp31_, &_tmp32_);
				_vala_array_add10 (&self->priv->_current_command.args, &self->priv->_current_command.args_length1, &self->priv->_current_command._args_size_, &_tmp32_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice* _tmp33_;
				gint _tmp33__length1;
				CompletionProviderCompletionChoice _tmp34_;
				CompletionProviderCompletionChoice _tmp35_ = {0};
				gboolean _tmp36_ = FALSE;
				CompletionProviderCompletionChoice _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp41_;
				_tmp33_ = self->priv->_current_arg.choices;
				_tmp33__length1 = self->priv->_current_arg.choices_length1;
				_tmp34_ = self->priv->_current_choice;
				completion_provider_completion_choice_copy (&_tmp34_, &_tmp35_);
				_vala_array_add11 (&self->priv->_current_arg.choices, &self->priv->_current_arg.choices_length1, &self->priv->_current_arg._choices_size_, &_tmp35_);
				_tmp37_ = self->priv->_current_choice;
				_tmp38_ = _tmp37_.insert;
				if (_tmp38_ != NULL) {
					_tmp36_ = TRUE;
				} else {
					CompletionProviderCompletionChoice _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = self->priv->_current_choice;
					_tmp40_ = _tmp39_.insert_after;
					_tmp36_ = _tmp40_ != NULL;
				}
				_tmp41_ = _tmp36_;
				if (_tmp41_) {
					GeeHashMap* _tmp42_;
					CompletionProviderCompletionChoice _tmp43_;
					const gchar* _tmp44_;
					CompletionProviderCompletionChoice _tmp45_;
					_tmp42_ = self->priv->_environments;
					_tmp43_ = self->priv->_current_choice;
					_tmp44_ = _tmp43_.name;
					_tmp45_ = self->priv->_current_choice;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp44_, &_tmp45_);
				}
				break;
			}
		}
	}
}


static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("insert")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = text;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (self->priv->_current_choice.insert);
				self->priv->_current_choice.insert = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("insert_after")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = text;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (self->priv->_current_choice.insert_after);
				self->priv->_current_choice.insert_after = _tmp8_;
				break;
			}
		}
	}
}


static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_argument_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length) {
	CompletionProviderCompletionArgument* result;
	int i;
	result = g_new0 (CompletionProviderCompletionArgument, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionArgument _tmp0_ = {0};
		completion_provider_completion_argument_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).args;
	_tmp4__length1 = (*self).args_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
	(*dest).args = _tmp5_;
	(*dest).args_length1 = _tmp5__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}


static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
}


static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self) {
	CompletionProviderCompletionCommand* dup;
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
	completion_provider_completion_command_copy (self, dup);
	return dup;
}


static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self) {
	completion_provider_completion_command_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_command_get_type (void) {
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}


static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_choice_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length) {
	CompletionProviderCompletionChoice* result;
	int i;
	result = g_new0 (CompletionProviderCompletionChoice, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionChoice _tmp0_ = {0};
		completion_provider_completion_choice_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	CompletionProviderCompletionChoice* _tmp3_;
	gint _tmp3__length1;
	CompletionProviderCompletionChoice* _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).optional;
	(*dest).optional = _tmp2_;
	_tmp3_ = (*self).choices;
	_tmp3__length1 = (*self).choices_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
	(*dest).choices = _tmp4_;
	(*dest).choices_length1 = _tmp4__length1;
	(*dest)._choices_size_ = (*dest).choices_length1;
}


static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self) {
	_g_free0 ((*self).label);
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
}


static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self) {
	CompletionProviderCompletionArgument* dup;
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
	completion_provider_completion_argument_copy (self, dup);
	return dup;
}


static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self) {
	completion_provider_completion_argument_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_argument_get_type (void) {
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}


static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).insert;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).insert);
	(*dest).insert = _tmp5_;
	_tmp6_ = (*self).insert_after;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).insert_after);
	(*dest).insert_after = _tmp7_;
}


static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	_g_free0 ((*self).insert);
	_g_free0 ((*self).insert_after);
}


static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self) {
	CompletionProviderCompletionChoice* dup;
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
	completion_provider_completion_choice_copy (self, dup);
	return dup;
}


static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self) {
	completion_provider_completion_choice_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_choice_get_type (void) {
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}


static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	_tmp0_ = (*self).cmd_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmd_name);
	(*dest).cmd_name = _tmp1_;
	_tmp2_ = (*self).arg_contents;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).arg_contents);
	(*dest).arg_contents = _tmp3_;
	_tmp4_ = (*self).args_types;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).args_types);
	(*dest).args_types = _tmp5_;
}


static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self) {
	_g_free0 ((*self).cmd_name);
	_g_free0 ((*self).arg_contents);
	_g_object_unref0 ((*self).args_types);
}


static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self) {
	CompletionProviderArgumentContext* dup;
	dup = g_new0 (CompletionProviderArgumentContext, 1);
	completion_provider_argument_context_copy (self, dup);
	return dup;
}


static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self) {
	completion_provider_argument_context_destroy (self);
	g_free (self);
}


static GType completion_provider_argument_context_get_type (void) {
	static volatile gsize completion_provider_argument_context_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_argument_context_type_id__volatile)) {
		GType completion_provider_argument_context_type_id;
		completion_provider_argument_context_type_id = g_boxed_type_register_static ("CompletionProviderArgumentContext", (GBoxedCopyFunc) completion_provider_argument_context_dup, (GBoxedFreeFunc) completion_provider_argument_context_free);
		g_once_init_leave (&completion_provider_argument_context_type_id__volatile, completion_provider_argument_context_type_id);
	}
	return completion_provider_argument_context_type_id__volatile;
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_name;
	iface->get_activation = (GtkSourceCompletionActivation (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
	iface->match = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
}


static void completion_provider_instance_init (CompletionProvider * self) {
	self->priv = COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
}


static void completion_provider_finalize (GObject* obj) {
	CompletionProvider * self;
	self = COMPLETION_PROVIDER (obj);
	_g_object_unref0 (self->priv->_settings);
	__g_list_free__g_object_unref0_0 (self->priv->_proposals);
	_g_object_unref0 (self->priv->_commands);
	_g_object_unref0 (self->priv->_environments);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	_g_object_unref0 (self->priv->_icon_cmd);
	_g_object_unref0 (self->priv->_icon_choice);
	_g_object_unref0 (self->priv->_icon_package_required);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, GTK_TYPE_SOURCE_COMPLETION_PROVIDER, &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



