#include "LaunchtoolCfg.h"

#include <signal.h>	// Kill constants

using namespace std;

Cfg::Cfg(const string& tag) throw ()
	: tag(tag), visible_tag("launchtool-" + tag), root_dir(), start_dir("/"),
		umask((mode_t)-1), infinite_runs(false), good_running_time(300),
		detach(false), pidfile(false), piddir(PID_DIR), limit_cpu(-1),
		limit_file_size(-1), limit_data_memory(-1), limit_process_count(-1),
		limit_open_files(-1), limit_core_size(-1), user(), group(),
		restrict_environment(false), log_launchtool_out("stdout"),
		log_launchtool_err("stderr"), log_child_stdout("stdout"),
		log_child_stderr("stderr"), enable_silent_restart(false),
		silent_restart_status(-1), verbose(false), debug(false), stats(false)
{
/*
	// Initialize the wait times
	// First 2 minutes small intervals
	wait_times.push_back(10);
	wait_times.push_back(10);
	wait_times.push_back(30);
	wait_times.push_back(30);
	wait_times.push_back(40);
	// Next 5 minutes, 1 minute intervals
	for (unsigned int i = 0; i < 5; i++)
		wait_times.push_back(60);
	// Next 10 minutes, 2 minute intervals
	for (unsigned int i = 0; i < 5; i++)
		wait_times.push_back(120);
	// Next 8 hours, 5 minute intervals 
	for (unsigned int i = 0; i < 12*8; i++)
		wait_times.push_back(300);
*/

/*
	forwarded_signals.push_back(SIGHUP);
	forwarded_signals.push_back(SIGUSR1);
	forwarded_signals.push_back(SIGUSR2);
*/
}

#include <stringf.h>

using namespace stringf;

static string strFmt(const string& s) throw ()
{
	return s.size() ? s : "<empty>";
}

#include <stdio.h>

static void printSigVec(FILE* out, vector<unsigned int>& v) throw ()
{
	if (v.size())
		for (unsigned int i = 0; i < v.size(); i++)
		{
			if (i > 0)
				fprintf(out, ", ");
			fprintf(out, "%d (%s)", v[i], sys_siglist[v[i]]);
		}
	else
		fprintf(out, "none");
}

void Cfg::print() throw ()
{
	FILE* out = stdout;
	fprintf(out, " * Configuration for %.*s (%.*s):\n\n", PFSTR(tag), PFSTR(visible_tag));
	fprintf(out, "Root dir: %.*s\tStart dir: %.*s\tUmask: %d\n", PFSTR(strFmt(root_dir)), PFSTR(strFmt(start_dir)), umask);

	fprintf(out, "Wait times (good running time: %d): ", good_running_time);
	for (unsigned int i = 0; i < wait_times.size(); i++)
	{
		if (i > 0)
			fprintf(out, ", ");
		fprintf(out, "%d", wait_times[i]);
	}
	if (infinite_runs)
		fprintf(out, ", ...\n");
	else
		fprintf(out, "\n");

	if (enable_silent_restart)
		fprintf(out, "Silent restart enabled, status: %d, wait time: %d\n", silent_restart_status, silent_restart_time);
	else
		fprintf(out, "Silent restart disabled\n");

	fprintf(out, "Forwarded signals: "); printSigVec(out, forwarded_signals); fprintf(out, "\n");
	fprintf(out, "Blocked signals: "); printSigVec(out, blocked_signals); fprintf(out, "\n");

	fprintf(out, "Command: %.*s, %sdetached, with %spidfile\n", PFSTR(command), detach ? "" : "not ", pidfile ? "" : "no ");

	fprintf(out, "Force user: %.*s, group: %.*s\n", PFSTR(strFmt(user)), PFSTR(strFmt(group)));

	fprintf(out, "Limits: cpu: %d, file size: %d, data mem: %d, processes: %d, open files: %d, core size: %d\n", limit_cpu, limit_file_size, limit_data_memory, limit_process_count, limit_open_files, limit_core_size);

	if (restrict_environment)
	{
		fprintf(out, "Env. restricted.  Allowed vars: ");
		if (allowed_env_vars.size())
		{
			for (set<string>::const_iterator i = allowed_env_vars.begin();
					i != allowed_env_vars.end(); i++)
			{
				if (i != allowed_env_vars.begin())
					fprintf(out, ", ");
				fprintf(out, "%.*s", PFSTR(*i));
			}
			fprintf(out, "\n");
		} else
			fprintf(out, "none\n");
	}

	fprintf(out, "Launchtool logging: out: %.*s, err: %.*s\n", PFSTR(log_launchtool_out), PFSTR(log_launchtool_err));
	fprintf(out, "Child logging: out: %.*s, err: %.*s\n", PFSTR(log_child_stdout), PFSTR(log_child_stderr));

	fprintf(out, "Output: %sverbose, %sdebug, %sstats\n", verbose ? "" : "no ", debug ? "": "no ", stats ? "" : "no ");
}

Cfg* Cfg::instance = 0;

// vim:set ts=4 sw=4:
